#include "Mix/AtomicValue.h"

namespace Mix{

AtomicValue::AtomicValue( void )
{
	Set( 0 );
}

AtomicValue::AtomicValue( const Long32 v )
{
	Set( v );
}

Long32 AtomicValue::Set( Long32 v )
{
	return ::InterlockedExchange( &m_Value, v );
}

Long32 AtomicValue::Get( void ) const
{
	return ::InterlockedExchangeAdd( const_cast<volatile Long32*>( &m_Value ), 0 );
}

Long32 AtomicValue::Add( Long32 v )
{
	return ::InterlockedExchangeAdd( &m_Value, v );
}

Long32 AtomicValue::Increment( void )
{
	return ::InterlockedIncrement( &m_Value );
}

Long32 AtomicValue::Decrement( void )
{
	return ::InterlockedDecrement( &m_Value );
}

Long32 AtomicValue::CompareAndSet( Long32 v, Long32 cv )
{
	return ::InterlockedCompareExchange( &m_Value, v, cv );
}

void AtomicValue::operator = ( Long32 v )
{
	Set( v );
}

}
