#pragma once

//! @file Mix/Parallel/IManager.h
//! @brief pl[WC^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace Parallel{

	//! @class IManager
	//! @brief }l[WC^[tF[X
	class IManager : public Mix::Reference
	{
	protected:
		//! @brief fXgN^
		virtual ~IManager( void ){}

	public:
		//! @brief Xbh擾܂
		//! @return XbhԂ܂
		virtual UInt32 GetThreadCount( void ) const = 0;

		//! @brief [N}bv܂
		//! @param[in] numWork [N̐
		//! @param[in] works }bv郏[N\ Mix::Parallel::WORK \̂̔z
		//! @return ꍇ́A}bv[ÑnhԂ܂
		//! @note
		//! obNOEhœ삷t@NVo^܂B<br>
		//! ܂AEFCNAbvpIuWFNgLĂ郏[N͕ŏ܂A<br>
		//! IuWFNgقȂ郏[NmA Mix::Parallel::ExecuteFunction ɂĎst@NV͓Ďs܂B
		virtual HANDLE MapWorks( UInt32 numWork, Mix::Parallel::WORK* works ) = 0;
		//! @brief [NA}bv܂
		//! @param[in] handle A}bv郏[Ñnh
		//! @return ꍇ True Ԃ܂
		virtual Boolean UnmapWorks( HANDLE handle ) = 0;

		//! @brief w肵̃Xbhgpăt@NVs܂
		//! @param[in] threadNum gpXbh
		//! @param[in] pFunc st@NṼ|C^
		//! @param[in] pData st@NVɓnf[^̃|C^
		//! @param[in] debugID fobOpʎq ( Mix::Parallel::DEBUG_ID )
		//! @return ꍇ True Ԃ܂
		//! @note
		//! gpXbh ( threadNum )  0 w肵ꍇ́A1 w肵Ƃ݂Ȃ܂B<br>
		//! ܂AőXbh ( GetThreadCount ) 𒴂ꍇ́AOa܂B
		virtual Boolean ExecuteFunction( UInt32 threadNum, FunctionPtr pFunc, void* pData, UInt32 debugID = Mix::Parallel::DEBUG_USER ) = 0;

		//! @brief fobO : Xbh̏擾܂
		//! @param[in] threadIndex Xbh̃CfbNX
		//! @return Xbh̏\ Mix::Parallel::DEBUG_THREAD_INFO \̂Ԃ܂
		virtual const Mix::Parallel::DEBUG_THREAD_INFO& Debug_GetThreadInfo( UInt32 threadIndex ) const = 0;
	};

}}
