#pragma once

//! @file Mix/Matrix3x3.h
//! @brief 3x3sNXCN[ht@C

namespace Mix
{
	//! @class Matrix3x3
	//! @brief 3x3sNX
	class _MIX_DLL_API Matrix3x3
	{
	public:
		union
		{
			struct
			{
				Float32 m00;	//!< vf ( 0, 0 ) ̒l
				Float32 m01;	//!< vf ( 0, 1 ) ̒l
				Float32 m02;	//!< vf ( 0, 2 ) ̒l
				Float32 m10;	//!< vf ( 1, 0 ) ̒l
				Float32 m11;	//!< vf ( 1, 1 ) ̒l
				Float32 m12;	//!< vf ( 1, 2 ) ̒l
				Float32 m20;	//!< vf ( 2, 0 ) ̒l
				Float32 m21;	//!< vf ( 2, 1 ) ̒l
				Float32 m22;	//!< vf ( 2, 2 ) ̒l
			};

			Float32 m[3][3];	//!< s̗vf
		};

	public:
		//! @brief RXgN^
		Matrix3x3( void );
		//! @brief RXgN^
		//! @param[in] _m00 vf m[0][0] ̒l
		//! @param[in] _m01 vf m[0][1] ̒l
		//! @param[in] _m02 vf m[0][2] ̒l
		//! @param[in] _m10 vf m[1][0] ̒l
		//! @param[in] _m11 vf m[1][1] ̒l
		//! @param[in] _m12 vf m[1][2] ̒l
		//! @param[in] _m20 vf m[2][0] ̒l
		//! @param[in] _m21 vf m[2][1] ̒l
		//! @param[in] _m22 vf m[2][2] ̒l
		Matrix3x3( Float32 _m00, Float32 _m01, Float32 _m02,
				   Float32 _m10, Float32 _m11, Float32 _m12,
				   Float32 _m20, Float32 _m21, Float32 _m22 );
		//! @brief Rs[RXgN^
		//! @param[in] mat s
		Matrix3x3( const Matrix3x3& mat );
		//! @brief fXgN^
		~Matrix3x3( void );

	public:
		//! @brief XP[ݒ肵܂
		//! @param[in] s XP[O
		void SetScaling( Float32 s );
		//! @brief XP[ϊݒ肵܂
		//! @param[in] s XP[O\ Mix::Vector2 NX
		void SetScaling( const Mix::Vector2& s );

		//! @brief XL[ݒ肵܂
		//! @param[in] s XL[\ Mix::Vector2 NX
		void SetSkew( const Mix::Vector2& s );

		//! @brief ]ݒ肵܂
		//! @param[in] theta ]px( WAP )
		void SetRotation( Float32 theta );

		//! @brief sړݒ肵܂
		//! @param[in] t ړ\ Mix::Vector2 NX
		void SetTranslation( const Mix::Vector2& t );

		//! @brief w肵̃xNg擾܂
		//! @param[in] index s̃CfbNX( 0`2 )
		//! @return s̃xNg\ Mix::Vector4 NXԂ܂
		Mix::Vector3 GetColumn( UInt32 index ) const;
		//! @brief w肵ɃxNgݒ肵܂
		//! @param[in] index s̃CfbNX( 0`2 )
		//! @param[in] v xNg\ Mix::Vector3 NX
		void SetColumn( UInt32 index, const Mix::Vector3& v );

		//! @brief w肵s̃xNg擾܂
		//! @param[in] index s̃CfbNX( 0`3 )
		//! @return xNg\ Mix::Vector4 NXԂ܂
		Mix::Vector3 GetRow( UInt32 index ) const;
		//! @brief w肵sɃxNgݒ肵܂
		//! @param[in] index s̃CfbNX( 0`3 )
		//! @param[in] v xNg\ Mix::Vector3 NX
		void SetRow( UInt32 index, const Mix::Vector3& v );

		//! @brief gtsɂ܂
		//! @return ꍇ True Ԃ܂
		Boolean Inverse( void );
		//! @brief g̋tsԂ܂
		//! @return g̋ts\ Mix::Matrix3x3 NX
		Mix::Matrix3x3 ToInverse( void ) const;

		//! @brief g]usɂ܂
		void Transpose( void );
		//! @brief g̓]usԂ܂
		//! @return g̓]us\ Mix::Matrix3x3 NX
		Mix::Matrix3x3 ToTranspose( void ) const;

		//! @brief ̃xNg܂Ƃ߂ĕϊ܂
		//! @param[in, out] vectors ϊxNg\ Mix::Vector2 NX̃|C^
		//! @param[in] count ϊxNg̐
		void Transform( Mix::Vector2* vectors, UInt32 count ) const;
		//! @brief ̃xNg܂Ƃ߂ĕϊ܂
		//! @param[in, out] vectors ϊxNg\ Mix::Vector3 NX̃|C^
		//! @param[in] count ϊxNg̐
		//! @note xy ϊ܂B
		void Transform( Mix::Vector3* vectors, UInt32 count ) const;
		//! @brief ̃xNg܂Ƃ߂ĕϊ܂
		//! @param[in] srcVectors ϊxNg\ Mix::Vector2 NX̔z
		//! @param[out] dstVectors ϊ̃xNgn Mix::Vector2 NX̔z
		//! @param[in] count ϊxNg̐
		void Transform( const Mix::Vector2* srcVectors, Mix::Vector2* dstVectors, UInt32 count ) const;
		//! @brief ̃xNg܂Ƃ߂ĕϊ܂
		//! @param[in] srcVectors ϊxNg\ Mix::Vector3 NX̔z
		//! @param[out] dstVectors ϊ̃xNgn Mix::Vector3 NX̔z
		//! @param[in] count ϊxNg̐
		//! @note xy ϊ܂B
		void Transform( const Mix::Vector3* srcVectors, Mix::Vector3* dstVectors, UInt32 count ) const;

		//! @brief ̃xNg܂Ƃ߂ĕϊ܂ ( ړ͍s܂ )
		//! @param[in, out] vectors ϊxNg\ Mix::Vector2 NX̃|C^
		//! @param[in] count ϊxNg̐
		void TransformSR( Mix::Vector2* vectors, UInt32 count ) const;
		//! @brief ̃xNg܂Ƃ߂ĕϊ܂ ( ړ͍s܂ )
		//! @param[in, out] vectors ϊxNg\ Mix::Vector3 NX̃|C^
		//! @param[in] count ϊxNg̐
		//! @note xy ϊ܂B
		void TransformSR( Mix::Vector3* vectors, UInt32 count ) const;
		//! @brief ̃xNg܂Ƃ߂ĕϊ܂ ( ړ͍s܂ )
		//! @param[in] srcVectors ϊxNg\ Mix::Vector2 NX̔z
		//! @param[out] dstVectors ϊ̃xNgn Mix::Vector2 NX̔z
		//! @param[in] count ϊxNg̐
		void TransformSR( const Mix::Vector2* srcVectors, Mix::Vector2* dstVectors, UInt32 count ) const;
		//! @brief ̃xNg܂Ƃ߂ĕϊ܂ ( ړ͍s܂ )
		//! @param[in] srcVectors ϊxNg\ Mix::Vector3 NX̔z
		//! @param[out] dstVectors ϊ̃xNgn Mix::Vector3 NX̔z
		//! @param[in] count ϊxNg̐
		//! @note xy ϊ܂B
		void TransformSR( const Mix::Vector3* srcVectors, Mix::Vector3* dstVectors, UInt32 count ) const;

		//! @brief r
		//! @param[in] mat rs
		//! @return lꍇ True Ԃ܂
		Boolean operator == ( const Matrix3x3& mat ) const;
		//! @brief r
		//! @param[in] mat rs
		//! @return lȂꍇ True Ԃ܂
		Boolean operator != ( const Matrix3x3& mat ) const;

		//! @brief 
		//! @param[in] mat s
		//! @return 
		Matrix3x3& operator = ( const Matrix3x3& mat );

		//! @brief Z
		//! @param[in] mat Zs
		//! @return 
		Matrix3x3& operator *= ( const Matrix3x3& mat );
		//! @brief Z
		//! @param[in] mat Z̍s
		//! @return Z̍s
		Matrix3x3 operator * ( const Matrix3x3& mat ) const;

		//! @brief xNg̕ϊ
		//! @param[in] v ϊxNg
		//! @return ϊ̃xNg
		Vector2 operator * ( const Vector2& v ) const;
		//! @brief xNg̕ϊ
		//! @param[in] v ϊxNg
		//! @return ϊ̃xNg
		Vector3 operator * ( const Vector3& v ) const;

		//! @brief xNgϊ܂
		//! @param[in] v ϊxNg
		//! @param[in] mat ϊs
		//! @return ϊ̃xNg
		friend const Vector2 operator * ( const Vector2& v, const Matrix3x3& mat )
		{
			return ( mat * v );
		}

		//! @brief xNgϊ܂
		//! @param[in] v ϊxNg
		//! @param[in] mat ϊs
		//! @return ϊ̃xNg
		friend const Vector3 operator * ( const Vector3& v, const Matrix3x3& mat )
		{
			return ( mat * v );
		}

	public:
		//! @brief SĂ̗vf 0.0f ̍s擾܂
		//! @return s\ Matrix3x3 NXԂ܂
		static Matrix3x3 Zero( void )
		{
			static const Mix::Matrix3x3 mat(	0.0f, 0.0f, 0.0f,
												0.0f, 0.0f, 0.0f,
												0.0f, 0.0f, 0.0f );

			return mat;
		}

		//! @brief Pʍs擾܂
		//! @return Pɍs\ Matrix3x3 NXԂ܂
		static const Matrix3x3& Identity( void )
		{
			static const Mix::Matrix3x3 mat(	1.0f, 0.0f, 0.0f,
												0.0f, 1.0f, 0.0f,
												0.0f, 0.0f, 1.0f );

			return mat;
		}
	};

}
