#pragma once

//! @file Mix/Graphics/ITexture.h
//! @brief eNX`C^[tF[XCN[ht@C

#include "Mix/Graphics/IDeviceObject.h"

namespace Mix{ namespace Graphics{

	//! @class ITexture
	//! @brief eNX`C^[tF[X
	class ITexture : public Mix::Graphics::IDeviceObject
	{
	public:
		//! @enum DIMENSION_TYPE
		//! @brief fBW^Cv񋓒萔
		enum DIMENSION_TYPE
		{
			DIMENSION_PLANE		= 0,	//!< v[ ( 2D )
			DIMENSION_VOLUME	= 1,	//!< {[ ( 3D )
			DIMENSION_CUBE		= 2,	//!< L[u
		};

		//! @enum BIND_TYPE
		//! @brief oCh^Cv񋓒萔
		enum BIND_TYPE
		{
			//! @brief ftHg
			//! @note Mix::Graphics::IDevice::SetTexture Őݒ肷邱Ƃł܂B
			BIND_DEFAULT	= 0,
			//! @brief ^[Qbg
			//! @note Mix::Graphics::IDevice::SetTarget Őݒ肷邱Ƃł܂B
			BIND_TARGET		= 1,
			//! @brief fvX
			//! @note Mix::Graphics::IDevice::SetTarget Őݒ肷邱Ƃł܂B
			BIND_DEPTH		= 2,
		};

		//! @enum ACCESS_FLAG
		//! @brief ANZXtO񋓒萔
		enum ACCESS_FLAG
		{
			//! @brief CPU ɂǂݎ肪ł܂
			//! @see Mix::Graphics::ITexture::Lock
			ACCESS_CPU_READ		= 0x00000001,
			//! @brief CPU ɂ鏑݂ł܂
			//! @see Mix::Graphics::ITexture::Lock
			ACCESS_CPU_WRITE	= 0x00000002,

			//! @brief GPU ɂǂݎ肪ł܂
			ACCESS_GPU_READ		= 0x00000004,
			//! @brief GPU ɂ鏑݂ł܂
			ACCESS_GPU_WRITE	= 0x00000008,
		};

		//! @struct LOCK
		//! @brief bN\
		struct LOCK
		{
			UInt32 pitch;	//!< sb` ( oCgP )
			void* bits;		//!< rbgւ̃|C^
		};

	protected:
		//! @brief fXgN^
		virtual ~ITexture( void ){}

	public:
		//! @brief fBW^Cv擾܂
		//! @return fBW^Cv\ Mix::Graphics::ITexture::DIMENSION_TYPE Ԃ܂
		virtual Mix::Graphics::ITexture::DIMENSION_TYPE GetDimensionType( void ) const = 0;
		//! @brief oCh^Cv擾܂
		//! @return oCh^Cv\ Mix::Graphics::ITexture::BIND_TYPE Ԃ܂
		virtual Mix::Graphics::ITexture::BIND_TYPE GetBindType( void ) const = 0;
		//! @brief ANZX̃tO擾܂
		//! @return ANZX̃tO\ Mix::Graphics::ITexture::ACCESS_FLAG ̑gݍ킹Ԃ܂
		virtual UInt32 GetAccessFlags( void ) const = 0;

		//! @brief 擾܂
		//! @return Ԃ܂
		virtual UInt32 GetWidth( void ) const = 0;
		//! @brief 擾܂
		//! @return Ԃ܂
		virtual UInt32 GetHeight( void ) const = 0;

		//! @brief tH[}bg擾܂
		//! @return tH[}bg\ Mix::Graphics::FORMAT 񋓒萔Ԃ܂
		virtual Mix::Graphics::FORMAT GetFormat( void ) const = 0;

		//! @brief t@CpX擾܂
		//! @return t@CpXԂ܂
		//! @note
		//! t@CA탁̃t@C쐬Ăꍇ̂ݗLłB<br>
		//! ȊȌꍇ́A̕Ԃ܂B
		virtual const wchar_t* GetFilePath( void ) const = 0;

		//! @brief bNāAǂݍ ܂ ݂łԂɂ܂
		//! @param[out] lock bN\ Mix::Graphics::ITexture::LOCK \
		//! @return ꍇ True Ԃ܂
		//! @note
		//! ̃\bĥ CPU ɂǂݍ݂\ Mix::Graphics::ITexture::ACCESS_CPU_READ<br>
		//! CPU ɂ鏑݂\ Mix::Graphics::ITexture::ACCESS_CPU_WRITE ̂ǂ炩 Mix::Graphics::ITexture::GetAccessFlags Ŏw肳ĂꍇɌ܂B
		virtual Boolean Lock( Mix::Graphics::ITexture::LOCK& lock ) = 0;
		//! @brief bN܂B
		virtual void Unlock( void ) = 0;
	};

}}
