#pragma once

//! @file Mix/Graphics/IDevice.h
//! @brief OtBbNXfoCXC^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace Graphics{
	
	//! @class IDevice
	//! @brief OtBbNXfoCXC^[tF[X
	class IDevice : public Mix::Reference
	{
	public:
		//! @enum DISPLAY_MODE
		//! @brief fBXvC[h񋓒萔
		enum DISPLAY_MODE
		{
			WINDOW		= 0,	//!< EBhE[h
			FULLSCREEN	= 1,	//!< tXN[[h
		};

	protected:
		//! @brief fXgN^
		virtual ~IDevice( void ){}

	public:
		//! @brief VF[_[f擾܂
		//! @return VF[_[f\ Mix::Graphics::SHADER_MODEL 񋓒萔Ԃ܂
		virtual Mix::Graphics::SHADER_MODEL GetShaderModel( void ) const = 0;

		//! @brief fBXvC[h擾܂
		//! @return fBXvC[h\ Mix::Graphics::IDevice::DISPLAY_MODE 񋓒萔Ԃ܂
		virtual Mix::Graphics::IDevice::DISPLAY_MODE GetDisplayMode( void ) const = 0;
		//! @brief fBXvC[hݒ肵܂
		//! @param[in] dispMode fBXvC[h\ Mix::Graphics::IDevice::DISPLAY_MODE 񋓒萔
		virtual void SetDisplayMode( Mix::Graphics::IDevice::DISPLAY_MODE dispMode ) = 0;
		//! @brief fBXvC[h݂ɐ؂ւ܂
		virtual void ToggleDisplayMode( void ) = 0;

		//! @brief XN[̃TCY擾܂
		//! @return XN[̃TCYԂ܂
		virtual const Mix::Point& GetScreenSize( void ) const = 0;
		//! @brief XN[̗LȔ͈͂擾܂
		//! @return XN[̗LȔ͈͂Ԃ܂
		virtual const Mix::Rectangle& GetScreenValidBounds( void ) const = 0;

		//! @brief nVF[_[gpł邩ǂmF܂
		//! @return gpłꍇ True Ԃ܂
		virtual Boolean IsHullShaderSupported( void ) const = 0;
		//! @brief hCVF[_[gpł邩ǂmF܂
		//! @return gpłꍇ True Ԃ܂
		virtual Boolean IsDomainShaderSupported( void ) const = 0;
		//! @brief WIgVF[_[gpł邩ǂmF܂
		//! @return gpłꍇ True Ԃ܂
		virtual Boolean IsGeometryShaderSupported( void ) const = 0;
		//! @brief VF[_[萔gpł邩ǂmF܂
		//! @return gpłꍇ True Ԃ܂
		virtual Boolean IsShaderConstantSupported( void ) const = 0;

		//! @brief w肳ꂽCfbNXtH[}bggpł邩ǂmF܂
		//! @param[in] format CfbNXtH[}bg\ Mix::Graphics::INDEX_FORMAT 񋓒萔
		//! @return gpłꍇ True Ԃ܂
		virtual Boolean IsIndexSupported( Mix::Graphics::INDEX_FORMAT format ) const = 0;

		//! @brief w肳ꂽtH[}bgŃv[eNX`쐬ł邩ǂmF܂
		//! @param[in] format mFtH[}bg\ Mix::Graphics::FORMAT 񋓒萔
		//! @return gpłꍇ True Ԃ܂
		virtual Boolean IsPlaneTextureSupported( Mix::Graphics::FORMAT format ) const = 0;
		//! @brief w肳ꂽtH[}bgŃ{[eNX`쐬ł邩ǂmF܂
		//! @param[in] format mFtH[}bg\ Mix::Graphics::FORMAT 񋓒萔
		//! @return gpłꍇ True Ԃ܂
		virtual Boolean IsVolumeTextureSupported( Mix::Graphics::FORMAT format ) const = 0;
		//! @brief w肳ꂽtH[}bgŃL[ueNX`쐬ł邩ǂmF܂
		//! @param[in] format mFtH[}bg\ Mix::Graphics::FORMAT 񋓒萔
		//! @return gpłꍇ True Ԃ܂
		virtual Boolean IsCubeTextureSupported( Mix::Graphics::FORMAT format ) const = 0;
		//! @brief w肳ꂽtH[}bgŃ_Ci~bNv[eNX`쐬ł邩ǂmF܂
		//! @param[in] format mFtH[}bg\ Mix::Graphics::FORMAT 񋓒萔
		//! @return gpłꍇ True Ԃ܂
		virtual Boolean IsDynamicPlaneTextureSupported( Mix::Graphics::FORMAT format ) const = 0;
		//! @brief w肳ꂽtH[}bgŃ^[Qbgv[eNX`쐬ł邩ǂmF܂
		//! @param[in] format mFtH[}bg\ Mix::Graphics::FORMAT 񋓒萔
		//! @return gpłꍇ True Ԃ܂
		virtual Boolean IsTargetPlaneTextureSupported( Mix::Graphics::FORMAT format ) const = 0;
		//! @brief w肳ꂽtH[}bgŃ^[Qbgv[eNX` ( Lockable ) 쐬ł邩ǂmF܂
		//! @param[in] format mFtH[}bg\ Mix::Graphics::FORMAT 񋓒萔
		//! @return gpłꍇ True Ԃ܂
		virtual Boolean IsLockableTargetPlaneTextureSupported( Mix::Graphics::FORMAT format ) const = 0;
		//! @brief w肳ꂽtH[}bgŃ^[QbgL[ueNX`쐬ł邩ǂmF܂
		//! @param[in] format mFtH[}bg\ Mix::Graphics::FORMAT 񋓒萔
		//! @return gpłꍇ True Ԃ܂
		virtual Boolean IsTargetCubeTextureSupported( Mix::Graphics::FORMAT format ) const = 0;
		//! @brief w肳ꂽtH[}bgŃfvXeNX`쐬ł邩ǂmF܂
		//! @param[in] format mFtH[}bg\ Mix::Graphics::FORMAT 񋓒萔
		//! @return gpłꍇ True Ԃ܂
		virtual Boolean IsDepthTextureSupported( Mix::Graphics::FORMAT format ) const = 0;

		//! @brief nVF[_[t@C쐬܂
		//! @param[in] pFilePath t@CpX
		//! @param[out] ppHullShader 쐬nVF[_[n Mix::Graphics::IHullShader C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note VF[_[fT̏ꍇɎgpł܂
		virtual Boolean CreateHullShaderFromFile( const wchar_t* pFilePath, Mix::Graphics::IHullShader** ppHullShader ) = 0;
		//! @brief nVF[_[̃t@C쐬܂
		//! @param[in] pSrc ̃t@C̃|C^
		//! @param[in] srcSize ̃t@C̃TCY
		//! @param[out] ppHullShader 쐬nVF[_[n Mix::Graphics::IHullShader C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		//! @note VF[_[fT̏ꍇɎgpł܂
		virtual Boolean CreateHullShaderFromMemory( const void* pSrc, UInt32 srcSize, Mix::Graphics::IHullShader** ppHullShader, const wchar_t* pDebugName = NULL ) = 0;
		//! @brief hCVF[_[t@C쐬܂
		//! @param[in] pFilePath t@CpX
		//! @param[out] ppDomainShader 쐬hCVF[_[n Mix::Graphics::IDomainShader C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note VF[_[fT̏ꍇɎgpł܂
		virtual Boolean CreateDomainShaderFromFile( const wchar_t* pFilePath, Mix::Graphics::IDomainShader** ppDomainShader ) = 0;
		//! @brief hCVF[_[̃t@C쐬܂
		//! @param[in] pSrc ̃t@C̃|C^
		//! @param[in] srcSize ̃t@C̃TCY
		//! @param[out] ppDomainShader 쐬hCVF[_[n Mix::Graphics::IDomainShader C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		//! @note VF[_[fT̏ꍇɎgpł܂
		virtual Boolean CreateDomainShaderFromMemory( const void* pSrc, UInt32 srcSize, Mix::Graphics::IDomainShader** ppDomainShader, const wchar_t* pDebugName = NULL ) = 0;
		//! @brief WIgVF[_[t@C쐬܂
		//! @param[in] pFilePath t@CpX
		//! @param[out] ppGeometryShader 쐬WIgVF[_[n Mix::Graphics::IGeometryShader C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note VF[_[fSAT̏ꍇɎgpł܂
		virtual Boolean CreateGeometryShaderFromFile( const wchar_t* pFilePath, Mix::Graphics::IGeometryShader** ppGeometryShader ) = 0;
		//! @brief WIgVF[_[̃t@C쐬܂
		//! @param[in] pSrc ̃t@C̃|C^
		//! @param[in] srcSize ̃t@C̃TCY
		//! @param[out] ppGeometryShader 쐬WIgVF[_[n Mix::Graphics::IGeometryShader C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		//! @note VF[_[fSAT̏ꍇɎgpł܂
		virtual Boolean CreateGeometryShaderFromMemory( const void* pSrc, UInt32 srcSize, Mix::Graphics::IGeometryShader** ppGeometryShader, const wchar_t* pDebugName = NULL ) = 0;
		//! @brief o[ebNXVF[_[t@C쐬܂
		//! @param[in] pFilePath t@CpX
		//! @param[out] ppVertexShader 쐬o[ebNXVF[_[n Mix::Graphics::IVertexShader C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateVertexShaderFromFile( const wchar_t* pFilePath, Mix::Graphics::IVertexShader** ppVertexShader ) = 0;
		//! @brief o[ebNXVF[_[̃t@C쐬܂
		//! @param[in] pSrc o[ebNXVF[_[̍쐬Ɏg̃t@C̃|C^
		//! @param[in] srcSize ̃t@C̃TCY
		//! @param[out] ppVertexShader 쐬o[ebNXVF[_[n Mix::Graphics::IVertexShader C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateVertexShaderFromMemory( const void* pSrc, UInt32 srcSize, Mix::Graphics::IVertexShader** ppVertexShader, const wchar_t* pDebugName = NULL ) = 0;
		//! @brief sNZVF[_[t@C쐬܂
		//! @param[in] pFilePath t@CpX
		//! @param[out] ppPixelShader 쐬sNZVF[_[n Mix::Graphics::IPixelShader C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreatePixelShaderFromFile( const wchar_t* pFilePath, Mix::Graphics::IPixelShader** ppPixelShader ) = 0;
		//! @brief sNZVF[_[̃t@C쐬܂
		//! @param[in] pSrcData sNZVF[_[̍쐬Ɏg̃t@C̃|C^
		//! @param[in] srcDataSize ̃t@C̃TCY
		//! @param[out] ppPixelShader 쐬sNZVF[_[n Mix::Graphics::IPixelShader C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreatePixelShaderFromMemory( const void* pSrcData, UInt32 srcDataSize, Mix::Graphics::IPixelShader** ppPixelShader, const wchar_t* pDebugName = NULL ) = 0;

		//! @brief VF[_[萔쐬܂
		//! @param[in] size VF[_[萔̃TCY
		//! @param[in] bDynamic Ȉꍇ True
		//! @param[in] pInitialData 쐬̏f[^
		//! @param[out] ppShaderConstant 쐬VF[_[萔\ Mix::Graphics::IShaderConstant C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @note VF[_[fSAT̏ꍇɎgpł܂
		virtual Boolean CreateShaderConstant( UInt32 size, Boolean bDynamic, const void* pInitialData, Mix::Graphics::IShaderConstant** ppShaderConstant, const wchar_t* pDebugName = NULL ) = 0;

		//! @brief o[ebNXCAEg쐬܂
		//! @param[in] pElements vf\ Mix::Graphics::VERTEX_ELEMENT ̔z
		//! @param[in] numElement vf̐
		//! @param[in] pVertexShader ̓VOl`r Mix::Graphics::IVertexShader C^[tF[X̃|C^
		//! @param[out] ppVertexLayout 쐬o[ebNXCAEgn Mix::Graphics::IVertexLayout C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateVertexLayout( const Mix::Graphics::VERTEX_ELEMENT* pElements, UInt32 numElement, const Mix::Graphics::IVertexShader* pVertexShader, Mix::Graphics::IVertexLayout** ppVertexLayout, const wchar_t* pDebugName = NULL ) = 0;
		//! @brief o[ebNXobt@쐬܂
		//! @param[in] count ő咸_
		//! @param[in] stride _̃oCgTCY
		//! @param[in] bDynamic Ȉꍇ True
		//! @param[in] resizeStep TCYXebv( _P )
		//! @param[in] pInitialData 쐬̏f[^
		//! @param[out] ppVertexBuffer 쐬o[ebNXobt@n Mix::Graphics::IVertexBuffer C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateVertexBuffer( UInt32 count, UInt32 stride, Boolean bDynamic, UInt32 resizeStep, const void* pInitialData, Mix::Graphics::IVertexBuffer** ppVertexBuffer, const wchar_t* pDebugName = NULL ) = 0;
		//! @brief CfbNXobt@쐬܂
		//! @param[in] format CfbNX̃tH[}bg\ Mix::Graphics::INDEX_FORMAT 񋓒萔
		//! @param[in] count őCfbNX
		//! @param[in] bDynamic Ȉꍇ True
		//! @param[in] resizeStep CfbNXobt@̃TCYXebv( CfbNXP )
		//! @param[in] pInitialData 쐬̏f[^
		//! @param[out] ppIndexBuffer 쐬CfbNXobt@n Mix::Graphics::IIndexBuffer C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateIndexBuffer( Mix::Graphics::INDEX_FORMAT format, UInt32 count, Boolean bDynamic, UInt32 resizeStep, const void* pInitialData, Mix::Graphics::IIndexBuffer** ppIndexBuffer, const wchar_t* pDebugName = NULL ) = 0;

		//! @brief eNX`t@C쐬܂
		//! @param[in] pFilePath t@CpX
		//! @param[out] ppTexture 쐬eNX`n Mix::Graphics::ITexture C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateTextureFromFile( const wchar_t* pFilePath, Mix::Graphics::ITexture** ppTexture ) = 0;
		//! @brief eNX`̃t@C쐬܂
		//! @param[in] pFilePath t@CpX
		//! @param[in] pSrc ̃eNX`t@C
		//! @param[in] srcSize ̃eNX`t@C̃TCY
		//! @param[out] ppTexture 쐬eNX`n Mix::Graphics::ITexture C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateTextureFromMemory( const wchar_t* pFilePath, const void* pSrc, UInt32 srcSize, Mix::Graphics::ITexture** ppTexture ) = 0;
		//! @brief _Ci~bNeNX`쐬܂
		//! @param[in] width eNX`̕
		//! @param[in] height eNX`̍
		//! @param[in] format eNX`̃tH[}bg\ Mix::Graphics::FORMAT 񋓒萔
		//! @param[out] ppTexture 쐬_Ci~bNeNX`n Mix::Graphics::ITexture C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		//! @note Mix::Graphics::ITexture::Lock gp CPU ɂ鏑݁AGPU ɂǂݎ肪\łB
		virtual Boolean CreateDynamicPlaneTexture( UInt32 width, UInt32 height, Mix::Graphics::FORMAT format, Mix::Graphics::ITexture** ppTexture, const wchar_t* pDebugName = NULL ) = 0;
		//! @brief ^[QbgeNX`쐬܂
		//! @param[in] width eNX`̕
		//! @param[in] height eNX`̍
		//! @param[in] format eNX`̃tH[}bg\ Mix::Graphics::FORMAT 񋓒萔
		//! @param[out] ppTexture 쐬^[QbgeNX`n Mix::Graphics::ITexture C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateTargetPlaneTexture( UInt32 width, UInt32 height, Mix::Graphics::FORMAT format, Mix::Graphics::ITexture** ppTexture, const wchar_t* pDebugName = NULL ) = 0;
		//! @brief ^[QbgeNX`쐬܂
		//! @param[in] width eNX`̕
		//! @param[in] height eNX`̍
		//! @param[in] format eNX`̃tH[}bg\ Mix::Graphics::FORMAT 񋓒萔
		//! @param[out] ppTexture 쐬^[QbgeNX`n Mix::Graphics::ITexture C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		//! @note Mix::Graphics::ITexture::Lock gp CPU ɂǂݎAGPU ɂ鏑݂\łB
		virtual Boolean CreateLockableTargetPlaneTexture( UInt32 width, UInt32 height, Mix::Graphics::FORMAT format, Mix::Graphics::ITexture** ppTexture, const wchar_t* pDebugName = NULL ) = 0;
		//! @brief ^[QbgeNX`쐬܂
		//! @param[in] edgeLength GbW̒
		//! @param[in] format eNX`̃tH[}bg\ Mix::Graphics::FORMAT 񋓒萔
		//! @param[out] ppTexture 쐬^[QbgeNX`n Mix::Graphics::ITexture C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateTargetCubeTexture( UInt32 edgeLength, Mix::Graphics::FORMAT format, Mix::Graphics::ITexture** ppTexture, const wchar_t* pDebugName = NULL ) = 0;
		//! @brief fvXeNX`쐬܂
		//! @param[in] width eNX`̕
		//! @param[in] height eNX`̍
		//! @param[in] format eNX`̃tH[}bg\ Mix::Graphics::FORMAT 񋓒萔<br>
		//! uFMT_D16vuFMT_D32vuFMT_D24S8v̂ꂩw肵Ă
		//! @param[out] ppTexture 쐬fvXeNX`n Mix::Graphics::ITexture C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateDepthTexture( UInt32 width, UInt32 height, Mix::Graphics::FORMAT format, Mix::Graphics::ITexture** ppTexture, const wchar_t* pDebugName = NULL ) = 0;

		//! @brief NG쐬܂
		//! @param[in] format NG̃tH[}bg\ Mix::Graphics::QUERY_FORMAT 񋓒萔
		//! @param[out] ppQuery 쐬NGn Mix::Graphics::IQuery C^[tF[X̃|C^̃AhX
		//! @param[in] pDebugName fobO
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateQuery( Mix::Graphics::QUERY_FORMAT format, Mix::Graphics::IQuery** ppQuery, const wchar_t* pDebugName = NULL ) = 0;

		//! @brief `Jn܂
		//! @return ꍇ True Ԃ܂
		virtual Boolean Begin( void ) = 0;
		//! @brief `I܂
		virtual void End( void ) = 0;
		//! @brief obNobt@̓e]܂
		virtual void Present( void ) = 0;

		//! @brief `^[Qbg擾܂
		//! @param ppT0 Xbg 0 Ƀ^[QbgƂĐݒ肳Ă Mix::Graphics::ITexture C^[tF[X̃|C^̃AhX
		//! @param ppT1 Xbg 1 Ƀ^[QbgƂĐݒ肳Ă Mix::Graphics::ITexture C^[tF[X̃|C^̃AhX
		//! @param ppT2 Xbg 2 Ƀ^[QbgƂĐݒ肳Ă Mix::Graphics::ITexture C^[tF[X̃|C^̃AhX
		//! @param ppT3 Xbg 3 Ƀ^[QbgƂĐݒ肳Ă Mix::Graphics::ITexture C^[tF[X̃|C^̃AhX
		//! @param ppDS fvX/XeVobt@ƂĐݒ肳Ă Mix::Graphics::ITexture C^[tF[X̃|C^̃AhX
		virtual void GetTarget( Mix::Graphics::ITexture** ppT0, Mix::Graphics::ITexture** ppT1, Mix::Graphics::ITexture** ppT2, Mix::Graphics::ITexture** ppT3, Mix::Graphics::ITexture** ppDS ) = 0;
		//! @brief `^[Qbgݒ肵܂
		//! @param pT0 Xbg 0 Ƀ^[QbgƂĐݒ肷 Mix::Graphics::ITexture C^[tF[X̃|C^
		//! @param pT1 Xbg 1 Ƀ^[QbgƂĐݒ肷 Mix::Graphics::ITexture C^[tF[X̃|C^
		//! @param pT2 Xbg 2 Ƀ^[QbgƂĐݒ肷 Mix::Graphics::ITexture C^[tF[X̃|C^
		//! @param pT3 Xbg 3 Ƀ^[QbgƂĐݒ肷 Mix::Graphics::ITexture C^[tF[X̃|C^
		//! @param pDS fvX/XeVobt@ƂĐݒ肷 Mix::Graphics::ITexture C^[tF[X̃|C^
		virtual void SetTarget( Mix::Graphics::ITexture* pT0, Mix::Graphics::ITexture* pT1, Mix::Graphics::ITexture* pT2, Mix::Graphics::ITexture* pT3, Mix::Graphics::ITexture* pDS ) = 0;

		//! @brief ݂̕`^[QbgNA܂
		//! @param[in] clearTarget ^[QbgeNX`NAꍇ True
		//! @param[in] clearDepth fvXeNX`NAꍇ True
		//! @param[in] color ^[QbgeNX`̃NAF\ Mix::Vector4 NX
		//! @param[in] z fvXeNX`NAۂ̒l
		virtual void Clear( Boolean clearTarget, Boolean clearDepth, const Mix::Vector4& color = Mix::Vector4(), Float32 z = 1.0f ) = 0;

		//! @brief r[͈̔͂擾܂
		//! @return r[͈̔͂\ Mix::Rectangle NXԂ܂
		virtual const Mix::Rectangle& GetViewBounds( void ) const = 0;
		//! @brief r[͈̔͂ݒ肵܂
		//! @param[in] x r[͈̔͂̍wW
		//! @param[in] y r[͈̔͂̍xW
		//! @param[in] width r[͈̔͂̕
		//! @param[in] height r[͈̔͂̍
		virtual void SetViewBounds( Int32 x, Int32 y, Int32 width, Int32 height ) = 0;
		//! @brief r[͈̔͂ݒ肵܂
		//! @param[in] rect r[͈̔͂\ Mix::Rectangle NX
		virtual void SetViewBounds( const Mix::Rectangle& rect ) = 0;

		//! @brief VUO͈̔͂擾܂
		//! @return VUO͈̔͂\ Mix::Rectangle NXԂ܂
		virtual const Mix::Rectangle& GetScissorBounds( void ) const = 0;
		//! @brief VUO͈̔͂ݒ肵܂
		//! @param[in] rect VUO͈̔͂\ Mix::Rectangle NX
		virtual void SetScissorBounds( const Mix::Rectangle& rect ) = 0;
		//! @brief VUO͈̔͂ݒ肵܂
		//! @param[in] x VU[`̍wW
		//! @param[in] y VU[`̍xW
		//! @param[in] width VU[`̕
		//! @param[in] height VU[`̍
		virtual void SetScissorBounds( Int32 x, Int32 y, Int32 width, Int32 height ) = 0;

		//! @brief X^CUXe[g擾܂
		//! @return X^CUXe[g\ Mix::Graphics::RASTERIZER_DESC \̂Ԃ܂
		virtual const Mix::Graphics::RASTERIZER_DESC& GetRasterizerState( void ) const = 0;
		//! @brief X^CUXe[gݒ肵܂
		//! @param[in] fillMode `惂[h
		//! @param[in] cullMode JO[h
		//! @param[in] bScissoring VUOLɂꍇ True
		virtual void SetRasterizerState( Mix::Graphics::FILL_TYPE fillMode, Mix::Graphics::CULL_TYPE cullMode, Boolean bScissoring ) = 0;
		//! @brief X^CUXe[gݒ肵܂
		//! @param[in] desc X^CUXe[g\ Mix::Graphics::RASTERIZER_DESC \
		virtual void SetRasterizerState( const Mix::Graphics::RASTERIZER_DESC& desc ) = 0;

		//! @brief fvXXe[g擾܂
		//! @return fvXXe[g\ Mix::Graphics::DEPTH_DESC \̂Ԃ܂
		virtual const Mix::Graphics::DEPTH_DESC& GetDepthState( void ) const = 0;
		//! @brief fvXXe[gݒ肵܂
		//! @param[in] bTest [xeXgLɂꍇ True
		//! @param[in] bWrite [xobt@ւ݂̏Lɂꍇ True
		//! @param[in] func [xeXgɎgpt@NV\ Mix::Graphics::ZFUNC_TYPE 񋓒萔
		virtual void SetDepthState( Boolean bTest, Boolean bWrite, Mix::Graphics::ZFUNC_TYPE func = Mix::Graphics::ZFUNC_LESSEQUAL ) = 0;
		//! @brief fvXXe[gݒ肵܂
		//! @param[in] desc fvXXe[g\ Mix::Graphics::DEPTH_DESC \
		virtual void SetDepthState( const Mix::Graphics::DEPTH_DESC& desc ) = 0;

		//! @brief uhXe[g擾܂
		//! @return uhXe[g\ Mix::Graphics::BLEND_DESC \̂Ԃ܂
		virtual const Mix::Graphics::BLEND_DESC& GetBlendState( void ) const = 0;
		//! @brief uhXe[gݒ肵܂
		//! @param[in] type uh^Cv\ Mix::Graphics::BLEND_TYPE 񋓒萔
		//! @param[in] colorWriteMask J[̏݃}XN\ Mix::Graphics::COLOR_WRITE_MASK 񋓒萔
		virtual void SetBlendState( Mix::Graphics::BLEND_TYPE type, Mix::Graphics::COLOR_WRITE_MASK colorWriteMask = Mix::Graphics::COLOR_WRITE_RGBA ) = 0;
		//! @brief uhXe[gݒ肵܂
		//! @param[in] desc uhXe[g\ Mix::Graphics::BLEND_DESC \
		virtual void SetBlendState( const Mix::Graphics::BLEND_DESC& desc ) = 0;

		//! @brief o[ebNXCAEgݒ肵܂
		//! @param[in] pVertexLayout ݒ肷o[ebNXCAEg\ Mix::Graphics::IVertexLayout C^[tF[X̃|C^
		virtual void SetVertexLayout( Mix::Graphics::IVertexLayout* pVertexLayout ) = 0;

		//! @brief nVF[_[ݒ肵܂
		//! @param[in] pHullShader ݒ肷nVF[_[\ Mix::Graphics::IHullShader C^[tF[X̃|C^
		//! @note VF[_[fT̏ꍇɎgpł܂
		virtual void SetHullShader( Mix::Graphics::IHullShader* pHullShader ) = 0;
		//! @brief hCVF[_[ݒ肵܂
		//! @param[in] pDomainShader ݒ肷hCVF[_[\ Mix::Graphics::IDomainShader C^[tF[X̃|C^
		//! @note VF[_[fT̏ꍇɎgpł܂
		virtual void SetDomainShader( Mix::Graphics::IDomainShader* pDomainShader ) = 0;
		//! @brief WIgVF[_[ݒ肵܂
		//! @param[in] pGeometryShader ݒ肷WIgVF[_[\ Mix::Graphics::IGeometryShader C^[tF[X̃|C^
		//! @note VF[_[fSAT̏ꍇɎgpł܂
		virtual void SetGeometryShader( Mix::Graphics::IGeometryShader* pGeometryShader ) = 0;
		//! @brief o[ebNXVF[_[ݒ肵܂
		//! @param[in] pVertexShader ݒ肷o[ebNXVF[_[\ Mix::Graphics::IVertexShader C^[tF[X̃|C^
		virtual void SetVertexShader( Mix::Graphics::IVertexShader* pVertexShader ) = 0;
		//! @brief sNZVF[_[ݒ肵܂
		//! @param[in] pPixelShader ݒ肷sNZVF[_[\ Mix::Graphics::IPixelShader C^[tF[X̃|C^
		virtual void SetPixelShader( Mix::Graphics::IPixelShader* pPixelShader ) = 0;

		//! @brief o[ebNXVF[_[Ƀu[^萔ݒ肵܂
		//! @param[in] startRegister ŏ̒萔i[郌WX^ԍ
		//! @param[in] data 萔z̃|C^
		//! @param[in] count 萔z̃u[l̐
		//! @note VF[_[fȐꍇɎgpł܂
		virtual void SetVertexShaderConstantB( UInt32 startRegister, const Boolean* data, UInt32 count ) = 0;
		//! @brief o[ebNXVF[_[ɐ^萔ݒ肵܂
		//! @param[in] startRegister ŏ̒萔i[郌WX^ԍ
		//! @param[in] data 萔z̃|C^
		//! @param[in] count 萔z4̐l̐
		//! @note VF[_[fȐꍇɎgpł܂
		virtual void SetVertexShaderConstantI( UInt32 startRegister, const Int32* data, UInt32 count ) = 0;
		//! @brief o[ebNXVF[_[ɕ_^萔ݒ肵܂
		//! @param[in] startRegister ŏ̒萔i[郌WX^ԍ
		//! @param[in] data 萔z̃|C^
		//! @param[in] count 萔z4̕_l̐
		//! @note VF[_[fȐꍇɎgpł܂
		virtual void SetVertexShaderConstantF( UInt32 startRegister, const Float32* data, UInt32 count ) = 0;
		//! @brief o[ebNXVF[_[ɕ_xNg萔ݒ肵܂
		//! @param[in] startRegister ŏ̒萔i[郌WX^ԍ
		//! @param[in] data 萔z̃|C^
		//! @param[in] count 萔z̕_xNg̐
		//! @note VF[_[fȐꍇɎgpł܂
		virtual void SetVertexShaderConstantF( UInt32 startRegister, const Mix::Vector4* data, UInt32 count ) = 0;
		//! @brief o[ebNXVF[_[ɕ_s萔ݒ肵܂
		//! @param[in] startRegister ŏ̒萔i[郌WX^ԍ
		//! @param[in] data 萔z̃|C^
		//! @param[in] count 萔z̕_xNg̐
		//! @note VF[_[fȐꍇɎgpł܂
		virtual void SetVertexShaderConstantF( UInt32 startRegister, const Mix::Matrix4x4* data, UInt32 count ) = 0;
		//! @brief sNZVF[_[Ƀu[^萔ݒ肵܂
		//! @param[in] startRegister ŏ̒萔i[郌WX^ԍ
		//! @param[in] data 萔z̃|C^
		//! @param[in] count 萔z̃u[l̐
		//! @note VF[_[fȐꍇɎgpł܂
		virtual void SetPixelShaderConstantB( UInt32 startRegister, const Boolean* data, UInt32 count ) = 0;
		//! @brief sNZVF[_[ɐ^萔ݒ肵܂
		//! @param[in] startRegister ŏ̒萔i[郌WX^ԍ
		//! @param[in] data 萔z̃|C^
		//! @param[in] count 萔z4̐l̐
		//! @note VF[_[fȐꍇɎgpł܂
		virtual void SetPixelShaderConstantI( UInt32 startRegister, const Int32* data, UInt32 count ) = 0;
		//! @brief sNZVF[_[ɕ_^萔ݒ肵܂
		//! @param[in] startRegister ŏ̒萔i[郌WX^ԍ
		//! @param[in] data 萔z̃|C^
		//! @param[in] count 萔z4̕_l̐
		//! @note VF[_[fȐꍇɎgpł܂
		virtual void SetPixelShaderConstantF( UInt32 startRegister, const Float32* data, UInt32 count ) = 0;
		//! @brief sNZVF[_[ɕ_xNg萔ݒ肵܂
		//! @param[in] startRegister ŏ̒萔i[郌WX^ԍ
		//! @param[in] data 萔z̃|C^
		//! @param[in] count 萔z̕_xNg̐
		//! @note VF[_[fȐꍇɎgpł܂
		virtual void SetPixelShaderConstantF( UInt32 startRegister, const Mix::Vector4* data, UInt32 count ) = 0;
		//! @brief sNZVF[_[ɕ_s萔ݒ肵܂
		//! @param[in] startRegister ŏ̒萔i[郌WX^ԍ
		//! @param[in] data 萔z̃|C^
		//! @param[in] count 萔z̕_xNg̐
		//! @note VF[_[fȐꍇɎgpł܂
		virtual void SetPixelShaderConstantF( UInt32 startRegister, const Mix::Matrix4x4* data, UInt32 count ) = 0;

		//! @brief nVF[_[ɒ萔ݒ肵܂
		//! @param[in] slot ݒ肷Xbg
		//! @param[in] pShaderConstant ݒ肷VF[_[萔\ Mix::Graphics::IShaderConstant C^[tF[X̃|C^
		//! @note VF[_[fT̏ꍇɎgpł܂
		virtual void SetHullShaderConstant( UInt32 slot, Mix::Graphics::IShaderConstant* pShaderConstant ) = 0;
		//! @brief hCVF[_[ɒ萔ݒ肵܂
		//! @param[in] slot ݒ肷Xbg
		//! @param[in] pShaderConstant ݒ肷VF[_[萔\ Mix::Graphics::IShaderConstant C^[tF[X̃|C^
		//! @note VF[_[fT̏ꍇɎgpł܂
		virtual void SetDomainShaderConstant( UInt32 slot, Mix::Graphics::IShaderConstant* pShaderConstant ) = 0;
		//! @brief WIgVF[_[ɒ萔ݒ肵܂
		//! @param[in] slot ݒ肷Xbg
		//! @param[in] pShaderConstant ݒ肷VF[_[萔\ Mix::Graphics::IShaderConstant C^[tF[X̃|C^
		//! @note VF[_[fSAT̏ꍇɎgpł܂
		virtual void SetGeometryShaderConstant( UInt32 slot, Mix::Graphics::IShaderConstant* pShaderConstant ) = 0;
		//! @brief o[ebNXVF[_[ɒ萔ݒ肵܂
		//! @param[in] slot ݒ肷Xbg
		//! @param[in] pShaderConstant ݒ肷VF[_[萔\ Mix::Graphics::IShaderConstant C^[tF[X̃|C^
		virtual void SetVertexShaderConstant( UInt32 slot, Mix::Graphics::IShaderConstant* pShaderConstant ) = 0;
		//! @brief sNZVF[_[ɒ萔ݒ肵܂
		//! @param[in] slot ݒ肷Xbg
		//! @param[in] pShaderConstant ݒ肷VF[_[萔\ Mix::Graphics::IShaderConstant C^[tF[X̃|C^
		virtual void SetPixelShaderConstant( UInt32 slot, Mix::Graphics::IShaderConstant* pShaderConstant ) = 0;

		//! @brief o[ebNXobt@ݒ肵܂
		//! @param[in] pVertexBuffer ݒ肷o[ebNXobt@\ Mix::Graphics::IVertexBuffer C^[tF[X̃|C^
		virtual void SetVertexBuffer( Mix::Graphics::IVertexBuffer* pVertexBuffer ) = 0;
		//! @brief CfbNXobt@ݒ肵܂
		//! @param[in] pIndexBuffer ݒ肷CfbNXobt@\ Mix::Graphics::IIndexBuffer C^[tF[X̃|C^
		virtual void SetIndexBuffer( Mix::Graphics::IIndexBuffer* pIndexBuffer ) = 0;

		//! @brief eNX`Xe[W̍ő吔擾܂
		//! @return eNX`Xe[W̍ő吔Ԃ܂
		virtual UInt32 GetTextureStageMax( void ) const = 0;
		//! @brief eNX`ݒ肵܂
		//! @param[in] stage eNX`ݒ肷Xe[W
		//! @param[in] filter eNX`ɓKptB^\ Mix::Graphics::TEXTURE_FILTER 񋓒萔
		//! @param[in] address eNX`ɓKpW̉@\ Mix::Graphics::TEXTURE_ADDRESS 񋓒萔
		//! @param[in] pTexture ݒ肷eNX`\ Mix::Graphics::ITexture C^[tF[X̃|C^
		virtual void SetTexture( UInt32 stage, Mix::Graphics::TEXTURE_FILTER_TYPE filter, Mix::Graphics::TEXTURE_ADDRESS_TYPE address, Mix::Graphics::ITexture* pTexture ) = 0;
		//! @brief eNX` NULL ɐݒ肵܂
		//! @param[in] stage NULL ɐݒ肷eNX`Xe[W
		virtual void ResetTexture( UInt32 stage ) = 0;

		//! @brief v~eBu`悵܂
		//! @param[in] primitiveType v~eBu̎ނ\ Mix::Graphics::PRIMITIVE_TYPE 񋓒萔
		//! @param[in] startVertex _̊Jnʒu
		//! @param[in] numVertex `Ɏgp钸_
		virtual void Draw( Mix::Graphics::PRIMITIVE_TYPE primitiveType, UInt32 startVertex, UInt32 numVertex ) = 0;
		//! @brief CfbNXɊÂăv~eBu`悵܂
		//! @param[in] primitiveType v~eBu̎ނ\ Mix::Graphics::PRIMITIVE_TYPE 񋓒萔
		//! @param[in] startVertex _̊Jnʒu
		//! @param[in] numVertex `Ɏgp钸_
		//! @param[in] startIndex CfbNX̊Jnʒu
		//! @param[in] numIndex `ɎgpCfbNX
		virtual void DrawIndexed( Mix::Graphics::PRIMITIVE_TYPE primitiveType, UInt32 startVertex, UInt32 numVertex, UInt32 startIndex, UInt32 numIndex ) = 0;

		//! @brief `悵v~eBu̐擾܂
		//! @return `悵v~eBuԂ܂
		virtual UInt32 GetDrawPrimitiveCount( void ) const = 0;

		//! @brief XN[Vbgۑ܂
		//! @param[in] pFileName ۑt@C
		//! @return ꍇ True Ԃ܂
		//! @note BMPAJPGAPNG T|[gĂ܂
		virtual Boolean SaveScreenshot( const wchar_t* pFileName ) = 0;
	};

}}
