#pragma once

//! @file Mix/Geometry/Sphere.h
//! @brief XtBANXCN[ht@C

namespace Mix{ namespace Geometry{

	class AABB;

	//! @class Sphere
	//! @brief NX
	class _MIX_DLL_API Sphere
	{
	public:
		Mix::Vector3 center;	//!< SW
		Float32 radius;			//!< a

	public:
		//! @brief RXgN^
		Sphere( void );
		//! @brief RXgN^
		//! @param[in] cx SXW
		//! @param[in] cy SYW
		//! @param[in] cz SZW
		//! @param[in] r a
		Sphere( Float32 cx, Float32 cy, Float32 cz, Float32 r );
		//! @brief RXgN^
		//! @param[in] c SW\ Mix::Vector3 NX
		//! @param[in] r a
		Sphere( const Mix::Vector3& c, Float32 r );
		//! @brief RXgN^
		//! @param[in] aabb AABB\ Mix::Geometry::AABB NX
		Sphere( const Mix::Geometry::AABB& aabb );

	public:
		//! @brief AABB܂
		//! @param[in] aabb AABB\ Mix::Geometry::AABB NX
		//! @return \ Mix::Geometry::Sphere NXԂ܂
		//! @note AABB ɊSɓ鋅߂܂
		Mix::Geometry::Sphere& operator = ( const Mix::Geometry::AABB& aabb );

		//! @brief ܂
		//! @param[in] sphere 鋅\ Mix::Geometry::Sphere NX
		//! @return \ Mix::Geometry::Sphere NXԂ܂
		Mix::Geometry::Sphere& operator += ( const Mix::Geometry::Sphere& sphere );
		//! @brief AABB܂
		//! @param[in] aabb 鋅\ Mix::Geometry::AABB NX
		//! @return \ Mix::Geometry::Sphere NXԂ܂
		Mix::Geometry::Sphere& operator += ( const Mix::Geometry::AABB& aabb );

		//! @brief ܂
		//! @param[in] sphere 鋅\ Mix::Geometry::Sphere NX
		//! @return \ Mix::Geometry::Sphere NXԂ܂
		Mix::Geometry::Sphere operator + ( const Mix::Geometry::Sphere& sphere ) const;
		//! @brief AABB܂
		//! @param[in] aabb AABB\ Mix::Geometry::AABB NX
		//! @return \ Mix::Geometry::Sphere NXԂ܂
		Mix::Geometry::Sphere operator + ( const Mix::Geometry::AABB& aabb ) const;
	};

}}
