#pragma once

//! @file Mix/Geometry/Frustum.h
//! @brief tX^NXCN[ht@C

#include "Mix/Geometry/AABB.h"
#include "Mix/Geometry/Plane.h"
#include "Mix/Geometry/Sphere.h"

namespace Mix{ namespace Geometry{

	//! @class Frustum
	//! @brief tX^NX
	class Frustum
	{
	public:
		//! @enum PLANE_TYPE
		//! @brief v[^Cv񋓒萔
		enum PLANE_TYPE
		{
			PLANE_NEAR		= 0,	//!< O
			PLANE_FAR		= 1,	//!< 
			PLANE_TOP		= 2,	//!< 
			PLANE_BOTTOM	= 3,	//!< 
			PLANE_LEFT		= 4,	//!< 
			PLANE_RIGHT		= 5,	//!< E
		};

	private:
		Mix::Matrix4x4 m_ViewProjMat;
		Mix::Geometry::Plane m_Planes[6];

	public:
		//! @brief RXgN^
		Frustum( void );
		//! @brief RXgN^
		//! @param[in] viewProjMat ϊs\ Mix::Matrix4x4 NX
		Frustum( const Mix::Matrix4x4& viewProjMat );

		//! @brief XVs܂
		void Update( const Mix::Matrix4x4& viewProjMat );

		//! @brief ϊs擾܂
		//! @return ϊs\ Mix::Matrix4x4 NXԂ܂
		const Mix::Matrix4x4& GetViewProjectionMatrix( void ) const;

		//! @brief tX^\镽ʂ擾܂
		//! @param[in] type Mix::Geometry::Frustum::PLANE_TYPE 񋓒萔
		//! @return ʂ\ Mix::Geometry::Plane NXԂ܂
		const Mix::Geometry::Plane& GetPlane( Mix::Geometry::Frustum::PLANE_TYPE type ) const;

		//! @brief _tX^ɓĂ邩ǂ𔻒肵܂
		//! @param[in] point _\ Mix::Vector3 NX
		//! @return _tX^ɓĂꍇ True Ԃ܂
		Boolean Contains( const Mix::Vector3& point ) const;
		//! @brief tX^ɓĂ邩ǂ𔻒肵܂
		//! @param[in] sphere \ Mix::Geometry::Sphere NX
		//! @return tX^ɓĂꍇ True Ԃ܂
		Boolean Contains( const Mix::Geometry::Sphere& sphere ) const;
		//! @brief tX^ɓĂ邩ǂ𔻒肵܂( Top Bottom Left Right )
		//! @param[in] sphere \ Mix::Geometry::Sphere NX
		//! @return tX^ɓĂꍇ True Ԃ܂
		Boolean ContainsTBLR( const Mix::Geometry::Sphere& sphere ) const;
		//! @brief AABBtX^ɓĂ邩ǂ𔻒肵܂
		//! @param[in] aabb AABB\ Mix::Geometry::AABB NX
		//! @return AABBtX^ɓĂꍇ True Ԃ܂
		//! @note O Mix::Geometry::AABB::ComputePoints sĂKv܂
		Boolean Contains( const Mix::Geometry::AABB& aabb ) const;
		//! @brief AABBtX^ɓĂ邩ǂ𔻒肵܂( Top Bottom Left Right )
		//! @param[in] aabb AABB\ Mix::Geometry::AABB NX
		//! @return AABBtX^ɓĂꍇ True Ԃ܂
		//! @note O Mix::Geometry::AABB::ComputePoints sĂKv܂
		Boolean ContainsTBLR( const Mix::Geometry::AABB& aabb ) const;
	};

}}
