#pragma once

//! @file Mix/Dynamics/IObjectListener.h
//! @brief IuWFNgXi[C^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace Dynamics{

	//! @class IObjectListener
	//! @brief IuWFNgXi[C^[tF[X
	class IObjectListener : public Mix::Reference
	{
	protected:
		//! @brief fXgN^
		virtual ~IObjectListener( void ){}

	public:
		//! @brief IuWFNg[hɒǉꂽۂɌĂяo܂
		//! @param[in] pObject [hɒǉꂽIuWFNg\ Mix::Dynamics::IObject C^[tF[X̃|C^
		//! @param[in] pWorld IuWFNgǉꂽ[h\ Mix::Dynamics::IWorld C^[tF[X̃|C^
		virtual void OnAddedToWorld( Mix::Dynamics::IObject* pObject, Mix::Dynamics::IWorld* pWorld ) = 0;
		//! @brief IuWFNg[h폜ꂽۂɌĂяo܂
		//! @param[in] pObject [h폜ꂽIuWFNg\ Mix::Dynamics::IObject C^[tF[X̃|C^
		//! @param[in] pWorld IuWFNg폜ꂽ[h\ Mix::Dynamics::IWorld C^[tF[X̃|C^
		virtual void OnRemovedFromWorld( Mix::Dynamics::IObject* pObject, Mix::Dynamics::IWorld* pWorld ) = 0;

		//! @brief IuWFNgڐGĂۂɌĂяo܂
		//! @param[in] pObject ̃Xi[ݒ肳ĂIuWFNg\ Mix::Dynamics::IObject C^[tF[X̃|C^
		//! @param[in] manifold }jtH[h\ Mix::Dynamics::MANIFOLD \
		virtual void OnContact( Mix::Dynamics::IObject* pObject, const Mix::Dynamics::MANIFOLD& manifold ) = 0;
	};

}}
