#pragma once

//! @file Mix/Dynamics/IObjectDragger.h
//! @brief IuWFNghbK[C^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace Dynamics{

	//! @class IObjectDragger
	//! @brief IuWFNhbK[gC^[tF[X
	class IObjectDragger : public Mix::Reference
	{
	protected:
		//! @brief fXgN^
		virtual ~IObjectDragger( void ) {}

	public:
		//! @brief Lb`IuWFNg݂郏[h擾܂
		//! @param[out] ppWorld [h\ Mix::Dynamics::IWorld C^[tF[X̃|C^̃AhX
		virtual void GetWorld( Mix::Dynamics::IWorld** ppWorld ) = 0;

		//! @brief Lb`ۂ̃tB^[擾܂
		//! @return tB^[Ԃ܂
		virtual UInt16 GetCatchFilter( void ) const = 0;
		//! @brief Lb`ۂ̃tB^[ݒ肵܂
		//! @param[in] filter tB^[
		//! @note ݒ肷l̓_Ci~NX̃[hɃIuWFNgǉۂɐݒ肵tB^[O[vɂȂ܂
		virtual void SetCatchFilter( UInt16 filter ) = 0;

		//! @brief IuWFNgLb`Ă邩ǂ擾܂
		//! @return Lb`Ăꍇ True Ԃ܂
		virtual Boolean IsCatch( void ) const = 0;
		//! @brief Lb`ĂIuWFNg擾܂
		//! @param[out] ppObject Lb`ĂIuWFNg\ Mix::Dynamics::IObject C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean GetCatchObject( Mix::Dynamics::IObject** ppObject ) = 0;

		//! @brief [h̃IuWFNgLb`܂
		//! @param[in] eyePos _\ Mix::Vector3 NX
		//! @param[in] rayFrom sC̎n_\ Mix::Vector3 NX
		//! @param[in] rayTo sC̏I_\ Mix::Vector3 NX
		//! @return ꍇ True Ԃ܂
		//! @note Lb`łIuWFNg̓Wbh{fBɌ肳܂
		virtual Boolean CatchStart( const Mix::Vector3& eyePos, const Mix::Vector3& rayFrom, const Mix::Vector3& rayTo ) = 0;
		//! @brief XVs܂
		//! @param[in] eyePos _\ Mix::Vector3 NX
		//! @param[in] rayTo sC̏I_\ Mix::Vector3 NX
		//! @note Lb`ĂŒ͏ɌĂяoKv܂
		virtual void CatchContinue( const Mix::Vector3& eyePos, const Mix::Vector3& rayTo ) = 0;
		//! @brief Lb`ĂIuWFNg܂
		virtual void Free( void ) = 0;
	};

}}
