#pragma once

//! @file Mix/Dynamics/IObject.h
//! @brief IuWFNgC^[tF[XCN[ht@C

#include "Mix/Reference.h"
#include "Mix/Geometry/AABB.h"

namespace Mix{ namespace Dynamics{

	//! @class IObject
	//! @brief IuWFNgC^[tF[X
	class IObject : public Mix::Reference
	{
	public:
		//! @enum TYPE
		//! @brief ^Cv񋓒萔
		enum TYPE
		{
			STATIC_PLANE		= 0,	//!< X^eBbNv[
			STATIC_MESH			= 1,	//!< X^eBbNbV
			RIGIDBODY			= 2,	//!< Wbh{fB
			SENSOR				= 3,	//!< ZT[
			KINEMATIC_CHARACTER	= 4,	//!< Ll}eBbNLN^[
			VEHICLE				= 5,	//!< rnCN
		};

	protected:
		//! @brief fXgN^
		virtual ~IObject( void ) {}

	public:
		//! @brief ނ擾܂
		//! @return ނ\ Mix::Dynamics::IObject::TYPE 񋓒萔Ԃ܂
		virtual Mix::Dynamics::IObject::TYPE GetType( void ) const = 0;

		//! @brief VFCv擾܂
		//! @param[out] ppShape 擾VFCvn Mix::Dynamics::IShape C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note
		//! ȉ̃IuWFNg̓VFCv擾邱ƂłȂ߁A<br>
		//! ̃\bh͏ False Ԃ܂B<br>
		//! <br>
		//! Mix::Dynamics::IStaticPlane<br>
		//! Mix::Dynamics::IStaticMesh 
		virtual Boolean GetShape( Mix::Dynamics::IShape** ppShape ) = 0;

		//! @brief VFCv̏Փ˃}[W擾܂
		//! @return Փ˃}[WԂ܂
		//! @note Mix::Dynamics::IShape::GetMargine ĂяoĂ܂
		virtual Float32 GetShapeMargin( void ) const = 0;
		//! @brief VFCv̏Փ˃}[Wݒ肵܂
		//! @param[in] margin Փ˃}[W
		//! @note Mix::Dynamics::IShape::SetMargine ĂяoĂ܂
		virtual void SetShapeMargin( Float32 margin ) = 0;

		//! @brief tB^[O[v擾܂
		//! @return tB^[O[vԂ܂
		virtual UInt16 GetFilterGroup( void ) const = 0;
		//! @brief tB^[O[vݒ肵܂
		//! @param[in] filterGroup tB^[O[v
		virtual void SetFilterGroup( UInt16 filterGroup ) = 0;

		//! @brief tB^[}XN擾܂
		//! @return tB^[}XNԂ܂
		virtual UInt16 GetFilterMask( void ) const = 0;
		//! @brief tB^[}XNݒ肵܂
		//! @param[in] filterMask tB^[}XN
		virtual void SetFilterMask( UInt16 filterMask ) = 0;

		//! @brief }eA擾܂
		//! @return }eA\ Mix::Dynamics::MATERIAL \̂Ԃ܂
		virtual const Mix::Dynamics::MATERIAL& GetMaterial( void ) const = 0;
		//! @brief }eAݒ肵܂
		//! @param[in] material }eA\ Mix::Dynamics::MATERIAL \
		virtual void SetMaterial( const Mix::Dynamics::MATERIAL& material ) = 0;

		//! @brief [h̉]擾܂
		//! @return [h̉]\ Mix::Quaternion NXԂ܂
		virtual Mix::Quaternion GetWorldRotation( void ) const = 0;
		//! @brief [ḧʒu擾܂
		//! @return ʒu\ Mix::Vector3 NXԂ܂
		virtual Mix::Vector3 GetWorldPosition( void ) const = 0;
		//! @brief [hs擾܂
		//! @return [hs\ Mix::Matrix4x4 NXԂ܂
		virtual Mix::Matrix4x4 GetWorldMatrix( void ) const = 0;

		//! @brief [h̉]ݒ肵܂
		//! @param[in] rot ]\ Mix::Quaternion NX
		virtual void SetWorldRotation( const Mix::Quaternion& rot ) = 0;
		//! @brief [ḧʒuݒ肵܂
		//! @param[in] pos ʒu\ Mix::Vector3 NX
		virtual void SetWorldPosition( const Mix::Vector3& pos ) = 0;
		//! @brief [hgXtH[ݒ肵܂
		//! @param[in] rot ]\ Mix::Quaternion NX
		//! @param[in] pos ʒu\ Mix::Vector3 NX
		virtual void SetWorldTransform( const Mix::Quaternion& rot, const Mix::Vector3& pos ) = 0;

		//! @brief [hɔzuĂ邩ǂmF܂
		//! @return zuĂꍇ True Ԃ܂
		virtual Boolean IsInWorld( void ) const = 0;

		//! @brief E擾܂
		//! @return E\ Mix::Geometry::AABB NXԂ܂
		virtual Mix::Geometry::AABB GetBounds( void ) const = 0;

		//! @brief Xi[ǉ܂
		//! @param[in] pListener ǉ郊Xi[\ Mix::Dynamics::IObjectListener C^[tF[X̃|C^
		//! @return ǉɐꍇ True Ԃ܂
		virtual Boolean AddListener( Mix::Dynamics::IObjectListener* pListener ) = 0;
		//! @brief Xi[폜܂
		//! @param[in] pListener 폜郊Xi[\ Mix::Dynamics::IObjectListener C^[tF[X̃|C^
		virtual void RemoveListener( Mix::Dynamics::IObjectListener* pListener ) = 0;

		//! @brief [U[CfbNX擾܂
		//! @return CfbNXԂ܂
		virtual Int32 GetUserIndex( void )  const = 0;
		//! @brief [U[CfbNXݒ肵܂
		//! @param index CfbNX
		//! @note ̒l̓[U[RɎgpł܂
		virtual void SetUserIndex( Int32 index ) = 0;

		//! @brief [U[|C^擾܂
		//! @return |C^Ԃ܂
		virtual void* GetUserPtr( void ) const = 0;
		//! @brief [U[|C^ݒ肵܂
		//! @param pData |C^
		//! @note ̒l̓[U[RɎgpł܂
		virtual void SetUserPtr( void* pData ) = 0;

		//! @brief fobO : `tO擾܂
		//! @return `tO\ Mix::Dynamics::DEBUG_DRAW_FLAG 񋓒萔̑gݍ킹Ԃ܂
		virtual UInt32 Debug_GetDrawFlags( void ) const = 0;
		//! @brief fobO : `tOݒ肵܂
		//! @param[in] flags `tO\ Mix::Dynamics::DEBUG_DRAW_FLAG 񋓒萔̑gݍ킹
		virtual void Debug_SetDrawFlags( UInt32 flags ) = 0;

		//! @brief fobO : `悷ۂ̂擾܂
		//! @return `悷ۂ̃XP[Ԃ܂
		virtual Float32 Debug_GetDrawAxisScaling( void ) const = 0;
		//! @brief fobO : `悷ۂ̃XP[ݒ肵܂
		//! @param[in] scaling `悷ۂ̃XP[( 0.0fȏ )
		virtual void Debug_SetDrawAxisScaling( Float32 scaling ) = 0;

		//! @brief fobO`܂
		//! @param[in] pPerspectiveRenderer fobO`p̃C^[tF[X\ Mix::Graphics::Utility::IPerspectiveRenderer C^[tF[X̃|C^
		//! @param[in] opacity sx( 0.0f`1.0f )
		virtual void Debug_Draw( Mix::Graphics::Utility::IPerspectiveRenderer* pPerspectiveRenderer, Float32 opacity = 1.0f ) = 0;
	};

}}
