#pragma once

//! @file Mix/Dynamics/IKinematicCharacter.h
//! @brief Ll}eBbNLN^[C^[tF[XCN[ht@C

#include "Mix/Dynamics/IObject.h"

namespace Mix{ namespace Dynamics {

	//! @class IKinematicCharacter
	//! @brief Ll}eBbNLN^[C^[tF[X
	//! @note
	//! SetWorldRotation SetWorldTransform Ȃǂ̂̉]͉e܂̂ŁA<br>
	//! [U[RɎgpČ\łB
	class IKinematicCharacter : public Mix::Dynamics::IObject
	{
	protected:
		//! @brief fXgN^
		virtual ~IKinematicCharacter( void ) {}

	public:
		//! @brief 擾܂
		//! @return Ԃ܂
		virtual Float32 GetHeight( void ) const = 0;
		//! @brief a擾܂
		//! @return aԂ܂
		virtual Float32 GetRadius( void ) const = 0;

		//! @brief d͂擾܂
		//! @return d͂Ԃ܂
		virtual Float32 GetGravity( void ) const = 0;
		//! @brief d͂ݒ肵܂
		//! @param[in] gravity d
		virtual void SetGravity( Float32 gravity ) = 0;

		//! @brief ő嗎x擾܂
		//! @return ő嗎xԂ܂
		virtual Float32 GetMaxFallSpeed( void ) const = 0;
		//! @brief ő嗎xݒ肵܂
		//! @param[in] speed ő嗎x( 0.0f ȏ )
		virtual void SetMaxFallSpeed( Float32 speed ) = 0;

		//! @brief Wv̏擾܂
		//! @return Wv̏Ԃ܂
		virtual Float32 GetInitalJumpSpeed( void ) const = 0;
		//! @brief Wv̏ݒ肵܂
		//! @param[in] speed Wv̏( 0.0f ȏ )
		virtual void SetInitalJumpSpeed( Float32 speed ) = 0;

		//! @brief i̍擾܂
		//! @return i̍Ԃ܂
		virtual Float32 GetStepHeight( void ) const = 0;
		//! @brief i̍ݒ肵܂
		//! @param[in] height i̍
		//! @note
		//! ̃\bh͐ݒ𔽉f邽߂ɁAIuWFNg蒼Ă܂̂ŁA<br>
		//! pɂɐݒ̕ύXƃptH[}Xɉeyڂ܂B
		virtual void SetStepHeight( Float32 height ) = 0;

		//! @brief z̊px擾܂
		//! @return z̊px̊pxԂ܂
		virtual Float32 GetSlopeLimit( void ) const = 0;
		//! @brief z̊pxݒ肵܂
		//! @param[in] rad z̊px(WAP)
		virtual void SetSlopeLimit( Float32 rad ) = 0;

		//! @brief ĂƔf鑬x擾܂
		//! @return xԂ܂
		virtual Float32 GetActiveThreshold( void ) const = 0;
		//! @brief ĂƔf鑬xݒ肵܂
		//! @param[in] threshold x( 0.0f ȏ )
		virtual void SetActiveThreshold( Float32 threshold ) = 0;
		//! @brief 񊈓ԂƔfoߎԂ擾܂
		//! @return oߎԂԂ܂
		virtual Float32 GetDeactivationElapsedTime( void ) const = 0;
		//! @brief 񊈓ԂƔfoߎԂݒ肵܂
		//! @param[in] elapsedTime oߎ( 0.0fȏ )
		virtual void SetDeactivationElapsedTime( Float32 elapsedTime ) = 0;

		//! @brief ړx擾܂
		//! @return ړx\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetLinearVelocity( void ) const = 0;
		//! @brief ړxݒ肵܂
		//! @param[in] velocity ړx\ Mix::Vector3 NX
		virtual void SetLinearVelocity( const Mix::Vector3& velocity ) = 0;

		//! @brief ڒnĂ邩ǂmF܂
		//! @return ڒnĂꍇ True Ԃ܂
		virtual Boolean OnGround( void ) const = 0;
		//! @brief Ă邩ǂmF܂
		//! @return Ăꍇ True Ԃ܂
		virtual Boolean IsActive( void ) const = 0;

		//! @brief Wv܂
		virtual void Jump( void ) = 0;
	};

}}
