#pragma once

//! @file Mix/Dynamics/ICompoundShape.h
//! @brief RpEhVFCvC^[tF[XCN[ht@C

#include "Mix/Dynamics/IShape.h"

namespace Mix{ namespace Dynamics{

	//! @class ICompoundShape
	//! @brief RpEhVFCvC^[tF[X
	//! @note
	//! ̃VFCvĈ̃VFCvƂĈ܂B<br>
	//! <br>
	//! Wbh{fB( Mix::Dynamics::IRigidBody )ɂłɐݒ肳ĂꍇłAǉA폜Ap̍XVȂǂsĂ܂߁A<br>
	//! ȉ̃\bhgpꍇ́AK UpdateLocalInertia ĂяoāAe\XVĂB<br>
	//! <br>
	//! AddChild<br>
	//! RemoveChildByIndex<br>
	//! RemoveChild<br>
	//! UpdateChildTransform<br>
	class ICompoundShape : public Mix::Dynamics::IShape
	{
	protected:
		//! @brief fXgN^
		virtual ~ICompoundShape( void ){}

	public:
		//! @brief qǉ܂
		//! @param[in] pShape ǉVFCv\  Mix::Dynamics::IShape C^[tF[X̃|C^
		//! @param[in] rot ]\ Mix::Quaternion NX
		//! @param[in] pos ʒu\ Mix::Vector3 NX
		//! @return ꍇ True Ԃ܂
		//! @note ǉq́AQƃJE^ +1 ܂
		virtual Boolean AddChild( Mix::Dynamics::IShape* pShape, const Mix::Quaternion& rot, const Mix::Vector3& pos ) = 0;
		//! @brief q폜܂
		//! @param[in] pShape 폜q\ Mix::Dynamics::IShape C^[tF[X̃|C^
		//! @note 폜q́AQƃJE^ -1 ܂
		virtual UInt32 RemoveChild( Mix::Dynamics::IShape* pShape ) = 0;
		//! @brief q폜܂
		//! @param[in] index 폜q̃CfbNX
		//! @note 폜q́AQƃJE^ -1 ܂
		virtual Boolean RemoveChildByIndex( UInt32 index ) = 0;

		//! @brief q擾܂
		//! @param[in] index q̃CfbNX
		//! @param[out] ppShape 擾q\ Mix::Dynamics::IShape C^[tF[X̃|C^̃AhX
		//! @return 擾ɐꍇ True Ԃ܂
		//! @note 擾q́AQƃJE^ +1 ܂
		virtual Boolean GetChildByIndex( UInt32 index, Mix::Dynamics::IShape** ppShape ) = 0;
		//! @brief q̃|C^擾܂
		//! @param[in] index q̃CfbNX
		//! @return 擾ɐꍇ́AMix::Dynamics::IShape C^[tF[X̃|C^Ԃ܂
		//! sꍇ NULL Ԃ܂
		virtual Mix::Dynamics::IShape* GetChildPtrByIndex( UInt32 index ) const = 0;

		//! @brief q̈ʒuA]p擾܂
		//! @param[in] index q̃CfbNX
		//! @param[in] rot ]\ Mix::Quaternion NX
		//! @param[in] pos ʒu\ Mix::Vector3 NX
		//! @return ꍇ True Ԃ܂
		virtual Boolean GetChildTransformByIndex( UInt32 index, Mix::Quaternion& rot, Mix::Vector3& pos ) = 0;
		//! @brief q̈ʒuƉ]pXV܂
		//! @param[in] index q̃CfbNX
		//! @param[in] rot ]\ Mix::Quaternion NX
		//! @param[in] pos ʒu\ Mix::Vector3 NX
		//! @return ꍇ True Ԃ܂
		virtual Boolean SetChildTransformByIndex( UInt32 index, const Mix::Quaternion& rot, const Mix::Vector3& pos ) = 0;

		//! @brief q̐擾܂
		//! @return q̐Ԃ܂
		virtual UInt32 GetChildCount( void ) const = 0;
	};

}}
