#pragma once

//! @file Mix/Common.h
//! @brief ʃCN[ht@C

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// CN[h
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <windows.h>
#include <vector>
#include <list>
#include <map>

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// x̖
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma warning ( disable: 4100 )	//֐̈xQƂĂȂƂɂłx𖳎( C^[tF[X̔hȂ )
#pragma warning ( disable: 4201 )	//\̂̌x𖳎
#pragma warning ( disable: 4786 )	//255蒷V{̌x𖳎

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// `
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//! @name DLL
//! @{

#ifdef _MIX_DLL
	#ifdef _MIX_DLL_EXPORTS
		//! @def _MIX_DLL_API
		//! @brief DLLGNX|[g`
		#define _MIX_DLL_API __declspec( dllexport )
	#else // _MIX_DLL_EXPORTS
		//! @def _MIX_DLL_API
		//! @brief DLLC|[g`
		#define _MIX_DLL_API __declspec( dllimport )
	#endif // _MIX_DLL_EXPORTS
#else //_MIX_DLL
	//! @def _MIX_DLL_API
	//! @brief DLL`
	#define _MIX_DLL_API
#endif //_MIX_DLL

//! @}

//! @name ϐ^
//! @{

//! @typedef Int8
//! @brief L8rbg
typedef char Int8;
//! @typedef UInt8
//! @brief 8rbg
typedef unsigned char UInt8;
//! @typedef Int16
//! @brief L16rbg
typedef short Int16;
//! @typedef UInt16
//! @brief 16rbg
typedef unsigned short UInt16;
//! @typedef Int32
//! @brief L32rbg
typedef int Int32;
//! @typedef UInt32
//! @brief 32rbg
typedef unsigned int UInt32;
//! @typedef Int64
//! @brief L64rbg
typedef long long Int64;
//! @typedef UInt64
//! @brief 64rbg
typedef unsigned long long UInt64;
//! @typedef Long32
//! @brief L32rbg
typedef long Long32;
//! @typedef ULong32
//! @brief 32rbg
typedef unsigned long ULong32;
//! @typedef Float32
//! @brief 32rbg_
typedef float Float32;
//! @typedef Float64
//! @brief 64rbg_
typedef double Float64;

//! @var typedef IntT
//! @brief L萮
#ifdef _WIN64
typedef long long IntT;
#else //_WIN64
typedef int IntT;
#endif //_WIN64

//! @var typedef UIntT
//! @brief 
typedef size_t UIntT;

//! @var typedef BOOL Boolean
//! @brief 32rbgu[A
typedef BOOL Boolean;
//! @def True
//! @brief Boolean^̐^l
#define True TRUE
//! @def False
//! @brief Boolean^̋Ul
#define False FALSE

//! @}

#ifdef _DEBUG

	//! @name AT[g
	//! vIȃG[bZ[W{bNXŕ\AAvP[VI܂B
	//! @{

	//! @def MIX_ASSERT
	//! @brief W̃AT[g
	#define MIX_ASSERT( cnd ) \
		if( !( cnd ) ) \
		{ \
			char text[1024]; \
			::sprintf_s( text, sizeof( text ), "File : \"%s\"\nLine : %d\nCondition : %s", __FILE__, __LINE__, #cnd ); \
			::MessageBoxA( ::GetActiveWindow(), text, "Assert", MB_OK | MB_ICONSTOP ); \
			*( ( int* )0x0 ) = 0x0; \
		}

	//! @def MIX_ASSERT_EX_W
	//! @brief gAT[g ( jR[h )
	#define MIX_ASSERT_EX_W( cnd, mes, ... ) \
		if( !( cnd ) ) \
		{ \
			wchar_t fmt[1024] = L"File : \"%s\"\nLine : %d\nCondition : %s\n\n"; \
			wchar_t text[1024]; \
			::wcscat_s( fmt, ( sizeof( fmt ) >> 1 ), mes ); \
			::swprintf_s( text, fmt, __FILEW__, __LINE__, L#cnd, __VA_ARGS__ ); \
			::MessageBoxW( ::GetActiveWindow(), text, L"Assert", MB_OK | MB_ICONSTOP ); \
			*( ( int* )0x0 ) = 0x0; \
		}

	//! @def MIX_ASSERT_EX_A
	//! @brief gAT[g ( }`oCg )
	#define MIX_ASSERT_EX_A( cnd, mes, ... ) \
		if( !( cnd ) ) \
		{ \
			char fmt[1024] = "File : \"%s\"\nLine : %d\nCondition : %s\n\n"; \
			char text[1024]; \
			::strcat_s( fmt, sizeof( fmt ), mes ); \
			::sprintf_s( text, sizeof( text ), fmt, __FILE__, __LINE__, #cnd, __VA_ARGS__ ); \
			::MessageBoxA( ::GetActiveWindow(), text, "Assert", MB_OK | MB_ICONSTOP ); \
			*( ( int* )0x0 ) = 0x0; \
		}

	//! @def MIX_ASSERT_EX
	//! @brief W̊gAT[g
	#define MIX_ASSERT_EX MIX_ASSERT_EX_W

	//! @}

	//! @name G[
	//! G[bZ[W{bNXƂĕ\܂B<br>
	//! ܂AAT[ĝ悤ɃAvP[V͋I܂B
	//! @{

	//! @def MIX_ERROR_W
	//! @brief G[ ( jR[h )
	#define MIX_ERROR_W( mes, ... ) \
		{ \
			wchar_t fmt[1024] = L"File : \"%s\"\nLine : %d\n\n"; \
			wchar_t text[1024]; \
			::wcscat_s( fmt, ( sizeof( fmt ) >> 1 ), mes ); \
			::swprintf_s( text, fmt, __FILEW__, __LINE__, __VA_ARGS__ ); \
			::MessageBoxW( ::GetActiveWindow(), text, L"Error", MB_OK | MB_ICONSTOP ); \
		}

	//! @def MIX_ERROR_A
	//! @brief G[ ( }`oCg )
	#define MIX_ERROR_A( mes, ... ) \
		{ \
			char fmt[1024] = "File : \"%s\"\nLine : %d\n\n"; \
			char text[1024]; \
			::strcat_s( fmt, sizeof( fmt ), mes ); \
			::sprintf_s( text, sizeof( text ), fmt, __FILE__, __LINE__, __VA_ARGS__ ); \
			::MessageBoxA( ::GetActiveWindow(), text, "Error", MB_OK | MB_ICONSTOP ); \
		}

	//! @def MIX_ERROR
	//! @brief W̃G[̒ʒm
	#define MIX_ERROR MIX_ERROR_W

	//! @}

	//! @name g[X
	//! fobK̏o͂ɕ\܂B
	//! @{

	//! @def MIX_TRACE_W
	//! @brief g[X ( jR[h )
	#define MIX_TRACE_W( fmt, ... ) \
		{ \
			wchar_t text[1024] = L""; \
			::swprintf_s( text, fmt, __VA_ARGS__ ); \
			::OutputDebugStringW( text ); \
		}

	//! @def MIX_TRACE_A
	//! @brief g[X ( }`oCg )
	#define MIX_TRACE_A( fmt, ... ) \
		{ \
			char text[1024] = ""; \
			::sprintf_s( text, sizeof( text ), fmt, __VA_ARGS__ ); \
			::OutputDebugStringA( text ); \
		}

	//! @def MIX_TRACE
	//! @brief W̃g[X
	#define MIX_TRACE MIX_TRACE_W

	//! @def MIX_TRACELINE_W
	//! @brief g[XC ( jR[h )
	#define MIX_TRACELINE_W( fmt, ... ) \
		{ \
			wchar_t text[1024] = L""; \
			::swprintf_s( text, fmt, ##__VA_ARGS__ ); \
			::wcscat_s( text, sizeof( text ) >> 1, L"\n" ); \
			::OutputDebugStringW( text ); \
		}

	//! @def MIX_TRACELINE_A
	//! @brief g[XC ( }`oCg )
	#define MIX_TRACELINE_A( fmt, ... ) \
		{ \
			char text[1024] = ""; \
			::sprintf_s( text, sizeof( text ), fmt, __VA_ARGS__ ); \
			::strcat_s( text, sizeof( text ), "\n" ); \
			::OutputDebugStringA( text ); \
		}

	//! @def MIX_TRACELINE
	//! @brief W̃g[XC
	#define MIX_TRACELINE MIX_TRACELINE_W

	//! @}

	//! @name fobO
	//! @{

	//! @struct MIX_DEBUGNAME_STRUCT
	//! @brief fobO\
	struct MIX_DEBUGNAME_STRUCT
	{
	private:
		wchar_t text[512];

	public:
		//! @brief RXgN^
		//! @param[in] fileName t@C
		//! @param[in] line s
		MIX_DEBUGNAME_STRUCT( const wchar_t* fileName, UInt32 line )
		{
			::wsprintfW( text, L"%s[%d]", fileName, line );
		}

		//! @brief RXgN^
		//! @param[in] title ^Cg
		//! @param[in] fileName t@C
		//! @param[in] line s
		MIX_DEBUGNAME_STRUCT( const wchar_t* title, const wchar_t* fileName, UInt32 line )
		{
			::wsprintfW( text, L"%s : %s[%d]", title, fileName, line );
		}

		//! @brief ^ϊ
		//! @return ꂽfobOl[
		operator const wchar_t*( void )
		{
			return text;
		}
	};

	//! @def MIX_DEBUGNAME
	//! @brief fobO
	#define MIX_DEBUGNAME MIX_DEBUGNAME_STRUCT( __FILEW__, __LINE__ )
	//! @def MIX_DEBUGNAME_T
	//! @brief fobO( ^Cg )
	#define MIX_DEBUGNAME_T( title ) MIX_DEBUGNAME_STRUCT( title, __FILEW__, __LINE__ )

	//! @}

	/// @cond _INTERNAL

	namespace Mix
	{
		_MIX_DLL_API Int8 IntT_ToInt8( IntT value );
		_MIX_DLL_API Int16 IntT_ToInt16( IntT value );
#ifdef _WIN64
		_MIX_DLL_API Int32 IntT_ToInt32( IntT value );
#else //_WIN64
		_MIX_DLL_API IntT Int64_ToIntT( Int64 value );
#endif //_WIN64

		_MIX_DLL_API UInt8 IntT_ToUInt8( IntT value );
		_MIX_DLL_API UInt16 IntT_ToUInt16( IntT value );
		_MIX_DLL_API UInt32 IntT_ToUInt32( IntT value );

		_MIX_DLL_API UInt8 UIntT_ToUInt8( UIntT value );
		_MIX_DLL_API UInt16 UIntT_ToUInt16( UIntT value );
#ifdef _WIN64
		_MIX_DLL_API UInt32 UIntT_ToUInt32( UIntT value );
#else //_WIN64
		_MIX_DLL_API UIntT UInt64_ToUIntT( UInt64 value );
#endif //_WIN64

		_MIX_DLL_API Int8 UIntT_ToInt8( UIntT value );
		_MIX_DLL_API Int16 UIntT_ToInt16( UIntT value );
		_MIX_DLL_API Int32 UIntT_ToInt32( UIntT value );
	}

	/// @endcond

	//! @name ϐ̃LXg
	//! @{

	//! @def MIX_IT_TO_I8
	//! @brief IntT  Int8 ɃLXg܂
	#define MIX_IT_TO_I8( value ) Mix::IntT_ToInt8( value )
	//! @def MIX_IT_TO_I16
	//! @brief IntT  Int16 ɃLXg܂
	#define MIX_IT_TO_I16( value ) Mix::IntT_ToInt16( value )
#ifdef _WIN64
	//! @def MIX_IT_TO_I32
	//! @brief IntT  Int32 ɃLXg܂
	#define MIX_IT_TO_I32( value ) Mix::IntT_ToInt32( value )
	//! @def MIX_IT64_TO_IT
	//! @brief Int64  IntT ɃLXg܂
	#define MIX_IT64_TO_IT( value ) value
#else //_WIN64
	//! @def MIX_IT_TO_I32
	//! @brief IntT  Int32 ɃLXg܂
	#define MIX_IT_TO_I32( value ) value
	//! @def MIX_IT64_TO_IT
	//! @brief Int64  IntT ɃLXg܂
	#define MIX_IT64_TO_IT( value ) Mix::Int64_ToIntT( value )
#endif //_WIN64

	//! @def MIX_IT_TO_UI8
	//! @brief IntT  UInt8 ɃLXg܂
	#define MIX_IT_TO_UI8( value ) Mix::IntT_ToUInt8( value )
	//! @def MIX_IT_TO_UI16
	//! @brief IntT  UInt16 ɃLXg܂
	#define MIX_IT_TO_UI16( value ) Mix::IntT_ToUInt16( value )
	//! @def MIX_IT_TO_UI32
	//! @brief IntT  UInt32 ɃLXg܂
	#define MIX_IT_TO_UI32( value ) Mix::IntT_ToUInt32( value )

	//! @def MIX_UIT_TO_UI8
	//! @brief UIntT  UInt8 ɃLXg܂
	#define MIX_UIT_TO_UI8( value ) Mix::UIntT_ToUInt8( value )
	//! @def MIX_UIT_TO_UI16
	//! @brief UIntT  UInt16 ɃLXg܂
	#define MIX_UIT_TO_UI16( value ) Mix::UIntT_ToUInt16( value )
#ifdef _WIN64
	//! @def MIX_UIT_TO_UI32
	//! @brief UIntT  UInt32 ɃLXg܂
	#define MIX_UIT_TO_UI32( value ) Mix::UIntT_ToUInt32( value )
	//! @def MIT_UI64_TO_UIT
	//! @brief UInt64  UIntT ɃLXg܂
	#define MIT_UI64_TO_UIT( value ) value
#else //_WIN64
	//! @def MIX_UIT_TO_UI32
	//! @brief UIntT  UInt32 ɃLXg܂
	#define MIX_UIT_TO_UI32( value ) value
	//! @def MIT_UI64_TO_UIT
	//! @brief UInt64  UIntT ɃLXg܂
	#define MIT_UI64_TO_UIT( value ) Mix::UInt64_ToUIntT( value )
#endif //_WIN64

	//! @def MIX_UIT_TO_I8
	//! @brief UIntT  Int8 ɃLXg܂
	#define MIX_UIT_TO_I8( value ) Mix::UIntT_ToInt8( value )
	//! @def MIX_UIT_TO_I16
	//! @brief UIntT  Int16 ɃLXg܂
	#define MIX_UIT_TO_I16( value ) Mix::UIntT_ToInt16( value )
	//! @def MIX_UIT_TO_I32
	//! @brief UIntT  Int32 ɃLXg܂
	#define MIX_UIT_TO_I32( value ) Mix::UIntT_ToInt32( value )

	//! @}

#else //_DEBUG

	#define MIX_ASSERT( cnd )
	#define MIX_ASSERT_EX_W( cnd, mes, ... )
	#define MIX_ASSERT_EX_A( cnd, mes, ... )
	#define MIX_ERROR_W( mes, ... )
	#define MIX_ERROR_A( mes, ... )
	#define MIX_TRACE_W( fmt, ... )
	#define MIX_TRACE_A( fmt, ... )
	#define MIX_TRACELINE_W( fmt, ... )
	#define MIX_TRACELINE_A( fmt, ... )
	#define MIX_ASSERT_EX( cnd, mes, ... )
	#define MIX_ERROR( mes, ... )
	#define MIX_TRACE( fmt, ... )
	#define MIX_TRACELINE( fmt, ... )
	#define MIX_DEBUGNAME L""
	#define MIX_DEBUGNAME_T( title ) L""

	#define MIX_IT_TO_I8( value ) static_cast<Int8>( value )
	#define MIX_IT_TO_I16( value ) static_cast<Int16>( value )
#ifdef _WIN64
	#define MIX_IT_TO_I32( value ) static_cast<Int32>( value )
	#define MIX_IT64_TO_IT( value ) value
#else //_WIN64
	#define MIX_IT_TO_I32( value ) value
	#define MIX_IT64_TO_IT( value ) static_cast<IntT>( value )
#endif //_WIN64

	#define MIX_IT_TO_UI8( value ) static_cast<UInt8>( value )
	#define MIX_IT_TO_UI16( value ) static_cast<UInt16>( value )
	#define MIX_IT_TO_UI32( value ) static_cast<UInt32>( value )

	#define MIX_UIT_TO_UI8( value ) static_cast<UInt8>( value )
	#define MIX_UIT_TO_UI16( value ) static_cast<UInt16>( value )
#ifdef _WIN64
	#define MIX_UIT_TO_UI32( value ) static_cast<UInt32>( value )
	#define MIT_UI64_TO_UIT( value ) value
#else //_WIN64
	#define MIX_UIT_TO_UI32( value ) value
	#define MIT_UI64_TO_UIT( value ) static_cast<UIntT>( value )
#endif //_WIN64

	#define MIX_UIT_TO_I8( value ) static_cast<Int8>( value )
	#define MIX_UIT_TO_I16( value ) static_cast<Int16>( value )
	#define MIX_UIT_TO_I32( value ) static_cast<Int32>( value )

#endif //_DEBUG

//! @name ACg
//! @{

//! @def MIX_ALIGN
//! @brief ACgw肵܂
#define MIX_ALIGN( n ) _declspec( align( n ) )
//! @def MIX_ALIGN_16
//! @brief ACg 16Byte Ŏw肵܂
#define MIX_ALIGN_16 _declspec( align( 16 ) )

//! @}

//! @name QƃJE^ ( Mix::Reference )
//! @{

//! @def MIX_ADD_REF
//! @brief Mix::Release C^[tF[XpNX̎QƃJE^CNg܂
#define MIX_ADD_REF( x ) \
	if( x != NULL ) \
	{ \
		x->AddRef(); \
	}

//! @def MIX_RELEASE
//! @brief Mix::Release C^[tF[XpNX̎QƃJE^fNg܂
#define MIX_RELEASE( x ) \
	if( x != NULL ) \
	{ \
		x->Release(); \
		x = NULL; \
	}

//! @}

//! @name rbg
//! @{

//! @def MIX_SETBIT
//! @brief rbgZbg܂
#define MIX_SETBIT( flags, bit ) \
	if( ( flags & ( bit ) ) == 0 ) \
	{ \
		flags |= ( bit ); \
	}

//! @def MIX_RESETBIT
//! @brief rbgZbg܂
#define MIX_RESETBIT( flags, bit ) \
	if( ( flags & ( bit ) ) == ( bit ) ) \
	{ \
		flags ^= ( bit ); \
	}

//! @def MIX_TESTBIT
//! @brief rbgeXg܂
#define MIX_TESTBIT( flags, bit ) ( ( flags ) & ( bit ) )

//! @}

//! @name Zp֌W
//! @{

//! @def MIX_PI
//! @brief ~
#define MIX_PI 3.141592654f
//! @def MIX_2PI
//! @brief ~ * 2
#define MIX_2PI 6.283185308f
//! @def MIX_4PI
//! @brief ~ * 4
#define MIX_4PI 12.566370616f
//! @def MIX_HALF_PI
//! @brief ~ / 2
#define MIX_HALF_PI 1.570796327f
//! @def MIX_QUARTER_PI
//! @brief ~ / 4
#define MIX_QUARTER_PI 0.7853981635f

//! @def MIX_FLOAT_MIN
//! @brief _̍ŏl
#define MIX_FLOAT_MIN 1.175494351e-38F
//! @def MIX_FLOAT_MAX
//! @brief _̍ől
#define MIX_FLOAT_MAX 3.402823466e+38F
//! @def MIX_FLOAT_EPSILON
//! @brief _CvV
#define MIX_FLOAT_EPSILON 1.192092896e-07F

//! @def MIX_TO_RAD
//! @brief w肳ꂽpx(x@)WAPʂɕϊ܂
#define MIX_TO_RAD( x ) ( MIX_PI * ( x ) / 180.0f )
//! @def MIX_TO_DEG
//! @brief w肳ꂽpx(WA)x@ɕϊ܂
#define MIX_TO_DEG( x ) ( ( x ) * 180.0f / MIX_PI )

//! @def MIX_FLOAT_IS_ZERO
//! @brief _̒l0ǂԂ܂
#define MIX_FLOAT_IS_ZERO( a ) ( ( -MIX_FLOAT_EPSILON < ( a ) ) && ( MIX_FLOAT_EPSILON > ( a ) ) )
//! @def MIX_FLOAT_EQUAL
//! @brief _̒lǂԂ܂
#define MIX_FLOAT_EQUAL( a, b ) ( ( ( ( a ) - MIX_FLOAT_EPSILON ) <= ( b ) ) && ( ( ( a ) + MIX_FLOAT_EPSILON ) >= ( b ) ) )
//! @def MIX_FLOAT_RECIPROCAL
//! @brief a ̋t߂܂
#define MIX_FLOAT_RECIPROCAL( a ) ( ( MIX_FLOAT_IS_ZERO( a ) == False )? ( 1.0f / ( a ) ) : 0.0f )
//! @def MIX_FLOAT_DIV
//! @brief a  b ŏZ܂
#define MIX_FLOAT_DIV( a, b ) ( ( MIX_FLOAT_IS_ZERO( b ) == False )? ( ( a ) / ( b ) ) : 0.0f )
//! @def MIX_FLOAT_SATURATE
//! @brief a  0.0f`1.0f ɖOa܂
#define MIX_FLOAT_SATURATE( a ) ( ( ( a ) < MIX_FLOAT_EPSILON )? 0.0f : ( ( a ) > 1.0f )? 1.0f : ( a ) )
//! @def MIX_CLAMP
//! @brief b <= a >= c ɂȂ悤 a Oa܂
#define MIX_CLAMP( a, b, c ) ( ( ( b ) > ( a ) )? ( b ) : ( ( c ) < ( a ) )? ( c ) : ( a ) )

//! @}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// OԂ̒` 1
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//! @namespace Mix::Memory
//! @brief 
namespace Mix{ namespace Memory{

	class IBuffer;

	//! @enum SECTION_TYPE
	//! @brief ZNV^Cv񋓒萔
	enum SECTION_TYPE
	{
		SECTION_GENERAL		= 0,	//!< S
		SECTION_GRAPHICS	= 1,	//!< OtBbNX
		SECTION_SOUND		= 2,	//!< TEh
		SECTION_DYNAMICS	= 3,	//!< _Ci~NX
		SECTION_SCENE		= 4,	//!< V[
		SECTION_USER		= 5,	//!< [U[
	};

	//! @struct SECTION_INFO
	//! @brief ZNV\
	struct SECTION_INFO
	{
		UIntT maxTotalAllocatedSize;	//!< mۂ̍ő̃TCY
		UIntT totalAllocatedSize;		//!< mۂ̃TCY
		UIntT totalFreeSize;			//!< Ă郁̃TCY
		UIntT releasableSize;			//!< ł郁̃TCY
	};

	//! @class STLAllocator
	//! @brief STL AP[^ev[gNX
	//! @tparam ST ZNV^Cv\ Mix::Memory::SECTION_TYPE 񋓒萔
	//! @tparam T AP[^ŃmۂCX^X̌^
	template<Mix::Memory::SECTION_TYPE ST, typename T>
	class STLAllocator
	{
		//! @cond _INTERNAL

	public:
		typedef T value_type;
		typedef T *pointer;
		typedef const T *const_pointer;
		typedef T &reference;
		typedef const T &const_reference;
		typedef size_t size_type;
		typedef ptrdiff_t difference_type;

		template <class U>
		struct rebind { typedef Mix::Memory::STLAllocator<ST, U> other; };

	public:
		STLAllocator( void ) {}
		STLAllocator( const STLAllocator& ) {}

		template <class U>
		STLAllocator( const STLAllocator<ST, U>& ) {}

		~STLAllocator( void ) {}

		pointer allocate( size_type num, void *hint = 0 ) { ( void )hint; return ( pointer )( Mix::Memory::Allocate( ST, sizeof( T ) * num, __FILEW__, __LINE__ ) ); }
		void deallocate( pointer p, size_type num ) { ( void )num; Mix::Memory::Free( p, __FILEW__, __LINE__ ); }

		void construct( pointer p, const T& value ) { new( p ) T( value ); }
		void destroy( pointer p ) { p->~T(); }

		pointer address( reference value ) const { return &value; }
		const_pointer address( const_reference value ) const { return &value; }

		size_type max_size() const { return ( std::numeric_limits<size_t>::max )() / sizeof( T ); }

		//! @endcond
	};

	//! @cond _INTERNAL

	template <Mix::Memory::SECTION_TYPE ST, typename T, typename U>
	bool operator == ( const Mix::Memory::STLAllocator<ST, T>& lhs, Mix::Memory::STLAllocator<ST, U> const & rhs ) { return true; }

	template <Mix::Memory::SECTION_TYPE ST, typename T, typename U>
	bool operator != ( const Mix::Memory::STLAllocator<ST, T>& lhs, Mix::Memory::STLAllocator<ST, U> const & rhs ) { return !( lhs == rhs ); }

	//! @endcond

	//! @brief STL ̃ftHgAP[^
	//! @tparam T mۂCX^X̌^
	template<typename T>
	using STLDefaultAllocator = STLAllocator<Mix::Memory::SECTION_USER, T>;

	//! @brief ZNV̏擾܂
	//! @param section ZNV
	//! @return ZNV̏\ Mix::Memory::SECTION_INFO \̂Ԃ܂
	_MIX_DLL_API Mix::Memory::SECTION_INFO GetSectionInfo( UInt16 section );

	//! @brief mۂ܂
	//! @param[in] section ZNV
	//! @param[in] size mۂ郁̃TCY
	//! @param[in] pSrcFile mۂ\[Xt@C̃pX( __FILEW__ )
	//! @param[in] srcLine mۂ\[Xt@C̍s( __LINE__ )
	//! @return mۂ̃|C^Ԃ܂
	//! @note
	//! obt@Ȃǂ̃mۂۂ MIX_MALLOC ܂ MIX_DEBUG_MALLOC gpA MIX_FREE gpĂB<br>
	//! ܂ACX^X̏́AMIX_NEW ܂ MIX_DEBUG_NEW gpA MIX_DELETE MIX_DELETE_ARRAY MIX_DELETE_THIS gpĂB
	_MIX_DLL_API void* Allocate( UInt16 section, UIntT size, const wchar_t* pSrcFile, Int32 srcLine );

	//! @brief mۂ܂
	//! @param[in] section ZNV
	//! @param[in] alignment mۂ郁̃ACg( oCgP )
	//! @param[in] size mۂ郁̃TCY( oCgP )
	//! @param[in] pSrcFile mۂ\[Xt@C̃pX( __FILEW__ )
	//! @param[in] srcLine mۂ\[Xt@C̍s( __LINE__ )
	//! @return mۂ̃|C^Ԃ܂
	_MIX_DLL_API void* AllocateAligned( UInt16 section, UInt16 alignment, UIntT size, const wchar_t* pSrcFile, Int32 srcLine );

	//! @brief Ċmۂ܂
	//! @param[in] ptr Ċmۂ郁̃|C^
	//! @param[in] size ĊmۂTCY
	//! @param[in] pSrcFile mۂ\[Xt@C̃pX( __FILEW__ )
	//! @param[in] srcLine mۂ\[Xt@C̍s( __LINE__ )
	//! @return ꍇ́AĊmۂ̃|C^Ԃ܂
	//! @note
	//! obt@Ȃǂ̃̍Ċmۂۂ MIX_REALLOC gpĂB<br>
	//! ܂AĊmۂɎsꍇAw肵Ċmۂ悤ƂĂ郁 ( ptr ) ͉܂B<br>
	//! Mix::Memory::Free ( MIX_FREE ) gpĉKv܂B
	_MIX_DLL_API void* Reallocate( void* ptr, UIntT size, const wchar_t* pSrcFile, Int32 srcLine );

	//! @brief ܂
	//! @param[in] ptr 郁̃|C^
	//! @param[in] pSrcFile mۂ\[Xt@C̃pX( __FILEW__ )
	//! @param[in] srcLine mۂ\[Xt@C̍s( __LINE__ )
	//! @note ̉ MIX_FREE gpĂB
	_MIX_DLL_API void Free( void* ptr, const wchar_t* pSrcFile, Int32 srcLine );

	//! @brief Rs[܂
	//! @param[in] dst Rs[̃̃|C^
	//! @param[in] src Rs[̃̃|C^
	//! @param[in] size Rs[TCY
	_MIX_DLL_API void Copy( void* dst, const void* src, UIntT size );

	//! @brief ŜɎw肵l݂܂
	//! @param[in] ptr ̃|C^
	//! @param[in] size ̃TCY
	//! @param[in] fill ɏޒl
	_MIX_DLL_API void Fill( void* ptr, UIntT size, UInt8 fill );

	//! @brief Ŝ 0 ݂܂
	//! @param[in] ptr ̃|C^
	//! @param[in] size ̃TCY
	_MIX_DLL_API void Zero( void* ptr, UIntT size );

	//! @brief obt@쐬܂
	//! @param[in] section ZNV
	//! @param[in] size obt@̃TCY
	//! @param[in] pInitialData obt@̏f[^( NULLw\ )
	//! @param[out] ppBuffer Mix::Memory::IBuffer C^[tF[X̃|C^
	_MIX_DLL_API Boolean CreateBuffer( UInt16 section, UIntT size, const void* pInitialData, Mix::Memory::IBuffer** ppBuffer );

}}

//! @name Mix ̃ǗgpÅmہA
//! @{

//! @def MIX_MALLOC
//! @brief Aw肵TCYŊmۂ܂
#define MIX_MALLOC( size ) Mix::Memory::Allocate( Mix::Memory::SECTION_USER, size, __FILEW__, __LINE__ )
//! @def MIX_MALLOC_T
//! @brief Aw肵^AŊmۂ܂
#define MIX_MALLOC_T( T, count ) static_cast<T*>( Mix::Memory::Allocate( Mix::Memory::SECTION_USER, sizeof( T ) * count, __FILEW__, __LINE__ ) )
//! @def MIX_ALIGNED_MALLOC
//! @brief Aw肵ACgATCYŊmۂ܂
#define MIX_ALIGNED_MALLOC( alignment, size ) Mix::Memory::Allocate( Mix::Memory::SECTION_USER, alignment, size, __FILEW__, __LINE__ )
//! @def MIX_ALIGNED_MALLOC_T
//! @brief Aw肵ACgA^AŊmۂ܂
#define MIX_ALIGNED_MALLOC_T( alignment, T, count ) static_cast<T*>( Mix::Memory::Allocate( Mix::Memory::SECTION_USER, alignment, sizeof( T ) * count, __FILEW__, __LINE__ ) )

//! @def MIX_REALLOC
//! @brief w肵w肵TCYōĊmۂ܂
#define MIX_REALLOC( ptr, size ) Mix::Memory::Reallocate( ptr, size )
//! @def MIX_REALLOC_T
//! @brief w肵Aw肵^ATCYōĊmۂ܂
#define MIX_REALLOC_T( ptr, T, count ) static_cast<T*>( Mix::Memory::Reallocate( ptr, sizeof( T ) * count ) )

//! @def MIX_FREE
//! @brief MIX_MALLOC  MIX_ALIGNED_MALLOC ɂĊmۂꂽ܂
#define MIX_FREE( ptr ) \
	if( ptr != NULL ) \
	{ \
		Mix::Memory::Free( ptr, __FILEW__, __LINE__ ); \
		ptr = NULL; \
	}

//! @}

/// @cond _INTERNAL

inline void* operator new( size_t size, Mix::Memory::SECTION_TYPE secType, const wchar_t* srcFile, Int32 srcLine ) {
	return Mix::Memory::Allocate( secType, size, srcFile, srcLine ); }
inline void operator delete( void* ptr, Mix::Memory::SECTION_TYPE secType, const wchar_t* srcFile, Int32 srcLine ) {}

inline void* operator new[]( size_t size, Mix::Memory::SECTION_TYPE secType, const wchar_t* srcFile, Int32 srcLine ) {
	return Mix::Memory::Allocate( secType, size, srcFile, srcLine ); }
inline void operator delete[]( void* ptr, Mix::Memory::SECTION_TYPE secType, const wchar_t* srcFile, Int32 srcLine ) {}

inline void* operator new( size_t size, Mix::Memory::SECTION_TYPE secType, UInt16 align, const wchar_t* srcFile, Int32 srcLine ) {
	return Mix::Memory::AllocateAligned( secType, align, size, srcFile, srcLine ); }
inline void operator delete( void* ptr, Mix::Memory::SECTION_TYPE secType, UInt16 align, const wchar_t* srcFile, Int32 srcLine ) {}

inline void* operator new[]( size_t size, Mix::Memory::SECTION_TYPE secType, UInt16 align, const wchar_t* srcFile, Int32 srcLine ) {
	return Mix::Memory::AllocateAligned( secType, align, size, srcFile, srcLine ); }
inline void operator delete[]( void* ptr, Mix::Memory::SECTION_TYPE secType, UInt16 align, const wchar_t* srcFile, Int32 srcLine ) {}

/// @endcond

//! @name Mix ̃ǗgpACX^X̍쐬A폜
//! @{

//! @def MIX_DECLARE_ALLOCATOR
//! @brief NXɃAP[^̒`ǉ܂
#define MIX_DECLARE_ALLOCATOR() \
	inline void* operator new( size_t size, Mix::Memory::SECTION_TYPE secType, const wchar_t* srcFile, Int32 srcLine ) { \
		return Mix::Memory::Allocate( secType, size, srcFile, srcLine ); } \
	inline void operator delete( void* ptr, Mix::Memory::SECTION_TYPE secType, const wchar_t* srcFile, Int32 srcLine ) {} \
	 \
	inline void* operator new[]( size_t size, Mix::Memory::SECTION_TYPE secType, const wchar_t* srcFile, Int32 srcLine ) { \
		return Mix::Memory::Allocate( secType, size, srcFile, srcLine ); }\
	inline void operator delete[]( void* ptr, Mix::Memory::SECTION_TYPE secType, const wchar_t* srcFile, Int32 srcLine ) {} \
	 \
	inline void* operator new( size_t size, Mix::Memory::SECTION_TYPE secType, UInt16 align, const wchar_t* srcFile, Int32 srcLine ) { \
		return Mix::Memory::AllocateAligned( secType, align, size, srcFile, srcLine ); } \
	inline void operator delete( void* ptr, Mix::Memory::SECTION_TYPE secType, UInt16 align, const wchar_t* srcFile, Int32 srcLine ) {} \
	 \
	inline void* operator new[]( size_t size, Mix::Memory::SECTION_TYPE secType, UInt16 align, const wchar_t* srcFile, Int32 srcLine ) { \
		return Mix::Memory::AllocateAligned( secType, align, size, srcFile, srcLine ); } \
	inline void operator delete[]( void* ptr, Mix::Memory::SECTION_TYPE secType, UInt16 align, const wchar_t* srcFile, Int32 srcLine ) {}

//! @def MIX_NEW_T
//! @brief VCX^Xw肵ACX^X̌^ARXgN^ɓnō쐬܂
#define MIX_NEW_T( T, ... ) new( Mix::Memory::SECTION_USER, __FILEW__, __LINE__ ) T( __VA_ARGS__ )
//! @def MIX_ALIGNED_NEW_T
//! @brief VCX^Xw肵AACgACX^X̌^ARXgN^ɓnō쐬܂
#define MIX_ALIGNED_NEW_T( align, T, ... ) new( Mix::Memory::SECTION_USER, align, __FILEW__, __LINE__ ) T( __VA_ARGS__ )

//! @def MIX_DELETE_T
//! @brief MIX_NEW_T ܂ MIX_ALIGNED_NEW_T ɂč쐬ꂽCX^X폜܂
#define MIX_DELETE_T( T, ptr ) \
	if( ptr != NULL ) \
	{ \
		ptr->~T(); \
		Mix::Memory::Free( ptr, __FILEW__, __LINE__ ); \
		ptr = NULL; \
	}

//! @def MIX_DELETE_THIS_T
//! @brief MIX_NEW_T ܂ MIX_ALIGNED_NEW_T ɂč쐬ꂽg̃CX^X폜܂
#define MIX_DELETE_THIS_T( T, ptr ) \
	ptr->~T(); \
	Mix::Memory::Free( ptr, __FILEW__, __LINE__ );

//! @def MIX_NEW_ARRAY_T
//! @brief VCX^Xzw肵ACX^X̌^Az̗vf̐ō쐬܂
#define MIX_NEW_ARRAY_T( T, count ) new( Mix::Memory::SECTION_USER, __FILEW__, __LINE__ ) T[count]
//! @def MIX_ALIGNED_NEW_ARRAY_T
//! @brief VCX^Xzw肵AACgACX^X̌^Az̗vf̐ō쐬܂
#define MIX_ALIGNED_NEW_ARRAY_T( align, T, count ) new( Mix::Memory::SECTION_USER, align, __FILEW__, __LINE__ ) T[count]

/// @cond _INTERNAL
#ifdef _DEBUG
	#define MIX_DELETE_ARRAY_T_MEM_CHECK if( real == NULL ) { MIX_ERROR( L"ǗÕ悤Ƃ܂B \"%s\"(%u)", __FILEW__, __LINE__ ); *( ( int* )0x0 ) = 0x0; }
#else //_DEBUG
	#define MIX_DELETE_ARRAY_T_MEM_CHECK
#endif //_DEBUG
/// @endcond

//! @def MIX_DELETE_ARRAY_T
//! @brief MIX_NEW_T ɂč쐬ꂽCX^Xz폜܂
#define MIX_DELETE_ARRAY_T( T, ptr ) \
	if( ptr != NULL ) \
	{ \
		UInt32* temp = ( UInt32* )ptr - 1; \
		void* real = NULL; \
		UInt32 count; \
		 \
		if( *temp == 0x4D474D47 ) \
		{ \
			real = ptr; \
			count = 0; \
		} \
		else if( *( temp - 1 ) == 0x4D474D47 ) \
		{ \
			real = temp; \
			count = *temp; \
		} \
		else if( *( temp - 2 ) == 0x4D474D47 ) \
		{ \
			real = ( temp - 1 ); \
			count = *( temp - 1 ); \
		} \
		 \
		MIX_DELETE_ARRAY_T_MEM_CHECK \
		 \
		if( count > 0 ) \
		{ \
			UInt32 i; \
			 \
			for( i = 0; i < count; i++ ) \
			{ \
				( ptr )[i].~T(); \
			} \
		} \
		 \
		Mix::Memory::Free( real, __FILEW__, __LINE__ ); \
		 \
		ptr = NULL; \
	}

//! @def MIX_DELETE_PTR_ARRAY_T
//! @brief MIX_NEW_ARRAY_T ܂ MIX_ALIGNED_NEW_ARRAY_T ɂč쐬ꂽCX^X̃|C^z폜܂
#define MIX_DELETE_PTR_ARRAY_T( ptr ) \
	if( ptr != NULL ) \
	{ \
		Mix::Memory::Free( ptr, __FILEW__, __LINE__ ); \
		ptr = NULL; \
	}

//! @}

//! @name W̃ǗgpACX^X̍쐬A폜
//! @{

//! @def MIX_NEW
//! @brief VCX^X쐬܂
#define MIX_NEW new

//! @def MIX_DELETE
//! @brief MIX_NEW ɂč쐬ꂽCX^X폜܂
#define MIX_DELETE( x ) \
	if( x != NULL ) \
	{ \
		delete x; \
		x = NULL; \
	}

//! @def MIX_DELETE_ARRAY
//! @brief MIX_NEW ɂč쐬ꂽCX^Xz폜܂
#define MIX_DELETE_ARRAY( x ) \
	if( x != NULL ) \
	{ \
		delete [] x; \
		x = NULL; \
	}

//! @def MIX_DELETE_THIS
//! @brief MIX_NEW ɂč쐬ꂽg̃CX^X폜܂
#define MIX_DELETE_THIS( x ) delete x

//! @}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// CN[h
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "Mix/String.h"
#include "Mix/Point.h"
#include "Mix/Rectangle.h"
#include "Mix/RectangleF.h"
#include "Mix/Vector2.h"
#include "Mix/Vector3.h"
#include "Mix/Vector4.h"
#include "Mix/Quaternion.h"
#include "Mix/Matrix3x3.h"
#include "Mix/Matrix4x4.h"

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// OԂ̒` 2
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//! @namespace Mix::IO
//! @brief o
namespace Mix{ namespace IO{

	class IManager;
	class IStream;
	class IReader;
	class IWriter;

	//! @enum SEEK_METHOD
	//! @brief V[N񋓒萔
	enum SEEK_METHOD
	{
		SEEK_METHOD_BEGIN	= 0,	//!< t@C̐擪V[N
		SEEK_METHOD_CURRENT	= 1,	//!< t@C݈ʒuV[N
		SEEK_METHOD_END		= 2,	//!< t@C̏I[V[N
	};

	//! @enum SPECIAL_DIRECTORY_TYPE
	//! @brief fBNg^Cv񋓒萔
	enum SPECIAL_DIRECTORY_TYPE
	{
		SPDIR_APPDATA		= 1,	//!< AvP[Vf[^
		SPDIR_DESKTOP		= 2,	//!< fXNgbv
		SPDIR_MYDOCUMENT	= 3,	//!< }ChLg
	};

	//! @brief }l[W̃|C^擾܂
	//! @return }l[W\ Mix::IO::IManager C^[tF[X̃|C^Ԃ܂
	_MIX_DLL_API Mix::IO::IManager* GetManagerPtr( void );
	//! @brief }l[W擾܂
	//! @param[out] ppManager }l[W\ Mix::IO::IManager C^[tF[X̃|C^̃AhX
	//! @return ꍇ True Ԃ܂
	//! @note 擾}l[W͎QƃJE^ +1 ܂B
	_MIX_DLL_API Boolean GetManager( Mix::IO::IManager** ppManager );

	//! @brief ΃pXǂmF܂
	//! @param[in] pPath mFpX
	//! @return ΃pX̏ꍇ True Ԃ܂
	_MIX_DLL_API Boolean IsAbsolutePath( const wchar_t* pPath );
	//! @brief ΃pXǂmF܂
	//! @param[in] pPath mFpX
	//! @return ΃pX̏ꍇ True Ԃ܂
	_MIX_DLL_API Boolean IsRelativePath( const wchar_t* pPath );
	//! @brief pX܂
	//! @param[in] pBaseDirPath Pڂ̃fBNgpX
	//! @param[in] bCnvBase pBaseDirPath ɑ΃pXw肳ꍇɁAJgfBNg̐΃pXɕϊꍇ True
	//! @param[in] pRelPath Qڂ̃fBNgAt@CpX
	//! @param[out] outPath ꂽpX
	//! @return ꍇ True Ԃ܂
	_MIX_DLL_API Boolean CombinePath( const wchar_t* pBaseDirPath, Boolean bCnvBase, const wchar_t* pRelPath, Mix::StringW& outPath );

	//! @brief fBNg̖O擾܂
	//! @param[in] type fBNg̃^Cv\ Mix::SPECIAL_DIRECTORY_TYPE 񋓒萔
	//! @param[out] dirPath fBNg̃pXi[ Mix::String NX
	//! @return ꍇ True Ԃ܂
	_MIX_DLL_API Boolean GetSpecialDirectoryPath( Mix::IO::SPECIAL_DIRECTORY_TYPE type, Mix::String& dirPath );
}}

//! @namespace Mix::HID
//! @brief q[}C^[tF[XfoCX
namespace Mix{ namespace HID{

	class IManager;
	class IKeyboard;
	class IMouse;
	class IGamepad;

	//! @enum KEY
	//! @brief L[R[h񋓒萔
	enum KEY
	{
		KEY_F1			= 1,	//!< F1
		KEY_F2			= 2,	//!< F2 
		KEY_F3			= 3,	//!< F3
		KEY_F4			= 4,	//!< F4
		KEY_F5			= 5,	//!< F5
		KEY_F6			= 6,	//!< F6
		KEY_F7			= 7,	//!< F7
		KEY_F8			= 8,	//!< F8
		KEY_F9			= 9,	//!< F9
		KEY_F10			= 10,	//!< F10
		KEY_F11			= 11,	//!< F11
		KEY_F12			= 12,	//!< F12

		KEY_0			= 13,	//!< 0
		KEY_1			= 14,	//!< 1
		KEY_2			= 15,	//!< 2
		KEY_3			= 16,	//!< 3
		KEY_4			= 17,	//!< 4
		KEY_5			= 18,	//!< 5
		KEY_6			= 19,	//!< 6
		KEY_7			= 20,	//!< 7
		KEY_8			= 21,	//!< 8
		KEY_9			= 22,	//!< 9

		KEY_NP0			= 23,	//!< NUMPAD 0
		KEY_NP1			= 24,	//!< NUMPAD 1
		KEY_NP2			= 25,	//!< NUMPAD 2
		KEY_NP3			= 26,	//!< NUMPAD 3
		KEY_NP4			= 27,	//!< NUMPAD 4
		KEY_NP5			= 28,	//!< NUMPAD 5
		KEY_NP6			= 29,	//!< NUMPAD 6
		KEY_NP7			= 30,	//!< NUMPAD 7
		KEY_NP8			= 31,	//!< NUMPAD 8
		KEY_NP9			= 32,	//!< NUMPAD 9

		KEY_A			= 33,	//!< A
		KEY_B			= 34,	//!< B
		KEY_C			= 35,	//!< C
		KEY_D			= 36,	//!< D
		KEY_E			= 37,	//!< E
		KEY_F			= 38,	//!< F
		KEY_G			= 39,	//!< G
		KEY_H			= 40,	//!< H
		KEY_I			= 41,	//!< I
		KEY_J			= 42,	//!< J
		KEY_K			= 43,	//!< K
		KEY_L			= 44,	//!< L
		KEY_M			= 45,	//!< M
		KEY_N			= 46,	//!< N
		KEY_O			= 47,	//!< O
		KEY_P			= 48,	//!< P
		KEY_Q			= 49,	//!< Q
		KEY_R			= 50,	//!< R
		KEY_S			= 51,	//!< S
		KEY_T			= 52,	//!< T
		KEY_U			= 53,	//!< U
		KEY_V			= 54,	//!< V
		KEY_W			= 55,	//!< W
		KEY_X			= 56,	//!< X
		KEY_Y			= 57,	//!< Y
		KEY_Z			= 58,	//!< Z

		KEY_UP			= 59,	//!< 
		KEY_DOWN		= 60,	//!< 
		KEY_LEFT		= 61,	//!< 
		KEY_RIGHT		= 62,	//!< 

		KEY_ESCAPE		= 63,	//!< ESC
		KEY_TAB			= 64,	//!< TAB
		KEY_BACKSPACE	= 65,	//!< BACKSPACE
		KEY_DELETE		= 66,	//!< DEL
		KEY_SPACE		= 67,	//!< SPACE
		KEY_RETURN		= 68,	//!< RETURN( ENTER )
		KEY_SHIFT		= 69,	//!< SHIFT
		KEY_LSHIFT		= 70,	//!< SHIFT
		KEY_RSHIFT		= 71,	//!< ESHIFT
		KEY_CTRL		= 72,	//!< CTRL
		KEY_LCTRL		= 73,	//!< CTRL
		KEY_RCTRL		= 74,	//!< ECTRL
		KEY_ALT			= 75,	//!< ALT
		KEY_LALT		= 76,	//!< ALT
		KEY_RALT		= 77,	//!< EALT

		KEY_MAX			= 78,	//!< L[̍ő吔
	};

	//! @enum GAMEPAD_API
	//! @brief Q[pbh API 񋓒萔
	enum GAMEPAD_API
	{
		GAMEPAD_UNKNOWN		= 0,	//!< s
		GAMEPAD_XINPUT		= 1,	//!< XInput
		GAMEPAD_DIRECTINPUT	= 2,	//!< DirectInput
	};

	//! @enum GAMEPAD_CONSTANT
	//! @brief Q[pbh萔񋓒萔
	enum GAMEPAD_CONSTANT
	{
		GAMEPAD_TRIGGER_RESOLUTION	= 255,		//!< gK[̉𑜓x
		GAMEPAD_STICK_RESOLUTION	= 32767,	//!< XeBbN̉𑜓x

		GAMEPAD_LEFT				= 0,		//!< 
		GAMEPAD_RIGHT				= 1,		//!< E
	};

	//! @enum GAMEPAD_PORT
	//! @brief Q[pbh|[g񋓒萔
	enum GAMEPAD_PORT
	{
		GAMEPAD_XI_A		= 0,	//!< XInputQ[pbhA
		GAMEPAD_XI_B		= 1,	//!< XInputQ[pbhB
		GAMEPAD_XI_C		= 2,	//!< XInputQ[pbhC
		GAMEPAD_XI_D		= 3,	//!< XInputQ[pbhD

		GAMEPAD_DI_A		= 4,	//!< DirectInputQ[pbhA
		GAMEPAD_DI_B		= 5,	//!< DirectInputQ[pbhB
		GAMEPAD_DI_C		= 6,	//!< DirectInputQ[pbhC
		GAMEPAD_DI_D		= 7,	//!< DirectInputQ[pbhD

		GAMEPAD_PORT_MAX	= 8,	//!< Q[|[g̍ő吔
	};

	//! @enum GAMEPAD_BUTTON
	//! @brief Q[pbh{^񋓒萔
	enum GAMEPAD_BUTTON
	{
		GAMEPAD_POV_UP			= 0,	//!< POV(  )
		GAMEPAD_POV_DOWN		= 1,	//!< POV(  )
		GAMEPAD_POV_LEFT		= 2,	//!< POV(  )
		GAMEPAD_POV_RIGHT		= 3,	//!< POV( E )
		GAMEPAD_START			= 4,	//!< X^[g
		GAMEPAD_BACK			= 5,	//!< obN
		GAMEPAD_STICK_LEFT		= 6,	//!< XeBbN(  )
		GAMEPAD_STICK_RIGHT		= 7,	//!< XeBbN( E )
		GAMEPAD_SHOULDER_LEFT	= 8,	//!< V_[(  )
		GAMEPAD_SHOULDER_RIGHT	= 9,	//!< V_[( E )
		GAMEPAD_A				= 10,	//!< A
		GAMEPAD_B				= 11,	//!< B
		GAMEPAD_X				= 12,	//!< X
		GAMEPAD_Y				= 13,	//!< Y

		GAMEPAD_BUTTON_MAX		= 14,	//!< {^̍ő吔
	};

	//! @enum SWITCH_STATE
	//! @brief XCb`Xe[g񋓒萔
	enum SWITCH_STATE
	{
		PRESSED			= 0x00000001,		//!< L[A{^ꂽ
		RELEASED		= 0x00000002,		//!< L[A{^ꂽ
		DOWN			= 0x00000004,		//!< L[A{^Ă
	};

	//! @brief }l[W̃|C^擾܂
	//! @return }l[W\ Mix::HID::IManager C^[tF[X̃|C^Ԃ܂
	_MIX_DLL_API Mix::HID::IManager* GetManagerPtr( void );
	//! @brief }l[W擾܂
	//! @param[out] ppManager }l[W\ Mix::HID::IManager C^[tF[X̃|C^̃AhX
	//! @return ꍇ True Ԃ܂
	//! @note 擾}l[W͎QƃJE^ +1 ܂B
	_MIX_DLL_API Boolean GetManager( Mix::HID::IManager** ppManager );
}}

//! @namespace Mix::Parallel
//! @brief p
namespace Mix{ namespace Parallel{

	class IManager;

	//! @enum DEBUG_ID
	//! @brief fobOpʎq 񋓒萔
	enum DEBUG_ID
	{
		DEBUG_DYNAMICS_COLLISION_DISPATCHER = 0,	//!< _Ci~NX : RWfBXpb`[
		DEBUG_DYNAMICS_JOINT_SOLVER			= 1,	//!< _Ci~NX : WCg\o[

		DEBUG_USER							= 2,	//!< [U[`
	};
	
	//! @fn void Function( UInt32 threadNum, UInt32 threadIndex, void* pData )
	//! @brief t@NV
	//! @param threadNum t@NVsXbh̐
	//! @param threadIndex t@NVsĂXbh̃CfbNX ( 0 <= threadIndex < threadNum )
	//! @param pData t@NV̎s ( Mix::Parallel::IManager::ExecuteFunction ) ɓnf[^̃|C^
	typedef void __stdcall Function( UInt32 threadNum, UInt32 threadIndex, void* pData );

	//! @typedef FunctionPtr
	//! @brief Mix::Parallel::Function ̃|C^
	typedef Function* FunctionPtr;

	//! @struct WORK
	//! @brief [N\
	struct WORK
	{
		UInt32 threadIndex;					//!< Xbh̃CfbNX
		HANDLE hWakeup;						//!< EFCNAbvpIuWFNg̃nh
		Mix::Parallel::FunctionPtr pFunc;	//!< st@NṼ|C^
		void* pData;						//!< t@NVɓnf[^̃|C^
		UInt32 debugID;						//!< fobOpʎq ( Mix::Parallel::DEBUG_ID )
	};

	//! @struct DEBUG_FUNC_INFO
	//! @brief fobO : t@NV\
	struct DEBUG_FUNC_INFO
	{
		UInt32 id;				//!< ʎq ( Mix::Parallel::DEBUG_ID )
		Float32 startTime;		//!< t@NVJn ( bP )
		Float32 elapsedTime;	//!< t@NV̎sɂ ( bP )
	};

	//! @struct DEBUG_THREAD_INFO
	//! @brief fobO : Xbh\
	struct DEBUG_THREAD_INFO
	{
		Float32 elapsedTime;				//!< XbhŎsꂽt@NV̍v

		UInt32 funcCount;					//!< XbhŎsꂽt@NV̐
		const DEBUG_FUNC_INFO* funcInfos;	//!< XbhŎsꂽt@NV̏z
	};

	//! @brief }l[W̃|C^擾܂
	//! @return }l[W\ Mix::Parallel::IManager C^[tF[X̃|C^Ԃ܂
	_MIX_DLL_API Mix::Parallel::IManager* GetManagerPtr( void );
	//! @brief }l[W擾܂
	//! @param[out] ppManager }l[W\ Mix::Parallel::IManager C^[tF[X̃|C^̃AhX
	//! @return ꍇ True Ԃ܂
	//! @note 擾}l[W͎QƃJE^ +1 ܂B
	_MIX_DLL_API Boolean GetManager( Mix::Parallel::IManager** ppManager );

}}

//! @namespace Mix::Geometry
//! @brief WIg
namespace Mix{ namespace Geometry{

	class AABB;
	class Frustum;
	class OBB;
	class Plane;
	class Sphere;

	//! @brief ʂ_܂ł̋߂܂
	//! @param[in] p _\ Mix::Vector3 NX
	//! @param[in] plane Mix::Geometry::Plane NX
	//! @return ʂ_܂ł̋
	_MIX_DLL_API Float32 DistancePointPlane( const Mix::Vector3& p, const Mix::Geometry::Plane& plane );

	//! @brief _ւ̍Őڋߓ_߂܂
	//! @param[in] p 肷_\ Mix::Vector3 NX
	//! @param[in] sphere 肷鋅\ Mix::Geometry::Sphere NX
	//! @param[out] q Őڋߓ_\ Mix::Vector3 NX
	_MIX_DLL_API void ClosestPointSphere( const Mix::Vector3& p, const Mix::Geometry::Sphere& sphere, Mix::Vector3& q );
	//! @brief ʂ_ւ̍Őڋߓ_߂܂
	//! @param[in] p 肷_\ Mix::Vector3 NX
	//! @param[in] plane 肷镽ʂ\ Mix::Geometry::Plane NX
	//! @param[out] q Őڋߓ_\ Mix::Vector3 NX
	_MIX_DLL_API void ClosestPointPlane( const Mix::Vector3& p, const Mix::Geometry::Plane& plane, Mix::Vector3& q );
	//! @brief OBB_ւ̍Őڋߓ_߂܂
	//! @param[in] p 肷_\ Mix::Vector3 NX
	//! @param[in] obb 肷OBB\ Mix::Geometry::OBB NX
	//! @param[out] q Őڋߓ_\ Mix::Vector3 NX
	_MIX_DLL_API void ClosestPointOBB( const Mix::Vector3& p, const Mix::Geometry::OBB& obb, Mix::Vector3& q );
	//! @brief AABBƓ_̍Őڋߓ_߂܂
	//! @param[in] p 肷_\ Mix::Vector3 NX
	//! @param[in] aabb 肷AABB\ Mix::Geometry::AABB NX
	//! @param[out] q Őڋߓ_\ Mix::Vector3 NX
	_MIX_DLL_API void ClosestPointAABB( const Mix::Vector3& p, const Mix::Geometry::AABB& aabb, Mix::Vector3& q );

	//! @brief _v̎Op`abc̓ɂ邩ǂ𔻒肵܂
	//! @param[in] p 肷_\ Mix::Vector3 NX
	//! @param[in] a 肷Op`̓_1\ Mix::Vector3 NX
	//! @param[in] b 肷Op`̓_2\ Mix::Vector3 NX
	//! @param[in] c 肷Op`3_\ Mix::Vector3 NX
	//! @return _Op`̓ɂꍇ True Ԃ܂
	_MIX_DLL_API Boolean PointInTriangle( const Mix::Vector3& p, const Mix::Vector3& a, const Mix::Vector3& b, const Mix::Vector3& c );

	//! @brief AABBƓ_̌Ă邩ǂ𔻒肵܂
	//! @param[in] p 肷_\ Mix::Vector3 NX
	//! @param[in] aabb 肷AABB\ Mix::Geometry::AABB NX
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean IntersectPointAABB( const Mix::Vector3& p, const Mix::Geometry::AABB& aabb );
	//! @brief mĂ邩ǂ𔻒肵܂
	//! @param[in] sphere1 肷鋅\ Mix::Geometry::Sphere NX
	//! @param[in] sphere2 肷鋅\ Mix::Geometry::Sphere NX
	//! @param[out] pDist m̒S̋
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean IntersectSphereSphere( const Mix::Geometry::Sphere& sphere1, const Mix::Geometry::Sphere& sphere2, Float32* pDist = NULL );
	//! @brief ƕʂĂ邩ǂ𔻒肵܂
	//! @param[in] sphere 肷鋅\ Mix::Geometry::Sphere NX
	//! @param[in] plane 肷镽ʂ\ Mix::Geometry::Plane NX
	//! @param[out] pDist ʂ狅̒S܂ł̋
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean IntersectSpherePlane( const Mix::Geometry::Sphere& sphere, const Mix::Geometry::Plane& plane, Float32* pDist = NULL );
	//! @brief OBBĂ邩ǂ𔻒肵܂
	//! @param[in] sphere 肷鋅\ Mix::Geometry::Sphere NX
	//! @param[in] obb 肷OBB\ Mix::Geometry::OBB NX
	//! @param[out] pPos ̒Sɑ΂OBB̍Őڋߓ_\ Mix::Vector3 NX̃|C^
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean IntersectSphereOBB( const Mix::Geometry::Sphere& sphere, const Mix::Geometry::OBB& obb, Mix::Vector3* pPos = NULL );
	//! @brief AABBĂ邩ǂ𔻒肵܂
	//! @param[in] sphere 肷鋅\ Mix::Geometry::Sphere NX
	//! @param[in] aabb 肷AABB\ Mix::Geometry::AABB NX
	//! @param[out] pPos ̒Sɑ΂AABB̍Őڋߓ_\ Mix::Vector3 NX̃|C^
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean IntersectSphereAABB( const Mix::Geometry::Sphere& sphere, const Mix::Geometry::AABB& aabb, Mix::Vector3* pPos = NULL );

	//! @brief ʂƕʂĂ邩ǂ𔻒肵܂
	//! @param[in] plane1 肷镽ʂ\ Mix::Geometry::Plane NX
	//! @param[in] plane2 肷镽ʂ\ Mix::Geometry::Plane NX
	//! @param[out] pPos ̓_̈ʒu\ Mix::Vector3 NX̃|C^
	//! @param[out] pDir ̕\ Mix::Vector3 NX̃|C^
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean IntersectPlanePlane( const Mix::Geometry::Plane& plane1, const Mix::Geometry::Plane& plane2, Mix::Vector3* pPos = NULL, Mix::Vector3* pDir = NULL );
	//! @brief ʂOBBĂ邩ǂ𔻒肵܂
	//! @param[in] plane 肷镽ʂ\ Mix::Geometry::Plane NX
	//! @param[in] obb 肷OBB\ Mix::Geometry::OBB NX
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean IntersectPlaneOBB( const Mix::Geometry::Plane& plane, const Mix::Geometry::OBB& obb );
	//! @brief ʂAABBĂ邩ǂ𔻒肵܂
	//! @param[in] plane 肷镽ʂ\ Mix::Geometry::Plane NX
	//! @param[in] aabb 肷AABB\ Mix::Geometry::AABB NX
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean IntersectPlaneAABB( const Mix::Geometry::Plane& plane, const Mix::Geometry::AABB& aabb );

	//! @brief OBBmĂ邩ǂ𔻒肵܂
	//! @param[in] obb1 肷OBB\ Mix::Geometry::OBB NX
	//! @param[in] obb2 肷OBB\ Mix::Geometry::OBB NX
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean IntersectOBBOBB( const Mix::Geometry::OBB& obb1, const Mix::Geometry::OBB& obb2 );

	//! @brief AABBmĂ邩ǂ𔻒肵܂
	//! @param[in] aabb1 肷AABB\ Mix::Geometry::AABB NX
	//! @param[in] aabb2 肷AABB\ Mix::Geometry::AABB NX
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean IntersectAABBAABB( const Mix::Geometry::AABB& aabb1, const Mix::Geometry::AABB& aabb2 );

	//! @brief ƋĂ邩ǂ𔻒肵܂
	//! @param[in] rayPos 𔭂Ăʒu\ Mix::Vector3 NX
	//! @param[in] rayDir ̃xNg\ rayDir
	//! @param[in] sphere 肷鋅\ Mix::Geometry::Sphere NX
	//! @param[out] pDist 𔭂ĂʒuĂʒu܂ł̋
	//! @param[out] pPos Ăʒu\ Mix::Vector3 NX̃|C^
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean IntersectRaySphere( const Mix::Vector3& rayPos, const Mix::Vector3& rayDir, const Mix::Geometry::Sphere& sphere, Float32* pDist = NULL, Mix::Vector3* pPos = NULL );
	//! @brief ƕʂĂ邩ǂ𔻒肵܂
	//! @param[in] rayPos 𔭂Ăʒu\ Mix::Vector3 NX
	//! @param[in] rayDir ̃xNg\ rayDir
	//! @param[in] plane 肷镽ʂ\ Mix::Geometry::Plane NX
	//! @param[out] pDist 𔭂ĂʒuĂʒu܂ł̋
	//! @param[out] pPos Ăʒu\ Mix::Vector3 NX̃|C^
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean IntersectRayPlane( const Mix::Vector3& rayPos, const Mix::Vector3& rayDir, const Mix::Geometry::Plane& plane, Float32* pDist = NULL, Mix::Vector3* pPos = NULL );
	//! @brief OBBĂ邩ǂ𔻒肵܂
	//! @param[in] rayPos 𔭂Ăʒu\ Mix::Vector3 NX
	//! @param[in] rayDir ̃xNg\ rayDir
	//! @param[in] obb 肷OBB\ Mix::Geometry::OBB NX
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean IntersectRayOBB( const Mix::Vector3& rayPos, const Mix::Vector3& rayDir, const Mix::Geometry::OBB& obb );
	//! @brief AABBĂ邩ǂ𔻒肵܂
	//! @param[in] rayPos 𔭂Ăʒu\ Mix::Vector3 NX
	//! @param[in] rayDir ̃xNg\ rayDir
	//! @param[in] aabb 肷AABB\ Mix::Geometry::AABB NX
	//! @param[out] pDist 𔭂ĂʒuĂʒu܂ł̋
	//! @param[out] pPos Ăʒu\ Mix::Vector3 NX̃|C^
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean IntersectRayAABB( const Mix::Vector3& rayPos, const Mix::Vector3& rayDir, const Mix::Geometry::AABB& aabb, Float32* pDist = NULL, Mix::Vector3* pPos = NULL );

	//! @brief ƋĂ邩ǂ𔻒肵܂
	//! @param[in] p1 ̒[̓_\ Mix::Vector3 NX
	//! @param[in] p2 ̒[̓_\ Mix::Vector3 NX
	//! @param[in] sphere 肷鋅\ Mix::Geometry::Sphere NX
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean IntersectSegmentSphere( const Mix::Vector3& p1, const Mix::Vector3& p2, const Mix::Geometry::Sphere& sphere );
	//! @brief ƕʂĂ邩ǂ𔻒肵܂
	//! @param[in] p1 ̒[̓_1\ Mix::Vector3 NX
	//! @param[in] p2 ̒[̓_2\ Mix::Vector3 NX
	//! @param[in] plane 肷镽ʂ\ Mix::Geometry::Plane NX
	//! @param[out] pDist 𔭂ĂʒuĂʒu܂ł̋
	//! @param[out] pPos Ăʒu\ Mix::Vector3 NX̃|C^
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean IntersectSegmentPlane( const Mix::Vector3& p1, const Mix::Vector3& p2, const Mix::Geometry::Plane& plane, Float32* pDist = NULL, Mix::Vector3* pPos = NULL );
	//! @brief OBBĂ邩ǂ𔻒肵܂
	//! @param[in] p1 ̒[̓_1\ Mix::Vector3 NX
	//! @param[in] p2 ̒[̓_2\ Mix::Vector3 NX
	//! @param[in] obb 肷OBB\ Mix::Geometry::OBB NX
	//! @param[out] pDist 𔭂ĂʒuĂʒu܂ł̋
	//! @param[out] pPos Ăʒu\ Mix::Vector3 NX̃|C^
	//! @return Ăꍇ True Ԃ܂
	//! @note 
	_MIX_DLL_API Boolean IntersectSegmentOBB( const Mix::Vector3& p1, const Mix::Vector3& p2, const Mix::Geometry::OBB& obb, Float32* pDist = NULL, Mix::Vector3* pPos = NULL );
	//! @brief AABBĂ邩ǂ𔻒肵܂
	//! @param[in] p1 ̒[̓_1\ Mix::Vector3 NX
	//! @param[in] p2 ̒[̓_2\ Mix::Vector3 NX
	//! @param[in] aabb 肷OBB\ Mix::Geometry::AABB NX
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean IntersectSegmentAABB( const Mix::Vector3& p1, const Mix::Vector3& p2, const Mix::Geometry::AABB& aabb );

}}
//! @namespace Mix::Graphics
//! @brief OtBbNX
namespace Mix{ namespace Graphics{

	class IManager;
	class IDevice;
	class IDeviceObject;
	class IVertexLayout;
	class IHullShader;
	class IDomainShader;
	class IGeometryShader;
	class IVertexShader;
	class IPixelShader;
	class IShaderConstant;
	class IVertexBuffer;
	class IIndexBuffer;
	class ITexture;
	class IQuery;

	//! @enum SHADER_MODEL
	//! @brief VF[_[f񋓒萔
	enum SHADER_MODEL
	{
		SHADER_MODEL_3	= 0,	//!< VF[_[f 3.0( DirectX9 )
		SHADER_MODEL_4	= 1,	//!< VF[_[f 4.0( DirectX10 )
		SHADER_MODEL_5	= 2,	//!< VF[_[f 5.0( DirectX11 )
	};

	//! @enum VERTEX_ELEMENT_SEMANTIC
	//! @brief o[ebNXGgZ}eBbN񋓒萔
	enum VERTEX_ELEMENT_SEMANTIC
	{
		VLS_POSITION		= 0,	//!< W( Float32[4] )
		VLS_BLENDWEIGHT		= 1,	//!< uh̏d( Float32 )
		VLS_BLENDINDICES	= 2,	//!< uhCfbNX( UInt32[n] )
		VLS_NORMAL			= 3,	//!< @( Float32[4] )
		VLS_PSIZE			= 4,	//!< |CgTCY( Float32[n] )
		VLS_TEXTURE			= 5,	//!< eNX`W( Float32[4] )
		VLS_TANGENT			= 6,	//!< ڐ( Float32[4] )
		VLS_BINORMAL		= 7,	//!< ]@( Float32[4] )
		VLS_COLOR			= 8,	//!< J[( Float32[4] )
	};

	//! @enum VERTEX_ELEMENT_FORMAT
	//! @brief o[ebNXGgtH[}bg񋓒萔
	enum VERTEX_ELEMENT_FORMAT
	{
		VLF_FLOAT32_1	= 0,	//!< 1A32rbg_
		VLF_FLOAT32_2	= 1,	//!< 2A32rbg_
		VLF_FLOAT32_3	= 2,	//!< 3A32rbg_
		VLF_FLOAT32_4	= 3,	//!< 4A32rbg_
		VLF_UINT8_4		= 4,	//!< 4A8rbgȂ
		VLF_INT16_2		= 5,	//!< 2A16rbg萮
		VLF_INT16_4		= 6,	//!< 4A16rbg萮
		VLF_UINT8_4N	= 7,	//!< 4A8rbgȂ( K )
		VLF_INT16_2N	= 8,	//!< 2A16rbg萮( K )
		VLF_INT16_4N	= 9,	//!< 4A16rbg萮( K )
		VLF_UINT16_2N	= 10,	//!< 2A16rbgȂ( K )
		VLF_UINT16_4N	= 11,	//!< 4A16rbgȂ( K )
		VLF_FLOAT16_2	= 12,	//!< 2A16rbg_
		VLF_FLOAT16_4	= 13,	//!< 4A16rbg_
	};

	//! @enum SHADER_TARGET
	//! @brief VF[_[^[Qbg񋓒萔
	enum SHADER_TARGET
	{
		VS_3_0	= 0,	//!< o[ebNXVF[_[ 3.0
		PS_3_0	= 1,	//!< sNZVF[_[ 3.0

		CS_4_0	= 2,	//!< Rs[gVF[_[ 4.0
		GS_4_0	= 3,	//!< WIgVF[_[ 4.0
		VS_4_0	= 4,	//!< o[ebNXVF[_[ 4.0
		PS_4_0	= 5,	//!< sNZVF[_[ 4.0

		CS_4_1	= 6,	//!< Rs[gVF[_[ 4.1
		GS_4_1	= 7,	//!< WIgVF[_[ 4.1
		VS_4_1	= 8,	//!< o[ebNXVF[_[ 4.1
		PS_4_1	= 9,	//!< sNZVF[_[ 4.1

		CS_5_0	= 10,	//!< Rs[gVF[_[ 5.0
		DS_5_0	= 11,	//!< hCVF[_[ 5.0
		GS_5_0	= 12,	//!< WIgVF[_[ 5.0
		HS_5_0	= 13,	//!< nVF[_[ 5.0
		VS_5_0	= 14,	//!< o[ebNXVF[_[ 5.0
		PS_5_0	= 15,	//!< sNZVF[_[ 5.0
	};

	//! @struct SHADER_MACRO
	//! @brief VF[_[}N\
	struct SHADER_MACRO
	{
		const char* pNameA;	//!< O
		const char* pDefA;	//!< `
	};

	//! @enum FILL_TYPE
	//! @brief `^Cv񋓒萔
	enum FILL_TYPE
	{
		FILL_WIREFRAME	= 0,	//!< C[t[
		FILL_SOLID		= 1,	//!< \bh
	};

	//! @enum CULL_TYPE
	//! @brief JO^Cv񋓒萔
	enum CULL_TYPE
	{
		CULL_NONE	= 0,	//!< SĂ̎Op``悵܂
		CULL_FRONT	= 1,	//!< O̎Op``悵܂
		CULL_BACK	= 2,	//!< ̎Op``悵܂
	};

	//! @enum BLEND_TYPE
	//! @brief uh^Cv񋓒萔
	enum BLEND_TYPE
	{
		BLEND_COPY		= 0,	//!< Rs[
		BLEND_NORMAL	= 1,	//!< ʏ
		BLEND_ADD		= 2,	//!< Z
		BLEND_SUB		= 3,	//!< Z
		BLEND_MUL		= 4,	//!< Z
		BLEND_SCREEN	= 5,	//!< XN[
	};

	//! @enum ZFUNC_TYPE
	//! @brief Zt@NV񋓒萔
	enum ZFUNC_TYPE
	{
		ZFUNC_ALWAYS		= 0,	//!< ɐ
		ZFUNC_NEVER			= 1,	//!< Ɏs
		ZFUNC_LESS			= 2,	//!< VsNZ݂̃sNZ菬ɉ
		ZFUNC_EQUAL			= 3,	//!< VsNZ݂̃sNZƓɉ
		ZFUNC_LESSEQUAL		= 4,	//!< VsNZlÃ݂sNZlȉ̂Ƃɉ
		ZFUNC_GREATER		= 5,	//!< VsNZlÃ݂sNZl傫Ƃɉ
		ZFUNC_NOTEQUAL		= 6,	//!< VsNZlÃ݂sNZlƓȂƂɉ
		ZFUNC_GREATEREQUAL	= 7,	//!< VsNZlÃ݂sNZlȏ̂Ƃɉ
	};

	//! @enum TEXTURE_FILTER_TYPE
	//! @brief eNX`tB^^Cv񋓒萔
	enum TEXTURE_FILTER_TYPE
	{
		TEXTURE_FILTER_POINT		= 0,	//!< |CgtB^
		TEXTURE_FILTER_LINEAR		= 1,	//!< jAtB^( ` )
		TEXTURE_FILTER_ANISOTROPIC	= 2,	//!< Aj\gsbNtB^( ٕ )
	};

	//! @enum TEXTURE_ADDRESS_TYPE
	//! @brief eNX`[W̉@񋓒萔
	enum TEXTURE_ADDRESS_TYPE
	{
		TEXTURE_ADDRESS_WRAP		= 0,	//!< ؂育ƂɃeNX`[JԂ܂
		TEXTURE_ADDRESS_CLAMP	= 1,	//!< ؂育ƂɃeNX`[𔽓]܂
	};

	//! @enum CUBEMAP_FACE
	//! @brief L[u}bṽtFCX񋓒萔
	enum CUBEMAP_FACE
	{
		CUBEMAP_FACE_POSITIVE_X = 0,	//!< ̂w
		CUBEMAP_FACE_NEGATIVE_X = 1,	//!< ̂w
		CUBEMAP_FACE_POSITIVE_Y = 2,	//!< ̂x
		CUBEMAP_FACE_NEGATIVE_Y = 3,	//!< ̂x
		CUBEMAP_FACE_POSITIVE_Z = 4,	//!< ̂y
		CUBEMAP_FACE_NEGATIVE_Z = 5,	//!< ̂y
	};

	//! @enum FORMAT
	//! @brief tH[}bg񋓒萔
	enum FORMAT
	{
		FMT_UNKNOWN			= 0,	//!< sȃtH[}bg

		FMT_D16				= 1,	//!< 1AfvX`l16rbgtH[}bg
		FMT_D32				= 2,	//!< 1AfvX`l32rbgtH[}bg
		FMT_D24S8			= 3,	//!< 2AfvX`l24rbg XeV`l8rbgtH[}bg

		FMT_R8G8B8A8		= 4,	//!< 4A32rbgtH[}bg
		FMT_A8				= 5,	//!< 1A8rbgtH[}bg
		FMT_R16F			= 6,	//!< 1A16rbg_tH[}bg
		FMT_R32F			= 7,	//!< 1A32rbg_tH[}bg
		FMT_R16G16F			= 8,	//!< 2A16rbg_tH[}bg
		FMT_R32G32F			= 9,	//!< 2A32rbg_tH[}bg
		FMT_R16G16B16A16F	= 10,	//!< 4A64rbg_tH[}bg
		FMT_R32G32B32A32F	= 11,	//!< 4A128rbg_tH[}bg

		FMT_BC1				= 12,	//!< BC1 ( DXT1 ) ktH[}bg
		FMT_BC2				= 13,	//!< BC2 ( DXT3 ) ktH[}bg
		FMT_BC3				= 14,	//!< BC3 ( DXT5 ) ktH[}bg
	};

	//! @enum INDEX_FORMAT
	//! @brief CfbNXtH[}bg񋓒萔
	enum INDEX_FORMAT
	{
		INDEX_USHORT	= 0,	//!< 16BitCfbNXobt@
		INDEX_UINT		= 1,	//!< 32BitCfbNXobt@
	};

	//! @enum QUERY_FORMAT
	//! @brief NGtH[}bg񋓒萔
	enum QUERY_FORMAT
	{
		QUERY_EVENT		= 0,	//!< Cxg
		QUERY_OCCLUSION	= 1,	//!< IN[W
	};

	//! @enum PRIMITIVE_TYPE
	//! @brief v~eBu^Cv񋓒萔
	enum PRIMITIVE_TYPE
	{
		PRIMITIVE_POINTLIST		= 0,	//!< |CgXg
		PRIMITIVE_LINELIST		= 1,	//!< CXg
		PRIMITIVE_LINESTRIP		= 2,	//!< CXgbv
		PRIMITIVE_TRIANGLELIST	= 3,	//!< gCAOXg
		PRIMITIVE_TRIANGLESTRIP	= 4,	//!< gCAOXgbv
	};

	//! @enum COLOR_WRITE_MASK
	//! @brief J[݃}XN񋓒萔
	enum COLOR_WRITE_MASK
	{
		COLOR_WRITE_RGBA	= 0,	//!< Sď
		COLOR_WRITE_RGB		= 1,	//!< RGB̂ݏ
		COLOR_WRITE_A		= 2,	//!< At@̂ݏ
	};

	//! @struct VERTEX_ELEMENT
	//! @brief o[ebNXGg\
	struct VERTEX_ELEMENT
	{
		UInt32 semanticType;	//!< Z}eBbN^Cv( Mix::Graphics::VERTEX_ELEMENT_SEMANTIC )
		UInt32 semanticIndex;	//!< Z}eBbNCfbNX
		UInt32 format;			//!< tH[}bg( Mix::Graphics::VERTEX_ELEMENT_FORMAT )
		UInt32 offset;			//!< ItZbg
	};

	//! @struct RASTERIZER_DESC
	//! @brief X^CUXe[g\
	struct RASTERIZER_DESC
	{
		Mix::Graphics::FILL_TYPE fillMode;	//!< tB[h
		Mix::Graphics::CULL_TYPE cullMode;	//!< JO[h
		Boolean bScissoring;				//!< VUOLɂꍇ True
	};

	//! @struct DEPTH_DESC
	//! @brief fvXXe[g\
	struct DEPTH_DESC
	{
		Boolean bTest;					//!< ZeXgLɂꍇ True
		Boolean bWrite;					//!< Zl݂̏Lɂꍇ True
		Mix::Graphics::ZFUNC_TYPE func;	//!< ZeXgɎgpt@NV
	};

	//! @struct BLEND_DESC
	//! @brief uhXe[g\
	struct BLEND_DESC
	{
		Mix::Graphics::BLEND_TYPE type;					//!< ^Cv
		Mix::Graphics::COLOR_WRITE_MASK colorWriteMask;	//!< J[̏݃}XN\ Mix::Graphics::COLOR_WRITE_MASK 񋓒萔
	};

	//! @brief }l[W̃|C^擾܂
	//! @return }l[W\ Mix::Graphics::IManager C^[tF[X̃|C^Ԃ܂
	_MIX_DLL_API Mix::Graphics::IManager* GetManagerPtr( void );
	//! @brief }l[W擾܂
	//! @param[out] ppManager }l[W\ Mix::Graphics::IManager C^[tF[X̃|C^̃AhX
	//! @return ꍇ True Ԃ܂
	//! @note 擾}l[W͎QƃJE^ +1 ܂B
	_MIX_DLL_API Boolean GetManager( Mix::Graphics::IManager** ppManager );
}}

//! @namespace Mix::Graphics::Utility
//! @brief OtBbNX ( [eBeB )
namespace Mix{ namespace Graphics{ namespace Utility{

	class ITargetTextureChain;
	class IFont;
	class IPerspectiveRenderer;
	class ICanvasRenderer;

	//! @enum STRING_FLAGS
	//! @brief tO񋓒萔
	enum STRING_FLAGS
	{
		SF_HCENTER		= 0x00000001,	//!< ŃZ^O
		SF_VCENTER		= 0x00000002,	//!< ŃZ^O
		SF_WORDBREAK	= 0x00000004,	//!< `͂ݏoꍇ͉s
	};

	//! @brief VF[_[RpC܂
	//! @param[in] pFilePath t@CpX
	//! @param[in] pMacros }Nz( NULLw\ )
	//! @param[in] pFuncName t@NV̖O
	//! @param[in] target ^[Qbg\ Mix::Graphics::SHADER_TARGET 񋓒萔
	//! @param[out] ppBuffer RpCꂽVF[_i[ Mix::Memory::IBuffer C^[tF[X̃|C^̃AhX
	//! @return ꍇ True Ԃ܂
	//! @note }Nw肷ꍇ͖ SHADER_MACRO( pName = NULL, pDef = NULL ) ǉĂĂB
	_MIX_DLL_API Boolean CompileShaderFromFile(	const wchar_t* pFilePath,
												Mix::Graphics::SHADER_MACRO* pMacros,
												const char* pFuncName,
												Mix::Graphics::SHADER_TARGET target,
												Mix::Memory::IBuffer** ppBuffer );

	//! @brief VF[_[RpC܂
	//! @param[in] pFilePath t@CpX
	//! @param[in] pSrc RpC\[X̃|C^( ANSI )
	//! @param[in] srcSize RpC\[X̃TCY
	//! @param[in] pMacros }Nz( NULLw\ )
	//! @param[in] pFuncName t@NV̖O
	//! @param[in] target ^[Qbg\ Mix::Graphics::SHADER_TARGET 񋓒萔
	//! @param[out] ppBuffer RpCꂽVF[_i[ Mix::Memory::IBuffer C^[tF[X̃|C^̃AhX
	//! @return ꍇ True Ԃ܂
	//! @note }Nw肷ꍇ͖ SHADER_MACRO( pName = NULL, pDef = NULL ) ǉĂĂB
	_MIX_DLL_API Boolean CompileShaderFromMemory(	const wchar_t* pFilePath,
													const void* pSrc, UInt32 srcSize,
													Mix::Graphics::SHADER_MACRO* pMacros,
													const char* pFuncName,
													Mix::Graphics::SHADER_TARGET target,
													Mix::Memory::IBuffer** ppBuffer );

	//! @brief w肵tHgƕŕ`悵ꍇ̃TCYv܂
	//! @param[in] pFont tHg\ Mix::Graphics::Utility::IFont C^[tF[X̃|C^
	//! @param[in] pStr 
	//! @return vTCY\ Mix::Point NXԂ܂
	_MIX_DLL_API Mix::Point MeasureString( Mix::Graphics::Utility::IFont* pFont, const wchar_t* pStr );

}}}

//! @namespace Mix::Sound
//! @brief TEh
namespace Mix{ namespace Sound{

	class IManager;
	class IDevice;
	class IController;
	class IEmitter;
	class IListener;

	//! @brief }l[W̃|C^擾܂
	//! @return }l[W\ Mix::Sound::IManager C^[tF[X̃|C^Ԃ܂
	_MIX_DLL_API Mix::Sound::IManager* GetManagerPtr( void );
	//! @brief }l[W擾܂
	//! @param[out] ppManager }l[W\ Mix::Sound::IManager C^[tF[X̃|C^̃AhX
	//! @return ꍇ True Ԃ܂
	//! @note 擾}l[W͎QƃJE^ +1 ܂B
	_MIX_DLL_API Boolean GetManager( Mix::Sound::IManager** ppManager );

}}

//! @namespace Mix::Dynamics
//! @brief _Ci~NX
namespace Mix{ namespace Dynamics{

	class IManager;
	class IShape;
	class ISphereShape;
	class IBoxShape;
	class IConeShape;
	class ICapsuleShape;
	class ICylinderShape;
	class IConvexHullShape;
	class ICompoundShape;
	class IJoint;
	class IPointJoint;
	class IHingeJoint;
	class ISliderJoint;
	class IDofJoint;
	class IBallJoint;
	class IWorld;
	class IObject;
	class IObjectListener;
	class IObjectDragger;
	class ISimpleObject;
	class IStaticPlane;
	class IStaticMesh;
	class IRigidBody;
	class ISensor;
	class IKinematicCharacter;
	class IVehicle;
	class IVehicleWheel;

	//! @enum AXIS_TYPE
	//! @brief ^Cv񋓒萔
	enum AXIS_TYPE
	{
		AXIS_X = 0,	//!< X
		AXIS_Y = 1,	//!< Y
		AXIS_Z = 2,	//!< Z
	};

	//! @enum OBJECT_FILTER_FLAG
	//! @brief IuWFNgtB^[tO񋓒萔
	enum OBJECT_FILTER_FLAG
	{
		OF_DEFAULT			= 0x0001,	//!< ftHg
		OF_STATIC			= 0x0002,	//!< X^eBbN
		OF_KINEMATIC		= 0x0004,	//!< Ll}eBbN
		OF_DEBRIS			= 0x0008,	//!< fu
		OF_SENSOR			= 0x0010,	//!< ZT[
		OF_CHARACTER		= 0x0020,	//!< LN^[

		//! @brief S
		OF_ALL				= ( OF_DEFAULT | OF_STATIC | OF_KINEMATIC | OF_DEBRIS | OF_SENSOR | OF_CHARACTER ),

		//! @brief ftHgtB^[}XN
		OF_DEFAULT_MASK		= ( OF_DEFAULT | OF_STATIC | OF_KINEMATIC | OF_SENSOR ),
		//! @brief X^eBbNtB^[}XN
		OF_STATIC_MASK		= ( OF_DEFAULT | OF_KINEMATIC | OF_DEBRIS | OF_SENSOR | OF_CHARACTER ),
		//! @brief Ll}eBbNtB^[}XN
		OF_KINEMATIC_MASK	= ( OF_DEFAULT | OF_SENSOR ),
		//! @brief futB^[}XN
		OF_DEBRIS_MASK		= ( OF_STATIC ),
		//! @brief ZT[tB^[}XN
		OF_SENSOR_MASK		= ( OF_DEFAULT | OF_STATIC | OF_KINEMATIC ),
		//! @brief LN^[tB^[}XN
		OF_CHARACTER_MASK	= ( OF_STATIC | OF_CHARACTER ),
	};

	//! @enum DEBUG_DRAW_FLAG
	//! @brief fobO`̃tO񋓒萔
	enum DEBUG_DRAW_FLAG
	{
		DD_WIREFRAME	= 0x00000001,	//!< C[t[(Wbh{fBAZT[ALl}eBbNLN^[)
		DD_AXIS			= 0x00000002,	//!< ( Wbh{fB )
		DD_JOINT_FRAME	= 0x00000004,	//!< WCg̃t[
		DD_JOINT_LIMIT	= 0x00000008,	//!< WCg̃~bg
	};

	//! @enum DEBUG_DRAW_COLOR_TYPE
	//! @brief fobO`̃J[^Cv񋓒萔
	enum DEBUG_DRAW_COLOR_TYPE
	{
		DDC_RIGIDBODY_AROUSAL		= 0,	//!< Wbh{fB : Ɋ
		DDC_RIGIDBODY_ACTIVE		= 1,	//!< Wbh{fB : 
		DDC_RIGIDBODY_SLEEPY		= 2,	//!< Wbh{fB : x~ɂȂȌ
		DDC_RIGIDBODY_REST			= 3,	//!< Wbh{fB : x~
		DDC_RIGIDBODY_DISABLE		= 4,	//!< Wbh{fB : ( V~[V͍sĂȂ )

		DDC_SENSOR					= 5,	//!< ZT[

		DDC_KINEMATIC_CHARACTER		= 6,	//!< Ll}eBbNLN^[

		DDC_JOINT_FRAME				= 7,	//!< WCg : t[
		DDC_JOINT_LIMIT				= 8,	//!< WCg : ~bg
	};

	//! @struct WORLD_CONFIG
	//! @brief [hݒ\
	struct WORLD_CONFIG
	{
		Boolean bParallelCollisionDispatcher;	//!< RW̃fBXpb`ŏꍇ True
		Boolean bParallelJointSolver;			//!< WCg\o[ŏꍇ True

		UInt32 numContactSolverIterations;	//!< LCP \o[̔ ( 4 ` 20 )
		Float32 allowedCcdPenetration;		//!< XEB[veXgۂɂ߂荞łƔf[x

		UInt32 persistentManifoldPoolSize;	//!< }jtH[h̃v[̃TCY
		UInt32 collisionAlgorithmPoolSize;	//!< RWASỸv[̃TCY

		//! @brief RXgN^
		WORLD_CONFIG( void )
		{
			bParallelCollisionDispatcher = True;
			bParallelJointSolver = False;

			numContactSolverIterations = 10;
			allowedCcdPenetration = 0.04f;

			persistentManifoldPoolSize = 4096;
			collisionAlgorithmPoolSize = 4096;
		}
	};

	//! @struct MATERIAL
	//! @brief }eA\
	struct MATERIAL
	{
		UInt32 id;				//!< ʎq
		UInt32 attr;			//!< 
		Float32 friction;		//!< CW
		Float32 restitution;	//!< W

		//! @brief RXgN^
		MATERIAL( void )
		{
			id = 0;
			attr = 0;
			friction = 0.5f;
			restitution = 0.0f;
		}

		//! @brief RXgN^
		//! @param[in] _id ʎq
		//! @param[in] _attr 
		MATERIAL( UInt32 _id, UInt32 _attr )
		{
			id = _id;
			attr = _attr;
			friction = 0.5f;
			restitution = 0.0f;
		}

		//! @brief RXgN^
		//! @param[in] _id ʎq
		//! @param[in] _attr 
		//! @param[in] _friction CW
		//! @param[in] _restitution W
		MATERIAL( UInt32 _id, UInt32 _attr, Float32 _friction, Float32 _restitution )
		{
			id = _id;
			attr = _attr;
			friction = _friction;
			restitution = _restitution;
		}
	};

	//! @struct MESH
	//! @brief bV\
	struct MESH
	{
		//! @brief _
		UInt32 vertexCount;

		//! @brief _Xg
		const Mix::Vector3* vertices;

		//! @brief |S
		UInt32 polygonCount;

		//! @brief |S̃CfbNXXg
		//! @note
		//! _̎QƗpCfbNXzɂȂ܂B<br>
		//! |S * 3 ̗vfzpӂKv܂( Op`Ŏw肷Kv邱ƂӖ܂ )B
		const UInt32* polygonIndices;
	};

	//! @struct MANIFOLD_MESH
	//! @brief }jtH[hbV\
	struct MANIFOLD_MESH
	{
		//! @brief p[gCfbNX
		//! @note X^eBbNbV쐬ۂɓn Mix::Dynamics::MESH z̃CfbNXɂȂ܂
		UInt32 partIndex;

		//! @brief |S̃CfbNX
		UInt32 polygonIndex;
	};

	//! @struct MANIFOLD_POINT
	//! @brief }jtH[h|Cg\
	struct MANIFOLD_POINT
	{
		Mix::Vector3 localPositionA;				//!< g : ڐGʒũ[JW
		Mix::Vector3 localPositionB;				//!<  : ڐGʒũ[JW

		Mix::Vector3 worldPositionA;				//!< g : ڐGʒũ[hW
		Mix::Vector3 worldPositionB;				//!<  : ڐGʒũ[hW

		Mix::Vector3 worldNormalB;					//!<  : ڐGʒũ[h@

		Mix::Dynamics::MATERIAL materialA;			//!< g : ڐGʒũ}eA
		Mix::Dynamics::MATERIAL materialB;			//!<  : ڐGʒũ}eA

		Mix::Dynamics::MANIFOLD_MESH meshA;			//!< g : bV
		Mix::Dynamics::MANIFOLD_MESH meshB;			//!<  : bV

		Float32 penetrationB;						//!< ߂荞ł鋗

		Float32 impulse;							//!< 

		Float32 combinedFriction;					//!< CW
		Float32 combinedRestitution;				//!< W
	};

	//! @struct MANIFOLD
	//! @brief }jtH[h\
	struct MANIFOLD
	{
		Mix::Dynamics::IObject* pObjectB;				//!< ڐGĂIuWFNg\ Mix::Dynamics::IObject C^[tF[X̃|C^

		UInt32 pointCount;								//!< |Cg̐
		const Mix::Dynamics::MANIFOLD_POINT* points;	//!< |CgXg
	};

	//! @struct TEST_LOCAL_RESULT
	//! @brief [J̌茋ʍ\
	struct TEST_LOCAL_RESULT
	{
		Mix::Vector3 pos;						//!< ڐGW
		Mix::Vector3 normal;					//!< ڐGĂW̖@
	};

	//! @struct VEHICLE_WHEEL_DESC
	//! @brief rnCNzC[\
	struct VEHICLE_WHEEL_DESC
	{
		Boolean bFront;					//!< tg̏ꍇ True
		Mix::Vector3 direction;			//!< 
		Mix::Vector3 axis;				//!< Vtg̎
		Mix::Vector3 connectionPoint;	//!< ڑʒu
		Float32 tireRadius;				//!< ^C̔a
		Float32 suspensionRestLength;	//!< TXyV̒
	};

	//! @struct DEBUG_WORLD_PROFILE
	//! @brief fobO : [hvt@C
	struct DEBUG_WORLD_PROFILE
	{
		Float32 ssElapsedTime;	//!< V~[Vɂ( bP )
		Float32 cpElapsedTime;	//!< ڐG̎Wɂ( bP )
	};

	//! @brief }l[W̃|C^擾܂
	//! @return }l[W\ Mix::Dynamics::IManager C^[tF[X̃|C^Ԃ܂
	_MIX_DLL_API Mix::Dynamics::IManager* GetManagerPtr( void );
	//! @brief }l[W擾܂
	//! @param[out] ppManager }l[W\ Mix::Dynamics::IManager C^[tF[X̃|C^̃AhX
	//! @return ꍇ True Ԃ܂
	//! @note 擾}l[W͎QƃJE^ +1 ܂B
	_MIX_DLL_API Boolean GetManager( Mix::Dynamics::IManager** ppManager );

	//! @brief CƃIuWFNǧs܂
	//! @param[in] rayFrom C̎n_\ Mix::Vector3 NX
	//! @param[in] rayTo C̏I_\ Mix::Vector3 NX
	//! @param[in] pReceiveObject sIuWFNg\ Mix::Dynamics::IObject C^[tF[X̃|C^
	//! @param[out] result 茋ʂ\ Mix::Dynamics::TEST_LOCAL_RESULT \
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean TestRay(	const Mix::Vector3& rayFrom,
									const Mix::Vector3& rayTo,
									const Mix::Dynamics::IObject* pReceiveObject,
									Mix::Dynamics::TEST_LOCAL_RESULT& result );

	//! @brief XB[vƃIuWFNǧs܂
	//! @param[in] pCastShape XB[v쐬VFCv\ Mix::Dynamics::IShape C^[tF[X̃|C^
	//! @param[in] castShapeFromPos XB[v̎n_̈ʒu\ Mix::Vector3 NX
	//! @param[in] castShapeToPos XB[v̏I_̈ʒu\ Mix::Vector3 NX
	//! @param[in] pReceiveObject sIuWFNg\ Mix::Dynamics::IObject C^[tF[X̃|C^
	//! @param[out] result 茋ʂ\ Mix::Dynamics::TEST_LOCAL_RESULT \
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean TestSweep(	const Mix::Dynamics::IShape* pCastShape,
									const Mix::Vector3& castShapeFromPos,
									const Mix::Vector3& castShapeToPos,
									const Mix::Dynamics::IObject* pReceiveObject,
									Mix::Dynamics::TEST_LOCAL_RESULT& result );

	//! @brief XB[vƃIuWFNǧs܂
	//! @param[in] pCastShape XB[v쐬VFCv\ Mix::Dynamics::IShape C^[tF[X̃|C^
	//! @param[in] castShapeFromRot XB[v̎n_̉]\ Mix::Vector3 NX
	//! @param[in] castShapeFromPos XB[v̎n_̈ʒu\ Mix::Vector3 NX
	//! @param[in] castShapeToRot XB[v̏I_̉]\ Mix::Vector3 NX
	//! @param[in] castShapeToPos XB[v̏I_̈ʒu\ Mix::Vector3 NX
	//! @param[in] pReceiveObject sIuWFNg\ Mix::Dynamics::IObject C^[tF[X̃|C^
	//! @param[out] result 茋ʂ\ Mix::Dynamics::TEST_LOCAL_RESULT \
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean TestSweep(	const Mix::Dynamics::IShape* pCastShape,
									const Mix::Quaternion& castShapeFromRot, const Mix::Vector3& castShapeFromPos,
									const Mix::Quaternion& castShapeToRot, const Mix::Vector3& castShapeToPos,
									const Mix::Dynamics::IObject* pReceiveObject,
									Mix::Dynamics::TEST_LOCAL_RESULT& result );
}}

//! @namespace Mix::Scene
//! @brief V[
namespace Mix{ namespace Scene{

	class IManager;

	class IEffectPackage;

	class IMaterial;
	class IDefaultMaterial;

	class IMotionMixer;
	class IMotionController;
	class IMotionListener;
	class IMotionState;
	class IMotion;

	class IDynamicsObject;
	class IContactListener;
	class ICollider;
	class ISimpleCollider;
	class ILibertyCollider;
	class IActorCollider;
	class ITerrainCollider;
	class ISensor;
	class ISimpleSensor;
	class IActorSensor;
	class IKinematicCharacter;
	class ISimpleKinematicCharacter;
	class IActorKinematicCharacter;

	class IRenderer;
	class IRendererObject;
	class IEntity;

	class ICamera;
	class IUniversalCamera;
	class IViewCamera;

	class IHemisphereLight;
	class IDirectionalLight;
	class ISpotLight;
	class IPointLight;

	class ISkyDome;
	class IParticle;
	class ILeavingParticle;
	class IScatterParticle;
	class IParticleSystem;
	class IDefaultParticleSystem;
	class IBillboardParticleSystem;
	class IParticleGenerator;
	class IParticleProcessor;
	class IActorModel;
	class IActorListener;
	class IActorNode;
	class IActorConstraint;
	class IActorDynamicsDirector;
	class ITerrainModel;
	class IFlowerPackage;
	class IPlanter;

	class IWaterPool;
	class IWaterPoolContext;

	class IFloor;
	class IGhost;

	class ILightShaftsCaster;
	class IAtmosphereScatter;
	class IDynamicsWorld;

	//! @struct MOTION_HANDLE
	//! @brief [Vnh\
	struct _MIX_DLL_API MOTION_HANDLE
	{
		const void* ref0;	//!< ύX֎~I
		const void* ref1;	//!< ύX֎~I

		//! @brief RXgN^
		MOTION_HANDLE( void );
		//! @brief RXgN^
		//! @param[in] value 0
		MOTION_HANDLE( Int32 value );
		//! @brief RXgN^
		//! @param[in] handle nh
		MOTION_HANDLE( const MOTION_HANDLE& handle );
		//! @brief gp֎~
		MOTION_HANDLE( const void* r0, const void* r1 );

		//! @brief nh NULL ɂ܂
		//! @param[in] value  NULL
		//! @return NULL ɂnhԂ܂
		MOTION_HANDLE& operator = ( Int32 value );

		//! @brief Rs[܂
		//! @param[in] handle Rs[̃nh
		//! @return Rs[nhԂ܂
		MOTION_HANDLE& operator = ( const MOTION_HANDLE& handle );

		//! @brief NULLǂmF܂
		//! @param[in] value  NULL
		//! @return NULL ꍇ True Ԃ܂
		Boolean operator == ( Int32 value ) const;
		//! @brief NULLǂmF܂
		//! @param[in] value  NULL
		//! @return NULL ꍇ True Ԃ܂
		Boolean operator != ( Int32 value ) const;

		//! @brief nhǂmF܂
		//! @param[in] handle rnh
		//! @return nh̏ꍇ True Ԃ܂
		Boolean operator == ( const MOTION_HANDLE& handle ) const;
		//! @brief ႤnhǂmF܂
		//! @param[in] handle rnh
		//! @return Ⴄnh̏ꍇ True Ԃ܂
		Boolean operator != ( const MOTION_HANDLE& handle ) const;

		//! @brief p
		bool operator < ( const MOTION_HANDLE& handle ) const;
	};

	//! @enum MOTION_CONSTANT
	//! @brief [V̗񋓒萔
	enum MOTION_CONSTANT
	{
		MOTION_INFINITE_LOOP	= 0xFFFFFFFF,	//!< [v
	};

	//! @enum MOTION_RT_FLAG
	//! @brief [Ṽ[ggXtH[tO񋓒萔
	enum MOTION_RT_FLAG
	{
		MOTION_RT_ROTATION		= 0x00000001,	//!< ]
		MOTION_RT_TRANSLATION	= 0x00000002,	//!< ړ
	};

	//! @enum MOTION_CONDITION_FLAG
	//! @brief [VԃtO񋓒萔
	enum MOTION_CONDITION_FLAG
	{
		//! @brief ҋ@
		//! @note R}hL[̍Ōɂ
		MOTION_COND_WATING		= 0x00000001,

		//! @brief ĐĂ
		//! @note ̃tOP̂Őݒ肳Ăꍇ( MOTION_COND_CURRENT ͐ݒ肳ĂȂ )́A<br>
		//! vrAX[V( gWVIɒ~ԂɂȂ )ɂȂ܂
		MOTION_COND_ACTIVE		= 0x00000002,

		//! @brief Jg[Vł
		//! @note MOTION_COND_ACTIVE ƃyAŐݒ肳܂
		MOTION_COND_CURRENT		= 0x00000004,

		//! @brief ׂẴtO
		MOTION_COND_ALL			= ( MOTION_COND_WATING | MOTION_COND_CURRENT ),

		//! @brief Jg[VƂčĐĂ
		MOTION_COND_CUR_ACTIVE	= ( MOTION_COND_CURRENT | MOTION_COND_ACTIVE ),
	};

	//! @enum MOTION_COMMAND_EXECUTE_TYPE
	//! @brief [VR}hs^Cv񋓒萔
	enum MOTION_COMMAND_EXECUTE_TYPE
	{
		//! @brief xs( ʏ )
		//! @note ҋ@̃R}hSď܂Ŏs܂
		MOTION_CE_DEFAULT	= 0,

		//! @brief s
		//! @note ݑҋ@̃R}hjAgWV̏ImFꎟAs܂
		MOTION_CE_EARLY		= 1,

		//! @brief s
		//! @note ݑҋ@̃R}hjAgWV𒆒fĂAs܂
		MOTION_CE_FORCE		= 2,
	};

	//! @enum MOTION_COMMAND_FLAG
	//! @brief [VR}htO񋓒萔
	enum MOTION_COMMAND_FLAG
	{
		//! @brief [V܂
		MOTION_CF_ACTIVATE				= 0x00000001,

		//! @brief t[( MOTION_COMMAND::frame )Lɂ܂
		MOTION_CF_FRAME					= 0x00000002,
		//! @brief [v( MOTION_COMMAND::loopCount )Lɂ܂
		MOTION_CF_LOOP					= 0x00000004,
		//! @brief gWV( MOTION_COMMAND::transitionTimeLength )Lɂ܂
		MOTION_CF_TRANSITION			= 0x00000008,

		//! @brief t[p܂
		//! @note MOTION_CF_ACTIVATE MOTION_CF_FRAME w肳ĂKv܂
		MOTION_CF_FRAME_INHERIT			= 0x00000010,
		//! @brief [vp܂
		//! @note MOTION_CF_ACTIVATE MOTION_CF_LOOP w肳ĂKv܂
		MOTION_CF_LOOP_INHERIT			= 0x00000020,
		//! @brief gWVp܂
		//! @note MOTION_CF_ACTIVATE MOTION_CF_TRANSITION w肳ĂKv܂
		MOTION_CF_TRANSITION_INHERIT	= 0x00000040,

		//! @brief t[A[vAgWV̑SĂݒ肵܂
		MOTION_CF_SET_ALL				= ( MOTION_CF_FRAME | MOTION_CF_LOOP | MOTION_CF_TRANSITION ),

		//! @brief t[A[vAgWVSĈp܂
		//! @note Đ悤ƂĂ郂[VA݁A풼Õ[VƓꍇɁAp܂B
		MOTION_CF_INHERIT				= ( MOTION_CF_FRAME_INHERIT | MOTION_CF_LOOP_INHERIT | MOTION_CF_TRANSITION_INHERIT ),

		//! @brief t[A[vAgWVݒ肵čĐ
		MOTION_CF_PLAY					= ( MOTION_CF_ACTIVATE | MOTION_CF_SET_ALL ),
		//! @brief t[A[vAgWVݒ肵čĐ( pL )
		MOTION_CF_PLAY_INHERIT			= ( MOTION_CF_ACTIVATE | MOTION_CF_SET_ALL | MOTION_CF_INHERIT ),

		//! @brief gWVݒ肵Ē~
		MOTION_CF_STOP					= ( MOTION_CF_TRANSITION ),
	};

	//! @struct MOTION_COMMAND
	//! @brief [VR}h\
	struct MOTION_COMMAND
	{
		//! @brief tO( Mix::Scene::MOTION_COMMAND_FLAG 񋓒萔̑gݍ킹 )
		UInt32 flags;

		//! @brief nh
		//! @note flags  Mix::Scene::MOTION_CF_ACTIVATE ݒ肳Ăꍇ̂ݗL
		MOTION_HANDLE handle;

		//! @brief t[
		//! @note flags  Mix::Scene::MOTION_CF_FRAME ݒ肳Ăꍇ̂ݗL
		Float32 frame;

		//! @brief [v( Mix::Scene::MOTION_INFINITE_LOOP Ŗ[v )
		//! @note flags  Mix::Scene::MOTION_CF_LOOP ݒ肳Ăꍇ̂ݗL
		UInt32 loopCount;

		//! @brief gWVɗv鎞Ԃ̒( bP )
		//! @note flags  Mix::Scene::MOTION_CF_TRANSITION ݒ肳Ăꍇ̂ݗL
		Float32 transitionTimeLength;
	};

	//! @struct MOTION_ENTRY_DESC
	//! @brief [VGg[\
	struct MOTION_ENTRY_DESC
	{
		Float32 startFrame;	//!< Jnt[
		Float32 endFrame;	//!< It[
		Boolean bAlways;	//!< Jnt[It[̊Ԃ̏ꍇ͏ɌĂяo

		void* userPtr;		//!< [U[|C^
		Int32 userIndex;	//!< [U[CfbNX
	};

	//! @enum RENDERER_CAPABILITY_FLAG
	//! @brief _[\̓tO񋓒萔
	enum RENDERER_CAPABILITY_FLAG
	{
		RCAP_WIDGET				=	0x00000001,	//!< EBWFbg( p[eBNAv^[ )
		RCAP_DYNAMICS			=	0x00000002,	//!< _Ci~NX[h
		RCAP_ATMOSPHERE			=	0x00000004,	//!< C
		RCAP_SHADOW_MAPPING		=	0x00000008,	//!< VhE}bsO
		RCAP_AMBIENT_OCCLUSION	=	0x00000010,	//!< ArGgIN[W
		RCAP_LUMINOSITY			=	0x00000020,	//!< PxɂK␳
		RCAP_BLOOM				=	0x00000040,	//!< u[
		RCAP_LIGHT_SHAFTS		=	0x00000080,	//!< CgVtg
		RCAP_LENS_FLARE			=	0x00000100,	//!< YtA
		RCAP_CHROMATISM			=	0x00000200,	//!< F
		RCAP_DEPTH_OF_FIELD		=	0x00000400,	//!< ʊE[x

		//! @brief S
		RCAP_ALL			=	RCAP_WIDGET |
								RCAP_DYNAMICS |
								RCAP_ATMOSPHERE |
								RCAP_SHADOW_MAPPING |
								RCAP_AMBIENT_OCCLUSION |
								RCAP_LUMINOSITY |
								RCAP_BLOOM |
								RCAP_LIGHT_SHAFTS |
								RCAP_LENS_FLARE |
								RCAP_CHROMATISM |
								RCAP_DEPTH_OF_FIELD,
	};

	//! @enum RENDERER_SAMPLING_RESOLUTION
	//! @brief _[ : TvO𑜓x񋓒萔
	enum RENDERER_SAMPLING_RESOLUTION
	{
		RSMPL_DEFAULT	= 0,	//!< ftHg
		RSMPL_DOWN2X	= 1,	//!< XN[TCY1/2
		RSMPL_DOWN4X	= 2,	//!< XN[TCY1/4
	};

	//! @struct RENDERER_OCTREE_CONFIG
	//! @brief _[ : ؐݒ\
	struct RENDERER_OCTREE_CONFIG
	{
		//! @brief L͈͂̍ŏ
		//! @note zuIuWFNg܂ޔ͈͂\܂B
		Mix::Vector3 minAABB;
		//! @brief L͈͂̍ő
		//! @note zuIuWFNg܂ޔ͈͂\܂B
		Mix::Vector3 maxAABB;
		//! @brief וx( 0`7 )
		UInt32 subdivisionLevel;
	};

	//! @struct RENDERER_CONFIG
	//! @brief _[ݒ\
	struct RENDERER_CONFIG
	{
		//! @brief \͂\ Mix::Scene::RENDERER_CAPABILITY_FLAG 񋓒萔̑gݍ킹
		UInt32 caps;

		//! @brief ؂̐ݒ
		Mix::Scene::RENDERER_OCTREE_CONFIG octree;
		//! @brief _Ci~NX̐ݒ
		Mix::Dynamics::WORLD_CONFIG dynamics;

		//! @brief RXgN^
		RENDERER_CONFIG( void )
		{
			caps = Mix::Scene::RCAP_ALL;

			octree.minAABB.Set( -500.0f, -500.0f, -500.0f );
			octree.maxAABB.Set( +500.0f, +500.0f, +500.0f );
			octree.subdivisionLevel = 4;

			dynamics.persistentManifoldPoolSize = 4096;
			dynamics.collisionAlgorithmPoolSize = 4096;
		}
	};

	//! @struct CAMERA_CONFIG
	//! @brief Jݒ\
	struct CAMERA_CONFIG
	{
		//! @brief \͂\ Mix::Scene::RENDERER_CAPABILITY_FLAG 񋓒萔̑gݍ킹
		//! @note
		//! ݒł\͈͂ȉ̂̂Ɍ肳܂B<br>
		//! <br>
		//! RCAP_DYNAMICS<br>
		//! RCAP_AMBIENT_OCCLUSION<br>
		//! RCAP_SHADOW_MAPPING<br>
		//! RCAP_LUMINOSITY<br>
		//! RCAP_BLOOM<br>
		//! RCAP_LIGHT_SHAFTS<br>
		//! RCAP_LENS_FLARE<br>
		//! RCAP_CHROMATISM<br>
		//! RCAP_DEPTH_OF_FIELD<br>
		//! <br>
		//! ܂A_Ci~NX( RCAP_DYNAMICS ) ̓JgpăIuWFNg̃hbO邩ǂw肷̂łāA<br>
		//! _Ci~NX̂ ONAOFF ł͂܂B
		UInt32 caps;

		//! @brief ^[Qbg̃TCY
		//! @note `̃^[Qbg̉𑜓xɂȂ܂B
		Mix::Point targetSize;

		//! @brief [xobt@̃tH[}bg
		Mix::Graphics::FORMAT depthBuffFormat;

		//! @brief J[eNX`tH[}bg
		//! @note gpłtH[}bǵuFMT_R8G8B8A8vuFMT_R16G16B16A16FvuFMT_R32G32B32A32Fv ̂RɂȂ܂B
		Mix::Graphics::FORMAT colorTexFormat;

		//! @brief [xeNX`tH[}bg
		//! @note
		//! p[eBNAʊE[xAArGgIN[W ȂǂŎgp܂B<br>
		//! gpłtH[}bǵuFMT_R16FvuFMT_R32Fv̂QɂȂ܂B<br>
		//! <br>
		//! fobÓAfobO`s悤ɂ邽߂Ɉȉ̂悤ɃtH[}bg߂܂B<br>
		//! <br>
		//! uFMT_R16FvuFMT_R16G16B16A16Fv<br>
		//! uFMT_R32FvuFMT_R32G32B32A32Fv<br>
		Mix::Graphics::FORMAT depthTexFormat;

		//! @brief ܃eNX`tH[}bg
		//! @note
		//! gpłtH[}bǵuFMT_R16G16B16A16FvuFMT_R32G32B32A32Fv̂QɂȂ܂B<br>
		//! FA[xi[邽߁AJ[tH[}bgƐ[x̐xlɂĐݒ肵ĂB
		Mix::Graphics::FORMAT refractTexFormat;

		//! @brief ArGgIN[W̃TvO𑜓x
		//! @note Mix::Scene::RSMPL_DEFAULT w肵ꍇ́AXN[̃TCYɂȂ܂B
		Mix::Scene::RENDERER_SAMPLING_RESOLUTION aoSmplRes;

		//! @brief VhE}bsO̐[xeNX`̃tH[}bg
		//! @note gpłtH[}bǵuFMT_R16G16B16A16FvuFMT_R32G32B32A32Fv̂QɂȂ܂B<br>
		Mix::Graphics::FORMAT smDepthTexFormat;
		//! @brief VhE}bsO̐[xeNX`̈ӂ̃TCY
		//! @note 256lw肵ꍇ́A256w肵Ƃ݂Ȃ܂B
		UInt32 smDepthTexSize;
		//! @brief VhE}bsÕTvO𑜓x
		//! @note Mix::Scene::RSMPL_DEFAULT w肵ꍇ́AXN[̃TCYɂȂ܂B
		Mix::Scene::RENDERER_SAMPLING_RESOLUTION smSmplRes;

		//! @brief PxeNX`tH[}bg
		//! @note
		//! gpłtH[}bǵuFMT_R16FvuFMT_R32Fv̂QɂȂ܂B<br>
		//! <br>
		//! fobÓAfobO`s悤ɂ邽߂Ɉȉ̂悤ɃtH[}bg߂܂B<br>
		//! <br>
		//! uFMT_R16FvuFMT_R16G16B16A16Fv<br>
		//! uFMT_R32FvuFMT_R32G32B32A32Fv<br>
		Mix::Graphics::FORMAT lumTexFormat;

		//! @brief u[̃I[o[t[
		//! @note 0w肵ꍇ́A1w肵Ƃ݂Ȃ܂B
		UInt32 bloomOverflowNum;
		//! @brief u[̃TvO𑜓x
		//! @note Mix::Scene::RSMPL_DEFAULT w肵ꍇ Mix::Scene::RSMPL_DOWN2X w肵ƌȂ܂B
		Mix::Scene::RENDERER_SAMPLING_RESOLUTION bloomSmplRes;

		//! @brief YtÃTvO𑜓x
		//! @note Mix::Scene::RSMPL_DEFAULT w肵ꍇ́AXN[̃TCYɂȂ܂B
		Mix::Scene::RENDERER_SAMPLING_RESOLUTION lfSmplRes;

		//! @brief F̃TvO𑜓x
		//! @note Mix::Scene::RSMPL_DEFAULT w肵ꍇ́AXN[̃TCYɂȂ܂B
		Mix::Scene::RENDERER_SAMPLING_RESOLUTION caSmplRes;

		//! @brief ʊE[x̃TvO𑜓x
		//! @note Mix::Scene::RSMPL_DEFAULT w肵ꍇ́AXN[̃TCYɂȂ܂B
		Mix::Scene::RENDERER_SAMPLING_RESOLUTION dofSmplRes;

		//! @brief RXgN^
		CAMERA_CONFIG( void )
		{
			caps = Mix::Scene::RCAP_ALL;

			depthBuffFormat = Mix::Graphics::FMT_D24S8;

			colorTexFormat = Mix::Graphics::FMT_R16G16B16A16F;
			depthTexFormat = Mix::Graphics::FMT_R16F;
			refractTexFormat = Mix::Graphics::FMT_R16G16B16A16F;

			aoSmplRes = Mix::Scene::RSMPL_DOWN2X;

			smDepthTexFormat = Mix::Graphics::FMT_R16G16B16A16F;
			smDepthTexSize = 2048;
			smSmplRes = Mix::Scene::RSMPL_DOWN2X;

			lumTexFormat = Mix::Graphics::FMT_R16F;

			bloomOverflowNum = 1;
			bloomSmplRes = Mix::Scene::RSMPL_DOWN2X;

			lfSmplRes = Mix::Scene::RSMPL_DOWN2X;

			caSmplRes = Mix::Scene::RSMPL_DOWN2X;

			dofSmplRes = Mix::Scene::RSMPL_DOWN2X;
		}
	};

	//! @struct BRIGHT_PASS
	//! @brief uCgpX\
	struct BRIGHT_PASS
	{
		Boolean bLumInf;	//!< Px̉e󂯂ꍇ True
		Float32 white;		//!< \Px̋( 0.0f`̖ )
		Float32 threshold;	//!< Px𒊏oۂ臒l( 0.0f`̖ )
		Float32 offset;		//!< Px𒊏oۂ̃ItZbg( 0.0f`̖ )
	};

	//! @struct BLUR
	//! @brief u[\
	struct _MIX_DLL_API BLUR
	{
	public:
		//! @enum TYPE
		//! @brief ^Cv񋓒萔
		enum TYPE
		{
			T_NONE			= 0,	//!< 
			T_KS_3x3		= 1,	//!< 3x3
			T_KS_5x5		= 2,	//!< 5x5
			T_GAUSSIAN		= 3,	//!< KEVAu[
			T_GAUSSIAN_EX	= 4,	//!< KEVAu[EX

			TYPE_MAX		= 5,	//!< ^Cv
		};

		//! @brief RXgN^
		BLUR( void );

		//! @brief ^Cv擾܂
		//! @return ^Cv\ Mix::Scene::BLUR::TYPE 񋓒萔Ԃ܂
		BLUR::TYPE GetType( void ) const;
		//! @brief ^̒l擾܂
		//! @return lԂ܂
		Int32 GetIntValue( void ) const;
		//! @brief _^̒l擾܂
		//! @return lԂ܂
		Float32 GetFloatValue( void ) const;

		//! @brief LǂmF܂
		//! @return L( type != Mix::Scene::BLUR::T_NONE )ȏꍇ True Ԃ܂
		Boolean IsValid( void ) const;

		//! @brief u[Ȃ
		//! @return u[\ Mix::Scene::BLUR \̂Ԃ܂
		static const Mix::Scene::BLUR& NONE( void );

		//! @brief J[lTCY 3x3 ̃u[
		//! @return u[\ Mix::Scene::BLUR \̂Ԃ܂
		//! @note JԂ 1 ɂȂ܂B
		static Mix::Scene::BLUR KS_3x3( void );
		//! @brief J[lTCY 3x3 ̃u[
		//! @param[in] iteration JԂ( 1`16 )
		//! @return u[\ Mix::Scene::BLUR \̂Ԃ܂
		//! @note JԂ GetIntValue() Ŏ擾ł܂B
		static Mix::Scene::BLUR KS_3x3( Int32 iteration );

		//! @brief J[lTCY 5x5 ̃u[
		//! @return u[\ Mix::Scene::BLUR \̂Ԃ܂
		//! @note JԂ 1 ɂȂ܂B
		static Mix::Scene::BLUR KS_5x5( void );
		//! @brief J[lTCY 5x5 ̃u[
		//! @param[in] iteration JԂ( 1`16 )
		//! @return u[\ Mix::Scene::BLUR \̂Ԃ܂
		//! @note JԂ GetIntValue() Ŏ擾ł܂B
		static Mix::Scene::BLUR KS_5x5( Int32 iteration );

		//! @brief KEVAu[
		//! @return u[\ Mix::Scene::BLUR \̂Ԃ܂
		//! @note Ul 0.0001f ɂȂ܂B
		static Mix::Scene::BLUR GAUSSIAN( void );
		//! @brief KEVAu[
		//! @param[in] dispersion Ul( 0.0001f`128.0000f )
		//! @return u[\ Mix::Scene::BLUR \̂Ԃ܂
		//! @note
		//! Ul GetFloatValue() Ŏ擾ł܂B<br>
		//! ܂4܂łłB
		static Mix::Scene::BLUR GAUSSIAN( Float32 dispersion );

		//! @brief KEVAu[EX
		//! @return u[\ Mix::Scene::BLUR \̂Ԃ܂
		//! @note
		//! a 4 ɂȂ܂B<br>
		//! ܂ VF[_[f3 ( DirectX9 ) ł͏󋵂ɂċɒ[ɏdȂ邱Ƃ܂̂ŁA<br>
		//! gp͍TĂB<br>
		static Mix::Scene::BLUR GAUSSIAN_EX( void );
		//! @brief KEVAu[EX
		//! @param[in] radius a( 4`64 )
		//! @return u[\ Mix::Scene::BLUR \̂Ԃ܂
		//! @note a GetIntValue() Ŏ擾ł܂B
		static Mix::Scene::BLUR GAUSSIAN_EX( Int32 radius );

	private:
		BLUR::TYPE type;
		Int32 data;
	};

	//! @struct DYNAMICS_CONTACT_POINT
	//! @brief ڐG|Cg\
	struct DYNAMICS_CONTACT_POINT
	{
		Mix::Vector3 localPositionA;		//!< g : ڐG|Cg̃[JW
		Mix::Vector3 localPositionB;		//!<  : ڐG|Cg̃[JW

		Mix::Vector3 worldPositionA;		//!<  : ڐG|Cg̃[hW
		Mix::Vector3 worldPositionB;		//!<  : ڐG|Cg̃[hW

		Mix::Vector3 worldNormalB;			//!<  : ڐG|Cg̃[h@

		Float32 penetrationB;				//!< ڐG|Cg̋( ߂荞łꍇ́A̒lɂȂ܂ )

		Mix::Dynamics::MATERIAL materialA;	//!< g : ڐG|Cg̃}eA
		Mix::Dynamics::MATERIAL materialB;	//!<  : ڐG|Cg̃}eA

		Float32 impulse;					//!< ڐG|CgɓKpꂽ
	};

	//! @enum WATER_CONTAINS_RESULT
	//! @brief ʂƂ̔茋ʗ񋓒萔
	enum WATER_CONTAINS_RESULT
	{
		WCR_UNKNOWN		= 0,	//!< s
		WCR_FRONT		= 1,	//!< ʂO
		WCR_BACK		= 2,	//!< ʂ艜
		WCR_OVERLAP		= 3,	//!< ʂƏdȂĂ
	};

	//! @enum DYNAMICS_COLLIDER_MODE
	//! @brief _Ci~NXRC_[[h񋓒萔
	enum DYNAMICS_COLLIDER_MODE
	{
		//! @brief ftHg
		//! @note RC_[fGfB^Őݒ肳ꂽԂɂ܂B
		DC_DEFAULT		= 0,

		//! @brief X^eBbN
		//! @note
		//! SẴRC_[IɃX^eBbNԂɂ܂B
		DC_STATIC		= 1,

		//! @brief Ll}eBbN
		//! @note SẴRC_[IɃLl}eBbNԂɂ܂
		DC_KINEMATIC	= 2,

		//! @brief Oh[
		//! @note X^eBbNwȊÕRC_[ftHgԂɂ܂
		DC_RAGDOLL		= 3,
	};

	//! @enum DYNAMICS_KCHAR_MODE
	//! @brief _Ci~NXLl}eBbNLN^[[h
	enum DYNAMICS_KCHAR_MODE
	{
		//! @brief M
		//! @note f̃[hgXtH[Ll}eBbNLN^[ɔf܂
		DKC_RECEIVE	= 0,

		//! @brief e
		//! @note Ll}eBbNLN^[̃[hgXtH[fɔf܂
		DKC_CAST	= 1,
	};

	//! @enum DEBUG_DRAW_METHOD
	//! @brief fobO : `惁\bh񋓒萔
	enum DEBUG_DRAW_METHOD
	{
		//! @brief p[eBNAf`悷OɃfobO`s܂
		//! @note |Šɂ̂`悳܂A|XgGtFNg̉e󂯂܂
		DDM_BEFORE	= 0,

		//! @brief p[eBNAf`悵ɃfobO`s܂
		//! @note |XgGtFNg̉e󂯂܂񂪁A|Šɂ͕̂`悳ȂȂ܂
		DDM_AFTER	= 1,

		//! @brief Aʏs킸AőOʂɃfobO`s܂
		DDM_XRAYS	= 2,
	};

	//! @enum DEBUG_DRAW_FLAG
	//! @brief fobO : `tO񋓒萔
	enum DEBUG_DRAW_FLAG
	{
		DDF_OCTREE				= 0x00000001,	//!<  : E

		DDF_DIRLIGHT_SHAPE		= 0x00000002,	//!< fBNViCg : `

		DDF_SPOTLIGHT_SHAPE		= 0x00000004,	//!< X|bgCg : `
		DDF_SPOTLIGHT_BOUNDS	= 0x00000008,	//!< X|bgCg : E

		DDF_POINTLIGHT_SHAPE	= 0x00000010,	//!< |CgCg : `
		DDF_POINTLIGHT_BOUNDS	= 0x00000020,	//!< |CgCg : E

		DDF_SHADOW_BOUNDS		= 0x00000040,	//!< VhE : E

		DDF_WIDGET_GROUP_BOUNDS	= 0x00000080,	//!< EBWFbg : O[v̋E

		DDF_PARTICLE_MESH		= 0x00000100,	//!< p[eBN : bV
		DDF_PARTICLE_AXIS		= 0x00000200,	//!< p[eBN : 
		DDF_PARTICLE_BOUNDS		= 0x00000400,	//!< p[eBN : E
		DDF_PARTICLE_GENERATOR	= 0x00000800,	//!< p[eBN : WFl[^[
		DDF_PARTICLE_PROCESSOR	= 0x00001000,	//!< p[eBN : vZbT[

		DDF_PLANTER_MESH		= 0x00002000,	//!< v^[ : bV
		DDF_PLANTER_BOUNDS		= 0x00004000,	//!< v^[ : E

		DDF_ACTORMODEL_MESH		= 0x00008000,	//!< AN^[f : bV
		DDF_ACTORMODEL_AXIS		= 0x00010000,	//!< AN^[f : 
		DDF_ACTORMODEL_BOUNDS	= 0x00020000,	//!< AN^[f : E
		DDF_ACTORMODEL_SKELETAL	= 0x00040000,	//!< AN^[f : i
		DDF_ACTORMODEL_KCHAR	= 0x00080000,	//!< AN^[f : Ll}eBbNLN^
		DDF_ACTORMODEL_COLLIDER	= 0x00100000,	//!< AN^[f : RC_[
		DDF_ACTORMODEL_SENSOR	= 0x00200000,	//!< AN^[f : ZT[
		DDF_ACTORMODEL_JOINT	= 0x00400000,	//!< AN^[f : WCg

		DDF_TERRAINMODEL_MESH	= 0x00800000,	//!< eCf : bV
		DDF_TERRAINMODEL_BOUNDS	= 0x01000000,	//!< eCf : E

		DDF_WATERPOOL_BOUNDS	= 0x02000000,	//!< EH[^[v[ : E

		DDF_PP_FILMIC			= 0x04000000,	//!< |XgvZX : tB~bN
		DDF_PP_CHROMATISM		= 0x08000000,	//!< |XgvZX : F
		DDF_PP_LENS_DISTORTION	= 0x10000000,	//!< |XgvZX : cȎ

		DDF_FLOOR_COLLIDER		= 0x20000000,	//!< tA : RC_[
		DDF_GHOST_COLLIDER		= 0x40000000,	//!< S[Xg : RC_[

		//! @brief bV
		DDF_MESH				= ( DDF_PLANTER_MESH | DDF_PARTICLE_MESH | DDF_ACTORMODEL_MESH | DDF_TERRAINMODEL_MESH ),
		//! @brief 
		DDF_AXIS				= ( DDF_PARTICLE_AXIS | DDF_ACTORMODEL_AXIS ),
		//! @brief E
		DDF_BOUNDS				= ( DDF_SPOTLIGHT_BOUNDS | DDF_POINTLIGHT_BOUNDS | DDF_PARTICLE_BOUNDS | DDF_ACTORMODEL_BOUNDS | DDF_TERRAINMODEL_BOUNDS | DDF_WATERPOOL_BOUNDS | DDF_PLANTER_BOUNDS ),

		//! @brief SẴCǧ`
		DDF_LIGHT_SHAPE			= ( DDF_DIRLIGHT_SHAPE | DDF_SPOTLIGHT_SHAPE | DDF_POINTLIGHT_SHAPE ),
		//! @brief SẴCg̋E
		DDF_LIGHT_BOUNDS		= ( DDF_SPOTLIGHT_BOUNDS | DDF_POINTLIGHT_BOUNDS ),
		//! @brief SẴCg
		DDF_LIGHT				= ( DDF_LIGHT_SHAPE | DDF_LIGHT_BOUNDS ),
		//! @brief fBNViCg
		DDF_DIRLIGHT			= ( DDF_DIRLIGHT_SHAPE ),
		//! @brief X|bgCg
		DDF_SPOTLIGHT			= ( DDF_SPOTLIGHT_SHAPE | DDF_SPOTLIGHT_BOUNDS ),
		//! @brief |CgCg
		DDF_POINTLIGHT			= ( DDF_POINTLIGHT_SHAPE | DDF_POINTLIGHT_BOUNDS ),

		//! @brief VhE
		DDF_SHADOW				= ( DDF_SHADOW_BOUNDS ),

		//! @brief EBWFbg
		DDF_WIDGET				= ( DDF_WIDGET_GROUP_BOUNDS ),
		//! @brief v^[
		DDF_PLANTER				= ( DDF_PLANTER_MESH | DDF_PLANTER_BOUNDS ),
		//! @brief p[eBN
		DDF_PARTICLE			= ( DDF_PARTICLE_MESH | DDF_PARTICLE_AXIS | DDF_PARTICLE_BOUNDS | DDF_PARTICLE_GENERATOR | DDF_PARTICLE_PROCESSOR ),

		//! @brief AN^[f
		DDF_ACTORMODEL			= ( DDF_ACTORMODEL_MESH | DDF_ACTORMODEL_AXIS | DDF_ACTORMODEL_BOUNDS | DDF_ACTORMODEL_SKELETAL | DDF_ACTORMODEL_KCHAR | DDF_ACTORMODEL_COLLIDER | DDF_ACTORMODEL_SENSOR | DDF_ACTORMODEL_JOINT ),
		//! @brief eCf
		DDF_TERRAINMODEL		= ( DDF_TERRAINMODEL_MESH | DDF_TERRAINMODEL_BOUNDS ),

		//! @brief EH[^[v[
		DDF_WATERPOOL			= ( DDF_WATERPOOL_BOUNDS ),

		//! @brief tA
		DDF_FLOOR				= ( DDF_FLOOR_COLLIDER ),

		//! @brief S[Xg
		DDF_GHOST				= ( DDF_GHOST_COLLIDER ),

		//! @brief _Ci~NX
		DDF_DYNAMICS			= ( DDF_FLOOR |
									DDF_GHOST |
									DDF_ACTORMODEL_SKELETAL |
									DDF_ACTORMODEL_KCHAR |
									DDF_ACTORMODEL_COLLIDER |
									DDF_ACTORMODEL_SENSOR |
									DDF_ACTORMODEL_JOINT ),
	};

	//! @enum DEBUG_DRAW_COLOR_TYPE
	//! @brief fobO : `J[^Cv񋓒萔
	enum DEBUG_DRAW_COLOR_TYPE
	{
		DDC_COLLIDER_AROUSAL		= 0,	//!< RC_[ : Ɋ
		DDC_COLLIDER_ACTIVE			= 1,	//!< RC_[ : 
		DDC_COLLIDER_SLEEPY			= 2,	//!< RC_[ : x~ɂȂȌ
		DDC_COLLIDER_REST			= 3,	//!< RC_[ : x~
		DDC_COLLIDER_DISABLE		= 4,	//!< RC_[ : ( V~[V͍sĂȂ )

		DDC_SENSOR					= 5,	//!< ZT[

		DDC_KINEMATIC_CHARACTER		= 6,	//!< Ll}eBbNLN^[

		DDC_JOINT_FRAME				= 7,	//!< WCg : t[
		DDC_JOINT_LIMIT				= 8,	//!< WCg : ~bg

		DDC_BOUNDS					= 9,	//!< E

		DDC_OCTREE_NODE_BOUNDS		= 10,	//!< INg[ : m[h̋E
		DDC_OCTREE_OBJS_BOUNDS		= 11,	//!< INg[ : IuWFNg̋E

		DDC_LIGHT_SHAPE				= 12,	//!< Cg : `
		DDC_PARTICLE_QUAD			= 13,	//!< p[eB : `
		DDC_ACTORMODEL_SKELETAL		= 14,	//!< AN^[f : i
		DDC_SM_CLIP_BOOUNDS			= 15,	//!< VhE}bsO : NbvE
		DDC_SM_CAST_BOOUNDS			= 16,	//!< VhE}bsO : LXgE

		DDC_FILMIC_BG				= 17,	//!< tB~bN : wi
		DDC_FILMIC_MEMORY			= 18,	//!< tB~bN : 
		DDC_FILMIC_CURVE			= 19,	//!< tB~bN : J[u

		DDC_ABERRATION				= 20,	//!< FAcȎ̊iq̐F
	};

	//! @enum DEBUG_PROFILE_TYPE
	//! @brief fobO : vt@C^Cv񋓒萔
	enum DEBUG_PROFILE_TYPE
	{
		DPT_GENERAL				= 0,	//!< S
		DPT_DYNAMICS			= 1,	//!< _Ci~NX
		DPT_OCTREE				= 2,	//!< 
		DPT_LIGHT				= 3,	//!< Cg
		DPT_WATER_POOL			= 4,	//!< EH[^[v[
		DPT_WIDGET				= 5,	//!< EBWFbg
		DPT_ACTOR_MODEL			= 6,	//!< AN^[f
		DPT_TERRAIN_MODEL		= 7,	//!< eCf
		DPT_PROJ_SHADOW			= 8,	//!< VhE̓e
		DPT_DRAW_OPACITY		= 9,	//!< s̕`
		DPT_DRAW_NEUTRALITY		= 10,	//!< s̕`Ƌ܂̕`̊Ԃɍs`
		DPT_DRAW_REFRACT		= 11,	//!< ܂̕`
		DPT_DRAW_TRANSPARENCY	= 12,	//!< ̕`
		DPT_POST_PROCESS		= 13,	//!< |XgvZX
	};

	//! @struct DEBUG_PROFILE_RENDERER_GENERAL
	//! @brief fobO : _[ : WFlvt@C\
	struct DEBUG_PROFILE_RENDERER_GENERAL
	{
		Float32 updElapsedTime;		//!< XV( Mix::Scene::IRenderer::Update )ɂ( bP )
		Float32 refElapsedTime;		//!< tbV( Mix::Scene::IRenderer::Refresh )ɂ( bP )
		Float32 drawElapsedTime;	//!< SẴJɂ`( Mix::Scene::ICamera::Draw )ɂ( bP )
		Float32 finElapsedTime;		//!< ㏈ɂ( bP )

		UInt32 drawPrimCount;		//!< SẴJɂ`悳ꂽv~eBu
	};

	//! @struct DEBUG_PROFILE_RENDERER_DYNAMICS
	//! @brief fobO : _[ : _Ci~NXvt@C\
	//! @note ̍\̂̃p[^̒ĺAMix::Scene::IRenderer::Update ɂčXV܂B
	struct DEBUG_PROFILE_RENDERER_DYNAMICS
	{
		Float32 ssElapsedTime;	//!< V~[Vɂ( bP )
		Float32 cpElapsedTime;	//!< ڐG̎Wɂ( bP )
	};

	//! @struct DEBUG_PROFILE_RENDERER_OCTREE
	//! @brief fobO : _[ : ؃vt@C\
	//! @note ̍\̂̃p[^̒ĺAMix::Scene::IRenderer::Refresh ɂčXV܂B
	struct DEBUG_PROFILE_RENDERER_OCTREE
	{
		UInt32 nodeCount;						//!< ݂̃m[h
		UInt32 nodeMax;							//!< m[h̍ő吔
		Mix::Vector3 unitSize;					//!< [tƂȂqԂ̃TCY

		UInt32 illegalLocalLightNum;			//!< C[Kȃ[JCg̐
		UInt32 illegalLeavingParticleNum;		//!< C[Kȃ[rOp[eBN̐
		UInt32 illegalScatterParticleUnitNum;	//!< C[KȃXLb^[p[eBÑjbg̐
		UInt32 illegalActorModelNum;			//!< C[KȃAN^[f̐
	};

	//! @struct DEBUG_PROFILE_CAMERA_GENERAL
	//! @brief fobO : J : WFlvt@C\
	struct DEBUG_PROFILE_CAMERA_GENERAL
	{
		Float32 drawElapsedTime;	//!< `( Mix::Scene::ICamera::Draw )ɂ( bP )
		UInt32 drawPrimCount;		//!< `悳ꂽv~eBu
	};

	//! @struct DEBUG_PROFILE_CAMERA_OCTREE
	//! @brief fobO : J : ؃vt@C\
	struct DEBUG_PROFILE_CAMERA_OCTREE
	{
		Float32 ccElapsedTime;	//!< `悷IuWFNg̎Wɂ( bP )
		Float32 csElapsedTime;	//!< eƂēeIuWFNg̎Wɂ( bP )
		Float32 fElapsedTime;	//!< IuWFNgW̏ɂ( bP )
	};

	//! @struct DEBUG_PROFILE_CAMERA_LIGHT
	//! @brief fobO : J : Cgvt@C\
	struct DEBUG_PROFILE_CAMERA_LIGHT
	{
		UInt32 vSpotCount;		//!< EɓĂX|bgCg̐
		UInt32 tSpotCount;		//!< SẴX|bgCg̐

		UInt32 vPointCount;		//!< Eɓė|CgCg̐
		UInt32 tPointCount;		//!< SẴ|CgCg̐

		Float32 vcElapsedTime;	//!< EɓĂ郍[JCg̎Wɂ( bP )
		Float32 vsElapsedTime;	//!< EɓĂ郍[JCg̃\[gɂ( bP )
	};

	//! @struct DEBUG_PROFILE_CAMERA_WATER_POOL
	//! @brief fobO : J : EH[^[v[vt@C
	struct DEBUG_PROFILE_CAMERA_WATER_POOL
	{
		Float32 vElapsedTime;	//!< EɓĂEH[^[v[̐
		UInt32 vCount;			//!< EɓĂSăEH[^[v[̐
		UInt32 vrCount;			//!< EɓĂܔɎgpĂEH[^[v[̐
		UInt32 tCount;			//!< SẴEH[^[v[̐
	};

	//! @struct DEBUG_PROFILE_CAMERA_WIDGET
	//! @brief fobO : J : EBWFbgvt@C\
	struct DEBUG_PROFILE_CAMERA_WIDGET
	{
		//! @struct DEBUG_PROFILE_LEAVING_PARTICLE
		//! @brief fobO : [rOp[eBNvt@C\
		struct DEBUG_PROFILE_LEAVING_PARTICLE
		{
			UInt32 vCount;			//!< EɓĂ郊[rOp[eBN̐
			UInt32 tCount;			//!< SẴ[rOp[eBN̐
			Float32 vElapsedTime;	//!< EɓĂ郊[rO̎Wɂ( bP )
		}lp; //!< [rOp[eBNvt@C

		//! @struct DEBUG_PROFILE_SCATTER_PARTICLE
		//! @brief fobO : XLb^[p[eBNvt@C\
		struct DEBUG_PROFILE_SCATTER_PARTICLE
		{
			UInt32 vCount;		//!< EɓĂXLb^[p[eBÑjbg̐
			UInt32 tCount;		//!< SẴXLb^[p[eBÑjbg̐
			Float32 vElapsedTime;	//!< EɓĂXLb^[p[eBN̎Wɂ( bP )
		}sp; //!< XLb^[p[eBNvt@C

		//! @struct DEBUG_PROFILE_PLANTER
		//! @brief fobO : v^[vt@C\
		struct DEBUG_PROFILE_PLANTER
		{
			UInt32 vCount;			//!< EɓĂv^[̐
			UInt32 tCount;			//!< SẴv^[̐
			Float32 vElapsedTime;	//!< EɓĂv^[̎Wɂ( bP )
		}pl; //!< v^[vt@C

		UInt32 subsetCount;		//!< TuZbg̐
		UInt32 quadCount;		//!< Nbh̐
		UInt32 objCount;		//!< TuZbgANbh琶ꂽIuWFNg̐
		UInt32 comCount;		//!< IuWFNgɐꂽR}h̐

		Float32 slElapsedTime;	//!< [JCeBOsEBWFbg̃\[gɂ( bP )
		Float32 alElapsedTime;	//!< [JCeBOɂ( bP )
		Float32 goElapsedTime;	//!< TuZbg甼IuWFNg̐ɂ( bP )
	};

	//! @struct DEBUG_PROFILE_CAMERA_MODEL
	//! @brief fobO : J : fvt@C\
	struct DEBUG_PROFILE_CAMERA_MODEL
	{
		UInt32 vCount;			//!< EɓĂ郂f̐
		UInt32 sCount;			//!< VhE}bsOsf̐
		UInt32 tCount;			//!< SẴf̐
		Float32 vcElapsedTime;	//!< EɓĂ郂f̎WAR}h̐ɂ( bP )
		Float32 cmElapsedTime;	//!< VhE}bsOsf̎Wɂ( bP )
	};

	//! @struct DEBUG_PROFILE_CAMERA_PROJ_SHADOW
	//! @brief fobO : J : VhEevt@C\
	struct DEBUG_PROFILE_CAMERA_PROJ_SHADOW
	{
		UInt32 comCount;			//!< R}h̐
		UInt32 comCapacity;			//!< R}h̃LpVeB

		Float32 preElapsedTime;		//!< O( \[g )ɂ( bP )
		Float32 drawElapsedTime;	//!< `ɂ( bP )
	};

	//! @struct DEBUG_PROFILE_CAMERA_DRAW_OPACITY
	//! @brief fobO : J : s`vt@C\
	struct DEBUG_PROFILE_CAMERA_DRAW_OPACITY
	{
		UInt32 comCount;			//!< R}h̐
		UInt32 comCapacity;			//!< R}h̃LpVeB

		Float32 preElapsedTime;		//!< O( \[g )ɂ( bP )
		Float32 drawElapsedTime;	//!< `ɂ( bP )
	};

	//! @struct DEBUG_PROFILE_CAMERA_DRAW_NEUTRALITY
	//! @brief fobO : J : s`Ɣ`( ܕ`܂ )̊Ԃ̕`vt@C\
	struct DEBUG_PROFILE_CAMERA_DRAW_NEUTRALITY
	{
		Float32 aoElapsedTime;	//!< ArGgIN[Wɂ( bP )
		Float32 asElapsedTime;	//!< C̕`ɂ( bP )
	};

	//! @struct DEBUG_PROFILE_CAMERA_DRAW_REFRACT
	//! @brief fobO : J : ܕ`vt@C\
	struct DEBUG_PROFILE_CAMERA_DRAW_REFRACT
	{
		UInt32 comCount;			//!< R}h̐
		UInt32 comCapacity;			//!< R}h̃LpVeB

		Float32 maskElapsedTime;	//!< ܃}XN̕`ɂ( bP )
		Float32 drawElapsedTime;	//!< ܂̕`ɂ( bP )
	};

	//! @struct DEBUG_PROFILE_CAMERA_DRAW_TRANSPARENCY
	//! @brief fobO : J : vt@C\
	struct DEBUG_PROFILE_CAMERA_DRAW_TRANSPARENCY
	{
		UInt32 objCount;			//!< IuWFNg
		UInt32 objCapacity;			//!< IuWFNg̃LpVeB

		UInt32 comCount;			//!< R}h̐
		UInt32 comCapacity;			//!< R}h̃LpVeB

		UInt32 bkComCount;			//!< ܖʂ̕`ɎgpꂽR}h̐( ܖʂƏdȂĂ̂܂ )
		UInt32 bkComCapacity;		//!< ܖʂ̕`ɎgpꂽR}h̃LpVeB

		UInt32 frComCount;			//!< ܖʂO̕`ɎgpꂽR}h̐( ܖʂƏdȂĂ̂܂ )
		UInt32 frComCapacity;		//!< ܖʂO̕`ɎgpꂽR}h̃LpVeB

		UInt32 ovComCount;			//!< ܖʂƏdȂĂ(I[obv)R}h̐

		Float32 soElapsedTime;		//!< IuWFNg̃\[gɂ( bP )
		Float32 gcElapsedTime;		//!< IuWFNgR}h̐ɂ( bP )
		Float32 dcElapsedTime;		//!< ܖʂɑ΂ÕR}h̕ɂ( bP )
		Float32 bkElapsedTime;		//!< ܖʂ̕`ɂ( bP )
		Float32 frElapsedTime;		//!< ܖʂO̕`ɂ( bP )
	};

	//! @struct DEBUG_PROFILE_CAMERA_POST_PROCESS
	//! @brief fobO : J : |XgvZXvt@C\
	struct DEBUG_PROFILE_CAMERA_POST_PROCESS
	{
		Float32 smElapsedTime;		//!< VhE}bsOɂ( bP )
		Float32 uwElapsedTime;		//!< ʉɂ( bP )
		Float32 lumTrElapsedTime;	//!< Px̕ϊAɂ( bP )
		Float32 lbElapsedTime;		//!< u[ɂ( bP )
		Float32 lsElapsedTime;		//!< CgVtgɂ( bP )
		Float32 lfElapsedTime;		//!< YtAɂ( bP )
		Float32 lumOpElapsedTime;	//!< Px̓Kpɂ( bP )
		Float32 fmElapsedTime;		//!< tB~bNɂ( bP )
		Float32 gcElapsedTime;		//!< K}␳ɂ( bP )
		Float32 mbElapsedTime;		//!< [Vu[ɂ( bP )
		Float32 caElapsedTime;		//!< Fɂ( bP )
		Float32 dofElapsedTime;		//!< ʊE[xɂ( bP )
		Float32 ldElapsedTime;		//!< cȎɂ( bP )
		Float32 viElapsedTime;		//!< Blbgɂ( bP )
		Float32 aaElapsedTime;		//!< A`GCAVOɂ( bP )
		Float32 finalElapsedTime;	//!< ŏI( obNobt@ւ̃Rs[ )ɂ( bP )
	};

	//! @enum DEBUG_IMAGE_TYPE
	//! @brief fobO : C[W񋓒萔
	enum DEBUG_IMAGE_TYPE
	{
		//! @brief [x
		DIT_DEPTH				= 0,

		//! @brief f[^
		//! @note
		//! RGB=r[@<br>
		//! A=XJCh[}XN
		DIT_DATA				= 1,

		//! @brief ArGgIN[W
		//! @note
		//! 0:J[<br>
		//! 1:J[̂ڂ
		DIT_AMBIENT_OCCLUSION	= 2,

		//! @brief VhE}bsO
		//! @note
		//! 0:[x<br>
		//! 1:J[<br>
		//! 2:J[̂ڂ<br>
		DIT_SHADOW_MAPPING		= 3,

		//! @brief ~mVeB
		//! @note
		//! 0:݂̋Px<br>
		//! 1:Px
		DIT_LUMINOSITY			= 4,

		//! @brief u[
		//! @note
		//! 0:uCgpX<br>
		//! 1ȍ~:I[o[t[
		DIT_BLOOM				= 5,

		//! @brief CgVtg
		//! @note
		//! 0:uCgpX<br>
		//! 1:J[
		DIT_LIGHT_SHAFTS		= 6,

		//! @brief YtA
		//! @note
		//! 0:uCgpX<br>
		//! 1:J[
		DIT_LENS_FLARE			= 7,

		//! @brief F
		//! @note
		//! 0:J[̍
		DIT_CHROMATISM			= 8,

		//! @brief ʊE[x
		//! @note
		//! 0:J[̂ڂ1<br>
		//! 1:J[̂ڂ2
		DIT_DOF					= 9,
	};

	//! @brief }l[W̃|C^擾܂
	//! @return }l[W\ Mix::Scene::IManager C^[tF[X̃|C^Ԃ܂
	_MIX_DLL_API Mix::Scene::IManager* GetManagerPtr( void );
	//! @brief }l[W擾܂
	//! @param[out] ppManager }l[W\ Mix::Scene::IManager C^[tF[X̃|C^̃AhX
	//! @return ꍇ True Ԃ܂
	//! @note 擾}l[W͎QƃJE^ +1 ܂B
	_MIX_DLL_API Boolean GetManager( Mix::Scene::IManager** ppManager );

}}

//! @namespace Mix
//! @brief ~bNX
namespace Mix{

	class IEngine;

	//! @struct ENGINE_CONFIG_FLAG
	//! @brief GWݒtO񋓒萔
	enum ENGINE_CONFIG_FLAG
	{
		//! @brief o ( Mix::IO ) }EgꂽAt@CAfBNgɌ肷
		//! @note
		//! ̃tOw肵Ȃꍇ́Aȉ̃\bh͋@\܂B<br>
		//! <br>
		//! Mix::IO::IManager::MountArchive<br>
		//! Mix::IO::IManager::MountDirectory<br>
		//! Mix::IO::IManager::MountFile<br>
		EC_IO_NARROW	= 0x00000001,
		//! @brief L[{[h ( Mix::HID::IKeyboard ) gp
		EC_KEYBOARD		= 0x00000002,
		//! @brief }EX ( Mix::HID::IMouse ) gp
		EC_MOUSE		= 0x00000004,
		//! @brief Q[pbh ( Mix::HID::IGamepad ) gp
		EC_GAMEPAD		= 0x00000008,
		//! @brief q[}C^[tF[XfoCX ( Mix::HID ) gp
		EC_HID			= EC_KEYBOARD | EC_MOUSE | EC_GAMEPAD,
		//! @brief OtBbNX ( Mix::Graphics ) gp
		EC_GRAPHICS		= 0x00000010,
		//! @brief TEh ( Mix::Sound ) gp
		EC_SOUND		= 0x00000020,
		//! @brief _Ci~NX ( Mix::Dynamics ) gp
		EC_DYNAMICS		= 0x00000040,
		//! @brief 񏈗 ( Mix::Parallel ) gp
		EC_PARALLEL		= 0x00000080,
		//! @brief V[ ( Mix::Scene ) gp
		EC_SCENE		= 0x00000100,

		//! @brief SĂgp
		EC_ALL		= EC_IO_NARROW | EC_HID | EC_GRAPHICS | EC_SOUND | EC_DYNAMICS | EC_PARALLEL | EC_SCENE,
	};

	//! @struct ENGINE_CONFIG
	//! @brief GWݒ\
	struct ENGINE_CONFIG
	{
		//! @brief gp@\ Mix::ENGINE_CONFIG_FLAG 񋓒萔̑gݍ킹Ŏw肵܂B
		UInt32 flags;

		//! @brief OEBhẼnh
		//! @note ŃEBhE쐬ꍇ NULL ɂĂKv܂B<br>
		HWND hWnd;

		//! @brief ^[Qbg̃TCY
		//! @note
		//! EBhEgpꍇ́AEBhẼNCAgAOtBbNX̃obNobt@̃TCYɂȂ܂B<br>
		//! ܂ATCYύX\ȊOEBhEw肳Ăꍇ́A̒l͖A<br>
		//! OtBbNX̃obNobt@̃TCÝÃ݂fBXvC̉𑜓xgp܂B<br>
		Mix::Point targetSize;

		//! @brief EBhẼ^Cgo[ɕ\镶
		//! @note OEBhEw肳Ăꍇ͖܂B
		const wchar_t* pCaption;
		//! @brief EBhẼ^Cgo[ɕ\ACR̃nh
		//! @note OEBhEw肳Ăꍇ͖܂B
		HICON hIcon;
		//! @brief EBhẼ^Cgo[ɕ\鏬ACR̃nh
		//! @note OEBhEw肳Ăꍇ͖܂B
		HICON hSmallIcon;
		//! @brief hbOhbv󂯓邩ǂ
		//! @note OEBhEw肳Ăꍇ͖܂B
		Boolean bAcceptDrop;

		//! @brief b̃t[<br>
		//! ( frameRate > 0 )  : b̃t[𐧌AFPSv܂<br>
		//! ( frameRate == 0 ) : b̃t[𐧌AFPSv܂<br>
		//! ( frameRate < 0 )  : b̃t[𐧌AFPSv܂
		Int32 baseFPS;
		//! @brief t[ɋ󂫎Ԃꍇɑ̃XbhɃ^CXCX( Sleep( 0 ) )t[
		Int32 insomniaFrames;

		//! @brief [gfBNg̃pX
		//! @note
		//! NULL w肷ƃvZX̃fBNgɂȂ܂B<br>
		//! ܂A΃pXw肷ƃJgfBNgx[XƂ΃pXɂȂ܂B
		const wchar_t* pRootDirectoryPath;
		//! @brief vOCĂfBNg̃pX
		//! @note
		//! NULL w肷ƃJgfBNgw肵ƂɂȂ܂B<br>
		//! ܂A΃pXw肵ꍇA[gfBNgx[XƂ΃pXɂȂ܂B
		const wchar_t* pPluginDirectoryPath;
		//! @brief [U[fBNg̃pX
		//! @note }ChLg̑΃pXw肵܂B
		const wchar_t* pUserDirectoryPath;

		//! @brief gpVF[_[f
		Mix::Graphics::SHADER_MODEL shaderModel;
		//! @brief tXN[ŋNꍇ True
		Boolean bFullscreen;
		//! @brief ҂ĕ`悷ꍇ True
		Boolean bWaitVSync;

		//! @brief eLXg̃^uTCY
		//! @note ŏl 2 łB
		Int32 textTabSize;
		//! @brief eLXg( tHg )ރ^[QbgeNX`̈ӂ̒
		Int32 textTargetSize;
		//! @brief eLXg( tHg )ރ^[QbgeNX`̏y[W
		Int32 initialTextTargetNum;

		//! @brief RXgN^
		ENGINE_CONFIG( void )
		{
			flags = Mix::EC_ALL;

			hWnd = NULL;

			pCaption = NULL;
			hIcon = NULL;
			hSmallIcon = NULL;
			bAcceptDrop = False;

			pRootDirectoryPath = NULL;
			pPluginDirectoryPath = NULL;
			pUserDirectoryPath = NULL;

			baseFPS = 60;
			insomniaFrames = 15;

			targetSize.x = 1024;
			targetSize.y = 768;

			shaderModel = Mix::Graphics::SHADER_MODEL_3;
			bFullscreen = False;
			bWaitVSync = False;

			textTabSize = 4;
			textTargetSize = 512;
			initialTextTargetNum = 2;
		}
	};

	//! @fn void MessageProc( HWND hWnd, UInt32 msg, WPARAM wp, LPARAM lp, void* pData )
	//! @brief bZ[WvV[W[
	//! @param hWnd EBChEnh
	//! @param message bZ[W
	//! @param wParam bZ[W̒ǉf[^ 1
	//! @param lParam bZ[W̒ǉf[^ 2 
	//! @param pData f[^
	typedef void __stdcall MessageProc( HWND hWnd, UInt32 message, WPARAM wParam, LPARAM lParam, void* pData );

	//! @typedef MessageProcPtr
	//! @brief Mix::MessageProc ̃|C^
	typedef MessageProc* MessageProcPtr;

	//! @brief Mix܂
	//! @return ꍇ True Ԃ܂
	_MIX_DLL_API Boolean Initialize( const Mix::ENGINE_CONFIG& config );
	//! @brief MixI܂
	_MIX_DLL_API void Finalize( void );

	//! @brief CX^X̃nh擾܂
	//! @return nhԂ܂
	_MIX_DLL_API HINSTANCE GetInstanceHandle( void );

	//! @brief GW̃|C^擾܂
	//! @return GW̃|C^\ Mix::IEngine C^[tF[X̃|C^Ԃ܂
	_MIX_DLL_API Mix::IEngine* GetEnginePtr( void );
	//! @brief GW擾܂
	//! @param[out] ppEngine GW\ Mix::IEngine C^[tF[X̃|C^̃AhX
	//! @note 擾GW͎QƃJE^ +1 ܂B
	_MIX_DLL_API Boolean GetEngine( Mix::IEngine** ppEngine );

	//! @brief ̕擾܂
	//! @param[in] value 𔻒肷l
	//! @return ̕Ԃ܂
	_MIX_DLL_API Int32 Sign( Int32 value );
	//! @brief _̕擾܂
	//! @param[in] value 𔻒肷l
	//! @return _̕Ԃ܂
	_MIX_DLL_API Float32 SignF( Float32 value );

	//! @brief _̕擾܂
	//! @param[in] value ߂l
	//! @return _̕Ԃ܂
	_MIX_DLL_API Float32 SqrtF( const Float32& value );

	//! @brief _̋t擾܂
	//! @param[in] value t߂l
	//! @return tԂ܂
	_MIX_DLL_API Float32 InvF( Float32 value );
	//! @brief _̋̕t擾܂
	//! @param[in] value ̋t߂l
	//! @return ̋tԂ܂
	_MIX_DLL_API Float32 InvSqrtF( Float32 value );

	//! @brief ܂
	_MIX_DLL_API void InitRand( void );
	//! @brief ܂
	//! @param[in] seed ̂ƂɂȂ鐔
	_MIX_DLL_API void InitRand( UInt32 seed );
	//! @brief ܂
	//! @param[in] seeds ̂ƂɂȂ鐔̔z
	//! @param[in] numSeed ̂ƂɂȂ鐔̔z̗vf̐
	_MIX_DLL_API void InitRand( UInt32* seeds, UInt32 numSeed );
	//! @brief ̗擾܂
	//! @return ̗Ԃ܂
	_MIX_DLL_API UInt32 Rand( void );
	//! @brief ̗擾܂
	//! @param[in] maxRnd 擾闐̍ől
	//! @return ̗Ԃ܂
	_MIX_DLL_API UInt32 Rand( UInt32 maxRnd );
	//! @brief ̗擾܂
	//! @param[in] r0 擾闐̊Jnl
	//! @param[in] r1 擾闐̏Il
	//! @return ̗Ԃ܂
	_MIX_DLL_API UInt32 Rand( UInt32 r0, UInt32 r1 );
	//! @brief _̗( 0.0f`1.0f )擾܂
	//! @return _̗Ԃ܂
	_MIX_DLL_API Float32 RandF( void );
	//! @brief _̗擾܂
	//! @param[in] maxRnd 擾闐̍ől
	//! @return _̗Ԃ܂
	_MIX_DLL_API Float32 RandF( Float32 maxRnd );
	//! @brief _̗擾܂
	//! @param[in] r0 擾闐̊Jnl
	//! @param[in] r1 擾闐̏Il
	//! @return _̗Ԃ܂
	_MIX_DLL_API Float32 RandF( Float32 r0, Float32 r1 );

	//! @brief _̐`Ԃ܂
	//! @param[in] a Ԍ
	//! @param[in] b Ԑ
	//! @param[in] t ԌW( 0.0f`1.0f )
	//! @return Ԃꂽ_Ԃ܂
	_MIX_DLL_API Float32 LerpF( Float32 a, Float32 b, Float32 t );

	//! @brief w肳ꂽxNgQ{̐ȃxNg߂܂
	//! @param[in] n ̓xNg\ Mix::Vector3 NX
	//! @param[out] p o̓xNgP\ Mix::Vector3 NX
	//! @param[out] q o̓xNgQ\ Mix::Vector3 NX
	_MIX_DLL_API void PlaneSpace( const Mix::Vector3& n, Mix::Vector3& p, Mix::Vector3& q );

	//! @brief w肳ꂽsQ{̃xNgŒZ̉]߂܂
	//! @param[in] v0 ڂ̃xNg\ Mix::Vector3 NX
	//! @param[in] v1 ڂ̃xNg\ Mix::Vector3 NX
	//! @return ]\ Mix::Quaternion NXԂ܂
	_MIX_DLL_API Mix::Quaternion ShortestArc( const Mix::Vector3& v0, const Mix::Vector3& v1 );

	//! @brief [hWXN[W֕ϊ܂
	//! @param[in] viewMat r[s\ Mix::Matrix4x4 NX
	//! @param[in] projMat ˉes\ Mix::Matrix4x4 NX
	//! @param[in] worldPos [hW\ Mix::Vector3 NX
	//! @param[in] screenSize XN[̃TCY\ Mix::Vector2 NX
	//! @return XN[W\ Mix::Vector3 NXԂ܂
	_MIX_DLL_API Mix::Vector3 Project( const Mix::Matrix4x4& viewMat, const Mix::Matrix4x4& projMat, const Mix::Vector3& worldPos, const Mix::Vector2& screenSize );
	//! @brief XN[W[hW֕ϊ܂
	//! @param[in] viewMat r[s\ Mix::Matrix4x4 NX
	//! @param[in] projMat ˉes\ Mix::Matrix4x4 NX
	//! @param[in] screenPos XN[W( z ͎ˉeԂ̒l 0.0f ` 1.0f )\ Mix::Vector3 NX
	//! @param[in] screenSize XN[̃TCY\ Mix::Vector2 NX
	//! @return [hW\ Mix::Vector3 NXԂ܂
	_MIX_DLL_API Mix::Vector3 Unproject( const Mix::Matrix4x4& viewMat, const Mix::Matrix4x4& projMat, const Mix::Vector3& screenPos, const Mix::Vector2& screenSize );
}
