#pragma once

//! @file Mix/Vector2.h
//! @brief 2_xNgNXCN[ht@C

namespace Mix
{
	class Point;

	//! @class Vector2
	//! @brief 2_xNgNX
	class _MIX_DLL_API Vector2
	{
	public:
		union
		{
			struct
			{
				Float32 x;	//!< XW
				Float32 y;	//!< YW
			};

			struct
			{
				Float32 u;	//!< UW
				Float32 v;	//!< VW
			};

			Float32 data[2];	//!< f[^
		};

	public:
		//! @brief RXgN^
		Vector2( void );
		//! @brief RXgN^
		//! @param[in] v Rs[|Cg
		Vector2( const Vector2& v );
		//! @brief RXgN^
		//! @param[in] p Rs[|Cg
		Vector2( const Point& p );
		//! @brief RXgN^
		//! @param[in] vx wW
		//! @param[in] vy xW
		Vector2( Float32 vx, Float32 vy );

		//! @brief r
		//! @param[in] v rxNg
		//! @return lꍇ True Ԃ܂
		Boolean operator == ( const Vector2& v ) const;
		//! @brief r
		//! @param[in] v rxNg
		//! @return lȂꍇ True Ԃ܂
		Boolean operator != ( const Vector2& v ) const;

		//! @brief 
		//! @param[in] v l
		//! @return xNgԂ܂
		Vector2& operator = ( const Vector2& v );
		//! @brief 
		//! @param[in] p l
		//! @return xNgԂ܂
		Vector2& operator = ( const Point& p );
		//! @brief Z
		//! @param[in] v Zl
		//! @return ZxNgԂ܂
		Vector2& operator += ( const Vector2& v );
		//! @brief Z
		//! @param[in] v Zl
		//! @return ZxNgԂ܂
		Vector2& operator -= ( const Vector2& v );
		//! @brief Z
		//! @param[in] v Zl
		//! @return ZxNgԂ܂
		Vector2& operator *= ( const Vector2& v );
		//! @brief Z
		//! @param[in] v Zl
		//! @return ZxNgԂ܂
		Vector2& operator /= ( const Vector2& v );

		//! @brief Z
		//! @param[in] v Zl
		//! @return ZxNgԂ܂
		Vector2 operator + ( const Vector2& v ) const;
		//! @brief Z
		//! @param[in] v Zl
		//! @return ZxNgԂ܂
		Vector2 operator - ( const Vector2& v ) const;
		//! @brief Z
		//! @param[in] v Zl
		//! @return ZxNgԂ܂
		Vector2 operator * ( const Vector2& v ) const;
		//! @brief Z
		//! @param[in] v Zl
		//! @return ZxNgԂ܂
		Vector2 operator / ( const Vector2& v ) const;

		//! @brief Z
		//! @param[in] s Zl
		//! @return ZxNgԂ܂
		Vector2& operator *= ( Float32 s );
		//! @brief Z
		//! @param[in] s Zl
		//! @return ZxNgԂ܂
		Vector2& operator /= ( Float32 s );

		//! @brief Z
		//! @param[in] s Zl
		//! @return ZxNgԂ܂
		Vector2 operator * ( Float32 s ) const;
		//! @brief Z
		//! @param[in] s Zl
		//! @return ZxNgԂ܂
		Vector2 operator / ( Float32 s ) const;

		//! @brief ̕ƂĈ܂
		//! @return xNgԂ܂
		Vector2 operator +( void ) const;
		//! @brief 𔽓]܂
		//! @return 𔽓]xNgԂ܂
		Vector2 operator -( void ) const;

		//! @brief Z
		//! @param[in] s Z̒l
		//! @param[in] v Z̒l
		//! @return ZꂽxNgԂ܂
		friend const Vector2 operator * ( Float32 s, const Vector2& v )
		{
			Vector2 tmp( v );
			tmp *= s;
			return tmp;
		}

		//! @brief Z
		//! @param[in] s Z̒l
		//! @param[in] v Z̒l
		//! @return ZꂽxNgԂ܂
		friend const Vector2 operator / ( Float32 s, const Vector2& v )
		{
			Vector2 tmp( v );
			tmp /= s;
			return tmp;
		}

		//! @brief xNgݒ肵܂
		//! @param[in] vx wW
		//! @param[in] vy xW
		void Set( Float32 vx, Float32 vy );

		//! @brief K܂
		//! @return KÕxNg̒
		Float32 Normalize( void );
		//! @brief KxNg擾܂
		//! @param[out] pLength KÕxNg̒ 
		//! @return KxNg\ Mix::Vector2 NXԂ܂
		Vector2 ToNormalize( Float32* pLength = NULL ) const;

		//! @brief 0.0f`1.0f ɖOa܂
		void Saturate( void );
		//! @brief 0.0f`1.0f ɖOaxNg擾܂
		//! @return OaxNg\ Mix::Vector2 NXԂ܂
		Vector2 ToSaturate( void ) const;

		//! @brief 2擾܂
		//! @return 2Ԃ܂
		Float32 GetLengthSqr( void ) const;
		//! @brief 擾܂
		//! @return Ԃ܂
		Float32 GetLength( void ) const;
		//! @brief 擾܂
		//! @return Ԃ܂
		//! @note ߂ۂ Mix::SqrtF gpĂ܂
		Float32 GetLengthF( void ) const;

		//! @brief ̃|Cg̓ςԂ܂
		//! @param[in] l |Cg1
		//! @param[in] r |Cg2
		//! @return 
		static Float32 Dot( const Vector2& l, const Vector2& r );

		//! @brief ( 0.0f`1.0f )擾܂
		//! @return \ Mix::Vector2 NXԂ܂
		static Vector2 Rand( void );
		//! @brief ( 0.0f`v )擾܂
		//! @param[in] v ͈̔͂\ x::Vector2 NX
		//! @return \ Mix::Vector2 NXԂ܂
		static Vector2 Rand( const Vector2& v );
		//! @brief ( v0`v1 )擾܂
		//! @param[in] v0 ̊Jnl\ Mix::Vector2 NX
		//! @param[in] v1 ̏Il\ Mix::Vector2 NX
		//! @return \ Mix::Vector2 NXԂ܂
		static Vector2 Rand( const Vector2& v0, const Vector2& v1 );

		//! @brief ̃xNg̍ŏl擾܂
		//! @param[in] v0 r|Cg\ Mix::Vector2 NX
		//! @param[in] v1 r|Cg\ Mix::Vector2 NX
		//! @return xNg̍ŏl\ Mix::Vector2 NXԂ܂
		static Vector2 Min( const Vector2& v0, const Vector2& v1 );
		//! @brief ̃xNg̍ől擾܂
		//! @param[in] v0 r|Cg\ Mix::Vector2 NX
		//! @param[in] v1 r|Cg\ Mix::Vector2 NX
		//! @return xNg̍ől\ Mix::Vector2 NXԂ܂
		static Vector2 Max( const Vector2& v0, const Vector2& v1 );

		//! @brief `Ԃ܂
		//! @param[in] vs `ԂJnxNg\ Mix::Vector2 NX
		//! @param[in] ve `ԂIxNg\ Mix::Vector2 NX
		//! @param[in] t ԌW( 0.0f`1.0f )
		//! @return `ԂꂽxNg\ Mix::Vector2 NXԂ܂
		static Vector2 Lerp( const Vector2& vs, const Vector2& ve, Float32 t );
		//! @brief ʐ`Ԃ܂
		//! @param[in] vs ԂJnxNg\ Mix::Vector2 NX
		//! @param[in] ve ԂIxNg\ Mix::Vector2 NX
		//! @param[in] t ԌW( 0.0f`1.0f )
		//! @return ԂꂽxNg\ Mix::Vector2 Ԃ܂
		static Vector2 Slerp( const Vector2& vs, const Vector2& ve, Float32 t );

	public:
		//! @brief l( 0.0f, 0.0f )擾܂
		//! @return l\ Mix::Vector2 NXԂ܂
		static const Vector2& Zero( void )
		{
			static const Vector2 zero( 0.0f, 0.0f );
			return zero;
		}

		//! @brief X( 1.0f, 0.0f )擾܂
		//! @return X\ Mix::Vector2 NXԂ܂
		static const Vector2& XAxis( void )
		{
			static const Vector2 xAxis( 1.0f, 0.0f );
			return xAxis;
		}

		//! @brief Y( 0.0f, 1.0f )擾܂
		//! @return Y\ Mix::Vector2 NXԂ܂
		static const Vector2& YAxis( void )
		{
			static const Vector2 yAxis( 0.0f, 1.0f );
			return yAxis;
		}
	};
};
