#pragma once

//! @file Mix/Scene/IViewCamera.h
//! @brief r[JC^[tF[XCN[ht@C

#include "Mix/Scene/ICamera.h"

namespace Mix{ namespace Scene{

	//! @class IViewCamera
	//! @brief r[JC^[tF[X
	class IViewCamera : public Mix::Scene::ICamera
	{
	protected:
		//! @brief fXgN^
		virtual ~IViewCamera( void ) {}

	public:
		//! @brief r[ݒ肵܂
		//! @param[in] at _\ Mix::Vector3 NX
		//! @param[in] rotation ^[Qbg_Ƃ]\ Mix::Quaternion NX
		//! @param[in] distance ^[Qbg܂ł̋
		virtual void SetView( const Mix::Vector3& at, const Mix::Quaternion& rotation, Float32 distance ) = 0;

		//! @brief _ݒ肵܂
		//! @param[in] at _\ Mix::Vector3 NX
		virtual void SetAt( const Mix::Vector3& at ) = 0;

		//! @brief _𒆐SƂ]擾܂
		//! @return ]\ Mix::Quaternion NXԂ܂
		virtual const Mix::Quaternion& GetRotation( void ) const = 0;
		//! @brief _𒆐SƂ]擾܂
		//! @return ]\ Mix::Matrix4x4 NXԂ܂
		virtual const Mix::Matrix4x4& GetRotationMatrix( void ) const = 0;
		//! @brief _𒆐SƂ]ݒ肵܂
		//! @param[in] rotation ]\ Mix::Quaternion NX
		virtual void SetRotation( const Mix::Quaternion& rotation ) = 0;

		//! @brief _܂ł̋擾܂
		//! @return Ԃ܂
		virtual Float32 GetDistance( void ) const = 0;
		//! @brief _܂ł̋ݒ肵܂
		//! @param[in] distance 
		virtual void SetDistance( Float32 distance ) = 0;
	};

}}
