#pragma once

//! @file Mix/Scene/ITerrainCollider.h"
//! @brief eCRC_[C^[tF[X

#include "Mix/Scene/ICollider.h"

namespace Mix{ namespace Scene{

	//! @class ITerrainCollider
	//! @brief eCRC_[C^[tF[X
	class ITerrainCollider : public Mix::Scene::ICollider
	{
	protected:
		//! @brief fXgN^
		virtual ~ITerrainCollider( void ) {}

	public:
		//! @brief p[g擾܂
		//! @return p[gԂ܂
		virtual UInt32 GetPartCount( void ) const = 0;
		//! @brief |S擾܂
		//! @return |SԂ܂
		virtual UInt32 GetPolygonCount( UInt32 partIndex ) const = 0;
		//! @brief |S擾܂
		//! @return |SԂ܂
		virtual UInt32 GetTotalPolygonCount( void ) const = 0;
		//! @brief }eA̐擾܂
		//! @return }eA̐Ԃ܂
		virtual UInt32 GetMaterialCount( void ) const = 0;

		//! @brief |S̃}eACfbNX擾܂
		//! @param[in] partIndex p[g̃CfbNX
		//! @param[in] polygonIndex |S̃CfbNX
		//! @return |S̃}eACfbNXԂ܂<br>
		//! w肵|S̃CfbNX͈͊Ȍꍇ́A 0xFFFFFFFF Ԃ܂
		virtual UInt32 GetMaterialIndex( UInt32 partIndex, UInt32 polygonIndex ) const = 0;
		//! @brief |S̃}eACfbNXݒ肵܂
		//! @param[in] partIndex p[g̃CfbNX
		//! @param[in] polygonIndex |S̃CfbNX
		//! @param[in] materialIndex }eÃCfbNX
		//! @return ꍇ True Ԃ܂
		virtual Boolean SetMaterialIndex( UInt32 partIndex, UInt32 polygonIndex, UInt32 materialIndex ) = 0;
		//! @brief |S̃}eACfbNXz擾܂
		//! @param[in] partIndex p[g̃CfbNX
		//! @param[in] polygonStartIndex 擾Jn|S̃CfbNX
		//! @param[in] polygonCount 擾|S̐
		//! @param[out] ppMaterialIndices |S̃}eACfbNXz
		//! @return ۂɎ擾Ԃ܂
		virtual UInt32 LockMaterialIndices( UInt32 partIndex, UInt32 polygonStartIndex, UInt32 polygonCount, UInt32** ppMaterialIndices ) const = 0;

		//! @brief }eA擾܂
		//! @param[in] index CfbNX
		//! @return }eA\ Mix::Dynamics::MATERIAL \̂Ԃ܂
		//! @note CfbNX͈͊Ȍꍇ̓ftHg̃}eAԂ܂
		virtual const Mix::Dynamics::MATERIAL& GetMaterial( UInt32 index ) const = 0;
		//! @brief }eA擾܂
		//! @param[in] index 擾CfbNX
		//! @param[out] material 擾}eAn Mix::Dynamics::MATERIAL ̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean GetMaterial( UInt32 index, Mix::Dynamics::MATERIAL& material ) const = 0;
		//! @brief }eA擾܂
		//! @param[in] partIndex p[g̃CfbNX
		//! @param[in] polygonIndex |S̃CfbNX
		//! @return }eA\ Mix::Dynamics::MATERIAL Ԃ܂
		//! @note p[gA|S̃CfbNX͈͊Ȍꍇ͏lԂ܂B
		virtual const Mix::Dynamics::MATERIAL& GetMaterial( UInt32 partIndex, UInt32 polygonIndex ) const = 0;
		//! @brief }eA擾܂
		//! @param[in] partIndex p[g̃CfbNX
		//! @param[in] polygonIndex |S̃CfbNX
		//! @param[out] material 擾}eAn 
		//! @return 擾ɐꍇ True Ԃ܂
		virtual Boolean GetMaterial( UInt32 partIndex, UInt32 polygonIndex, Mix::Dynamics::MATERIAL& material ) const = 0;
		//! @brief }eAݒ肵܂
		//! @param[in] index ݒ肷CfbNX
		//! @param[out] material ݒ肷}eA\ Mix::Dynamics::MATERIAL \̂̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean SetMaterial( UInt32 index, const Mix::Dynamics::MATERIAL& material ) = 0;
		//! @brief }eAz擾܂
		//! @param[in] startIndex 擾JnCfbNX
		//! @param[in] count 擾
		//! @param[out] ppMaterials 擾}eAzn Mix::Dynamics::MATERIAL \̂̃|C^̃AhX
		//! @return ۂɎ擾Ԃ܂
		virtual UInt32 LockMaterials( UInt32 startIndex, UInt32 count, Mix::Dynamics::MATERIAL** ppMaterials ) const = 0;

		//! @brief tB^[O[v擾܂
		//! @return tB^[O[vԂ܂
		virtual UInt16 GetFilterGroup( void ) const = 0;
		//! @brief tB^[O[vݒ肵܂
		//! @param[in] filterGroup tB^[O[v
		//! @note l ( Mix::Dynamics::OF_STATIC ) ɂȂ܂
		virtual void SetFilterGroup( UInt16 filterGroup ) = 0;

		//! @brief tB^[}XN擾܂
		//! @return tB^[}XNԂ܂
		virtual UInt16 GetFilterMask( void ) const = 0;
		//! @brief tB^[}XNݒ肵܂
		//! @param[in] filterMask tB^[}XN
		//! @note l ( Mix::Dynamics::OF_DEFAULT | Mix::Dynamics::OF_KINEMATIC | Mix::Dynamics::OF_SENSOR | Mix::Dynamics::OF_CHARACTER | Mix::Dynamics::OF_DEBRIS ) ɂȂ܂
		virtual void SetFilterMask( UInt16 filterMask ) = 0;

		//! @brief Փ˃}[W擾܂
		//! @return Փ˃}[WԂ܂
		virtual Float32 GetMargin( void ) const = 0;
		//! @brief Փ˃}[Wݒ肵܂
		//! @param[in] margin Փ˃}[W
		//! @note
		//! ̒l邱ƂɂĂ߂荞݂ɂȂ܂B<br>
		//! Aݒ肵ƕ悤ȏԂɂȂ܂̂ŒӂĂB
		virtual void SetMargin( Float32 margin ) = 0;
	};

}}
