#pragma once

//! @file Mix/Scene/ISimpleParticleSystem.h
//! @brief Vvp[eBNVXeC^[tF[XCN[ht@C

#include "Mix/Scene/IParticleSystem.h"

namespace Mix{ namespace Scene{

	//! @class ISimpleParticleSystem
	//! @brief Vvp[eBNVXeC^[tF[X
	class ISimpleParticleSystem : public Mix::Scene::IParticleSystem
	{
	protected:
		//! @brief fXgN^
		virtual ~ISimpleParticleSystem( void ) {}

	public:
		//! @brief ɃJ̕ǂmF܂
		//! @return ɃJ̕ꍇ True Ԃ܂
		virtual Boolean IsBillboard( void ) const = 0;
		//! @brief ̉]Aړ̉e󂯂邩ǂ擾܂
		//! @return ̉]Aړ̉e󂯂Ȃꍇ True Ԃ܂
		virtual Boolean IsSimulationWorldSpace( void ) const = 0;

		//! @brief EɓĂȂꍇɃX[vԂɂ邩ǂ擾܂
		//! @return EɓĂȂꍇɃX[vԂɂꍇ True Ԃ܂
		virtual Boolean IsInvisibleSleep( void ) const = 0;
		//! @brief EɓĂȂꍇɃX[vԂɂ邩ǂݒ肵܂
		//! @param[in] state EɓĂȂꍇɃX[vԂɂꍇ True
		virtual void SetInvisibleSleep( Boolean state ) = 0;

		//! @brief Ɣfŏ擾܂
		//! @return Ԃ܂
		virtual Float32 GetMinFarDist( void ) const = 0;
		//! @brief Ɣfő勗擾܂
		//! @return Ԃ܂
		virtual Float32 GetMaxFarDist( void ) const = 0;
		//! @brief ǂ𔻒f鋗ݒ肵܂
		//! @param[in] minDist Ɣfŏ( minDist < maxDist )
		//! @param[in] maxDist Ɣfő勗( minDist < maxDist )
		virtual void SetFarDist( Float32 minDist, Float32 maxDist ) = 0;

		//! @brief ƔfꂽۂɃt[XLbv邩ǂ擾܂
		//! @return t[XLbvꍇ True Ԃ܂
		virtual Boolean IsFarSkipFrames( void ) const = 0;
		//! @brief ƔfꂽۂɃt[XLbv邩ǂݒ肵܂
		//! @param[in] state t[XLbvꍇ True
		virtual void SetFarSkipFrames( Boolean state ) = 0;
		//! @brief ƔfꂽۂɃXLbvt[̍ő吔擾܂
		//! @return XLbvt[̍ő吔Ԃ܂
		virtual UInt32 GetMaxFarSkipFrames( void ) const = 0;
		//! @brief ƔfꂽۂɃXLbvt[̍ő吔ݒ肵܂
		//! @param[in] value XLbvt[̍ő吔
		virtual void SetMaxFarSkipFrames( UInt32 value ) = 0;

		//! @brief ŏԊu擾܂
		//! @return ԊuԂ܂
		virtual Float32 GetMinEmitInterval( void ) const = 0;
		//! @brief ő唭Ԋu擾܂
		//! @return ԊuԂ܂
		virtual Float32 GetMaxEmitInterval( void ) const = 0;
		//! @brief Ԋuݒ肵܂
		//! @param[in] minEI ŏԊu( 0.0f ȏ - bP )
		//! @param[in] maxEI őԊu( minEI ȏ - bP )
		virtual void SetEmitInterval( Float32 minEI, Float32 maxEI ) = 0;

		//! @brief ŏ擾܂
		//! @return Ԃ܂
		virtual UInt32 GetMinEmitCount( void ) const = 0;
		//! @brief ő唭擾܂
		//! @return Ԃ܂
		virtual UInt32 GetMaxEmitCount( void ) const = 0;
		//! @brief ݒ肵܂
		//! @param[in] minEC ŏ( 0 ȏ )
		//! @param[in] maxEC ő唭( ecMin ȏ )
		virtual void SetEmitCount( UInt32 minEC, UInt32 maxEC ) = 0;

		//! @brief a擾܂
		//! @return a\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetEmitRadius( void ) const = 0;
		//! @brief aݒ肵܂
		//! @param[in] radius a
		virtual void SetEmitRadius( const Mix::Vector3& radius ) = 0;

		//! @brief ͈͂̒S̃ItZbg擾܂
		//! @return ItZbgԂ܂
		virtual Float32 GetEmitOffset( void ) const = 0;
		//! @brief ͈͂̒S̃ItZbgݒ肵܂
		//! @param[in] offset ItZbg( 0.0f ` 1.0f )
		virtual void SetEmitOffset( Float32 offset ) = 0;

		//! @brief ŏCt擾܂
		//! @return CtԂ܂
		virtual Float32 GetMinLife( void ) const = 0;
		//! @brief ő僉Ct擾܂
		//! @return CtԂ܂
		virtual Float32 GetMaxLife( void ) const = 0;
		//! @brief Ctݒ肵܂
		//! @param[in] minLife ŏCt( 0.0fȏ - bP )
		//! @param[in] maxLife ő僉Ct( 0.0fȏ - bP )
		virtual void SetLife( Float32 minLife, Float32 maxLife ) = 0;

		//! @brief ŏʂ擾܂
		//! @return ʂԂ܂
		virtual Float32 GetMinMass( void ) const = 0;
		//! @brief ő县ʂ擾܂
		//! @return ʂԂ܂
		virtual Float32 GetMaxMass( void ) const = 0;
		//! @brief ʂݒ肵܂
		//! @param[in] minMass ŏ( 0.0fȏ )
		//! @param[in] maxMass ő县( 0.0fȏ )
		virtual void SetMass( Float32 minMass, Float32 maxMass ) = 0;

		//! @brief d͂擾܂
		//! @return d͂\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetGravity( void ) const = 0;
		//! @brief d͂ݒ肵܂
		//! @param[in] gravity d͂\ Mix::Vector3 NX
		virtual void SetGravity( const Mix::Vector3& gravity ) = 0;

		//! @brief ̈ړx擾܂
		//! @return ړx\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetConstantLinearVelocity( void ) const = 0;
		//! @brief ̈ړxݒ肵܂
		//! @param[in] vel ړx\ Mix::Vector3 NX
		virtual void SetConstantLinearVelocity( const Mix::Vector3& vel ) = 0;

		//! @brief ړ̍ŏ͂擾܂
		//! @return ͂\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetMinLinearImpulse( void ) const = 0;
		//! @brief ړ̍ő匂͂擾܂
		//! @return ͂\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetMaxLinearImpulse( void ) const = 0;
		//! @brief ړ̌͂ݒ肵܂
		//! @param[in] minImpulse ŏ͂\ Mix::Vector3 NX
		//! @param[in] maxImpulse ő匂͂\ Mix::Vector3 NX
		//! @note ړ̏ɉe܂
		virtual void SetLinearImpulse( const Mix::Vector3& minImpulse, const Mix::Vector3& maxImpulse ) = 0;

		//! @brief ړ̍ŏx擾܂
		//! @return x\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetMinLinearAcceleration( void ) const = 0;
		//! @brief ړ̍őx擾܂
		//! @return x\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetMaxLinearAcceleration( void ) const = 0;
		//! @brief ړ̉xݒ肵܂
		//! @param[in] minAcc ŏx\ Mix::Vector3 NX
		//! @param[in] maxAcc őx\ Mix::Vector3 NX
		virtual void SetLinearAcceleration( const Mix::Vector3& minAcc, const Mix::Vector3& maxAcc ) = 0;

		//! @brief ړ̍ŏl擾܂
		//! @return lԂ܂
		virtual Float32 GetMinLinearVelocityDamping( void ) const = 0;
		//! @brief ړ̍ő匸l擾܂
		//! @return lԂ܂
		virtual Float32 GetMaxLinearVelocityDamping( void ) const = 0;
		//! @brief ړ̌lݒ肵܂
		//! @param[in] minDamping ŏl( 0.0f ȏ )
		//! @param[in] maxDamping ő匸l( minDamping ȏ )
		virtual void SetLinearVelocityDamping( Float32 minDamping, Float32 maxDamping ) = 0;

		//! @brief ]̍ŏl擾܂
		//! @return lԂ܂
		virtual Float32 GetMinAngularVelocityDamping( void ) const = 0;
		//! @brief ]̍ő匸l擾܂
		//! @return lԂ܂
		virtual Float32 GetMaxAngularVelocityDamping( void ) const = 0;
		//! @brief ]̌lݒ肵܂
		//! @param[in] minDamping ŏl
		//! @param[in] maxDamping ő匸l
		virtual void SetAngularVelocityDamping( Float32 minDamping, Float32 maxDamping ) = 0;

		//! @brief ŏ̃TCY擾܂
		//! @return TCY\ Mix::Vector2 NXԂ܂
		virtual const Mix::Vector2& GetInitalSize( void ) const = 0;
		//! @brief Ō̃TCY擾܂
		//! @return TCY\ Mix::Vector2 NXԂ܂
		virtual const Mix::Vector2& GetLastSize( void ) const = 0;
		//! @brief TCY̍ŏXP[擾܂
		//! @return XP[Ԃ܂
		virtual Float32 GetMinSizeRand( void ) const = 0;
		//! @brief TCY̍őXP[擾܂
		//! @return XP[Ԃ܂
		virtual Float32 GetMaxSizeRand( void ) const = 0;
		//! @brief TCYݒ肵܂
		//! @param[in] initalSize ŏ̃TCY\ Mix::Vector2 NX
		//! @param[in] lastSize Ō̃TCY\ Mix::Vector2 NX
		//! @param[in] minSizeRnd ŏXP[
		//! @param[in] maxSizeRnd őXP[
		virtual void SetSize( const Mix::Vector2& initalSize, const Mix::Vector2& lastSize, Float32 minSizeRnd, Float32 maxSizeRnd ) = 0;

		//! @brief ŏ̐F擾܂
		//! @return F\ Mix::Vector4 NXԂ܂
		virtual const Mix::Vector4& GetInitalColor( void ) const = 0;
		//! @brief Ԃ̐F擾܂
		//! @return F\ Mix::Vector4 NXԂ܂
		virtual const Mix::Vector4& GetMiddleColor( void ) const = 0;
		//! @brief Ō̐F擾܂
		//! @return F\ Mix::Vector4 NXԂ܂
		virtual const Mix::Vector4& GetLastColor( void ) const = 0;
		//! @brief Fݒ肵܂
		//! @param[in] initalColor ŏ̐F\ Mix::Vector4 NX
		//! @param[in] middleColor Ԃ̐F\ Mix::Vector4 NX
		//! @param[in] lastColor Ō̐F\ Mix::Vector4 NX
		virtual void SetColor( const Mix::Vector4& initalColor, const Mix::Vector4& middleColor, const Mix::Vector4& lastColor ) = 0;

		//! @brief F̐|CgP擾܂
		//! @return |CgԂ܂
		virtual Float32 GetColorControlPoint1( void ) const = 0;
		//! @brief F̐|CgQ擾܂
		//! @return |CgԂ܂
		virtual Float32 GetColorControlPoint2( void ) const = 0;
		//! @brief F̐|Cgݒ肵܂
		//! @param[in] p1 |CgP( 0.0f ȏ )
		//! @param[in] p2 |CgQ( p1 ȏ )
		//! @note ԐFɉe܂B
		virtual void SetColorControlPoints( Float32 p1, Float32 p2 ) = 0;

		//! @brief \teNX`̍̂tuW擾܂
		//! @return tuW\ Mix::Vector2 NXԂ܂
		virtual const Mix::Vector2& GetTexTL( void ) const = 0;
		//! @brief \teNX`̉ÊtuW擾܂
		//! @return tuW\ Mix::Vector2 NXԂ܂
		virtual const Mix::Vector2& GetTexBR( void ) const = 0;
		//! @brief \teNX`̂tuWݒ肵܂
		//! @param[in] tl ̂tuW\ Mix::Vector2 NX
		//! @param[in] br ̂tuW\ Mix::Vector2 NX
		virtual void SetTexCoords( const Mix::Vector2& tl, const Mix::Vector2& br ) = 0;
	};

}}
