#pragma once

//! @file Mix/Scene/ISimpleCollider.h"
//! @brief VvRC_[C^[tF[XCN[ht@C

#include "Mix/Scene/ICollider.h"

namespace Mix{ namespace Scene{

	//! @class ISimpleCollider
	//! @brief VvRC_[C^[tF[X
	class ISimpleCollider : public Mix::Scene::ICollider
	{
	protected:
		//! @brief fXgN^
		virtual ~ISimpleCollider( void ) {}

	public:
		//! @brief tB^[O[v擾܂
		//! @return tB^[O[vԂ܂
		virtual UInt16 GetFilterGroup( void ) const = 0;
		//! @brief tB^[O[vݒ肵܂
		//! @param[in] filterGroup tB^[O[v
		//! @note
		//! l͂̃RC_[ĂIuWFNgɂĈقȂ܂B<br>
		//! <pre>
		//! Mix::Scene::IFloor : Mix::Dynamics::OF_STATIC</pre>
		virtual void SetFilterGroup( UInt16 filterGroup ) = 0;

		//! @brief tB^[}XN擾܂
		//! @return tB^[}XNԂ܂
		virtual UInt16 GetFilterMask( void ) const = 0;
		//! @brief tB^[}XNݒ肵܂
		//! @param[in] filterMask tB^[}XN
		//! @note
		//! l͂̃RC_[ĂIuWFNgɂĈقȂ܂B<br>
		//! <pre>
		//! Mix::Scene::IFloor : Mix::Dynamics::OF_DEFAULT |
		//!                        Mix::Dynamics::OF_KINEMATIC |
		//!                        Mix::Dynamics::OF_DEBRIS |
		//!                        Mix::Dynamics::OF_SENSOR |
		//!                        Mix::Dynamics::OF_CHARACTER</pre>
		virtual void SetFilterMask( UInt16 filterMask ) = 0;

		//! @brief }eA擾܂
		//! @return }eA\ Mix::Dynamics::MATERIAL \̂Ԃ܂
		virtual const Mix::Dynamics::MATERIAL& GetMaterial( void ) const = 0;
		//! @brief }eAݒ肵܂
		//! @param[in] material ݒ肷}eA\ Mix::Dynamics::MATERIAL \
		virtual void SetMaterial( const Mix::Dynamics::MATERIAL& material ) = 0;
	};

}}
