#pragma once

//! @file Mix/Scene/ISensor.h"
//! @brief ZT[C^[tF[XCN[ht@C

#include "Mix/Scene/IDynamicsObject.h"

namespace Mix{ namespace Scene{

	//! @class ISensor
	//! @brief ZT[C^[tF[X
	class ISensor : public Mix::Scene::IDynamicsObject
	{
	protected:
		//! @brief fXgN^
		virtual ~ISensor( void ) {}

	public:
		//! @brief tB^[O[v擾܂
		//! @return tB^[O[vԂ܂
		virtual UInt16 GetFilterGroup( void ) const = 0;
		//! @brief tB^[O[vݒ肵܂
		//! @param[in] filterGroup tB^[O[v
		//! @note l ( Mix::Dynamics::OF_SENSOR ) ɂȂ܂
		virtual void SetFilterGroup( UInt16 filterGroup ) = 0;

		//! @brief tB^[}XN擾܂
		//! @return tB^[}XNԂ܂
		virtual UInt16 GetFilterMask( void ) const = 0;
		//! @brief tB^[}XNݒ肵܂
		//! @param[in] filterMask tB^[}XN
		//! @note l ( Mix::Dynamics::OF_DEFAULT | Mix::Dynamics::OF_STATIC | Mix::Dynamics::OF_KINEMATIC ) ɂȂ܂
		virtual void SetFilterMask( UInt16 filterMask ) = 0;

		//! @brief }eA擾܂
		//! @return }eA\ Mix::Dynamics::MATERIAL \̂Ԃ܂
		virtual const Mix::Dynamics::MATERIAL& GetMaterial( void ) const = 0;
		//! @brief }eAݒ肵܂
		//! @param[in] material ݒ肷}eA\ Mix::Dynamics::MATERIAL \
		virtual void SetMaterial( const Mix::Dynamics::MATERIAL& material ) = 0;
	};

}}
