#pragma once

//! @file Mix/Scene/IRenderer.h
//! @brief _[C^[tF[XCN[ht@C

#include "Mix/Reference.h"
#include "Mix/Geometry/AABB.h"
#include "Mix/Scene/ISkyDome.h"
#include "Mix/Scene/IPlanter.h"

namespace Mix{ namespace Scene{

	//! @class IRenderer
	//! @brief _[C^[tF[X
	class IRenderer : public Mix::Reference
	{
	public:
		//! @enum TYPE
		//! @brief ^Cv񋓒萔
		enum TYPE
		{
			//! @brief tH[h
			//! @note
			//! fBNViCgɂ铮IVhE}bsOB<br>
			//! P}eAɑ΂čvS̃X|bgCgA|CgCgKpł܂B
			FORWARD	= 0,
		};

		//! @struct FOG_SETTINGS
		//! @brief tHOp[^\
		struct FOG_SETTINGS
		{
			Float32 start;			//!< tHOJn鋗
			Float32 end;			//!< tHOI鋗( ʂő )
			Mix::Vector4 color;		//!< F
		};

		//! @enum WIDGET_LIGHTING_MODE
		//! @brief EBWFbg : CeBO[h񋓒萔
		enum WIDGET_LIGHTING_MODE
		{
			//! @brief O[oCeBÔ
			WL_DEFAULT	= 0,
			//! @brief O[oCeBO and SẴEBWFbgЂƂ܂Ƃ߂ɂ[JCeBO
			//! @note CeBOɎgp郍[JCg͂SɌ肳܂B
			WL_EVERYONE	= 1,
			//! @brief O[oCeBO and EBWFbgPʂł̃[JCeBO
			WL_DETAILED	= 3,
		};

	protected:
		//! @brief fXgN^
		virtual ~IRenderer( void ) {}

	public:
		//! @name S
		//! @{

		//! @brief ^Cv擾܂
		//! @return ^Cv\ Mix::Scene::IRenderer::TYPE 񋓒萔Ԃ܂
		virtual Mix::Scene::IRenderer::TYPE GetType( void ) const = 0;

		//! @brief _[̖O擾܂
		//! @return _[̖OԂ܂
		virtual const wchar_t* GetName( void ) const = 0;

		//! @brief _[̃RtBO擾܂
		//! @return _[̃RtBO\ Mix::Scene::RENDERER_CONFIG \̂Ԃ܂
		virtual const Mix::Scene::RENDERER_CONFIG& GetConfig( void ) const = 0;
		//! @brief _[̃RtBOݒ肵܂
		//! @param[in] cfg _[̃RtBO\ Mix::Scene::RENDERER_CONFIG \
		virtual Boolean SetConfig( const Mix::Scene::RENDERER_CONFIG& cfg ) = 0;

		//! @brief _Ci~NXgp邱Ƃł邩ǂmF܂
		//! @return gpłꍇ True Ԃ܂
		virtual Boolean IsDynamicsAvailable( void ) const = 0;
		//! @brief EBWFbggp邱Ƃł邩ǂmF܂
		//! @return gpłꍇ True Ԃ܂
		//! @note EBWFbgƂ́Av^[Ap[eBN̂Ƃ\܂B
		virtual Boolean IsWidgetAvailable( void ) const = 0;
		//! @brief tHOgp邱Ƃł邩ǂmF܂
		//! @return gpłꍇ True Ԃ܂
		virtual Boolean IsFogAvailable( void ) const = 0;
		//! @brief CV~[Vgp邱Ƃł邩ǂmF܂
		//! @return gpłꍇ True Ԃ܂
		virtual Boolean IsAtmosphereAvailable( void ) const = 0;
		//! @brief ArGgIN[Wgp邱Ƃł邩ǂmF܂
		//! @return gpłꍇ True Ԃ܂
		virtual Boolean IsAmbientOcclusionAvailable( void ) const = 0;
		//! @brief VhE}bsOgp邱Ƃł邩ǂmF܂
		//! @return gpłꍇ True Ԃ܂
		//! @note fBNViCg쐬ĂȂA܂͖ɂȂĂꍇ False Ԃ܂B
		virtual Boolean IsShadowMappingAvailable( void ) const = 0;
		//! @brief ~mVeBgp邱Ƃł邩ǂmF܂
		//! @return gpłꍇ True Ԃ܂
		virtual Boolean IsLuminosityAvailable( void ) const = 0;
		//! @brief u[gp邱Ƃł邩ǂmF܂
		//! @return gpłꍇ True Ԃ܂
		virtual Boolean IsBloomAvailable( void ) const = 0;
		//! @brief CgVtggp邱Ƃł邩ǂmF܂
		//! @return gpłꍇ True Ԃ܂
		virtual Boolean IsLightShaftsAvailable( void ) const = 0;
		//! @brief YtAgp邱Ƃł邩ǂmF܂
		//! @return gpłꍇ True Ԃ܂
		virtual Boolean IsLensFlareAvailable( void ) const = 0;
		//! @brief Fgp邱Ƃł邩ǂmF܂
		//! @return gpłꍇ True Ԃ܂
		virtual Boolean IsChromatismAvailable( void ) const = 0;
		//! @brief ʊE[xgp邱Ƃł邩ǂmF܂
		//! @return gpłꍇ True Ԃ܂
		virtual Boolean IsDofAvailable( void ) const = 0;

		//! @brief XVs܂
		//! @param[in] dt 1t[̏v(bP)
		//! @param[in] baseDt 1t[̌Œ̏v(bP)
		//! @note
		//! ݂̃_[̐ݒɊÂāAp[^߂Ă܂B<br>
		//! ܂A_Ci~NX[h쐬Ăꍇ́Ã^C~O Mix::Dynamics::IWorld::Update ɂV~[Vs܂B<br>
		//! <br>
		//! p[eBNAfȂǂ̍XV( Update )͍sĂ܂
		virtual void Update( Float32 dt, Float32 baseDt = 1.0f / 60.0f ) = 0;
		//! @brief tbVs܂
		//! @note [JCgAp[eBNAfȂǂ̃tbV( Refresh )͍sĂ܂
		virtual void Refresh( void ) = 0;

		//! @brief `̍œKɎgp锪؂̋E擾܂
		//! @return E\ Mix::Geometry::AABB NXԂ܂
		virtual const Mix::Geometry::AABB& GetOctreeBounds( void ) const = 0;

		//! @}

		//! @name 
		//! @{

		//! @brief O[oArGgJ[擾܂
		//! @return J[\ Mix::Vector4 NXԂ܂
		virtual const Mix::Vector4& GetGlobalAmbientColor( void ) const = 0;
		//! @brief O[oArGgJ[ݒ肵܂
		//! @param[in] color J[\ Mix::Vector4 NX
		//! @note
		//! ̂ɂĂłÂ̐F\܂B<br>
		//! ܂FƂĐݒ肷xNg̊evf͈ȉ̂悤ɂȂ܂B<br>
		//! <br>
		//! xyz=F( 0.0f`1.0f )<br>
		//! w=ZW( 0.0f`1.0f )
		virtual void SetGlobalAmbientColor( const Mix::Vector4& color ) = 0;

		//! @brief eNX`݂Ă邩ǂmF܂
		//! @return ݂Ăꍇ True Ԃ܂B
		virtual Boolean ExistsEnvironmentTexture( void ) const = 0;
		//! @brief eNX`擾܂B
		//! @param[out] ppTex 擾eNX`\ Mix::Graphics::ITexture C^[tF[X̃|C^̃AhX
		//! @return 擾ɐꍇ True Ԃ܂B
		virtual Boolean GetEnvironmentTexture( Mix::Graphics::ITexture** ppTex ) = 0;
		//! @brief eNX`ݒ肵܂B
		//! @param[in] pTex ݒ肷eNX`\ Mix::Graphics::ITexture C^[tF[X̃|C^
		//! @note }eA̔˂ƂĎgpAL[ueNX`ɂȂ܂B<br>
		virtual void SetEnvironmentTexture( Mix::Graphics::ITexture* pTex ) = 0;

		//! @brief tHOLǂmF܂
		//! @return Lȏꍇ True Ԃ܂
		virtual Boolean IsFogEnabled( void ) const = 0;
		//! @brief tHOLɂ邩ǂݒ肵܂
		//! @param[in] state Lɂꍇ True
		virtual void SetFogEnabled( Boolean state ) = 0;
		//! @brief tHÕp[^擾܂
		//! @return p[^\ Mix::Scene::IRenderer::FOG_SETTINGS \̂Ԃ܂
		virtual const Mix::Scene::IRenderer::FOG_SETTINGS& GetFogSettings( void ) const = 0;
		//! @brief tHÕp[^ݒ肵܂
		//! @param[in] param p[^\ Mix::Scene::IRenderer::FOG_SETTINGS \
		virtual void SetFogSettings( const Mix::Scene::IRenderer::FOG_SETTINGS& param ) = 0;

		//! @brief CXLb^[擾܂
		//! @param[out] ppAtmospherePreference 擾CXLb^[n Mix::Scene::IAtmosphereScatter C^[tF[X̃|C^̃AhX
		virtual void GetAtmosphereScatter( Mix::Scene::IAtmosphereScatter** ppAtmospherePreference ) = 0;

		//! @brief _Ci~NX[h擾܂
		//! @param[out] ppDynamicsWorld 擾_Ci~NXvpeBn Mix::Scene::IDynamicsWorld C^[tF[X̃|C^̃AhX
		virtual void GetDynamicsWorld( Mix::Scene::IDynamicsWorld** ppDynamicsWorld ) = 0;

		//! @}

		//! @name J
		//! @{

		//! @brief J̐擾܂
		//! @return J̐Ԃ܂
		virtual UInt32 GetCameraCount( void ) const = 0;
		//! @brief J擾܂
		//! @param[in] index 擾J̃CfbNX
		//! @param[out] ppCamera 擾Jn Mix::Scene::ICamera C^[tF[X̃|C^̃AhX
		//! @note 擾J͎QƃJE^ +1 ܂
		virtual void GetCameraByIndex( UInt32 index, Mix::Scene::ICamera** ppCamera ) = 0;
		//! @brief J݂Ă邩ǂ擾܂
		//! @param[in] pCamera ݊mFJ\ Mix::Scene::ICamera C^[tF[X̃|C^
		//! @return ݂Ăꍇ True Ԃ܂
		virtual Boolean ContainsCamera( Mix::Scene::ICamera* pCamera ) const = 0;
		//! @brief Jǉ܂
		//! @param[in] pCamera ǉJ\ Mix::Scene::IUniversalCamera C^[tF[X̃|C^
		//! @return ꍇ True Ԃ܂
		//! @note ǉJ͎QƃJE^ +1 ܂B
		virtual Boolean AddCamera( Mix::Scene::ICamera* pCamera ) = 0;
		//! @brief J폜܂
		//! @param[in] pCamera 폜J\ Mix::Scene::ICamera C^[tF[X̃|C^
		//! @return ꍇ True Ԃ܂
		//! @note 폜J͎QƃJE^ -1 ܂
		virtual Boolean RemoveCamera( Mix::Scene::ICamera* pCamera ) = 0;
		//! @brief J폜܂
		//! @param[in] index 폜J̃CfbNX
		//! @note 폜J͎QƃJE^ -1 ܂
		virtual void RemoveCameraByIndex( UInt32 index ) = 0;
		//! @brief SẴJ폜܂
		//! @note 폜J͎QƃJE^ -1 ܂
		virtual void RemoveAllCamera( void ) = 0;

		//! @}

		//! @name Cg
		//! @{

		//! @brief Cgp\ǂ擾܂
		//! @return p\ȏꍇ True Ԃ܂
		virtual Boolean ExistsHemisphereLight( void ) const = 0;
		//! @brief Cg擾܂
		//! @param[out] ppHemisphereLight 擾Cgn Mix::Scene::IHemisphereLight C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note 擾Cg͎QƃJE^ +1 ܂
		virtual Boolean GetHemisphereLight( Mix::Scene::IHemisphereLight** ppHemisphereLight ) = 0;
		//! @brief Cgݒ肵܂
		//! @param[in] pHemisphereLight ݒ肵Cg\ Mix::Scene::IHemisphereLight C^[tF[X̃|C^
		//! @return ꍇ True Ԃ܂
		//! @note O̔Cg͎QƃJE^ -1 ܂B
		virtual Boolean SetHemisphereLight( Mix::Scene::IHemisphereLight* pHemisphereLight ) = 0;

		//! @}

		//! @name fBNViCg
		//! @{

		//! @brief fBNViCg݂Ă邩ǂ擾܂
		//! @return p\ȏꍇ True Ԃ܂
		virtual Boolean ExistsDirectionalLight( void ) const = 0;
		//! @brief fBNViCg擾܂
		//! @param[out] ppDirectionalLight 擾fBNViCgn Mix::Scene::IDirectionalLight C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note 擾fBNViCg͎QƃJE^ +1 ܂
		virtual Boolean GetDirectionalLight( Mix::Scene::IDirectionalLight** ppDirectionalLight ) = 0;
		//! @brief fBNViCgݒ肵܂
		//! @param[in] pDirectionalLight ݒ肷fBNViCg\ Mix::Scene::IDirectionalLight C^[tF[X̃|C^
		//! @return ꍇ True Ԃ܂
		//! @note ÕfBNViCg͎QƃJE^ -1 ܂B
		virtual Boolean SetDirectionalLight( Mix::Scene::IDirectionalLight* pDirectionalLight ) = 0;

		//! @}

		//! @name X|bgCg
		//! @{

		//! @brief X|bgCg̐擾܂
		//! @return X|bgCg̐Ԃ܂
		virtual UInt32 GetSpotLightCount( void ) const = 0;
		//! @brief X|bgCg擾܂
		//! @param[in] index 擾X|bgCg̃CfbNX
		//! @param[out] ppSpotLight 擾X|bgCgn Mix::Scene::ISpotLight C^[tF[X̃|C^̃AhX
		virtual void GetSpotLightByIndex( UInt32 index, Mix::Scene::ISpotLight** ppSpotLight ) = 0;
		//! @brief X|bgCg݂邩ǂ擾܂
		//! @param[in] pSpotLight X|bgCg\ Mix::Scene::ISpotLight C^[tF[X̃|C^
		//! @return ݂ꍇ True Ԃ܂
		virtual Boolean ContainsSpotLight( Mix::Scene::ISpotLight* pSpotLight ) const = 0;
		//! @brief X|bgCgǉ܂
		//! @param[in] pSpotLight ǉX|bgCg\ Mix::Scene::ISpotLight C^[tF[X̃|C^
		//! @return X|bgCg̒ǉɐꍇ True Ԃ܂
		//! @note ǉɐX|bgCǵAQƃJE^ +1 ܂
		virtual Boolean AddSpotLight( Mix::Scene::ISpotLight* pSpotLight ) = 0;
		//! @brief X|bgCg폜܂
		//! @param[in] pSpotLight 폜X|bgCg\ Mix::Scene::ISpotLight C^[tF[X̃|C^
		//! @return 폜ɐꍇ True Ԃ܂
		//! @note 폜ɐX|bgCǵAQƃJE^ -1 ܂
		virtual Boolean RemoveSpotLight( Mix::Scene::ISpotLight* pSpotLight ) = 0;
		//! @brief X|bgCg폜܂
		//! @param[in] index 폜X|bgCg̃CfbNX
		virtual void RemoveSpotLightByIndex( UInt32 index ) = 0;
		//! @brief SẴX|bgCg폜܂
		virtual void RemoveAllSpotLight( void ) = 0;

		//! @}

		//! @name |CgCg
		//! @{

		//! @brief |CgCg̐擾܂
		//! @return |CgCg̐Ԃ܂
		virtual UInt32 GetPointLightCount( void ) const = 0;
		//! @brief |CgCg擾܂
		//! @param[in] index 擾|CgCg̃CfbNX
		//! @param[out] ppPointLight 擾|CgCgn Mix::Scene::IPointLight C^[tF[X̃|C^̃AhX
		virtual void GetPointLightByIndex( UInt32 index, Mix::Scene::IPointLight** ppPointLight ) = 0;
		//! @brief |CgCg݂邩ǂ擾܂
		//! @param[in] pPointLight |CgCg\ Mix::Scene::IPointLight C^[tF[X̃|C^
		//! @return ݂ꍇ True Ԃ܂
		virtual Boolean ContainsPointLight( Mix::Scene::IPointLight* pPointLight ) const = 0;
		//! @brief |CgCgǉ܂
		//! @param[in] pPointLight ǉ|CgCg\ Mix::Scene::IPointLight C^[tF[X̃|C^
		//! @return |CgCg̒ǉɐꍇ True Ԃ܂
		//! @note ǉɐ|CgCǵAQƃJE^ +1 ܂
		virtual Boolean AddPointLight( Mix::Scene::IPointLight* pPointLight ) = 0;
		//! @brief |CgCg폜܂
		//! @param[in] pPointLight 폜|CgCg\ Mix::Scene::IPointLight C^[tF[X̃|C^
		//! @return 폜ɐꍇ True Ԃ܂
		//! @note 폜ɐ|CgCǵAQƃJE^ -1 ܂
		virtual Boolean RemovePointLight( Mix::Scene::IPointLight* pPointLight ) = 0;
		//! @brief |CgCg폜܂
		//! @param[in] index 폜|CgCg̃CfbNX
		//! @note 폜ɐ|CgCǵAQƃJE^ -1 ܂
		virtual void RemovePointLightByIndex( UInt32 index ) = 0;
		//! @brief SẴ|CgCg폜܂
		virtual void RemoveAllPointLight( void ) = 0;

		//! @}

		//! @name XJCh[
		//! @{

		//! @brief XJCh[݂Ă邩ǂmF܂
		//! @return ݂Ăꍇ True Ԃ܂
		virtual Boolean ExistsSkyDome( void ) const = 0;
		//! @brief XJCh[擾܂
		//! @param[out] ppSkyDome 擾XJCh[n Mix::Scene::ISkyDome C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean GetSkyDome( Mix::Scene::ISkyDome** ppSkyDome ) = 0;
		//! @brief XJCh[ݒ肵܂B
		//! @param[in] pSkyDome ݒ肷XJCh[\ Mix::Scene::ISkyDome C^[tF[X̃|C^
		//! @return ꍇ True Ԃ܂
		virtual Boolean SetSkyDome( Mix::Scene::ISkyDome* pSkyDome ) = 0;

		//! @}

		//! @name EBWFbg
		//! @{

		//! @brief EBWFbg̃CeBO[h擾܂
		//! @return CeBO[h\ Mix::Scene::IRenderer::WIDGET_LIGHTING_MODE 񋓒萔Ԃ܂
		virtual Mix::Scene::IRenderer::WIDGET_LIGHTING_MODE GetWidgetLightingMode( void ) const = 0;
		//! @brief EBWFbg̃CeBO[hݒ肵܂
		//! @param[in] mode CeBO[h\ Mix::Scene::IRenderer::WIDGET_LIGHTING_MODE 񋓒萔
		virtual void SetWidgetLightingMode( Mix::Scene::IRenderer::WIDGET_LIGHTING_MODE mode ) = 0;

		//! @}

		//! @name [rOp[eBN ( EBWFbg )
		//! @{

		//! @brief [rOp[eBN̐擾܂
		//! @return [rOp[eBN̐Ԃ܂
		virtual UInt32 GetLeavingParticleCount( void ) const = 0;
		//! @brief [rOp[eBN擾܂
		//! @param[in] index 擾郊[rOp[eBÑCfbNX
		//! @param[out] ppParticle 擾[rOp[eBNn Mix::Scene::IParticle C^[tF[X̃|C^̃AhX
		//! @note 擾ɐ[rOp[eBŃAQƃJE^ +1 ܂
		virtual void GetLeavingParticleByIndex( UInt32 index, Mix::Scene::IParticle** ppParticle ) = 0;
		//! @brief w肵[rOp[eBN݂Ă邩ǂ擾܂
		//! @param[in] pParticle [rOp[eBN\ Mix::Scene::IParticle C^[tF[X̃|C^
		//! @return ݂Ăꍇ True Ԃ܂
		virtual Boolean ContainsLeavingParticle( Mix::Scene::IParticle* pParticle ) const = 0;
		//! @brief [rO[rOp[eBNǉ܂
		//! @param[in] pParticle ǉ郊[rO[rOp[eBN\ Mix::Scene::ILeavingParticle C^[tF[X̃|C^
		//! @return ǉɐꍇ True Ԃ܂
		//! @note ǉɐ[rOp[eBŃAQƃJE^ +1 ܂
		virtual Boolean AddLeavingParticle( Mix::Scene::ILeavingParticle* pParticle ) = 0;
		//! @brief [rOp[eBN폜܂
		//! @param[in] pParticle 폜郊[rOp[eBN\ Mix::Scene::IParticle C^[tF[X̃|C^
		//! @return 폜ɐꍇ True Ԃ܂
		//! @note 폜ɐ[rOp[eBŃAQƃJE^ -1 ܂
		virtual Boolean RemoveLeavingParticle( Mix::Scene::IParticle* pParticle ) = 0;
		//! @brief [rOp[eBN폜܂
		//! @param[in] index 폜郊[rOp[eBÑCfbNX
		//! @note 폜ɐ[rOp[eBŃAQƃJE^ -1 ܂
		virtual void RemoveLeavingParticleByIndex( UInt32 index ) = 0;
		//! @brief SẴ[rOp[eBN폜܂
		virtual void RemoveAllLeavingParticle( void ) = 0;

		//! @}

		//! @name XLb^[p[eBN ( EBWFbg )
		//! @{

		//! @brief XLb^[p[eBN̐擾܂
		//! @return XLb^[p[eBN̐Ԃ܂
		virtual UInt32 GetScatterParticleCount( void ) const = 0;
		//! @brief XLb^[p[eBN擾܂
		//! @param[in] index 擾XLb^[p[eBÑCfbNX
		//! @param[out] ppParticle 擾XLb^[p[eBNn Mix::Scene::IParticle C^[tF[X̃|C^̃AhX
		//! @note 擾ɐXLb^[p[eBŃAQƃJE^ +1 ܂
		virtual void GetScatterParticleByIndex( UInt32 index, Mix::Scene::IParticle** ppParticle ) = 0;
		//! @brief w肵XLb^[p[eBN݂Ă邩ǂ擾܂
		//! @param[in] pParticle XLb^[p[eBN\ Mix::Scene::IParticle C^[tF[X̃|C^
		//! @return ݂Ăꍇ True Ԃ܂
		virtual Boolean ContainsScatterParticle( Mix::Scene::IParticle* pParticle ) const = 0;
		//! @brief XLb^[XLb^[p[eBNǉ܂
		//! @param[in] pParticle ǉXLb^[XLb^[p[eBN\ Mix::Scene::IScatterParticle C^[tF[X̃|C^
		//! @return ǉɐꍇ True Ԃ܂
		//! @note ǉɐXLb^[p[eBŃAQƃJE^ +1 ܂
		virtual Boolean AddScatterParticle( Mix::Scene::IScatterParticle* pParticle ) = 0;
		//! @brief XLb^[p[eBN폜܂
		//! @param[in] pParticle 폜XLb^[p[eBN\ Mix::Scene::IParticle C^[tF[X̃|C^
		//! @return 폜ɐꍇ True Ԃ܂
		//! @note 폜ɐXLb^[p[eBŃAQƃJE^ -1 ܂
		virtual Boolean RemoveScatterParticle( Mix::Scene::IParticle* pParticle ) = 0;
		//! @brief XLb^[p[eBN폜܂
		//! @param[in] index 폜XLb^[p[eBÑCfbNX
		//! @note 폜ɐXLb^[p[eBŃAQƃJE^ -1 ܂
		virtual void RemoveScatterParticleByIndex( UInt32 index ) = 0;
		//! @brief SẴXLb^[p[eBN폜܂
		virtual void RemoveAllScatterParticle( void ) = 0;

		//! @}

		//! @name v^[ ( EBWFbg )
		//! @{

		//! @brief v^[̐擾܂
		//! @return v^[̐Ԃ܂
		virtual UInt32 GetPlanterCount( void ) const = 0;
		//! @brief v^[擾܂
		//! @param[in] index 擾v^[̃CfbNX
		//! @param[out] ppPlanter 擾v^[n Mix::Scene::IPlanter C^[tF[X̃|C^̃AhX
		virtual void GetPlanterByIndex( UInt32 index, Mix::Scene::IPlanter** ppPlanter ) = 0;
		//! @brief v^[݂邩ǂ擾܂
		//! @param[in] pPlanter v^[\ Mix::Scene::IPlanter C^[tF[X̃|C^
		//! @return ݂ꍇ True Ԃ܂
		virtual Boolean ContainsPlanter( Mix::Scene::IPlanter* pPlanter ) const = 0;
		//! @brief v^[ǉ܂
		//! @param[in] pPlanter ǉv^[n Mix::Scene::IPlanter C^[tF[X̃|C^
		//! @return v^[̒ǉɐꍇ True Ԃ܂
		virtual Boolean AddPlanter( Mix::Scene::IPlanter* pPlanter ) = 0;
		//! @brief v^[폜܂
		//! @param[in] pPlanter 폜v^[\ Mix::Scene::IPlanter C^[tF[X̃|C^
		//! @return 폜ɐꍇ True Ԃ܂
		//! @note 폜ɐv^[́AQƃJE^ -1 ܂
		virtual Boolean RemovePlanter( Mix::Scene::IPlanter* pPlanter ) = 0;
		//! @brief v^[폜܂
		//! @param[in] index 폜v^[̃CfbNX
		//! @note 폜ɐv^[́AQƃJE^ -1 ܂
		virtual void RemovePlanterByIndex( UInt32 index ) = 0;
		//! @brief SẴv^[폜܂
		virtual void RemoveAllPlanter( void ) = 0;

		//! @}

		//! @name AN^[f
		//! @{

		//! @brief AN^[f̐擾܂
		//! @return AN^[f̐Ԃ܂
		virtual UInt32 GetActorModelCount( void ) const = 0;
		//! @brief AN^[f擾܂
		//! @param[in] index 擾AN^[f̃CfbNX
		//! @param[out] ppActorModel 擾AN^[fn Mix::Scene::IActorModel C^[tF[X̃|C^̃AhX
		//! @note 擾ɐAN^[f́AQƃJE^ +1 ܂
		virtual void GetActorModelByIndex( UInt32 index, Mix::Scene::IActorModel** ppActorModel ) = 0;
		//! @brief w肵AN^[f݂Ă邩ǂ擾܂
		//! @param[in] pActorModel AN^[f\ Mix::Scene::IActorModel C^[tF[X̃|C^
		//! @return ݂Ăꍇ True Ԃ܂
		virtual Boolean ContainsActorModel( Mix::Scene::IActorModel* pActorModel ) const = 0;
		//! @brief AN^[fǉ܂
		//! @param[in] pActorModel ǉAN^[f\ Mix::Scene::IActorModel C^[tF[X̃|C^
		//! @return ꍇ True Ԃ܂
		//! @note ǉɐAN^[f́AQƃJE^ +1 ܂
		virtual Boolean AddActorModel( Mix::Scene::IActorModel* pActorModel ) = 0;
		//! @brief AN^[f폜܂
		//! @param[in] pActorModel 폜AN^[f\ Mix::Scene::IActorModel C^[tF[X̃|C^
		//! @return 폜ɐꍇ True Ԃ܂
		//! @note 폜ɐAN^[f́AQƃJE^ -1 ܂
		virtual Boolean RemoveActorModel( Mix::Scene::IActorModel* pActorModel ) = 0;
		//! @brief AN^[f폜܂
		//! @param[in] index 폜AN^[f̃CfbNX
		//! @note 폜ɐAN^[f́AQƃJE^ -1 ܂
		virtual void RemoveActorModelByIndex( UInt32 index ) = 0;
		//! @brief SẴAN^[f폜܂
		virtual void RemoveAllActorModel( void ) = 0;

		//! @}

		//! @name eCf
		//! @{

		//! @brief n`f̐擾܂
		//! @return n`f̐Ԃ܂
		virtual UInt32 GetTerrainModelCount( void ) const = 0;
		//! @brief n`f擾܂
		//! @param[in] index 擾n`f̃CfbNX
		//! @param[out] ppTerrainModel 擾n`fn Mix::Scene::ITerrainModel C^[tF[X̃|C^̃AhX
		//! @note 擾ɐn`f́AQƃJE^ +1 ܂
		virtual void GetTerrainModelByIndex( UInt32 index, Mix::Scene::ITerrainModel** ppTerrainModel ) = 0;
		//! @brief w肵n`f݂Ă邩ǂ擾܂
		//! @param[in] pTerrainModel n`f\ Mix::Scene::ITerrainModel C^[tF[X̃|C^
		//! @return ݂Ăꍇ True Ԃ܂
		virtual Boolean ContainsTerrainModel( Mix::Scene::ITerrainModel* pTerrainModel ) = 0;
		//! @brief n`fǉ܂
		//! @param[in] pTerrainModel ǉn`f\ Mix::Scene::ITerrainModel C^[tF[X̃|C^
		//! @return ꍇ True Ԃ܂
		//! @note ǉɐn`f́AQƃJE^ +1 ܂
		virtual Boolean AddTerrainModel( Mix::Scene::ITerrainModel* pTerrainModel ) = 0;
		//! @brief n`f폜܂
		//! @param[in] pTerrainModel 폜n`f\ Mix::Scene::ITerrainModel C^[tF[X̃|C^
		//! @return 폜ɐꍇ True Ԃ܂
		//! @note 폜ɐn`f́AQƃJE^ -1 ܂
		virtual Boolean RemoveTerrainModel( Mix::Scene::ITerrainModel* pTerrainModel ) = 0;
		//! @brief n`f폜܂
		//! @param[in] index 폜n`f̃CfbNX
		//! @note 폜ɐn`f́AQƃJE^ -1 ܂
		virtual void RemoveTerrainModelByIndex( UInt32 index ) = 0;
		//! @brief SĂ̒n`f폜܂
		virtual void RemoveAllTerrainModel( void ) = 0;

		//! @}

		//! @name CgVtgLX^[
		//! @{

		//! @brief CgVtgLX^[݂Ă邩ǂmF܂
		//! @return ݂Ăꍇ True Ԃ܂
		virtual Boolean ExistsLightShaftsCaster( void ) const = 0;
		//! @brief CgVtgLX^[擾܂
		//! @param[out] ppLightShaftsCaster 擾CgVtgLX^[n Mix::Scene::ILightShaftsCaster C^tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean GetLightShaftsCaster( Mix::Scene::ILightShaftsCaster** ppLightShaftsCaster ) = 0;
		//! @brief CgVtgLX^[ݒ肵܂
		//! @param[in] pLightShaftsCaster ݒ肷郉CgVtgLX^[\ Mix::Scene::ILightShaftsCaster C^[tF[X̃|C^
		//! @return ꍇ True Ԃ܂
		virtual Boolean SetLightShaftsCaster( Mix::Scene::ILightShaftsCaster* pLightShaftsCaster ) = 0;

		//! @}

		//! @name EH[^[v[
		//! @{

		//! @brief EH[^[v[̐擾܂
		//! @return EH[^[v[̐Ԃ܂
		virtual UInt32 GetWaterPoolCount( void ) const = 0;
		//! @brief EH[^[v[擾܂
		//! @param[in] index 擾EH[^[v[̃CfbNX
		//! @param[out] ppWaterPool 擾EH[^[v[n Mix::Scene::IWaterPool C^[tF[X̃|C^̃AhX
		virtual void GetWaterPoolByIndex( UInt32 index, Mix::Scene::IWaterPool** ppWaterPool ) = 0;
		//! @brief EH[^[v[݂邩ǂ擾܂
		//! @param[in] pWaterPool EH[^[v[\ Mix::Scene::IWaterPool C^[tF[X̃|C^
		//! @return ݂ꍇ True Ԃ܂
		virtual Boolean ContainsWaterPool( Mix::Scene::IWaterPool* pWaterPool ) const = 0;
		//! @brief EH[^[v[ǉ܂
		//! @param[in] pWaterPool ǉEH[^[v[\ Mix::Scene::IWaterPool C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note ǉEH[^[v[́AQƃJE^ +1 ܂B
		virtual Boolean AddWaterPool( Mix::Scene::IWaterPool* pWaterPool ) = 0;
		//! @brief EH[^[v[폜܂
		//! @param[in] pWaterPool 폜EH[^[v[\ Mix::Scene::IWaterPool C^[tF[X̃|C^
		//! @return 폜ɐꍇ True Ԃ܂
		//! @note 폜ɐEH[^[v[́AQƃJE^ -1 ܂
		virtual Boolean RemoveWaterPool( Mix::Scene::IWaterPool* pWaterPool ) = 0;
		//! @brief EH[^[v[폜܂
		//! @param[in] index 폜EH[^[v[̃CfbNX
		//! @note 폜ɐEH[^[v[́AQƃJE^ -1 ܂
		virtual void RemoveWaterPoolByIndex( UInt32 index ) = 0;
		//! @brief SẴEH[^[v[폜܂
		virtual void RemoveAllWaterPool( void ) = 0;

		//! @}

		//! @name tA
		//! @{

		//! @brief tAp\ǂ擾܂
		//! @return p\ȏꍇ True Ԃ܂
		virtual Boolean ExistsFloor( void ) const = 0;
		//! @brief tA擾܂
		//! @param[out] ppFloor 擾tAn Mix::Scene::IFloor C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note 擾ɐꍇ tA̎QƃJE^ +1 ܂
		virtual Boolean GetFloor( Mix::Scene::IFloor** ppFloor ) = 0;
		//! @brief tAݒ肵܂
		//! @param[in] pFloor ݒ肷tA\ Mix::Scene::IFloor C^[tF[X̃|C^
		//! @return ꍇ True Ԃ܂
		//! @note ݒ肵tÁAQƃJE^ +1 ܂B
		virtual Boolean SetFloor( Mix::Scene::IFloor* pFloor ) = 0;

		//! @}

		//! @name S[Xg
		//! @{

		//! @brief S[Xg̐擾܂
		//! @return S[Xg̐A܂
		virtual UInt32 GetGhostCount( void ) const = 0;
		//! @brief S[Xg擾܂
		//! @param[in] index 擾S[Xg̃CfbNX
		//! @param[out] ppGhost 擾S[Xgn Mix::Scene::IGhost C^[tF[X̃|C^̃AhX
		//! @note 擾ɐS[XǵAQƃJE^ +1 ܂
		virtual void GetGhostByIndex( UInt32 index, Mix::Scene::IGhost** ppGhost ) = 0;
		//! @brief w肵S[Xg݂Ă邩ǂ擾܂
		//! @param[in] pGhost S[Xg\ Mix::Scene::IGhost C^[tF[X̃|C^
		//! @return ݂Ăꍇ True Ԃ܂
		virtual Boolean ContainsGhost( Mix::Scene::IGhost* pGhost ) const = 0;
		//! @brief S[Xgǉ܂
		//! @param[in] pGhost ǉS[Xg\ Mix::Scene::IGhost C^[tF[X̃|C^
		//! @return ꍇ True Ԃ܂
		//! @note ǉS[XǵAQƃJE^ +1 ܂B
		virtual Boolean AddGhost( Mix::Scene::IGhost* pGhost ) = 0;
		//! @brief S[Xg폜܂
		//! @param[in] pGhost 폜S[Xg\ Mix::Scene::IGhost C^[tF[X̃|C^
		//! @return 폜ɐꍇ True Ԃ܂
		//! @note 폜ɐS[XǵAQƃJE^ -1 ܂
		virtual Boolean RemoveGhost( Mix::Scene::IGhost* pGhost ) = 0;
		//! @brief S[Xg폜܂
		//! @param[in] index 폜S[Xg̃CfbNX
		//! @note 폜ɐS[XǵAQƃJE^ -1 ܂
		virtual void RemoveGhostByIndex( UInt32 index ) = 0;
		//! @brief SẴS[Xg폜܂
		virtual void RemoveAllGhost( void ) = 0;

		//! @}

		//! @name fobO
		//! @{

		//! @brief vt@C擾܂
		//! @param[in] type ^Cv\ Mix::Scene::DEBUG_PROFILE_TYPE 񋓒萔
		//! @param[out] pProf vt@C̃Rs[̃|C^
		//! @param[in] size vt@C̃Rs[̃TCY
		//! @return Rs[TCYԂ܂
		//! @note
		//! vt@C̃^CvƃRs[ɂȂ\̂̑gݍ킹͈ȉ̂悤ɂȂ܂B<br>
		//! <table>
		//!   <tr>
		//!     <th>^Cv</th>
		//!     <th>\</th>
		//!   </tr>
		//!   <tr>
		//!     <td>DPT_GENERAL</td>
		//!     <td>DEBUG_PROFILE_RENDERER_GENERAL</td>
		//!   </tr>
		//!   <tr>
		//!     <td>DPT_DYNAMICS</td>
		//!     <td>DEBUG_PROFILE_RENDERER_DYNAMICS</td>
		//!   </tr>
		//!   <tr>
		//!     <td>DPT_OCTREE</td>
		//!     <td>DEBUG_PROFILE_RENDERER_OCTREE</td>
		//!   </tr>
		//! </table>
		virtual UInt32 Debug_GetProfile( UInt32 type, void* pProf, UInt32 size ) const = 0;

		//! @brief `p̃p[XyNeBu_[擾܂
		//! @param[out] ppPerspectiveRenderer 擾p[XyNeBu_[n Mix::Graphics::Utility::IPerspectiveRenderer C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean Debug_GetPerspectiveRenderer( Mix::Graphics::Utility::IPerspectiveRenderer** ppPerspectiveRenderer ) = 0;
		//! @brief `p̃p[XyNeBu_[ݒ肵܂
		//! @param[in] pPerspectiveRenderer ݒ肷p[XyNeBu_[n Mix::Graphics::Utility::IPerspectiveRenderer C^[tF[X̃|C^̃AhX
		//! @note
		//! ̃\bhŐݒ肳ꂽp[XyNeBu_[̕` Mix::Scene::ICamera::Draw ōs܂B<br>
		//! O IPerspectiveRenderer::Update IPerspectiveRenderer::Draw ĂяoKv͂܂B
		virtual void Debug_SetPerspectiveRenderer( Mix::Graphics::Utility::IPerspectiveRenderer* pPerspectiveRenderer ) = 0;

		//! @brief `p̃LoX_[擾܂
		//! @param[out] ppCanvasRenderer 擾LoX_[n Mix::Graphics::Utility::ICanvasRenderer C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean Debug_GetCanvasRenderer( Mix::Graphics::Utility::ICanvasRenderer** ppCanvasRenderer ) = 0;
		//! @brief `p̃LoX_[ݒ肵܂
		//! @param[in] pCanvasRenderer LoX_[\ Mix::Graphics::Utility::ICanvasRenderer C^[tF[X̃|C^
		//! ̃\bhŐݒ肳ꂽLoX_[̕` Mix::Scene::ICamera::Draw ōs܂B<br>
		//! Op[XyNeBu_[ ICanvasRenderer::Update ICanvasRenderer::Draw ĂяoKv͂܂B<br>
		//! ܂AsANbv̓X^bN( DrainMatrix DrainClip )ɂāA܂̂ŒӂĂB
		virtual void Debug_SetCanvasRenderer( Mix::Graphics::Utility::ICanvasRenderer* pCanvasRenderer ) = 0;

		//! @}
	};

}}
