#pragma once

//! @file Mix/Scene/IParticle.h
//! @brief p[eBNC^[tF[XCN[ht@C

#include "Mix/Scene/IWidget.h"
#include "Mix/Geometry/AABB.h"

namespace Mix{ namespace Scene{

	//! @class IParticle
	//! @brief p[eBNC^[tF[X
	class IParticle : public Mix::Scene::IWidget
	{
	protected:
		//! @brief fXgN^
		virtual ~IParticle( void ){}

	public:
		//! @brief }eA擾܂
		//! @param[out] ppMaterial 擾}eAn Mix::Scene::IMaterial C^[tF[X̃|C^̃AhX
		virtual void GetMaterial( Mix::Scene::IMaterial** ppMaterial ) = 0;
		//! @brief }eAݒ肵܂
		//! @param[in] pMaterial ݒ肷}eA\ Mix::Scene::IMaterial C^[tF[X̃|C^
		//! @return ꍇ True Ԃ܂
		virtual Boolean SetMaterial( Mix::Scene::IMaterial* pMaterial ) = 0;

		//! @brief XV܂
		//! @param[in] dt f^^C( bP )
		//! @note
		//! XV̍ۂɎw肳ꂽf^^C̕Aj[Vi߂܂B<br>
		//! ܂Ã\bh<b>s</b>邱Ƃł܂B
		virtual void Update( Float32 dt ) = 0;

		//! @brief tbV܂
		//! @note
		//! ̃\bh́As邱Ƃ͂ł܂B<br>
		//! sꍇ Refresh1 Refresh2 gpĂB
		virtual void Refresh( void ) = 0;

		//! @brief 1 ڂ̃tbV܂
		//! @note
		//! ̃\bh Mix::Parallel gpătbV邱ƂOƂč쐬Ă܂B<br>
		//! ܂A1 ڂ̃tbV<b>s</b>ɂȂ܂B
		virtual void Refresh1( void ) = 0;
		//! @brief 2 ڂ̃tbV܂
		//! @note
		//! ̃\bh Mix::Parallel gpătbV邱ƂOƂč쐬Ă܂B<br>
		//! ܂A2 ڂ̃tbV<b>s</b>ɂȂ܂B
		virtual void Refresh2( void ) = 0;

		//! @brief fobO : `悷ۂ̃XP[擾܂
		//! @return XP[Ԃ܂
		virtual Float32 Debug_GetDrawAxisScaling( void ) const = 0;
		//! @brief fobO : `悷ۂ̃XP[ݒ肵܂
		//! @param[in] scaling XP[
		virtual void Debug_SetDrawAxisScaling( Float32 scaling ) = 0;
	};

}}
