#pragma once

//! @file Mix/Scene/IMotionListener.h
//! @brief [VXi[C^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace Scene{

	//! @class IMotionListener
	//! @brief [VXi[C^[tF[X
	class IMotionListener : public Mix::Reference
	{
	public:
		//! @brief fXgN^
		virtual ~IMotionListener( void ) {}

	public:
		//! @brief ĐJnAIۂɌĂяo܂
		//! @param[in] pMotion ĐJnAI[V\ Mix::Scene::IMotion C^[tF[X̃|C^
		//! @param[in] handle ĐJnAI[Ṽnh
		//! @param[in] bActive ĐJnꍇ́ATrue<br>
		//! ĐIꍇ False
		virtual void OnActivate(	const Mix::Scene::IMotion* pMotion,
									const Mix::Scene::MOTION_HANDLE& handle,
									Boolean bActive ) = 0;

		//! @brief [U[w肵͈͂ɓۂɌĂяo܂
		//! @param[in] pMotion ĐJn[V\ Mix::Scene::IMotion C^[tF[X̃|C^
		//! @param[in] handle ͈͂ɓ[Ṽnh
		//! @param[in] desc Gg[\ Mix::Scene::MOTION_ENTRY_DESC \
		//! @param[in] frame ͈͂ɓۂ̃t[
		virtual void OnEntry(	const Mix::Scene::IMotion* pMotion,
								const Mix::Scene::MOTION_HANDLE& handle,
								const Mix::Scene::MOTION_ENTRY_DESC& desc,
								Float32 frame ) = 0;
	};

}}
