#pragma once

//! @file Mix/Scene/IModel.h
//! @brief fC^[tF[XCN[ht@C

#include "Mix/Scene/IEntity.h"

namespace Mix{ namespace Scene{

	//! @class IModel
	//! @brief fC^[tF[X
	class IModel : public Mix::Scene::IEntity
	{
	protected:
		//! @brief fXgN^
		virtual ~IModel( void ){}

	public:
		//! @brief }eAXbg̐擾܂
		//! @return }eAXbg̐Ԃ܂
		virtual UInt32 GetMaterialSlotCount( void ) const = 0;
		//! @brief }eAXbg̖O擾܂
		//! @param[in] slotIndex }eAXbg̃CfbNX
		//! @return }eAXbg̖OԂ܂
		virtual const wchar_t* GetMaterialSlotName( UInt32 slotIndex ) const = 0;
		//! @brief }eAXbg̃CfbNX擾܂
		//! @param[in] pSlotName }eAXbg̖O
		//! @return }eAXbg̃CfbNXԂ܂
		virtual UInt32 GetMaterialSlotIndex( const wchar_t* pSlotName ) = 0;
		//! @brief }eA擾܂
		//! @param[in] slotIndex }eAXbg̃CfbNX
		//! @param[out] ppMaterial 擾}eAn Mix::Scene::IMaterial C^[tF[X̃|C^̃AhX
		//! @return 擾ɐꍇ True Ԃ܂
		//! @note 擾ɐꍇ́A}eA̎QƃJE^ +1 ܂
		virtual Boolean GetMaterialByIndex( UInt32 slotIndex, Mix::Scene::IMaterial** ppMaterial ) = 0;
		//! @brief }eA擾܂
		//! @param[in] pSlotName }eAXbg̖O
		//! @param[out] ppMaterial 擾}eAn Mix::Scene::IMaterial C^[tF[X̃|C^̃AhX
		//! @return 擾ɐꍇ True Ԃ܂
		//! @note 擾ɐꍇ́A}eA̎QƃJE^ +1 ܂
		virtual Boolean GetMaterialByName( const wchar_t* pSlotName, Mix::Scene::IMaterial** ppMaterial ) = 0;
		//! @brief }eAݒ肵܂
		//! @param[in] slotIndex }eAXbg̃CfbNX
		//! @param[in] pMaterial ݒ肷}eA\ Mix::Scene::IMaterial C^[tF[X̃|C^
		//! @return ݒɐꍇ True Ԃ܂
		//! @note ݒɐꍇ́AÕ}eA̎QƃJE^ -1 AVɐݒ肳 +1 ܂
		virtual Boolean SetMaterialByIndex( UInt32 slotIndex, Mix::Scene::IMaterial* pMaterial ) = 0;
		//! @brief }eAݒ肵܂
		//! @param[in] pSlotName }eAXbg̖O
		//! @param[in] pMaterial ݒ肷}eA\ Mix::Scene::IMaterial C^[tF[X̃|C^
		//! @return ݒɐꍇ True Ԃ܂
		//! @note ݒɐꍇ́AÕ}eA̎QƃJE^ -1 AVɐݒ肳 +1 ܂
		virtual Boolean SetMaterialByName( const wchar_t* pSlotName, Mix::Scene::IMaterial* pMaterial ) = 0;

		//! @brief [U[CfbNX擾܂
		//! @return CfbNXԂ܂
		virtual Int32 GetUserIndex( void )  const = 0;
		//! @brief [U[CfbNXݒ肵܂
		//! @param index CfbNX
		//! @note ̒l̓[U[RɎgpł܂
		virtual void SetUserIndex( Int32 index ) = 0;

		//! @brief [U[|C^擾܂
		//! @return |C^Ԃ܂
		virtual void* GetUserPtr( void ) const = 0;
		//! @brief [U[|C^ݒ肵܂
		//! @param pData |C^
		//! @note ̒l̓[U[RɎgpł܂
		virtual void SetUserPtr( void* pData ) = 0;
	};

}}
