#pragma once

//! @file Mix/Scene/ILeavingParticle.h
//! @brief [rOp[eBNC^[tF[XCN[ht@C

#include "Mix/Scene/IParticle.h"
#include "Mix/Geometry/AABB.h"

namespace Mix{ namespace Scene{

	//! @class ILeavingParticle
	//! @brief [rOp[eBNC^[tF[X
	//! @note
	//! u^Cṽp[eBNɂȂ܂B<br>
	//! XɔzuA≌ȂǂɍœKłB
	class ILeavingParticle : public Mix::Scene::IParticle
	{
	public:
		//! @enum CLONE_FLAGS
		//! @brief N[tO񋓒萔
		enum CLONE_FLAGS
		{
			//! @brief }eAL
			C_SHARED_MATERIAL			= 0x00000001,

			//! @brief vZbT[𕡐
			//! @note
			//! vTbZ[𕡐ꍇ́Ã݂p[eBN̔Ԃ̂܂܃Rs[܂B<br>
			//! ܂ÃtOw肵Ȃꍇ́AvZbT[͐VKɍ쐬A( ȂɂĂȂ )ԂɂȂ܂B<br>
			//! <br>
			//! <b> Mix::Scene::ILeavingParticleSystem::CONFIG  behaviorFlags  Mix::Scene::ILeavingParticleSystem::B_INDIVIDUAL ݒ肳Ăꍇ͋@\܂B</b>
			C_DUPLICATE_PROCESSOR		= 0x00000002,

			//!< SẴN[tO
			C_ALL						= ( C_SHARED_MATERIAL | C_DUPLICATE_PROCESSOR ),
		};

		//! @struct STATE
		//! @brief Xe[g\
		struct STATE
		{
			UInt32 quadCount;			//!< Nbh̐
			UInt32 quadCapacity;		//!< Nbh̃LpVeB

			Boolean bSleep;				//!< X[v̏ꍇ True

			Float32 farRatio;			//!< ( 0.0f ` 1.0f )

			Float32 deltaTimer;			//!< XLbvt[̃f^^C̍v

			UInt32 skipFrames;			//!< XLbvt[
			UInt32 curMaxSkipFrames;	//!< ݂̃XLbvőt[
		};

	protected:
		//! @brief fXgN^
		virtual ~ILeavingParticle( void ){}

	public:
		//! @brief [hs擾܂
		//! @return [hs\ Mix::Matrix4x4 NXԂ܂
		virtual const Mix::Matrix4x4& GetWorldMatrix( void ) const = 0;
		//! @brief [hsݒ肵܂
		//! @param[in] worldMat [hs\ Mix::Matrix4x4 NX
		virtual void SetWorldMatrix( const Mix::Matrix4x4& worldMat ) = 0;

		//! @brief ĐĂ邩ǂmF܂
		//! @return ĐĂꍇ True Ԃ܂
		virtual Boolean IsPlay( void ) const = 0;
		//! @brief Đ܂
		//! @param[in] bLoop pčĐꍇ True
		virtual void Play( Boolean bLoop ) = 0;
		//! @brief Đ܂
		//! @param[in] bLoop pčĐꍇ True
		//! @param[in] dt f^^C( bP )
		//! @param[in] stepCount Xebv
		virtual void Play( Boolean bLoop, Float32 dt, UInt32 stepCount ) = 0;
		//! @brief ~܂
		//! @param[in] bForce Iɒ~ꍇ True
		virtual void Stop( Boolean bForce = False ) = 0;

		//! @brief Xe[g擾܂
		//! @return Xe[g\ Mix::Scene::ILeavingParticle::STATE \̂Ԃ܂
		virtual const Mix::Scene::ILeavingParticle::STATE& GetState( void ) const = 0;

		//! @brief E擾܂
		//! @return E\ Mix::Geometry::AABB NXԂ܂
		virtual const Mix::Geometry::AABB& GetBounds( void ) const = 0;

		//! @brief EɓĂ邩ǂmF܂
		//! @return EɓĂꍇ True Ԃ܂
		virtual Boolean IsVisible( void ) const = 0;
		//! @brief EɓĂ邩ǂmF܂
		//! @param[in] id r[̎ʎq
		//! @return EɓĂꍇ True Ԃ܂
		virtual Boolean IsVisible( UInt32 id ) const = 0;
		//! @brief OǂmF܂
		//! @return Ȍꍇ True Ԃ܂
		//! @note OƂ͕`攻Ɏgp锪؂͈̔͂𒴂ĔzuĂԂ̂Ƃ\܂B
		virtual Boolean IsIgnored( void ) const = 0;

		//! @brief g̃N[쐬܂
		//! @param[out] ppParticle g̃N[n Mix::Scene::ILeavingParticle C^[tF[X̃|C^̃AhX
		//! @param[in] flags N[̃tO\ Mix::Scene::IActorModel::CLONE_FLAGS 񋓒萔̑gݍ킹
		//! @return ꍇ True Ԃ܂
		virtual Boolean Clone( Mix::Scene::ILeavingParticle** ppParticle, UInt32 flags = Mix::Scene::ILeavingParticle::C_ALL ) = 0;
	};

}}
