#pragma once

//! @file Mix/Scene/IFlowerPackage.h
//! @brief t[pbP[WC^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace Scene{

	//! @class IFlowerPackage
	//! @brief t[pbP[WC^[tF[X
	class IFlowerPackage : public Mix::Reference
	{
	public:
		//! @enum MODEL_TYPE
		//! @brief f^Cv񋓒萔
		enum MODEL_TYPE
		{
			M_SIMPLE	= 0,	//!< Vv( P̃|S )
			M_CROSS1	= 1,	//!< NXP( Q̃|S̃NX )
			M_CROSS2	= 2,	//!< NXQ( R̃|S̃NX )
		};

		//! @struct MODEL
		//! @brief f\
		struct MODEL
		{
			Mix::Scene::IFlowerPackage::MODEL_TYPE type; //!< ނ\ Mix::Scene::IFlowerPackage::MODEL_TYPE 񋓒萔
			Mix::Vector2 uv[2];	//!< fɓ\teNX`̍( uv[0] )ƉE( uv[1] )UVW
		};

	protected:
		//! @brief fXgN^
		virtual ~IFlowerPackage( void ) {}

	public:
		//! @brief }eA擾܂
		//! @param[out] ppMaterial 擾}eAn Mix::Scene::IMaterial C^[tF[X̃|C^̃AhX
		virtual void GetMaterial( Mix::Scene::IMaterial** ppMaterial ) = 0;
		//! @brief }eAݒ肵܂
		//! @param[in] pMaterial ݒ肷}eA\ Mix::Scene::IMaterial C^[tF[X̃|C^
		//! @return ꍇ True Ԃ܂
		virtual Boolean SetMaterial( Mix::Scene::IMaterial* pMaterial ) = 0;

		//! @brief f̐擾܂
		//! @return f̐Ԃ܂
		virtual UInt32 GetModelCount( void ) const = 0;
		//! @brief w肵CfbNX̃f擾܂
		//! @param[in] index f̃CfbNX
		//! @return f\ Mix::Scene::IFlowerPackage::MODEL \̂Ԃ܂
		virtual const Mix::Scene::IFlowerPackage::MODEL& GetModel( UInt32 index ) const = 0;
		//! @brief w肵CfbNX̃fݒ肵܂
		//! @param[in] index f̃CfbNX
		//! @param[in] model f\ Mix::Scene::IFlowerPackage::MODEL \
		virtual void SetModel( UInt32 index, const Mix::Scene::IFlowerPackage::MODEL& model ) = 0;
	};

}}
