#pragma once

//! @file Mix/Scene/IDirectionalLight.h
//! @brief fBNViCgC^[tF[XCN[ht@C

#include "Mix/Scene/ILight.h"

namespace Mix{ namespace Scene{

	//! @class IDirectionalLight
	//! @brief fBNViCgC^[tF[X
	//! @note
	//! ʒu񂪂Ȃ݂̂̎wCgłB<br>
	//! ܂AVhE}bsO( e ) 邱Ƃł郉Cgł܂B
	class IDirectionalLight : public Mix::Scene::ILight
	{
	public:
		//! @struct PROJECTION
		//! @brief e\
		struct PROJECTION
		{
			Float32 nearClip;			//!< eۂ̎ÕNbv( 0.0f`̖ )
			Float32 castPadding;		//!< e鋫ẼpfBO( 0.0f`̖ )
			Float32 errValue;			//!< eƎ̊px̌덷( 0.0f`1.0f )
		};

	protected:
		//! @brief fXgN^
		virtual ~IDirectionalLight( void ) {}

	public:
		//! @name S
		//! @{

		//! @brief 擾܂
		//! @return \ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetDirection( void ) const = 0;
		//! @brief ݒ肵܂
		//! @param dir \ Mix::Vector3 NX
		virtual void SetDirection( const Mix::Vector3& dir ) = 0;

		//! @brief F擾܂
		//! @return F\ Mix::Vector4 NXԂ܂
		virtual const Mix::Vector4& GetColor( void ) const = 0;
		//! @brief Fݒ肵܂
		//! @param[in] color F\ Mix::Vector4 NX
		virtual void SetColor( const Mix::Vector4& color ) = 0;

		//! @brief e擾܂
		//! @return ݒ\ Mix::Scene::IDirectionalLight::PROJECTION \̂Ԃ܂
		virtual const Mix::Scene::IDirectionalLight::PROJECTION& GetProjection( void ) const = 0;
		//! @brief eݒ肵܂
		//! @note VhE}bsO̊{ݒɂȂ܂B
		virtual void SetProjection( const Mix::Scene::IDirectionalLight::PROJECTION& proj ) = 0;

		//! @}

		//! @name fobO
		//! @{

		//! @brief `悷郉C̒擾܂
		//! @return Ԃ܂
		virtual Float32 Debug_GetDrawLength( void ) const = 0;
		//! @brief `悷郉C̒ݒ肵܂
		//! @param[in] len 
		virtual void Debug_SetDrawLength( Float32 len ) = 0;

		//! @}
	};

}}
