#pragma once

//! @file Mix/Scene/IDefaultMaterial.h
//! @brief ftHg}eAC^[tF[XCN[ht@C

#include "Mix/Scene/IMaterial.h"

namespace Mix{ namespace Scene{

	//! @class IDefaultMaterial
	//! @brief ftHg}eAC^[tF[X
	//! @note
	//! <ul>
	//!   <li>BeginConstant EndConstant ɑ΂ėLȃ\bh</li><br>
	//!   SetAmbientColor<br>
	//!   SetDiffuseColor<br>
	//!   SetDiffuseFresnelIntensity<br>
	//!   SetDiffuseRLHardness<br>
	//!   SetDiffuseRLScale<br>
	//!   SetSpecularColor<br>
	//!   SetSpecularHardness<br>
	//!   SetSpecularScale<br>
	//!   SetSpecularCTFresnel<br>
	//!   SetSpecularCTRoughness<br>
	//!   SetReflectTint<br>
	//!   SetReflectIntensity<br>
	//!   SetReflectBias<br>
	//!   SetReflectExprosure<br>
	//!   SetReflectScale<br>
	//!   SetEmissiveColor<br>
	//!   SetEmissiveScale<br>
	//!   SetBumpHeightScale<br>
	//!   SetBumpSampleCount<br>
	//!   SetBumpReflectFactor<br>
	//!   SetWaveUVOffset<br>
	//!   SetRefractIntensity<br>
	//!   SetSoftParticleThickness<br>
	//! </ul>
	class IDefaultMaterial : public Mix::Scene::IMaterial
	{
	public:
		//! @enum SHADER_TYPE
		//! @brief VF[_[^Cv񋓒萔
		enum SHADER_TYPE
		{
			SHADER_NORMAL		= 0,	//!< ʏ
			SHADER_WATER		= 1,	//!< EH[^[
			SHADER_SHADELESS	= 2,	//!< VF[hX
		};

		//! @enum DIFFUSE_TYPE
		//! @brief fBt[Y^Cv񋓒萔
		enum DIFFUSE_TYPE
		{
			DIFFUSE_LAMBERT			= 0,	//!< o[g
			DIFFUSE_HALF_LAMBERT	= 1,	//!< n[to[g
		};

		//! @enum SPECULAR_TYPE
		//! @brief XyL[^Cv񋓒萔
		enum SPECULAR_TYPE
		{
			SPECULAR_NONE			= 0,	//!< 
			SPECULAR_PHONG			= 1,	//!< tH
			SPECULAR_BLINN_PHONG	= 2,	//!< utH
			SPECULAR_COOKTORRANCE	= 3,	//!< NbNgX
		};

		//! @enum REFLECT_TYPE
		//! @brief ˃^Cv񋓒萔
		enum REFLECT_TYPE
		{
			REFLECT_NONE		= 0,	//!< 
			REFLECT_NORMAL		= 1,	//!< ʏ
			REFLECT_FRESNEL		= 2,	//!< tl
		};

		//! @enum BUMP_TYPE
		//! @brief v^Cv񋓒萔
		enum BUMP_TYPE
		{
			BUMP_NORMAL		= 0,		//!< @}bsO
			BUMP_PARALLAX	= 1,		//!< Ւf}bsO
		};

		//! @enum WAVE_TYPE
		//! @brief EF[u^Cv񋓒萔
		enum WAVE_TYPE
		{
			WAVE_NORMAL		= 0,	//!< ʏ
			WAVE_REFRACT	= 1,	//!< ܌
		};

		//! @enum WAVE_DIR
		//! @brief EF[u񋓒萔
		enum WAVE_DIR
		{
			WAVE_NEGATIVE_U = 0,	//!< eNX`Ԃ̍
			WAVE_POSITIVE_U = 1,	//!< eNX`Ԃ̉E
			WAVE_NEGATIVE_V = 2,	//!< eNX`Ԃ̏
			WAVE_POSITIVE_V = 3,	//!< eNX`Ԃ̉
		};

	protected:
		//! @brief fXgN^
		virtual ~IDefaultMaterial( void ) {}

	public:
		//! @brief O擾܂
		//! @return OԂ܂
		virtual const wchar_t* GetName( void ) const = 0;

		//! @brief VF[_[^Cv擾܂
		//! @return VF[_[^Cv\ Mix::Scene::IDefaultMaterial::SHADER_TYPE 񋓒萔Ԃ܂
		virtual Mix::Scene::IDefaultMaterial::SHADER_TYPE GetShaderType( void ) const = 0;

		//! @brief uh^Cv擾܂
		//! @return uh^Cv\ Mix::Graphics::BLEND_TYPE 񋓒萔Ԃ܂
		virtual Mix::Graphics::BLEND_TYPE GetBlendType( void ) const = 0;
		//! @brief uh^Cvݒ肵܂
		//! @param[in] type uh^Cv\ Mix::Graphics::BLEND_TYPE 񋓒萔
		virtual void SetBlendType( Mix::Graphics::BLEND_TYPE type ) = 0;

		//! @brief JO^Cv擾܂
		//! @return JO^Cv\ Mix::Graphics::CULL_TYPE 񋓒萔Ԃ܂
		virtual Mix::Graphics::CULL_TYPE GetCullingType( void ) const = 0;
		//! @brief JO^Cvݒ肵܂
		//! @param[in] type JO^Cv\ Mix::Graphics::CULL_TYPE 񋓒萔
		virtual void SetCullingType( Mix::Graphics::CULL_TYPE type ) = 0;

		//! @brief [xނǂmF܂
		//! @return [xޏꍇ True Ԃ܂
		virtual Boolean IsZWrite( void ) const = 0;
		//! @brief [xނǂmF܂
		//! @param[in] state [xޏꍇ True
		virtual void SetZWrite( Boolean state ) = 0;

		//! @brief eNX`tB^[擾܂
		//! @return eNX`tB^[\ Mix::Graphics::TEXTURE_FILTER 񋓒萔Ԃ܂
		virtual Mix::Graphics::TEXTURE_FILTER_TYPE GetTextureFilterType( void ) const = 0;
		//! @brief eNX`tB^[ݒ肵܂
		//! @param[in] filter eNX`tB^[\ Mix::Graphics::TEXTURE_FILTER_TYPE 񋓒萔
		virtual void SetTextureFilterType( Mix::Graphics::TEXTURE_FILTER_TYPE filter ) = 0;

		//! @brief eNX`W̉@擾܂
		//! @return Mix::Graphics::TEXTURE_ADDRESS eNX`W̉@\ Mix::Graphics::TEXTURE_ADDRESS 񋓒萔Ԃ܂
		virtual Mix::Graphics::TEXTURE_ADDRESS_TYPE GetTextureAddressType( void ) const = 0;
		//! @brief eNX`W̉@ݒ肵܂
		//! @param[in] address eNX`W̉@\ Mix::Graphics::TEXTURE_ADDRESS_TYPE 񋓒萔
		virtual void SetTextureAddressType( Mix::Graphics::TEXTURE_ADDRESS_TYPE address ) = 0;

		//! @brief ʃCeBOǂmF܂
		//! @return ʃCeBȌꍇ True Ԃ܂
		virtual Boolean IsBothFacesLighting( void ) const = 0;

		//! @brief gɉe𗎂ƂǂmF܂
		//! @return gɉe𗎂Ƃꍇ True
		virtual Boolean IsReceiveShadow( void ) const = 0;
		//! @brief ҂ɉe𗎂ƂǂmF܂
		//! @return ҂ɉe𗎂Ƃꍇ True
		virtual Boolean IsCastShadow( void ) const = 0;

		//! @brief ArGgJ[擾܂
		//! @return ArGgJ[\ Mix::Vector4 NXԂ܂
		virtual const Mix::Vector4& GetAmbientColor( void ) const = 0;
		//! @brief ArGgJ[ݒ肵܂
		//! @param[in] color ArGgJ[( rgb=F )
		virtual void SetAmbientColor( const Mix::Vector4& color ) = 0;

		//! @brief fBt[Y^Cv擾܂
		//! @return fBt[Y^Cv\ Mix::Scene::IDefaultMaterial::DIFFUSE_TYPE 񋓒萔Ԃ܂
		virtual Mix::Scene::IDefaultMaterial::DIFFUSE_TYPE GetDiffuseType( void ) const = 0;
		//! @brief fBt[YJ[擾܂
		//! @return fBt[YJ[\ Mix::Vector4 NXԂ܂
		virtual const Mix::Vector4& GetDiffuseColor( void ) const = 0;
		//! @brief fBt[YJ[ݒ肵܂
		//! @param[in] color fBt[YJ[( rgb=F a=sx )
		virtual void SetDiffuseColor( const Mix::Vector4& color ) = 0;
		//! @brief fBt[YeNX`擾܂
		//! @param[out] ppTexture 擾fBt[YeNX`n Mix::Graphics::ITexture C^[tF[X̃|C^̃AhX
		//! @return 擾ɐꍇ True Ԃ܂
		virtual Boolean GetDiffuseTexture( Mix::Graphics::ITexture** ppTexture ) = 0;
		//! @brief fBt[YeNX`ݒ肵܂
		//! @param[in] pTexture ݒ肷fBt[YeNX`\ Mix::Graphics::ITexture C^[tF[X̃|C^
		//! @return ꍇ True Ԃ܂
		//! @note
		//! ꍇ́AfBt[YeNX`̎QƃJE^ +1 ܂B<br>
		//! sꍇ́AVF[_[fBt[YeNX`ɑΉĂȂƂl܂B
		virtual Boolean SetDiffuseTexture( Mix::Graphics::ITexture* pTexture ) = 0;
		//! @brief fBt[YɃtlʂ邩ǂ擾܂
		//! @return tlʂꍇ True Ԃ܂
		virtual Boolean IsDiffuseFresnel( void ) const = 0;
		//! @brief fBt[Ỹtlʂ̋x擾܂
		//! @return xԂ܂
		virtual Float32 GetDiffuseFresnelIntensity( void ) const = 0;
		//! @brief fBt[Ỹtlʂ̋xݒ肵܂
		//! @param[in] intensity x( 0.0f`1.0f )
		virtual void SetDiffuseFresnelIntensity( Float32 intensity ) = 0;
		//! @brief fBt[ỸCeBOLǂ擾܂
		//! @return CeBOLȏꍇ True Ԃ܂
		virtual Boolean IsDiffuseRL( void ) const = 0;
		//! @brief fBt[ỸCeBỎs擾܂
		//! @return CeBỎsԂ܂
		virtual Float32 GetDiffuseRLHardness( void ) const = 0;
		//! @brief fBt[ỸCeBỎsݒ肵܂
		//! @param[in] hardness s( 0.01fȏ )
		virtual void SetDiffuseRLHardness( Float32 hardness ) = 0;
		//! @brief fBt[ỸCeBÕXP[擾܂
		//! @return CeBÕXP[Ԃ܂
		virtual Float32 GetDiffuseRLScale( void ) const = 0;
		//! @brief fBt[ỸCeBÕXP[ݒ肵܂
		//! @param[in] scale( 0.0fȏ )
		virtual void SetDiffuseRLScale( Float32 scale ) = 0;

		//! @brief XyL[̃^Cv擾܂
		//! @return XyL[̃^Cv\ Mix::Scene::IStandardMaterial::SPECULAR_TYPE 񋓒萔Ԃ܂
		virtual Mix::Scene::IDefaultMaterial::SPECULAR_TYPE GetSpecularType( void ) const = 0;
		//! @brief XyL[J[擾܂
		//! @return XyL[J[\ Mix::Vector4 NXԂ܂
		virtual const Mix::Vector4& GetSpecularColor( void ) const = 0;
		//! @brief XyL[J[ݒ肵܂
		//! @param[in] color XyL[J[\ Mix::Vector4 NX( rgb=F a=1.0f )
		virtual void SetSpecularColor( const Mix::Vector4& color ) = 0;
		//! @brief XyL[eNX`擾܂
		//! @param[out] ppTexture 擾XyL[eNX`n Mix::Graphics::ITexture C^[tF[X̃|C^̃AhX
		//! @return 擾ɐꍇ True Ԃ܂
		virtual Boolean GetSpecularTexture( Mix::Graphics::ITexture** ppTexture ) = 0;
		//! @brief XyL[eNX`ݒ肵܂
		//! @param[in] pTexture ݒ肷XyL[eNX`\ Mix::Graphics::ITexture C^[tF[X̃|C^
		//! @return ꍇ True Ԃ܂
		//! @note
		//! ꍇ́AXyL[eNX`̎QƃJE^ +1 ܂B<br>
		//! sꍇ́AVF[_[XyL[eNX`ɑΉĂȂƂl܂B
		virtual Boolean SetSpecularTexture( Mix::Graphics::ITexture* pTexture ) = 0;
		//! @brief XyL[̉s擾܂
		//! @return sԂ܂
		virtual Float32 GetSpecularHardness( void ) const = 0;
		//! @brief XyL[̉sݒ肵܂
		//! @param[in] hardness s( 0.01fȏ )
		virtual void SetSpecularHardness( Float32 hardness ) = 0;
		//! @brief XyL[̃XP[擾܂
		//! @return XP[Ԃ܂
		virtual Float32 GetSpecularScale( void ) const = 0;
		//! @brief XyL[̃XP[ݒ肵܂
		//! @param[in] scale XP[( 0.0f`1.0f )
		virtual void SetSpecularScale( Float32 scale ) = 0;
		//! @brief XyL[( NbNgX )̔ˋx擾܂
		//! @return ˋxԂ܂
		virtual Float32 GetSpecularCTFresnel( void ) const = 0;
		//! @brief XyL[( NbNgX )̔ˋxݒ肵܂
		//! @param[in] fresnel ˋx( 0.01fȏ )
		virtual void SetSpecularCTFresnel( Float32 fresnel ) = 0;
		//! @brief XyL[( NbNgX )̑eݒ肵܂
		//! @return eԂ܂
		virtual Float32 GetSpecularCTRoughness( void ) const = 0;
		//! @brief XyL[( NbNgX )̑eݒ肵܂
		//! @param[in] roughness e( 0.0f`1.0f )
		virtual void SetSpecularCTRoughness( Float32 roughness ) = 0;

		//! @brief ˃^Cv擾܂
		//! @return ˃^Cv\ Mix::Scene::IStandardMaterial::REFLECT_TYPE 񋓒萔Ԃ܂
		virtual Mix::Scene::IDefaultMaterial::REFLECT_TYPE GetReflectType( void ) const = 0;
		//! @brief ˂̃XP[擾܂
		//! @return XP[Ԃ܂
		virtual Float32 GetReflectScale( void ) const = 0;
		//! @brief ˂̃XP[ݒ肵܂
		//! @param[in] scale XP[( 0.0fȏ )
		virtual void SetReflectScale( Float32 scale ) = 0;
		//! @brief ˂̋擾܂
		//! @return ˂̋Ԃ܂
		virtual Float32 GetReflectIntensity( void ) const = 0;
		//! @brief ˂̋ݒ肵܂
		//! @param[in] intensity ˂̋( 0.0f`1.0f )
		virtual void SetReflectIntensity( Float32 intensity ) = 0;
		//! @brief ˂̃oCAX擾܂
		//! @return ˂̃oCAXԂ܂
		virtual Float32 GetReflectBias( void ) const = 0;
		//! @brief ˂̃oCAXݒ肵܂
		//! @param[in] bias ˂̃oCAX( 0.0f`1.0f )
		virtual void SetReflectBias( Float32 bias ) = 0;
		//! @brief ˂̘I擾܂
		//! @return ˂̘IԂ܂
		virtual Float32 GetReflectExprosure( void ) const = 0;
		//! @brief ˂̘Iݒ肵܂
		//! @param[in] exprosure ˂̘I( 0.0f`1.0f )
		virtual void SetReflectExprosure( Float32 exprosure ) = 0;

		//! @brief G~bVũJ[擾܂
		//! @return J[\ Mix::Vector4 NXԂ܂
		virtual const Mix::Vector4& GetEmissiveColor( void ) const = 0;
		//! @brief G~bVũJ[ݒ肵܂
		//! @param[in] color J[\ Mix::Vector4 NX( rgb=F a=XP[ )
		virtual void SetEmissiveColor( const Mix::Vector4& color ) = 0;
		//! @brief G~bVũXP[擾܂
		//! @return XP[Ԃ܂
		virtual Float32 GetEmissiveScale( void ) const = 0;
		//! @brief G~bVũXP[ݒ肵܂
		//! @param[in] scale XP[
		virtual void SetEmissiveScale( Float32 scale ) = 0;
		//! @brief G~bVueNX`擾܂
		//! @param[out] ppTexture 擾G~bVueNX`n Mix::Graphics::ITexture C^[tF[X̃|C^̃AhX
		//! @return 擾ɐꍇ True Ԃ܂
		virtual Boolean GetEmissiveTexture( Mix::Graphics::ITexture** ppTexture ) = 0;
		//! @brief G~bVueNX`ݒ肵܂
		//! @param[in] pTexture ݒ肷G~bVueNX`\ Mix::Graphics::ITexture C^[tF[X̃|C^
		//! @return ꍇ True Ԃ܂
		//! @note
		//! ꍇ́AG~bVueNX`̎QƃJE^ +1 ܂B<br>
		//! sꍇ́AVF[_[G~bVueNX`ɑΉĂȂƂl܂B
		virtual Boolean SetEmissiveTexture( Mix::Graphics::ITexture* pTexture ) = 0;

		//! @brief ovǂmF܂
		//! @return ovLȏꍇ True Ԃ܂
		virtual Boolean IsBump( void ) const = 0;
		//! @brief ov̎ނ擾܂
		//! @return ov̎ނ\ Mix::Scene::IStandardMaterial::BUMP_TYPE 񋓒萔Ԃ܂
		virtual Mix::Scene::IDefaultMaterial::BUMP_TYPE GetBumpType( void ) const = 0;
		//! @brief oveNX`擾܂
		//! @param[out] ppTexture 擾oveNX`n Mix::Graphics::ITexture C^[tF[X̃|C^̃AhX
		//! @return 擾ɐꍇ True Ԃ܂
		virtual Boolean GetBumpTexture( Mix::Graphics::ITexture** ppTexture ) = 0;
		//! @brief oveNX`ݒ肵܂
		//! @param[in] pTexture ݒ肷oveNX`\ Mix::Graphics::ITexture C^[tF[X̃|C^
		//! @return ꍇ True Ԃ܂
		//! @note
		//! ꍇ́AoveNX`̎QƃJE^ +1 ܂B<br>
		//! sꍇ́AVF[_[oveNX`ɑΉĂȂƂl܂B
		virtual Boolean SetBumpTexture( Mix::Graphics::ITexture* pTexture ) = 0;
		//! @brief oṽwCgXP[擾܂
		//! @return wCgXP[Ԃ܂
		virtual Float32 GetBumpHeightScale( void ) const = 0;
		//! @brief oṽwCgXP[ݒ肵܂
		//! @param[in] scale wCgXP[( 0.0f`1.0f )
		virtual void SetBumpHeightScale( Float32 scale ) = 0;
		//! @brief oṽTv擾܂
		//! @return TvԂ܂
		virtual Int32 GetBumpSampleCount( void ) const = 0;
		//! @brief oṽTvݒ肵܂
		//! @param[in] sampleCount Tv( 1`8 )
		virtual void SetBumpSampleCount( Int32 sampleCount ) = 0;
		//! @brief ov̔˂ւ̉ex擾܂
		//! @return ˂ւ̉exԂ܂
		virtual Float32 GetBumpReflectFactor( void ) const = 0;
		//! @brief ov̔˂ւ̉exݒ肵܂
		//! @param[in] factor ˂ւ̉ex( 0.0f`1.0f )
		virtual void SetBumpReflectFactor( Float32 factor ) = 0;

		//! @brief EF[u邩ǂmF܂
		//! @return EF[uꍇ True Ԃ܂
		virtual Boolean IsWave( void ) const = 0;
		//! @brief EF[ũ^Cv擾܂
		//! @return ^Cv\ Mix::Scene::IDefaultMaterial::WAVE_TYPE 񋓒萔Ԃ܂
		virtual Mix::Scene::IDefaultMaterial::WAVE_TYPE GetWaveType( void ) const = 0;
		//! @brief EF[u̕擾܂
		//! @return \ Mix::Scene::IDefaultMaterial::WAVE_DIR 񋓒萔Ԃ܂
		virtual Mix::Scene::IDefaultMaterial::WAVE_DIR GetWaveDir( void ) const = 0;
		//! @brief EF[u̕ݒ肵܂
		//! @param[in] dir \ Mix::Scene::IDefaultMaterial::WAVE_DIR 񋓒萔
		virtual void SetWaveDir( Mix::Scene::IDefaultMaterial::WAVE_DIR dir ) = 0;
		//! @brief EF[ũyA̕t]Ă邩ǂmF܂
		//! @return t]Ăꍇ True Ԃ܂
		virtual Boolean IsWaveInvert( void ) const = 0;
		//! @brief EF[ȗx(b)擾܂
		//! @return xԂ܂
		virtual Float32 GetWaveVelocity( void ) const = 0;
		//! @brief EF[ȗx(b)ݒ肵܂
		//! @param[in] vel x( 0.0f`1.0f )
		virtual void SetWaveVelocity( Float32 vel ) = 0;
		//! @brief EF[ũyAUVItZbg擾܂
		//! @return UVItZbgԂ܂
		virtual Float32 GetWaveUVOffset( void ) const = 0;
		//! @brief EF[ũyAUVItZbgݒ肵܂
		//! @param[in] uvOffset UVItZbg( 0.0f`1.0f )
		virtual void SetWaveUVOffset( Float32 uvOffset ) = 0;
		//! @brief EF[ũyAƂ̑Αx擾܂
		//! @return Ԃ܂
		virtual Float32 GetWaveGap( void ) const = 0;
		//! @brief EF[ũyAƂ̑Αxݒ肵܂
		//! @param[in] gap ( 0 ȏ )
		virtual void SetWaveGap( Float32 gap ) = 0;
		//! @brief EF[űܗ擾܂
		//! @return ܋xԂ܂
		virtual Float32 GetWaveRefractiveIndex( void ) const = 0;
		//! @brief EF[űܗݒ肵܂
		//! @param[in] index ܗ( 0.0f`1.0f )
		virtual void SetWaveRefractiveIndex( Float32 index ) = 0;

		//! @brief \tgp[eBNǂmF܂
		//! @return \tgp[eBN̏ꍇ True Ԃ܂
		virtual Boolean IsSoftParticle( void ) const = 0;
		//! @brief \tgp[eBŇ݂擾܂
		//! @return \tgp[eBŇ݂Ԃ܂
		virtual Float32 GetSoftParticleThickness( void ) const = 0;
		//! @brief \tgp[eBŇ݂ݒ肵܂
		//! @param[in] tickness \tgp[eBŇ( 0.0fȏ )
		virtual void SetSoftParticleThickness( Float32 tickness ) = 0;
	};

}}
