#pragma once

//! @file Mix/Scene.h
//! @brief V[ CN[ht@C

#include "Mix/Scene/IManager.h"

#include "Mix/Scene/IEffectPackage.h"

#include "Mix/Scene/IMaterial.h"
#include "Mix/Scene/IDefaultMaterial.h"

#include "Mix/Scene/IMotionMixer.h"
#include "Mix/Scene/IMotionController.h"
#include "Mix/Scene/IMotionListener.h"
#include "Mix/Scene/IMotionState.h"
#include "Mix/Scene/IMotion.h"

#include "Mix/Scene/IContactListener.h"

#include "Mix/Scene/IDynamicsObject.h"
#include "Mix/Scene/ICollider.h"
#include "Mix/Scene/ISimpleCollider.h"
#include "Mix/Scene/ILibertyCollider.h"
#include "Mix/Scene/IActorCollider.h"
#include "Mix/Scene/ITerrainCollider.h"
#include "Mix/Scene/ISensor.h"
#include "Mix/Scene/ISimpleSensor.h"
#include "Mix/Scene/IActorSensor.h"
#include "Mix/Scene/IKinematicCharacter.h"
#include "Mix/Scene/ISimpleKinematicCharacter.h"
#include "Mix/Scene/IActorKinematicCharacter.h"

#include "Mix/Scene/IRenderer.h"
#include "Mix/Scene/IRendererObject.h"
#include "Mix/Scene/IEntity.h"

#include "Mix/Scene/ICamera.h"
#include "Mix/Scene/IUniversalCamera.h"
#include "Mix/Scene/IViewCamera.h"

#include "Mix/Scene/IHemisphereLight.h"
#include "Mix/Scene/IDirectionalLight.h"
#include "Mix/Scene/ISpotLight.h"
#include "Mix/Scene/IPointLight.h"
#include "Mix/Scene/ISkyDome.h"
#include "Mix/Scene/ILeavingParticle.h"
#include "Mix/Scene/IScatterParticle.h"
#include "Mix/Scene/IParticleSystem.h"
#include "Mix/Scene/IDefaultParticleSystem.h"
#include "Mix/Scene/IBillboardParticleSystem.h"
#include "Mix/Scene/IParticleGenerator.h"
#include "Mix/Scene/IParticleProcessor.h"
#include "Mix/Scene/IActorModel.h"
#include "Mix/Scene/IActorListener.h"
#include "Mix/Scene/IActorNode.h"
#include "Mix/Scene/IActorConstraint.h"
#include "Mix/Scene/IActorDynamicsDirector.h"
#include "Mix/Scene/ITerrainModel.h"
#include "Mix/Scene/IFlowerPackage.h"
#include "Mix/Scene/IPlanter.h"
#include "Mix/Scene/IWaterPool.h"
#include "Mix/Scene/IFloor.h"
#include "Mix/Scene/IGhost.h"

#include "Mix/Scene/ILightShaftsCaster.h"
#include "Mix/Scene/IAtmosphereScatter.h"
#include "Mix/Scene/IDynamicsWorld.h"
