#pragma once

//! @file Mix/RectangleF.h
//! @brief _^`NXCN[ht@C

namespace Mix{

	class Vector2;
	class Rectangle;

	//! @class RectangleF
	//! @brief _^`NX
	class _MIX_DLL_API RectangleF
	{
	public:
		union
		{
			struct
			{
				Float32 x;		//!< XW
				Float32 y;		//!< YW
				Float32 width;	//!< 
				Float32 height;	//!< 
			};
		};

	public:
		//! @brief RXgN^
		RectangleF( void );
		//! @brief RXgN^
		//! @param[in] rx XW
		//! @param[in] ry YW
		//! @param[in] rw 
		//! @param[in] rh 
		RectangleF( Float32 rx, Float32 ry, Float32 rw, Float32 rh );
		//! @brief Rs[RXgN^
		//! @param[in] rect `
		RectangleF( const Mix::RectangleF& rect );
		//! @brief Rs[RXgN^
		//! @param[in] rect `
		RectangleF( const Mix::Rectangle& rect );

	public:
		//! @brief r
		//! @param[in] rect r`
		//! @return lꍇ True Ԃ܂
		Boolean operator == ( const RectangleF& rect ) const;
		//! @brief r
		//! @param[in] rect r`
		//! @return lȂꍇ True Ԃ܂
		Boolean operator != ( const RectangleF& rect ) const;

		//! @brief ( = )
		//! @param[in] rect 
		//! @return 
		Mix::RectangleF& operator = ( const Mix::RectangleF& rect );
		//! @brief ( = )
		//! @param[in] rect 
		//! @return 
		Mix::RectangleF& operator = ( const Mix::Rectangle& rect );

		//! @brief `ݒ肵܂
		//! @param[in] rx `̍ X W
		//! @param[in] ry `̍ Y W
		//! @param[in] rw `̕
		//! @param[in] rh `̍
		void Set( Float32 rx, Float32 ry, Float32 rw, Float32 rh );

		//! @brief w肵_܂܂Ă邩`FbN܂
		//! @return _܂܂Ăꍇ True Ԃ܂
		Boolean Contains( const Mix::Vector2& p ) const;
		//! @brief w肵`܂܂Ă邩`FbN܂
		//! @param[in] rect `\ Mix::RectangleF NX
		//! @param[out] pOverlapRect dȂĂ`\ Mix::RectangleF NX̃|C^
		//! @return `܂܂Ăꍇ True Ԃ܂
		Boolean Contains( const Mix::RectangleF& rect, Mix::RectangleF* pOverlapRect = NULL ) const;

		//! @brief `̉E[XW擾܂
		//! @return E[XW
		Float32 GetRight( void ) const;
		//! @brief `̉E[XWݒ肵܂
		//! @param[in] right E[XW
		void SetRight( Float32 right );
		//! @brief `̉[YW擾܂
		//! @return [YW
		Float32 GetBottom( void ) const;
		//! @brief `̉[YWݒ肵܂
		//! @param[in] bottom [YW
		void SetBottom( Float32 bottom );

	public:
		//! @brief l( 0.0, 0.0, 0.0, 0.0 )擾܂
		//! @return l\ Mix::RectangleF NXԂ܂
		static const Mix::RectangleF& Zero( void )
		{
			static const Mix::RectangleF zero( 0.0f, 0.0f, 0.0f, 0.0f );

			return zero;
		}
	};

}
