#include "Mix/Private/Sound/StreamingEmitterTask.h"
#include "Mix/Private/Sound/EmitterMediator.h"

namespace Mix{ namespace Sound{

StreamingEmitterTask::StreamingEmitterTask( Mix::Sound::EmitterMediator* pMediator ) : StreamingTask( pMediator ),
m_pMediator( NULL )
{
	MIX_ASSERT( pMediator != NULL );

	MIX_ADD_REF( pMediator );
	m_pMediator = pMediator;
}

StreamingEmitterTask::~StreamingEmitterTask( void )
{
	MIX_RELEASE( m_pMediator );
}

Boolean StreamingEmitterTask::Process( void )
{
	XAUDIO2_VOICE_STATE state;

	m_pVoice->GetState( &state );

	if( state.BuffersQueued > 0 )
	{
		m_pMediator->ApplyDSPSettings( m_pVoice );
	}

	return StreamingTask::Process();
}

}}
