#include "Mix/Private/Sound/StreamingControllerTask.h"
#include "Mix/Private/Sound/StreamingControllerMediator.h"

namespace Mix{ namespace Sound{

StreamingControllerTask::StreamingControllerTask( Mix::Sound::StreamingControllerMediator* pMediator ) : StreamingTask( pMediator ),
m_pMediator( NULL )
{
	MIX_ASSERT( pMediator != NULL );

	MIX_ADD_REF( pMediator );
	m_pMediator = pMediator;
}

StreamingControllerTask::~StreamingControllerTask( void )
{
	MIX_RELEASE( m_pMediator );
}

Boolean StreamingControllerTask::Process( void )
{
	Float32 volume;
	Float32 panpot;

	if( m_pMediator->GetVolume( volume ) == True )
	{
		m_pVoice->SetVolume( volume );
	}

	if( m_pMediator->GetPanpot( panpot ) == True )
	{
		Float32 cv[2];

		if( panpot >= 0.0f )
		{
			cv[0] = ( 1.0f - panpot );
			cv[1] = 1.0;
		}
		else
		{
			cv[0] = 1.0;
			cv[1] = ( 1.0f + panpot );
		}

		m_pVoice->SetChannelVolumes( 2, cv );
	}

	return StreamingTask::Process();
}

}}
