#pragma once

#include "Mix/Sound/IEmitter.h"

namespace Mix{ namespace Sound{

	class Listener;
	class EmitterMediator;

	class SimpleEmitter : public Mix::Sound::IEmitter
	{
	public:
		static SimpleEmitter* CreateInstance(	Mix::Sound::Listener* pListener,
												Mix::Sound::EmitterMediator* pMediator,
												const WAVEFORMATEX* pFormat,
												Mix::Memory::IBuffer* pBuffer,
												const Mix::Vector3& front,
												const Mix::Vector3& up,
												UInt32 masterChannels,
												const wchar_t* pFilePath );

	private:
		Mix::Sound::Listener* m_pListener;
		Mix::Sound::EmitterMediator* m_pMediator;
		WAVEFORMATEX m_Format;
		Mix::Memory::IBuffer* m_pBuffer;

		Mix::Vector3 m_LocalFront;
		Mix::Vector3 m_LocalUp;
		Mix::Matrix4x4 m_WorldMatrix;
		Mix::Vector3 m_WorldFront;
		Mix::Vector3 m_WorldUp;
		Mix::Vector3 m_Velocity;
		Mix::STL::Vector<Mix::Memory::SECTION_SOUND, Float32> m_ChannelAzimuths;
		X3DAUDIO_EMITTER m_Param;

		Mix::String m_FilePath;

	private:
		SimpleEmitter(	Mix::Sound::Listener* pListener,
						Mix::Sound::EmitterMediator* pMediator,
						const WAVEFORMATEX* pFormat,
						Mix::Memory::IBuffer* pBuffer,
						const Mix::Vector3& front,
						const Mix::Vector3& up,
						UInt32 masterChannels,
						const wchar_t* pFilePath );

		virtual ~SimpleEmitter( void );

	public:
		const WAVEFORMATEX* GetFormat( void ) const;

	public:
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Sound::IEmitter
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual const Mix::Vector3& GetLocalFront( void ) const;
		virtual const Mix::Vector3& GetLocalUp( void ) const;

		virtual const Mix::Vector3& GetWorldFront( void ) const;
		virtual const Mix::Vector3& GetWorldUp( void ) const;

		virtual const Mix::Matrix4x4& GetWorldMatrix( void ) const;
		virtual void SetWorldMatrix( const Mix::Matrix4x4& mat );

		virtual const Mix::Vector3& GetVelocity( void ) const;
		virtual void SetVelocity( const Mix::Vector3& velocity );

		virtual UInt32 GetChannelCount( void ) const;

		virtual Float32 GetChannelRadius( void ) const;
		virtual void SetChannelRadius( Float32 radius );

		virtual Float32 GetChannelAzimuth( UInt32 channel ) const;
		virtual void SetChannelAzimuth( UInt32 channel, Float32 azimuth );

		virtual Float32 GetDopplerScaler( void ) const;
		virtual void SetDopplerScaler( Float32 scaler );

		virtual void Update( void );

		virtual Boolean IsCloneable( void ) const;
		virtual Boolean Clone( Mix::Sound::IEmitter** ppEmitter );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Sound::IDevice
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual Boolean IsPlaying( void );
		virtual void Play( Boolean bLoop );
		virtual void Stop( void );

		virtual void Suspend( void );
		virtual void Resume( void );

		virtual Boolean IsDisposed( void );
		virtual void Dispose( void );

		virtual const wchar_t* GetFilePath( void ) const;
	};

}}
