#include "Mix/Private/Scene/Standard/DX9/Renderer.h"

#include "Mix/Graphics/IDevice.h"
#include "Mix/Scene/ISkyDome.h"

namespace Mix{ namespace Scene{ namespace Standard{ namespace DX9{

Renderer* Renderer::CreateInstance( Mix::Scene::Standard::Common::EffectPackage* pEffectPackage, const wchar_t* pDebugName )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_SCENE, Renderer, pEffectPackage, pDebugName );
}

Renderer::Renderer( Mix::Scene::Standard::Common::EffectPackage* pEffectPackage, const wchar_t* pDebugName ) :
Mix::Scene::Standard::Common::Renderer( pEffectPackage, pDebugName )
{
}

Renderer::~Renderer( void )
{
}

void Renderer::OnPrepareRendering( const Renderer::PREPARE_REDNERING_EVENT_ARGS& e )
{
	Mix::Vector4 invFarZ( e.invFarZ, 0.0f, 0.0f, 0.0f );
	Mix::Vector4 hemisphereAxis( e.hsAxis.x, e.hsAxis.y, e.hsAxis.z, ( e.hsEnabled == True )? 1.0f : 0.0f );
	Mix::Vector4 sunDir( e.sunDir.x, e.sunDir.y, e.sunDir.z, ( e.sunEnabled == True )? 1.0f : 0.0f );
	Mix::Vector4 fogParam( e.fogParam0, e.fogParam1, 0.0f, ( e.fogEnabled == True )? 1.0f : 0.0f );
	Mix::Vector4 shadowParam0( e.shadowDepthBias, e.shadowDepthSlopeScale, e.shadowDepthBiasClamp, ( e.shadowEnabled == True )? 1.0f : 0.0f );
	Mix::Vector4 shadowParam1( e.shadowPCFRange, e.shadowPCFMul, e.shadowTexelSize.x, e.shadowTexelSize.y );
	Mix::Vector4 asColor( e.asColor.x, e.asColor.y, e.asColor.z, ( e.asEnabled == True )? 1.0f : 0.0f );
	Mix::Vector4 localLight( 0.0f, 0.0f, 0.0f, 0.0f );

	m_pGraphicsDev->SetVertexShaderConstantF( Renderer::VSR_VIEW_MAT, &( e.viewMat ), 1 );
	m_pGraphicsDev->SetVertexShaderConstantF( Renderer::VSR_VIEWPROJ_MAT, &( e.viewProjMat ), 1 );
	m_pGraphicsDev->SetVertexShaderConstantF( Renderer::VSR_LIGHT_MAT, &( e.lightMat ), 1 );
	m_pGraphicsDev->SetVertexShaderConstantF( Renderer::VSR_LIGHTBIAS_MAT, &( e.lightBiasMat ), 1 );

	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_FAR_Z_INV, &invFarZ, 1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_EYE_POS, &( e.eyePos ), 1 );

	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_GROBAL_AMBIENT_COLOR, &( e.globalAmbientColor ), 1 );

	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_HS_AXIS, &hemisphereAxis, 1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_HS_GROUND_COLOR, &( e.hsGroundColor ), 1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_HS_SKY_COLOR, &( e.hsSkyColor ), 1 );

	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_SUN_DIR, &sunDir, 1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_SUN_COLOR, &( e.sunColor ), 1 );

	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_FOG_PARAM, &fogParam, 1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_FOG_COLOR, &( e.fogColor ), 1 );

	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_SHADOW_PARAM0, &shadowParam0, 1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_SHADOW_PARAM1, &shadowParam1, 1 );

	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_AS_COLOR, &asColor, 1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_AS_SUN_DIR, &( e.asSunDir ), 1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_AS_MULTIPLIERS, &( e.asMultipliers ), 1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_AS_HG, &( e.asHG ), 1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_AS_BETA_DASH_R, &( e.asBetaDashR ), 1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_AS_BETA_DASH_M, &( e.asBetaDashM ), 1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_AS_BETA_RM, &( e.asBetaRM ), 1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_AS_ONE_OVER_BETA_RM, &( e.asOneOverBetaRM ), 1 );

	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_LOCAL_LIGHT_POS, &localLight, 1 );
}

void Renderer::OnTransform( const Renderer::TRANSFORM_EVENT_ARGS& e )
{
	m_pGraphicsDev->SetVertexShaderConstantF( Renderer::VSR_WORLD_MAT, e.list, e.count );
}

void Renderer::OnPlacementLocalLight( const Renderer::LOCALLIGHT_EVENT_ARGS& e )
{
	UInt32 count = e.count;

	MIX_ASSERT( count <= Renderer::LOCAL_LIGHT_MAX );

	if( count > 0 )
	{
		Mix::Vector4* table;
		Mix::Vector4* pos;
		Mix::Vector4* dir;
		Mix::Vector4* atten;
		Mix::Vector4* color;
		Mix::Vector4* param;

		UInt32 posCount;

		m_VectorTable.resize( Renderer::LOCAL_LIGHT_MAX * Renderer::LTO_MAX );

		table = &( m_VectorTable[0] );
		pos = &( table[Renderer::LTO_POS] );
		dir = &( table[Renderer::LTO_DIR] );
		atten = &( table[Renderer::LTO_ATTEN] );
		color = &( table[Renderer::LTO_COLOR] );
		param = &( table[Renderer::LTO_PARAM] );

		if( count < Renderer::LOCAL_LIGHT_MAX )
		{
			pos[count].w = 0.0f;
			posCount = count + 1;
		}
		else
		{
			posCount = count;
		}

		MIX_ASSERT( posCount <= Renderer::LOCAL_LIGHT_MAX );

		for( UInt32 i = 0; i < count; i++ )
		{
			const Mix::Scene::Common::LOCAL_LIGHT* src = e.list[i];

			pos[i].Set( src->pos.x, src->pos.y, src->pos.z, 1.0f );
			atten[i].Set( src->atten.x, src->atten.y, src->atten.z, 0.0f );
			color[i] = src->color;

			if( src->type == Mix::Scene::IRendererObject::SPOT_LIGHT )
			{
				dir[i].Set( src->dir.x, src->dir.y, src->dir.z, 1.0f );
				param[i].Set( src->range, src->innerCos, src->outerCos, src->exp );
			}
			else
			{
				dir[i].Set( 0.0f, 0.0f, 0.0f, 0.0f );
				param[i].Set( src->outerRadius, src->invDiffRadius, 0.0f, 0.0f );
			}
		}

		m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_LOCAL_LIGHT_POS,   pos,   posCount );
		m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_LOCAL_LIGHT_DIR,   dir,   count );
		m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_LOCAL_LIGHT_ATTEN, atten, count );
		m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_LOCAL_LIGHT_COLOR, color, count );
		m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_LOCAL_LIGHT_PARAM, param, count );
	}
	else
	{
		m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_LOCAL_LIGHT_POS, &Mix::Vector4( 0.0f, 0.0f, 0.0f, 0.0f ), 1 );
	}
}

void Renderer::OnRenderSkyDome( const Renderer::SKYDOME_DEFAULT_EVENT_ARGS& e )
{
	Mix::Vector4 baseParam( e.baseParam.texScale, e.baseParam.texOpacity, 0.0f, 0.0f );
	Mix::Vector4 cloudLayer[Mix::Scene::Common::SkyDome::CL_MAX];

	for( UInt32 i = 0; i < Mix::Scene::Common::SkyDome::CL_MAX; i++ )
	{
		const Renderer::SKYDOME_CLOUD_LAYER& srcLayer = e.cloudLayers[i];
		const Mix::Vector2& texOffset = srcLayer.texOffset;

		cloudLayer[i].Set( texOffset.x, texOffset.y, srcLayer.texScale, srcLayer.texOpacity );
	}

	m_pGraphicsDev->SetVertexShaderConstantF( Renderer::VSR_SD_WVP_MAT, &( e.wvpMat ), 1 );

	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_SD_DEF_BASE_COLOR,  &( e.baseColor ),  1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_SD_DEF_BASE_PARAM,  &baseParam,        1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_SD_DEF_CLOUD_COLOR, &( e.cloudColor ), 1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_SD_DEF_CLOUD_LAYER, cloudLayer,        2 );
}

void Renderer::OnRenderSkyDome( const Renderer::SKYDOME_ATMOSPHERE_EVENT_ARGS& e )
{
	Mix::Vector4 baseParam( e.baseParam.texScale, e.baseParam.texOpacity, 0.0f, 0.0f );
	Mix::Vector4 cloudParam( e.cloudLighting.cornerThreshold, e.cloudLighting.cornerMul, e.cloudLighting.darkness, 0.0f );
	Mix::Vector4 cloudLayer[Mix::Scene::Common::SkyDome::CL_MAX];

	for( UInt32 i = 0; i < Mix::Scene::Common::SkyDome::CL_MAX; i++ )
	{
		const Renderer::SKYDOME_CLOUD_LAYER& srcLayer = e.cloudLayers[i];
		const Mix::Vector2& texOffset = srcLayer.texOffset;

		cloudLayer[i].Set( texOffset.x, texOffset.y, srcLayer.texScale, srcLayer.texOpacity );
	}

	m_pGraphicsDev->SetVertexShaderConstantF( Renderer::VSR_AS_W_MAT, &( e.worldMat ), 1 );
	m_pGraphicsDev->SetVertexShaderConstantF( Renderer::VSR_AS_WVP_MAT, &( e.worldViewProjMat ), 1 );

	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_SD_AS_SUN_COLOR,    &( e.sunColor ),   1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_SD_AS_NIGHT_COLOR,  &( e.nightColor ), 1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_SD_AS_BASE_PARAM,   &baseParam,        1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_SD_AS_CLOUD_COLOR,  &( e.cloudColor ), 1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_SD_AS_CLOUD_LAYER,  cloudLayer,        2 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_SD_AS_CLOUD_PARAMS, &cloudParam,       1 );
}

void Renderer::OnRenderPanorama( const Renderer::SKYDOME_PANORAMA_EVENT_ARGS& e )
{
	Mix::Vector4 param( e.texRepeat, e.dist, e.fogRatio, 0.0f );

	m_pGraphicsDev->SetVertexShaderConstantF( Renderer::VSR_PR_WVP_MAT, &( e.wvpMat ), 1 );
	m_pGraphicsDev->SetVertexShaderConstantF( Renderer::VSR_PR_W_MAT, &( e.wMat ), 1 );

	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_PR_BASE_COLOR, &( e.baseColor ), 1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_PR_PARAM, &param, 1 );
}

void Renderer::OnRenderSampling( const Renderer::RENDER_SAMPLING_ARGS& e )
{
	Mix::Vector4 param( e.texelSize.x, e.texelSize.y, e.colorScale, 0.0f );

	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_SAMPLING_PARAM, &param , 1 );
}

void Renderer::OnRenderBlur( const Renderer::RENDER_BLUR_ARGS& e )
{
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_BLUR_PARAM, &( e.params[0] ), 3 );
}

void Renderer::OnRenderGaussianBlur( const Renderer::RENDER_GAUSSIAN_BLUR_ARGS& e )
{
	m_pGraphicsDev->SetVertexShaderConstantF( Renderer::VSR_GAUSSIAN_BLUR_OFFSETS, e.inOffsets, sizeof( e.inOffsets ) / sizeof( Mix::Vector4 ) );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_GAUSSIAN_BLUR_OFFSETS, &( e.outOffset ), 1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_GAUSSIAN_BLUR_WEIGHTS, e.weights, sizeof( e.weights ) / sizeof( Float32[4] ) );
}

void Renderer::OnRenderGaussianBlurEx( const Renderer::RENDER_GAUSSIAN_BLUR_EX_ARGS& e )
{
	Mix::Vector4 param0( e.halfRadius, 0.0f, 0.0f, 0.0f );
	Mix::Vector4 param1( e.inc.x, e.inc.y, e.inc.z, 0.0f );
	Mix::Vector4 param2( e.step.x, e.step.y, 0.0f, 0.0f );

	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_GAUSSIAN_BLUR_EX_PARAM0, &param0, 1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_GAUSSIAN_BLUR_EX_PARAM1, &param1, 1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_GAUSSIAN_BLUR_EX_PARAM2, &param2, 1 );
}

void Renderer::OnRenderShadowMapping( const Renderer::RENDER_SHADOW_MAPPING_ARGS& e )
{
	Mix::Vector4 params( e.falloutStart, e.invFalloutDist, e.refractFactor, 0.0f );

	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_SM_PARAMS, &params, 1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_SM_COLOR, &( e.color ), 1 );
}

void Renderer::OnRenderAmbientOcclusion( const Renderer::RENDER_AMBIENT_OCCLUSION_ARGS& e )
{
	Mix::Vector4 param0( e.radius, e.threshold, e.depth, e.intensity );
	Mix::Vector4 param1( e.ntexAspect.x, e.ntexAspect.y, 0.0f, 0.0f );

	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_SSAO_PARAM0, &param0, 1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_SSAO_PARAM1, &param1, 1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_SSAO_COLOR, &( e.color ), 1 );
}

void Renderer::OnRenderLumTransform( const Renderer::RENDER_LUM_TRANSFORM_ARGS& e )
{
	const Mix::Vector2& ts = e.texelSize;
	const Mix::Vector2& lr = e.lumRange;

	Mix::Vector4 param( ts.x, ts.y, lr.x, lr.y );

	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_LUM_TRANSFORM_PARAM, &param, 1 );
}

void Renderer::OnRenderLumAdapted( const Renderer::RENDER_LUM_ADAPTED_ARGS& e )
{
	Mix::Vector4 param( e.rods, e.cones, e.deltaTime, 0.0f );

	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_LUM_ADAPTED_PARAM, &param, 1 );
}

void Renderer::OnRenderLumOperator( const Renderer::RENDER_LUM_OPERATOR_ARGS& e )
{
	Mix::Vector4 param( e.middleGray, e.invWhite2, 0.0f, 0.0f );

	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_LUM_OPERATOR_PARAM, &param, 1 );
}

void Renderer::OnRenderBrightPass( const Renderer::RENDER_BRIGHTPASS_ARGS& e )
{
	Mix::Vector4 param( e.middleGray, e.invWhite2, e.threshold, e.offset );

	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_BP_PARAM, &param, 1 );
}

void Renderer::OnRenderUnderWater( const Renderer::UNDERWATER_EVENT_ARGS& e )
{
	Mix::Vector4 param( e.density, e.intensity, e.threshold, e.offset );

	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_UW_COLOR, &( e.color ), 1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_UW_PARAM, &param, 1 );
}

void Renderer::OnRenderLightShaftsInit( const Renderer::RENDER_LIGHT_SHAFTS_INIT_ARGS& e )
{
	Mix::Vector4 param( e.whiteness, e.ntexAspect.x, e.ntexAspect.y, 0.0f );

	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_LS_INIT_PARAM, &param, 1 );
}

void Renderer::OnRenderLightShaftsBlur( const Renderer::RENDER_LIGHT_SHAFTS_BLUR_ARGS& e )
{
	Mix::Vector4 param0( e.lightPos.x, e.lightPos.y, e.EdotL, 0.0f );
	Mix::Vector4 param1( e.density, e.decay, e.exposure, 0.0f );
	Mix::Vector4 param2( e.fiStart, e.fiEnd, e.fiInvDist, 0.0f );

	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_LS_BLUR_PARAM0, &param0, 1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_LS_BLUR_PARAM1, &param1, 1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_LS_BLUR_PARAM2, &param2, 1 );
}

void Renderer::OnRenderLensFlareImage( const Renderer::RENDER_LENSFLARE_IMAGE_ARGS& e )
{
	Mix::Vector4 param0( e.distortion.x, e.distortion.y, e.distortion.z, static_cast<Float32>( e.numGhost ) );
	Mix::Vector4 param1( e.ghostWeight, e.ghostDispersion, e.haloWeight, e.haloWidth );

	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_LF_I_PARAM0, &param0, 1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_LF_I_PARAM1, &param1, 1 );
}

void Renderer::OnRenderLensFlareModify( const Renderer::RENDER_LENSFLARE_MODIFY_ARGS& e )
{
	Mix::Vector4 param( e.dirtIntensity, e.dirtExposure, e.brustIntensity, e.brustExposure );

	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_LF_M_PARAM, &param, 1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_LF_M_CAMMAT, &( e.camMat ), 1 );
}

void Renderer::OnRenderFilmicHable( const Renderer::RENDER_FILMIC_HABLE_ARGS& e )
{
	Mix::Vector4 param0( e.exposureBias, e.shoulderStrength, e.linearStrength, e.linearAngle );
	Mix::Vector4 param1( e.toeStrength, e.toeNumerator, e.toeDenominator, e.linearWhitePointValue );

	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::FI_HABLE_PARAM0, &param0, 1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::FI_HABLE_PARAM1, &param1, 1 );
}

void Renderer::OnRenderChromatismImage( const Renderer::RENDER_CHROMATISM_IMAGE_ARGS& e )
{
	Mix::Vector4 param( e.k, e.kCube, e.scale, 0.0f );

	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_CA_IMAGE_PARAM, &param, 1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_CA_IMAGE_COLOR_FACTOR, &( e.colorFactor ), 1 );
}

void Renderer::OnRenderChromatismFinish( const Renderer::RENDER_CHROMATISM_FINISH_ARGS& e )
{
	Mix::Vector4 param( e.weight, e.fiStartZ, e.fiInvDist, 0.0f );

	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_CA_FINISH_PARAM, &param, 1 );
}

void Renderer::OnRenderGammaCorrect( const Renderer::RENDER_GAMMA_ARGS& e )
{
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_SAMPLING_PARAM, &( e.invValue ), 1 );
}

void Renderer::OnRenderCameraMotionBlur( const Renderer::RENDER_CAMERA_MOTION_BLUR_ARGS& e )
{
	Mix::Vector4 param0( e.cp0, e.cp1, e.cp2, 0.0f );
	Mix::Vector4 param1( e.scale, e.intensity, e.invVolume, e.dist );

	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::CMB_INV_VP_MAT, &( e.invViewProjMat ), 1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::CMB_PRE_VP_MAT, &( e.preViewProjMat ), 1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::CMB_PARAM0, &param0, 1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::CMB_PARAM1, &param1, 1 );
}

void Renderer::OnRenderDof( const Renderer::RENDER_DOF_ARGS& e )
{
	Mix::Vector4 param0( e.nearZ, e.farZ, e.invNearDist, e.invFarDist );
	Mix::Vector4 param1( e.blurThreshold, e.invBlurThreaholdN, e.invBlurThreaholdF, 0.0f );

	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_DOF_PARAM0, &param0, 1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_DOF_PARAM1, &param1, 1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_DOF_SAMPLING_TABLE, e.samplingTable, Renderer::DOF_SAMPLING_NUM );
}

void Renderer::OnRenderLensDistortion( const Renderer::RENDER_LENS_DISTORTION_ARGS& e )
{
	Mix::Vector4 param( e.k, e.kCube, e.scale, 0.0f );

	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_LD_PARAM, &param, 1 );
}

void Renderer::OnRenderVignette( const Renderer::RENDER_VIGNETTE_ARGS& e )
{
	Mix::Vector4 params( e.start, e.invDist, 0.0f, 0.0f );

	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_VI_PARAMS, &params, 1 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_VI_COLOR, &( e.color ), 1 );
}

void Renderer::OnRenderFXAA( const Renderer::RENDER_FXAA_ARGS& e )
{
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_FXAA_TEXCOORDS, e.texCoords, 2 );
	m_pGraphicsDev->SetPixelShaderConstantF( Renderer::PSR_FXAA_INV_SCREEN_SIZE, &( e.invScreenSize ), 1 );
}

}}}}
