#pragma once

#include "Mix/Scene/IParticleGenerator.h"

namespace Mix{ namespace Scene{ namespace Common{

	class SimpleParticleGenerator : public Mix::Scene::IParticleGenerator
	{
	private:
		Mix::Vector3 m_EmitRadius;
		Float32 m_EmitOffset;
		Mix::Vector3 m_EmitInnerRadius;

		Float32 m_MinLife;
		Float32 m_MaxLife;
		Float32 m_DiffLife;

		Float32 m_MinMass;
		Float32 m_MaxMass;
		Float32 m_DiffMass;

		Mix::Vector3 m_Gravity;

		Mix::Vector3 m_ConstantLinearVelocity;

		Mix::Vector3 m_MinLinearImpulse;
		Mix::Vector3 m_MaxLinearImpulse;
		Mix::Vector3 m_DiffLinearImpulse;

		Mix::Vector3 m_MinLinearAcc;
		Mix::Vector3 m_MaxLinearAcc;
		Mix::Vector3 m_DiffLinearAcc;

		Float32 m_MinLinearVelDamp;
		Float32 m_MaxLinearVelDamp;
		Float32 m_DiffLinearVelDamp;

		Float32 m_MinAngularVelDamp;
		Float32 m_MaxAngularVelDamp;
		Float32 m_DiffAngularVelDamp;

		Mix::Vector2 m_InitalSize;
		Mix::Vector2 m_LastSize;
		Float32 m_MinSizeRnd;
		Float32 m_MaxSizeRnd;
		Float32 m_DiffSizeRnd;

		Mix::Vector4 m_InitalColor;
		Mix::Vector4 m_MiddleColor;
		Mix::Vector4 m_LastColor;
		Float32 m_ColorCtrlPoint1;
		Float32 m_ColorCtrlPoint2;

		Mix::Vector2 m_TexTL;
		Mix::Vector2 m_TexBR;

	protected:
		SimpleParticleGenerator( void );
		virtual ~SimpleParticleGenerator( void );

	public:
		const Mix::Vector3& GetEmitRadius( void ) const;
		void SetEmitRadius( const Mix::Vector3& radius );
		Float32 GetEmitOffset( void ) const;
		void SetEmitOffset( Float32 offset );

		Float32 GetMinLife( void ) const;
		Float32 GetMaxLife( void ) const;
		void SetLife( Float32 minLife, Float32 maxLife );

		Float32 GetMinMass( void ) const;
		Float32 GetMaxMass( void ) const;
		void SetMass( Float32 minMass, Float32 maxMass );

		const Mix::Vector3& GetGravity( void ) const;
		void SetGravity( const Mix::Vector3& gravity );

		const Mix::Vector3& GetConstantLinearVelocity( void ) const;
		void SetConstantLinearVelocity( const Mix::Vector3& vel );

		const Mix::Vector3& GetMinLinearImpulse( void ) const;
		const Mix::Vector3& GetMaxLinearImpulse( void ) const;
		void SetLinearImpulse( const Mix::Vector3& minImpulse, const Mix::Vector3& maxImpulse );

		const Mix::Vector3& GetMinLinearAcceleration( void ) const;
		const Mix::Vector3& GetMaxLinearAcceleration( void ) const;
		void SetLinearAcceleration( const Mix::Vector3& minAcc, const Mix::Vector3& maxAcc );

		Float32 GetMinLinearVelocityDamping( void ) const;
		Float32 GetMaxLinearVelocityDamping( void ) const;
		void SetLinearVelocityDamping( Float32 minDamping, Float32 maxDamping );

		Float32 GetMinAngularVelocityDamping( void ) const;
		Float32 GetMaxAngularVelocityDamping( void ) const;
		void SetAngularVelocityDamping( Float32 minDamping, Float32 maxDamping );

		const Mix::Vector2& GetInitalSize( void ) const;
		const Mix::Vector2& GetLastSize( void ) const;
		Float32 GetMinSizeRand( void ) const;
		Float32 GetMaxSizeRand( void ) const;
		void SetSize( const Mix::Vector2& initalSize, const Mix::Vector2& lastSize, Float32 minSizeScale, Float32 maxSizeScale );

		const Mix::Vector4& GetInitalColor( void ) const;
		const Mix::Vector4& GetMiddleColor( void ) const;
		const Mix::Vector4& GetLastColor( void ) const;
		void SetColor( const Mix::Vector4& initalColor, const Mix::Vector4& middleColor, const Mix::Vector4& lastColor );

		Float32 GetColorControlPoint1( void ) const;
		Float32 GetColorControlPoint2( void ) const;
		void SetColorControlPoints( Float32 p1, Float32 p2 );

		const Mix::Vector2& GetTexTL( void ) const;
		const Mix::Vector2& GetTexBR( void ) const;
		void SetTexCoords( const Mix::Vector2& tl, const Mix::Vector2& br );

		void GetData(	Float32& mass,
						Mix::Vector3& pos,
						Float32& lifeMax,
						Float32& invLifeMax,
						Mix::Vector3& constLinearAcc,
						Mix::Vector3& constLinearVel,
						Mix::Vector3& linearAcc,
						Mix::Vector3& linearVel,
						Float32& linearVelDamp,
						Float32& angularVelDamp,
						Mix::Vector2& initalSize,
						Mix::Vector2& middleSize,
						Mix::Vector2& lastSize,
						Mix::Vector4& initalColor,
						Mix::Vector4& middleColor,
						Mix::Vector4& lastColor,
						Float32* colCtrlPoints,
						Mix::Vector2& texTL,
						Mix::Vector2& texBR );

		void GetData( Float32 mass, Float32 x, Float32 y, Float32 z, Mix::Matrix4x4& invInertia );

	public:
//		virtual void GetData( void* pData, UInt32 dataStride, UInt32 dataCount );

#ifdef _DEBUG
		virtual void Debug_Draw( const Mix::Matrix4x4& worldMat, Mix::Graphics::Utility::IPerspectiveRenderer* pPerspectiveRenderer );
#endif //_DEBUG

	private:
		static const Mix::Vector3 MIN_EMIT_POS;
		static const Mix::Vector3 MAX_EMIT_POS;
	};

}}}
