#pragma once

#include "Mix/Scene/ILightShaftsCaster.h"
#include "Mix/Private/Scene/Common/RendererObject.h"

namespace Mix{ namespace Scene{ namespace Common{

	class Camera;

	class LightShaftsCaster : public Mix::Scene::ILightShaftsCaster, public Mix::Scene::Common::RendererObject
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::Common::LightShaftsCaster
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		struct PARAM
		{
			Mix::Vector2 pos;
			Float32 EdotL;
		};

	public:
		static LightShaftsCaster* CreateInstance( void );

	private:
		Boolean m_bEnabled;
		Mix::Vector3 m_Pos;

	private:
		LightShaftsCaster( void );
		virtual ~LightShaftsCaster( void );

	public:
		void Attach( void );
		void Detach( void );

		Boolean GetParam( Mix::Scene::Common::Camera* pCamera, LightShaftsCaster::PARAM& param );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::ILightShaftsCaster
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual Boolean IsEnabled( void ) const;
		virtual void SetEnabled( Boolean state );

		virtual const Mix::Vector3& GetPosition( void ) const;
		virtual void SetPosition( const Mix::Vector3& pos );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::IRendererObject
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual Mix::Scene::IRendererObject::TYPE GetType( void ) const;
		virtual Boolean IsRendering( void ) const;

	public:
		static const wchar_t* FAILED_CREATE;
	};

}}}
