#include "Mix/Private/Scene/Common/HemisphereLight.h"

namespace Mix{ namespace Scene{ namespace Common{

const wchar_t* HemisphereLight::FAILED_CREATE = L"Cg̍쐬Ɏs";

HemisphereLight* HemisphereLight::CreateInstance( void )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_SCENE, HemisphereLight );
}

HemisphereLight::HemisphereLight( void ) :
m_Axis( 0.0f, 1.0f, 0.0f ),
m_GroundColor( 0.0f, 0.0f, 0.0f, 1.0f ),
m_SkyColor( 0.0f, 0.0f, 0.0f, 1.0f ),
m_bEnabled( False )
{
}

HemisphereLight::~HemisphereLight( void )
{
}

void HemisphereLight::Attach( void )
{
	RendererObject::SetRendering( True );
}

void HemisphereLight::Detach( void )
{
	RendererObject::SetRendering( False );
}

const Mix::Vector3& HemisphereLight::GetAxis( void ) const
{
	return m_Axis;
}

void HemisphereLight::SetAxis( const Mix::Vector3& axis )
{
	m_Axis = axis.ToNormalize();
}

const Mix::Vector4& HemisphereLight::GetGroundColor( void ) const
{
	return m_GroundColor;
}

void HemisphereLight::SetGroundColor( const Mix::Vector4& color )
{
	m_GroundColor = color.ToSaturate();
}

const Mix::Vector4& HemisphereLight::GetSkyColor( void ) const
{
	return m_SkyColor;
}

void HemisphereLight::SetSkyColor( const Mix::Vector4& color )
{
	m_SkyColor = color.ToSaturate();
}

Boolean HemisphereLight::IsEnabled( void ) const
{
	return m_bEnabled;
}

void HemisphereLight::SetEnabled( Boolean state )
{
	m_bEnabled = state;
}

Mix::Scene::IRendererObject::TYPE HemisphereLight::GetType( void ) const
{
	return Mix::Scene::IRendererObject::HEMISPHERE_LIGHT;
}

Boolean HemisphereLight::IsRendering( void ) const
{
	return RendererObject::IsRendering();
}

}}}
