#pragma once

#include "Mix/Memory/IBuffer.h"

namespace Mix{ namespace Memory{

	class Buffer : public Mix::Memory::IBuffer
	{
	public:
		static Buffer* CreateInstance( void );

	private:
		void* m_pBuffer;
		UIntT m_Size;

	private:
		Buffer( void );
		virtual ~Buffer( void );

	public:
		Boolean Create( UInt16 section, UIntT size );

	public:
		virtual const void* GetConstPointer( void ) const;
		virtual void* GetPointer( void ) const;
		virtual UIntT GetSize( void ) const;
	};

}}
