#pragma once

#include "Mix/IO/IReader.h"

namespace Mix{ namespace IO{

	class MemoryReader : public Mix::IO::IReader
	{
	public:
		static MemoryReader* CreateInstance( const wchar_t* filePath, const void* pMem, UInt64 memSize );

	private:
		Mix::String m_FilePath;
		const UInt8* m_pMem;
		const UInt8* m_pBegin;
		UInt64 m_Pos;
		UInt64 m_Size;

	private:
		MemoryReader( const wchar_t* filePath, const void* pMem, UInt64 memSize );
		virtual ~MemoryReader( void );

	public:
		UInt32 Lock( const void** ppReadBuffer, UInt32 readSize );

	public:
		virtual UInt32 Read( void* pReadBuffer, UInt32 readSize );
		virtual UInt64 Seek( Mix::IO::SEEK_METHOD seekMethod, Int64 offset );
		virtual UInt64 GetPos( void ) const;
		virtual UInt64 GetSize( void ) const;
		virtual const wchar_t* GetFilePath( void ) const;
		virtual Boolean IsBuffered( void ) const;
		virtual Boolean Clone( Mix::IO::IReader** ppReader );

	public:
		virtual Mix::IO::IStream::ACCESS_TYPE GetAccessType( void ) const;
		virtual Mix::IO::IStream::SOURCE_TYPE GetSourceType( void ) const;
	};

}}
