#pragma once

#include "Mix/IO/IWriter.h"

namespace Mix{ namespace IO{

	class Controller;

	class FileWriter : public Mix::IO::IWriter
	{
	public:
		static FileWriter* CreateInstance( const wchar_t* pFilePath, Mix::IO::Controller* pCtrl );

	private:
		Mix::String m_FilePath;
		Mix::IO::Controller* m_pCtrl;

	private:
		FileWriter( const wchar_t* pFilePath, Mix::IO::Controller* pCtrl );
		virtual ~FileWriter( void );

	public:
		virtual UInt32 Write( const void* pWriteBuffer, UInt32 writeSize );
		virtual UInt64 GetSize( void ) const;
		virtual const wchar_t* GetFilePath( void ) const;

	public:
		virtual Mix::IO::IStream::ACCESS_TYPE GetAccessType( void ) const;
		virtual Mix::IO::IStream::SOURCE_TYPE GetSourceType( void ) const;
	};

}}
