#include "Mix/Private/IO/FileWriter.h"
#include "Mix/Private/IO/Controller.h"

namespace Mix{ namespace IO{

FileWriter* FileWriter::CreateInstance( const wchar_t* pFilePath, Mix::IO::Controller* pCtrl )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_GENERAL, FileWriter, pFilePath, pCtrl );
}

FileWriter::FileWriter( const wchar_t* pFilePath, Mix::IO::Controller* pCtrl ) :
m_FilePath( pFilePath ),
m_pCtrl( NULL )
{
	MIX_ASSERT( pCtrl != NULL );

	MIX_ADD_REF( pCtrl );
	m_pCtrl = pCtrl;
}

FileWriter::~FileWriter( void )
{
	m_pCtrl->Close();
	MIX_RELEASE( m_pCtrl );
}

UInt32 FileWriter::Write( const void* pWriteBuffer, UInt32 writeSize )
{
	return m_pCtrl->Write( pWriteBuffer, writeSize );
}

UInt64 FileWriter::GetSize( void ) const
{
	return m_pCtrl->GetSize();
}

const wchar_t* FileWriter::GetFilePath( void ) const
{
	return m_FilePath.GetConstPtr();
}

Mix::IO::IStream::ACCESS_TYPE FileWriter::GetAccessType( void ) const
{
	return Mix::IO::IStream::A_WRITE;
}

Mix::IO::IStream::SOURCE_TYPE FileWriter::GetSourceType( void ) const
{
	return Mix::IO::IStream::S_FILE;
}

}}
