#pragma once

#include "Mix/IO/IReader.h"

namespace Mix{ namespace IO{

	class Controller;

	class FileReader : public Mix::IO::IReader
	{
	public:
		static FileReader* CreateInstance( const wchar_t* pFilePath, Mix::IO::Controller* pCtrl );

	private:
		Mix::String m_FilePath;
		Mix::IO::Controller* m_pCtrl;

	protected:
		FileReader( const wchar_t* pFilePath, Mix::IO::Controller* pCtrl );
		virtual ~FileReader( void );

	public:
		virtual UInt32 Read( void* pReadBuffer, UInt32 readSize );
		virtual UInt64 Seek( Mix::IO::SEEK_METHOD seekMethod, Int64 offset );
		virtual UInt64 GetPos( void ) const;
		virtual UInt64 GetSize( void ) const;
		virtual const wchar_t* GetFilePath( void ) const;
		virtual Boolean Clone( Mix::IO::IReader** ppReader );

	public:
		virtual Mix::IO::IStream::ACCESS_TYPE GetAccessType( void ) const;
		virtual Mix::IO::IStream::SOURCE_TYPE GetSourceType( void ) const;
	};

}}
