#pragma once

#include "Mix/Private/IO/Controller.h"

namespace Mix{ namespace IO{

	class FileController : public Mix::IO::Controller
	{
	public:
		static FileController* CreateInstance( const wchar_t* fileName );

	private:
		HANDLE m_hFile;

	private:
		FileController( const wchar_t* fileName );
		virtual ~FileController( void );

	public:
		virtual Boolean Open( FileController::MODE mode );
		virtual void Close( void );
		virtual Boolean IsOpen( void ) const;

		virtual UInt32 Read( void* pReadBuffer, UInt32 readSize );
		virtual UInt32 Write( const void* pWriteBuffer, UInt32 writeSize );

		virtual UInt64 Seek( Mix::IO::SEEK_METHOD seekMethod, Int64 offset );

		virtual Boolean IsArchive( void ) const;
	};

}}
