#pragma once

#include "Mix/IO/IReader.h"

namespace Mix{ namespace IO{

	class BufferedReader : public Mix::IO::IReader
	{
	public:
		static BufferedReader* CreateInstance( const wchar_t* filePath, Mix::Memory::IBuffer* pBuffer );

	private:
		Mix::String m_FilePath;
		Mix::Memory::IBuffer* m_pBuffer;
		const UInt8* m_pBegin;
		UInt64 m_Pos;
		UInt64 m_Size;

	private:
		BufferedReader( const wchar_t* filePath, Mix::Memory::IBuffer* pBuffer );
		virtual ~BufferedReader( void );

	public:
		virtual UInt32 Read( void* pReadBuffer, UInt32 readSize );
		virtual UInt64 Seek( Mix::IO::SEEK_METHOD seekMethod, Int64 offset );
		virtual UInt64 GetPos( void ) const;
		virtual UInt64 GetSize( void ) const;
		virtual const wchar_t* GetFilePath( void ) const;
		virtual Boolean Clone( Mix::IO::IReader** ppReader );

	public:
		virtual Mix::IO::IStream::ACCESS_TYPE GetAccessType( void ) const;
		virtual Mix::IO::IStream::SOURCE_TYPE GetSourceType( void ) const;
	};

}}
