#pragma once

#include "Mix/Private/HID/RawInputDevice.h"
#include "Mix/HID/IKeyboard.h"
#include "Mix/Semaphore.h"
#include "Mix/CriticalSection.h"

namespace Mix{ namespace HID{

	class Keyboard : public Mix::HID::IKeyboard, public Mix::HID::RawInputDevice
	{
	public:
		static Keyboard* CreateInstance( HWND hWnd );

	private:
		HWND	m_hWnd;				//EBhEnh
		Boolean	m_bEnableUpdate;	//XVLȏꍇ True

		UInt8	m_VKConvTable[256];	//zL[ϊe[u

		UInt32 m_KeyStateArray[Mix::HID::KEY_MAX];	//L[Ԕz

		UInt8	m_KeyInfoList[Mix::HID::KEY_MAX];	//L[񃊃Xg( 0x00:Abv 0xFF:_E )

		UInt8	m_UpdateKeyList[Mix::HID::KEY_MAX];	//XVꂽL[̃Xg
		UInt8	m_UpdateKeyCount;							//XVꂽL[̐

		UInt16	m_LastUpdateKeyList[Mix::HID::KEY_MAX];	//OXVL[̃Xg
		UInt8	m_LastUpdateKeyCount;							//OXVL[̐

	private:
		Keyboard( HWND hWnd );
		virtual ~Keyboard( void );

	public:
		virtual void ProcessInput( const RAWINPUT* pInput );
		virtual void MessageProc( UInt32 msg, WPARAM wParam, LPARAM lParam );

	public:
		virtual void Update( void );

	public:
		virtual UInt32 GetKeyState( Mix::HID::KEY key ) const;
	};

}}
