#include "Mix/Private/Graphics/DX9/TextureVolume.h"
#include "Mix/Private/Graphics/DX9/Device.h"

namespace Mix{ namespace Graphics{ namespace DX9{

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::DX9::TextureVolume
////////////////////////////////////////////////////////////////////////////////////////////////////

TextureVolume* TextureVolume::CreateInstance(	Mix::Graphics::DX9::Device* pDevice,
												const wchar_t* pFilePath,
												UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
												IDirect3DVolumeTexture9* pD3DTexture )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_GRAPHICS, TextureVolume, pDevice, pFilePath, width, height, format, pD3DTexture );
}

TextureVolume::TextureVolume(	Mix::Graphics::DX9::Device* pDevice,
								const wchar_t* pFilePath,
								UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
								IDirect3DVolumeTexture9* pD3DTexture ) :
DeviceObject( pDevice ),
m_pDevice( NULL ),
m_FilePath( pFilePath ),
m_Width( width ),
m_Height( height ),
m_Format( format )
{
	MIX_ASSERT( pDevice != NULL );
	MIX_ASSERT( pD3DTexture != NULL );

	MIX_ADD_REF( pDevice );
	m_pDevice = pDevice;

	m_pD3DTexture = pD3DTexture;
}

TextureVolume::~TextureVolume( void )
{
	MIX_RELEASE( m_pD3DTexture );
	MIX_RELEASE( m_pDevice );
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::DeviceObject
////////////////////////////////////////////////////////////////////////////////////////////////////

void TextureVolume::Invalidate( void )
{
}

void TextureVolume::Validate( void )
{
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::Texture
////////////////////////////////////////////////////////////////////////////////////////////////////

IDirect3DBaseTexture9* TextureVolume::GetInterface( void )
{
	return m_pD3DTexture;
}

IDirect3DSurface9* TextureVolume::GetSurface( UInt32 index )
{
	return NULL;
}

UInt32 TextureVolume::GetSurfaceCount( void ) const
{
	return 0;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::ITexture
////////////////////////////////////////////////////////////////////////////////////////////////////

Mix::Graphics::ITexture::DIMENSION_TYPE TextureVolume::GetDimensionType( void ) const
{
	return ITexture::DIMENSION_VOLUME;
}

Mix::Graphics::ITexture::BIND_TYPE TextureVolume::GetBindType( void ) const
{
	return ITexture::BIND_DEFAULT;
}

UInt32 TextureVolume::GetAccessFlags( void ) const
{
	return ITexture::ACCESS_GPU_READ;
}

Boolean TextureVolume::Lock( Mix::Graphics::ITexture::LOCK& lock )
{
	return False;
}

void TextureVolume::Unlock( void )
{
}

UInt32 TextureVolume::GetWidth( void ) const
{
	return m_Width;
}

UInt32 TextureVolume::GetHeight( void ) const
{
	return m_Height;
}

Mix::Graphics::FORMAT TextureVolume::GetFormat( void ) const
{
	return m_Format;
}

const wchar_t* TextureVolume::GetFilePath( void ) const
{
	return m_FilePath.GetConstPtr();
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::IDeviceObject
////////////////////////////////////////////////////////////////////////////////////////////////////

Mix::Graphics::IDeviceObject::TYPE TextureVolume::GetType( void ) const
{
	return Mix::Graphics::IDeviceObject::TEXTURE;
}

}}}
