#include "Mix/Private/Graphics/DX9/TextureTarget.h"
#include "Mix/Private/Graphics/DX9/Device.h"

namespace Mix{ namespace Graphics{ namespace DX9{

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::DX9::TextureTarget
////////////////////////////////////////////////////////////////////////////////////////////////////

TextureTarget* TextureTarget::CreateInstance(	Mix::Graphics::DX9::Device* pDevice,
												UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
												IDirect3DTexture9* pTexture, IDirect3DSurface9* pSurface, D3DFORMAT d3dFormat )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_GRAPHICS, TextureTarget, pDevice, width, height, format, pTexture, pSurface, d3dFormat );
}

TextureTarget::TextureTarget(	Mix::Graphics::DX9::Device* pDevice,
								UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
								IDirect3DTexture9* pTexture, IDirect3DSurface9* pSurface, D3DFORMAT d3dFormat ) :
DeviceObject( pDevice ),
m_pDevice( pDevice ),
m_Width( width ),
m_Height( height ),
m_Format( format ),
m_pTexture( pTexture ),
m_pSurface( pSurface ),
m_D3DFormat( d3dFormat )
{
	MIX_ADD_REF( m_pDevice );
}

TextureTarget::~TextureTarget( void )
{
	MIX_RELEASE( m_pSurface );
	MIX_RELEASE( m_pTexture );
	MIX_RELEASE( m_pDevice );
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::DeviceObject
////////////////////////////////////////////////////////////////////////////////////////////////////

void TextureTarget::Invalidate( void )
{
	MIX_RELEASE( m_pSurface );
	MIX_RELEASE( m_pTexture );
}

void TextureTarget::Validate( void )
{
	HRESULT ret;

	ret = m_pDevice->CreateTargetTexture( m_Width, m_Height, m_D3DFormat, &m_pTexture );
	if( ret == D3D_OK )
	{
		ret = m_pTexture->GetSurfaceLevel( 0, &m_pSurface );
		if( ret != D3D_OK )
		{
			MIX_LOG_ERROR( L"^[QbgeNX`̕AɎs : GetSurfaceLevel G[Ԃ܂ : Result[%s]", m_pDevice->GetD3DResultText( ret ) );
		}
	}
	else
	{
		MIX_LOG_ERROR( L"^[QbgeNX`̕AɎs : Result[%s]", m_pDevice->GetD3DResultText( ret ) );
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::Texture
////////////////////////////////////////////////////////////////////////////////////////////////////

IDirect3DBaseTexture9* TextureTarget::GetInterface( void )
{
	return m_pTexture;
}

IDirect3DSurface9* TextureTarget::GetSurface( UInt32 index )
{
	return m_pSurface;
}

UInt32 TextureTarget::GetSurfaceCount( void ) const
{
	return 1;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::ITexture
////////////////////////////////////////////////////////////////////////////////////////////////////

Mix::Graphics::ITexture::DIMENSION_TYPE TextureTarget::GetDimensionType( void ) const
{
	return ITexture::DIMENSION_PLANE;
}

Mix::Graphics::ITexture::BIND_TYPE TextureTarget::GetBindType( void ) const
{
	return ITexture::BIND_TARGET;
}

UInt32 TextureTarget::GetAccessFlags( void ) const
{
	return ITexture::ACCESS_GPU_READ | ITexture::ACCESS_GPU_WRITE;
}

UInt32 TextureTarget::GetWidth( void ) const
{
	return m_Width;
}

UInt32 TextureTarget::GetHeight( void ) const
{
	return m_Height;
}

Mix::Graphics::FORMAT TextureTarget::GetFormat( void ) const
{
	return m_Format;
}

const wchar_t* TextureTarget::GetFilePath( void ) const
{
	return Mix::STR_NULL;
}

Boolean TextureTarget::Lock( Mix::Graphics::ITexture::LOCK& lock )
{
	return False;
}

void TextureTarget::Unlock( void )
{
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::IDeviceObject
////////////////////////////////////////////////////////////////////////////////////////////////////

Mix::Graphics::IDeviceObject::TYPE TextureTarget::GetType( void ) const
{
	return Mix::Graphics::IDeviceObject::TEXTURE;
}

}}}
