#pragma once

#include "Mix/Private/Graphics/Common/DeviceObject.h"
#include "Mix/Graphics/IQuery.h"

namespace Mix{ namespace Graphics{ namespace DX9{

	class Device;

	class Query : public Mix::Graphics::IQuery, public Mix::Graphics::Common::DeviceObject
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::DX9::Query
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		static Query* CreateInstance( Mix::Graphics::DX9::Device* pDevice, Mix::Graphics::QUERY_FORMAT format, IDirect3DQuery9* pD3DQuery );

	private:
		Mix::Graphics::DX9::Device* m_pDevice;
		Mix::Graphics::QUERY_FORMAT m_Format;
		IDirect3DQuery9* m_pD3DQuery;

	private:
		Query( Mix::Graphics::DX9::Device* pDevice, Mix::Graphics::QUERY_FORMAT format, IDirect3DQuery9* pD3DQuery );
		virtual ~Query( void );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::Common::DeviceObject
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual void Invalidate( void );
		virtual void Validate( void );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::IQuery
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual void Begin( void );
		virtual void End( void );
		virtual Boolean GetData( UInt32& data, Boolean bFlush ) const;
		virtual Mix::Graphics::QUERY_FORMAT GetFormat( void ) const;

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::IDeviceObject
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual Mix::Graphics::IDeviceObject::TYPE GetType( void ) const;
	};

}}}
