#pragma once

#include "Mix/Private/Graphics/Common/DeviceObject.h"
#include "Mix/Private/Graphics/DX11/Texture.h"

namespace Mix{ namespace Graphics{ namespace DX11{

	class Device;

	class TextureTarget : public Mix::Graphics::DX11::Texture, public Mix::Graphics::Common::DeviceObject
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::DX11::TextureTarget
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		static TextureTarget* CreateInstance(	Mix::Graphics::DX11::Device* pDevice,
												UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
												ID3D11Texture2D* pTexture, ID3D11RenderTargetView* pRTView, ID3D11ShaderResourceView* pSRView );

	private:
		UInt32 m_Width;
		UInt32 m_Height;
		Mix::Graphics::FORMAT m_Format;
		ID3D11Texture2D* m_pTexture;
		ID3D11RenderTargetView* m_pRTView;
		ID3D11ShaderResourceView* m_pSRView;

	private:
		TextureTarget(	Mix::Graphics::DX11::Device* pDevice,
						UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
						ID3D11Texture2D* pTexture, ID3D11RenderTargetView* pRTView, ID3D11ShaderResourceView* pSRView );

		virtual ~TextureTarget( void );

	public:
		ID3D11RenderTargetView* GetRTView( void );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::DX11::Texture
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual ID3D11Resource* GetInterface( void );
		virtual ID3D11ShaderResourceView* GetSRView( void );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::ITexture
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual Mix::Graphics::ITexture::DIMENSION_TYPE GetDimensionType( void ) const;
		virtual Mix::Graphics::ITexture::BIND_TYPE GetBindType( void ) const;
		virtual UInt32 GetAccessFlags( void ) const;
		virtual UInt32 GetWidth( void ) const;
		virtual UInt32 GetHeight( void ) const;
		virtual Mix::Graphics::FORMAT GetFormat( void ) const;
		virtual const wchar_t* GetFilePath( void ) const;
		virtual Boolean Lock( Mix::Graphics::ITexture::LOCK& lock );
		virtual void Unlock( void );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::IDeviceObject
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual Mix::Graphics::IDeviceObject::TYPE GetType( void ) const;
	};

}}}
