#pragma once

#include "Mix/Private/Graphics/DX11/Texture.h"
#include "Mix/Private/Graphics/Common/DeviceObject.h"

namespace Mix{ namespace Graphics{ namespace DX11{

	class Device;

	class TextureDynamic : public Mix::Graphics::DX11::Texture, public Mix::Graphics::Common::DeviceObject
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::DX11::TextureDynamic
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		static TextureDynamic* CreateInstance(	Mix::Graphics::DX11::Device* pDevice,
												UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
												ID3D11Texture2D* pTexture, ID3D11ShaderResourceView* pSRView );

	private:
		Mix::Graphics::DX11::Device* m_pDevice;
		UInt32 m_Width;
		UInt32 m_Height;
		Mix::Graphics::FORMAT m_Format;
		ID3D11Texture2D* m_pTexture;
		ID3D11ShaderResourceView* m_pSRView;
		Boolean m_bLock;

	private:
		TextureDynamic(	Mix::Graphics::DX11::Device* pDevice,
						UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
						ID3D11Texture2D* pTexture, ID3D11ShaderResourceView* pSRView );

		virtual ~TextureDynamic( void );

	public:
		void Attach( ID3D11Texture2D* pD3DTextureDynamic, ID3D11ShaderResourceView* pShaderResourceView );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::DX11::Texture
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual ID3D11Resource* GetInterface( void );
		virtual ID3D11ShaderResourceView* GetSRView( void );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::ITexture
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual Mix::Graphics::ITexture::DIMENSION_TYPE GetDimensionType( void ) const;
		virtual Mix::Graphics::ITexture::BIND_TYPE GetBindType( void ) const;
		virtual UInt32 GetAccessFlags( void ) const;
		virtual UInt32 GetWidth( void ) const;
		virtual UInt32 GetHeight( void ) const;
		virtual Mix::Graphics::FORMAT GetFormat( void ) const;
		virtual const wchar_t* GetFilePath( void ) const;
		virtual Boolean Lock( Mix::Graphics::ITexture::LOCK& lock );
		virtual void Unlock( void );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::IDeviceObject
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual Mix::Graphics::IDeviceObject::TYPE GetType( void ) const;
	};

}}}
