#include "Mix/Private/Graphics/DX11/TextureCube.h"
#include "Mix/Private/Graphics/DX11/Device.h"

namespace Mix{ namespace Graphics{ namespace DX11{

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::DX11::TextureCube
////////////////////////////////////////////////////////////////////////////////////////////////////

TextureCube* TextureCube::CreateInstance(	Mix::Graphics::DX11::Device* pDevice,
											const wchar_t* pFilePath,
											UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
											ID3D11Texture2D* pTexture, ID3D11ShaderResourceView* pSRView, ID3D11RenderTargetView* pRTView )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_GRAPHICS, TextureCube, pDevice, pFilePath, width, height, format, pTexture, pSRView, pRTView );
}

TextureCube::TextureCube(	Mix::Graphics::DX11::Device* pDevice,
							const wchar_t* pFilePath,
							UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
							ID3D11Texture2D* pTexture, ID3D11ShaderResourceView* pSRView, ID3D11RenderTargetView* pRTView ) :
DeviceObject( pDevice ),
m_FilePath( pFilePath ),
m_Width( width ),
m_Height( height ),
m_Format( format ),
m_pTexture( pTexture ),
m_pSRView( pSRView ),
m_pRTView( pRTView )
{
}

TextureCube::~TextureCube( void )
{
	MIX_RELEASE( m_pRTView );
	MIX_RELEASE( m_pSRView );
	MIX_RELEASE( m_pTexture );
}

ID3D11RenderTargetView* TextureCube::GetRTView( void )
{
	return m_pRTView;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::DX11::Texture
////////////////////////////////////////////////////////////////////////////////////////////////////

ID3D11Resource* TextureCube::GetInterface( void )
{
	return m_pTexture;
}

ID3D11ShaderResourceView* TextureCube::GetSRView( void )
{
	return m_pSRView;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::ITexture
////////////////////////////////////////////////////////////////////////////////////////////////////

Mix::Graphics::ITexture::DIMENSION_TYPE TextureCube::GetDimensionType( void ) const
{
	return ITexture::DIMENSION_CUBE;
}

Mix::Graphics::ITexture::BIND_TYPE TextureCube::GetBindType( void ) const
{
	return Mix::Graphics::ITexture::BIND_TARGET;
}

UInt32 TextureCube::GetAccessFlags( void ) const
{
	return ITexture::ACCESS_GPU_READ | ITexture::ACCESS_GPU_WRITE;
}

UInt32 TextureCube::GetWidth( void ) const
{
	return m_Width;
}

UInt32 TextureCube::GetHeight( void ) const
{
	return m_Height;
}

Mix::Graphics::FORMAT TextureCube::GetFormat( void ) const
{
	return m_Format;
}

const wchar_t* TextureCube::GetFilePath( void ) const
{
	return m_FilePath.GetConstPtr();
}

Boolean TextureCube::Lock( Mix::Graphics::ITexture::LOCK& lock )
{
	return False;
}

void TextureCube::Unlock( void )
{
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::IDeviceObject
////////////////////////////////////////////////////////////////////////////////////////////////////

Mix::Graphics::IDeviceObject::TYPE TextureCube::GetType( void ) const
{
	return Mix::Graphics::IDeviceObject::TEXTURE;
}

}}}
